/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Contains the schemata used in Model's predictions and explanations via
 * [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict], [PredictionService.Explain][google.cloud.aiplatform.v1beta1.PredictionService.Explain] and
 * [BatchPredictionJob][google.cloud.aiplatform.v1beta1.BatchPredictionJob].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.PredictSchemata}
 */
public final class PredictSchemata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PredictSchemata)
    PredictSchemataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PredictSchemata.newBuilder() to construct.
  private PredictSchemata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PredictSchemata() {
    instanceSchemaUri_ = "";
    parametersSchemaUri_ = "";
    predictionSchemaUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PredictSchemata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private PredictSchemata(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              instanceSchemaUri_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              parametersSchemaUri_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              predictionSchemaUri_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelProto
        .internal_static_google_cloud_aiplatform_v1beta1_PredictSchemata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelProto
        .internal_static_google_cloud_aiplatform_v1beta1_PredictSchemata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.PredictSchemata.class,
            com.google.cloud.aiplatform.v1beta1.PredictSchemata.Builder.class);
  }

  public static final int INSTANCE_SCHEMA_URI_FIELD_NUMBER = 1;
  private volatile java.lang.Object instanceSchemaUri_;
  /**
   *
   *
   * <pre>
   * Immutable. Points to a YAML file stored on Google Cloud Storage describing the format
   * of a single instance, which are used in [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
   * [ExplainRequest.instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] and
   * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.input_config].
   * The schema is defined as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * AutoML Models always have this field populated by Vertex AI.
   * Note: The URI given on output will be immutable and probably different,
   * including the URI scheme, than the one given on input. The output URI will
   * point to a location where the user only has a read access.
   * </pre>
   *
   * <code>string instance_schema_uri = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The instanceSchemaUri.
   */
  @java.lang.Override
  public java.lang.String getInstanceSchemaUri() {
    java.lang.Object ref = instanceSchemaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instanceSchemaUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Points to a YAML file stored on Google Cloud Storage describing the format
   * of a single instance, which are used in [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
   * [ExplainRequest.instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] and
   * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.input_config].
   * The schema is defined as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * AutoML Models always have this field populated by Vertex AI.
   * Note: The URI given on output will be immutable and probably different,
   * including the URI scheme, than the one given on input. The output URI will
   * point to a location where the user only has a read access.
   * </pre>
   *
   * <code>string instance_schema_uri = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for instanceSchemaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceSchemaUriBytes() {
    java.lang.Object ref = instanceSchemaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instanceSchemaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMETERS_SCHEMA_URI_FIELD_NUMBER = 2;
  private volatile java.lang.Object parametersSchemaUri_;
  /**
   *
   *
   * <pre>
   * Immutable. Points to a YAML file stored on Google Cloud Storage describing the
   * parameters of prediction and explanation via
   * [PredictRequest.parameters][google.cloud.aiplatform.v1beta1.PredictRequest.parameters], [ExplainRequest.parameters][google.cloud.aiplatform.v1beta1.ExplainRequest.parameters] and
   * [BatchPredictionJob.model_parameters][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model_parameters].
   * The schema is defined as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * AutoML Models always have this field populated by Vertex AI, if no
   * parameters are supported, then it is set to an empty string.
   * Note: The URI given on output will be immutable and probably different,
   * including the URI scheme, than the one given on input. The output URI will
   * point to a location where the user only has a read access.
   * </pre>
   *
   * <code>string parameters_schema_uri = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The parametersSchemaUri.
   */
  @java.lang.Override
  public java.lang.String getParametersSchemaUri() {
    java.lang.Object ref = parametersSchemaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parametersSchemaUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Points to a YAML file stored on Google Cloud Storage describing the
   * parameters of prediction and explanation via
   * [PredictRequest.parameters][google.cloud.aiplatform.v1beta1.PredictRequest.parameters], [ExplainRequest.parameters][google.cloud.aiplatform.v1beta1.ExplainRequest.parameters] and
   * [BatchPredictionJob.model_parameters][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model_parameters].
   * The schema is defined as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * AutoML Models always have this field populated by Vertex AI, if no
   * parameters are supported, then it is set to an empty string.
   * Note: The URI given on output will be immutable and probably different,
   * including the URI scheme, than the one given on input. The output URI will
   * point to a location where the user only has a read access.
   * </pre>
   *
   * <code>string parameters_schema_uri = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for parametersSchemaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParametersSchemaUriBytes() {
    java.lang.Object ref = parametersSchemaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parametersSchemaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREDICTION_SCHEMA_URI_FIELD_NUMBER = 3;
  private volatile java.lang.Object predictionSchemaUri_;
  /**
   *
   *
   * <pre>
   * Immutable. Points to a YAML file stored on Google Cloud Storage describing the format
   * of a single prediction produced by this Model, which are returned via
   * [PredictResponse.predictions][google.cloud.aiplatform.v1beta1.PredictResponse.predictions], [ExplainResponse.explanations][google.cloud.aiplatform.v1beta1.ExplainResponse.explanations], and
   * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config].
   * The schema is defined as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * AutoML Models always have this field populated by Vertex AI.
   * Note: The URI given on output will be immutable and probably different,
   * including the URI scheme, than the one given on input. The output URI will
   * point to a location where the user only has a read access.
   * </pre>
   *
   * <code>string prediction_schema_uri = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The predictionSchemaUri.
   */
  @java.lang.Override
  public java.lang.String getPredictionSchemaUri() {
    java.lang.Object ref = predictionSchemaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      predictionSchemaUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Points to a YAML file stored on Google Cloud Storage describing the format
   * of a single prediction produced by this Model, which are returned via
   * [PredictResponse.predictions][google.cloud.aiplatform.v1beta1.PredictResponse.predictions], [ExplainResponse.explanations][google.cloud.aiplatform.v1beta1.ExplainResponse.explanations], and
   * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config].
   * The schema is defined as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * AutoML Models always have this field populated by Vertex AI.
   * Note: The URI given on output will be immutable and probably different,
   * including the URI scheme, than the one given on input. The output URI will
   * point to a location where the user only has a read access.
   * </pre>
   *
   * <code>string prediction_schema_uri = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for predictionSchemaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPredictionSchemaUriBytes() {
    java.lang.Object ref = predictionSchemaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      predictionSchemaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceSchemaUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, instanceSchemaUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parametersSchemaUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, parametersSchemaUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(predictionSchemaUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, predictionSchemaUri_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceSchemaUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, instanceSchemaUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parametersSchemaUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, parametersSchemaUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(predictionSchemaUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, predictionSchemaUri_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.PredictSchemata)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.PredictSchemata other =
        (com.google.cloud.aiplatform.v1beta1.PredictSchemata) obj;

    if (!getInstanceSchemaUri().equals(other.getInstanceSchemaUri())) return false;
    if (!getParametersSchemaUri().equals(other.getParametersSchemaUri())) return false;
    if (!getPredictionSchemaUri().equals(other.getPredictionSchemaUri())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INSTANCE_SCHEMA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getInstanceSchemaUri().hashCode();
    hash = (37 * hash) + PARAMETERS_SCHEMA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getParametersSchemaUri().hashCode();
    hash = (37 * hash) + PREDICTION_SCHEMA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getPredictionSchemaUri().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictSchemata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictSchemata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictSchemata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictSchemata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictSchemata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictSchemata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictSchemata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictSchemata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictSchemata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictSchemata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictSchemata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictSchemata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.PredictSchemata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Contains the schemata used in Model's predictions and explanations via
   * [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict], [PredictionService.Explain][google.cloud.aiplatform.v1beta1.PredictionService.Explain] and
   * [BatchPredictionJob][google.cloud.aiplatform.v1beta1.BatchPredictionJob].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PredictSchemata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PredictSchemata)
      com.google.cloud.aiplatform.v1beta1.PredictSchemataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_PredictSchemata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_PredictSchemata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PredictSchemata.class,
              com.google.cloud.aiplatform.v1beta1.PredictSchemata.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.PredictSchemata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      instanceSchemaUri_ = "";

      parametersSchemaUri_ = "";

      predictionSchemaUri_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_PredictSchemata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PredictSchemata getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.PredictSchemata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PredictSchemata build() {
      com.google.cloud.aiplatform.v1beta1.PredictSchemata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PredictSchemata buildPartial() {
      com.google.cloud.aiplatform.v1beta1.PredictSchemata result =
          new com.google.cloud.aiplatform.v1beta1.PredictSchemata(this);
      result.instanceSchemaUri_ = instanceSchemaUri_;
      result.parametersSchemaUri_ = parametersSchemaUri_;
      result.predictionSchemaUri_ = predictionSchemaUri_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.PredictSchemata) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.PredictSchemata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.PredictSchemata other) {
      if (other == com.google.cloud.aiplatform.v1beta1.PredictSchemata.getDefaultInstance())
        return this;
      if (!other.getInstanceSchemaUri().isEmpty()) {
        instanceSchemaUri_ = other.instanceSchemaUri_;
        onChanged();
      }
      if (!other.getParametersSchemaUri().isEmpty()) {
        parametersSchemaUri_ = other.parametersSchemaUri_;
        onChanged();
      }
      if (!other.getPredictionSchemaUri().isEmpty()) {
        predictionSchemaUri_ = other.predictionSchemaUri_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.PredictSchemata parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1.PredictSchemata) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object instanceSchemaUri_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing the format
     * of a single instance, which are used in [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
     * [ExplainRequest.instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] and
     * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.input_config].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string instance_schema_uri = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The instanceSchemaUri.
     */
    public java.lang.String getInstanceSchemaUri() {
      java.lang.Object ref = instanceSchemaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceSchemaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing the format
     * of a single instance, which are used in [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
     * [ExplainRequest.instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] and
     * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.input_config].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string instance_schema_uri = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for instanceSchemaUri.
     */
    public com.google.protobuf.ByteString getInstanceSchemaUriBytes() {
      java.lang.Object ref = instanceSchemaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceSchemaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing the format
     * of a single instance, which are used in [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
     * [ExplainRequest.instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] and
     * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.input_config].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string instance_schema_uri = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The instanceSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      instanceSchemaUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing the format
     * of a single instance, which are used in [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
     * [ExplainRequest.instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] and
     * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.input_config].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string instance_schema_uri = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceSchemaUri() {

      instanceSchemaUri_ = getDefaultInstance().getInstanceSchemaUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing the format
     * of a single instance, which are used in [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
     * [ExplainRequest.instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] and
     * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.input_config].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string instance_schema_uri = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for instanceSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      instanceSchemaUri_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object parametersSchemaUri_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing the
     * parameters of prediction and explanation via
     * [PredictRequest.parameters][google.cloud.aiplatform.v1beta1.PredictRequest.parameters], [ExplainRequest.parameters][google.cloud.aiplatform.v1beta1.ExplainRequest.parameters] and
     * [BatchPredictionJob.model_parameters][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model_parameters].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI, if no
     * parameters are supported, then it is set to an empty string.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string parameters_schema_uri = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The parametersSchemaUri.
     */
    public java.lang.String getParametersSchemaUri() {
      java.lang.Object ref = parametersSchemaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parametersSchemaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing the
     * parameters of prediction and explanation via
     * [PredictRequest.parameters][google.cloud.aiplatform.v1beta1.PredictRequest.parameters], [ExplainRequest.parameters][google.cloud.aiplatform.v1beta1.ExplainRequest.parameters] and
     * [BatchPredictionJob.model_parameters][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model_parameters].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI, if no
     * parameters are supported, then it is set to an empty string.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string parameters_schema_uri = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for parametersSchemaUri.
     */
    public com.google.protobuf.ByteString getParametersSchemaUriBytes() {
      java.lang.Object ref = parametersSchemaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parametersSchemaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing the
     * parameters of prediction and explanation via
     * [PredictRequest.parameters][google.cloud.aiplatform.v1beta1.PredictRequest.parameters], [ExplainRequest.parameters][google.cloud.aiplatform.v1beta1.ExplainRequest.parameters] and
     * [BatchPredictionJob.model_parameters][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model_parameters].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI, if no
     * parameters are supported, then it is set to an empty string.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string parameters_schema_uri = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The parametersSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setParametersSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parametersSchemaUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing the
     * parameters of prediction and explanation via
     * [PredictRequest.parameters][google.cloud.aiplatform.v1beta1.PredictRequest.parameters], [ExplainRequest.parameters][google.cloud.aiplatform.v1beta1.ExplainRequest.parameters] and
     * [BatchPredictionJob.model_parameters][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model_parameters].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI, if no
     * parameters are supported, then it is set to an empty string.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string parameters_schema_uri = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParametersSchemaUri() {

      parametersSchemaUri_ = getDefaultInstance().getParametersSchemaUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing the
     * parameters of prediction and explanation via
     * [PredictRequest.parameters][google.cloud.aiplatform.v1beta1.PredictRequest.parameters], [ExplainRequest.parameters][google.cloud.aiplatform.v1beta1.ExplainRequest.parameters] and
     * [BatchPredictionJob.model_parameters][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model_parameters].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI, if no
     * parameters are supported, then it is set to an empty string.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string parameters_schema_uri = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for parametersSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setParametersSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parametersSchemaUri_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object predictionSchemaUri_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing the format
     * of a single prediction produced by this Model, which are returned via
     * [PredictResponse.predictions][google.cloud.aiplatform.v1beta1.PredictResponse.predictions], [ExplainResponse.explanations][google.cloud.aiplatform.v1beta1.ExplainResponse.explanations], and
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string prediction_schema_uri = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The predictionSchemaUri.
     */
    public java.lang.String getPredictionSchemaUri() {
      java.lang.Object ref = predictionSchemaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        predictionSchemaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing the format
     * of a single prediction produced by this Model, which are returned via
     * [PredictResponse.predictions][google.cloud.aiplatform.v1beta1.PredictResponse.predictions], [ExplainResponse.explanations][google.cloud.aiplatform.v1beta1.ExplainResponse.explanations], and
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string prediction_schema_uri = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for predictionSchemaUri.
     */
    public com.google.protobuf.ByteString getPredictionSchemaUriBytes() {
      java.lang.Object ref = predictionSchemaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        predictionSchemaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing the format
     * of a single prediction produced by this Model, which are returned via
     * [PredictResponse.predictions][google.cloud.aiplatform.v1beta1.PredictResponse.predictions], [ExplainResponse.explanations][google.cloud.aiplatform.v1beta1.ExplainResponse.explanations], and
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string prediction_schema_uri = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The predictionSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setPredictionSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      predictionSchemaUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing the format
     * of a single prediction produced by this Model, which are returned via
     * [PredictResponse.predictions][google.cloud.aiplatform.v1beta1.PredictResponse.predictions], [ExplainResponse.explanations][google.cloud.aiplatform.v1beta1.ExplainResponse.explanations], and
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string prediction_schema_uri = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPredictionSchemaUri() {

      predictionSchemaUri_ = getDefaultInstance().getPredictionSchemaUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing the format
     * of a single prediction produced by this Model, which are returned via
     * [PredictResponse.predictions][google.cloud.aiplatform.v1beta1.PredictResponse.predictions], [ExplainResponse.explanations][google.cloud.aiplatform.v1beta1.ExplainResponse.explanations], and
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string prediction_schema_uri = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for predictionSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setPredictionSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      predictionSchemaUri_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PredictSchemata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PredictSchemata)
  private static final com.google.cloud.aiplatform.v1beta1.PredictSchemata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.PredictSchemata();
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictSchemata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PredictSchemata> PARSER =
      new com.google.protobuf.AbstractParser<PredictSchemata>() {
        @java.lang.Override
        public PredictSchemata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new PredictSchemata(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<PredictSchemata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PredictSchemata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PredictSchemata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
