/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_evaluation_slice.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * A collection of metrics calculated by comparing Model's predictions on a
 * slice of the test data against ground truth annotations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelEvaluationSlice}
 */
public final class ModelEvaluationSlice extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelEvaluationSlice)
    ModelEvaluationSliceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ModelEvaluationSlice.newBuilder() to construct.
  private ModelEvaluationSlice(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelEvaluationSlice() {
    name_ = "";
    metricsSchemaUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelEvaluationSlice();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ModelEvaluationSlice(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.Builder subBuilder =
                  null;
              if (slice_ != null) {
                subBuilder = slice_.toBuilder();
              }
              slice_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(slice_);
                slice_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              metricsSchemaUri_ = s;
              break;
            }
          case 34:
            {
              com.google.protobuf.Value.Builder subBuilder = null;
              if (metrics_ != null) {
                subBuilder = metrics_.toBuilder();
              }
              metrics_ = input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(metrics_);
                metrics_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelEvaluationSliceProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluationSlice_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelEvaluationSliceProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluationSlice_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.class,
            com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Builder.class);
  }

  public interface SliceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The dimension of the slice.
     * Well-known dimensions are:
     *   * `annotationSpec`: This slice is on the test data that has either
     *     ground truth or prediction with [AnnotationSpec.display_name][google.cloud.aiplatform.v1beta1.AnnotationSpec.display_name]
     *     equals to [value][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.value].
     * </pre>
     *
     * <code>string dimension = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The dimension.
     */
    java.lang.String getDimension();
    /**
     *
     *
     * <pre>
     * Output only. The dimension of the slice.
     * Well-known dimensions are:
     *   * `annotationSpec`: This slice is on the test data that has either
     *     ground truth or prediction with [AnnotationSpec.display_name][google.cloud.aiplatform.v1beta1.AnnotationSpec.display_name]
     *     equals to [value][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.value].
     * </pre>
     *
     * <code>string dimension = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for dimension.
     */
    com.google.protobuf.ByteString getDimensionBytes();

    /**
     *
     *
     * <pre>
     * Output only. The value of the dimension in this slice.
     * </pre>
     *
     * <code>string value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The value.
     */
    java.lang.String getValue();
    /**
     *
     *
     * <pre>
     * Output only. The value of the dimension in this slice.
     * </pre>
     *
     * <code>string value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for value.
     */
    com.google.protobuf.ByteString getValueBytes();
  }
  /**
   *
   *
   * <pre>
   * Definition of a slice.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice}
   */
  public static final class Slice extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice)
      SliceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Slice.newBuilder() to construct.
    private Slice(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Slice() {
      dimension_ = "";
      value_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Slice();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Slice(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                dimension_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                value_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelEvaluationSliceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluationSlice_Slice_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelEvaluationSliceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluationSlice_Slice_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.class,
              com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.Builder.class);
    }

    public static final int DIMENSION_FIELD_NUMBER = 1;
    private volatile java.lang.Object dimension_;
    /**
     *
     *
     * <pre>
     * Output only. The dimension of the slice.
     * Well-known dimensions are:
     *   * `annotationSpec`: This slice is on the test data that has either
     *     ground truth or prediction with [AnnotationSpec.display_name][google.cloud.aiplatform.v1beta1.AnnotationSpec.display_name]
     *     equals to [value][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.value].
     * </pre>
     *
     * <code>string dimension = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The dimension.
     */
    @java.lang.Override
    public java.lang.String getDimension() {
      java.lang.Object ref = dimension_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dimension_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The dimension of the slice.
     * Well-known dimensions are:
     *   * `annotationSpec`: This slice is on the test data that has either
     *     ground truth or prediction with [AnnotationSpec.display_name][google.cloud.aiplatform.v1beta1.AnnotationSpec.display_name]
     *     equals to [value][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.value].
     * </pre>
     *
     * <code>string dimension = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for dimension.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDimensionBytes() {
      java.lang.Object ref = dimension_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dimension_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 2;
    private volatile java.lang.Object value_;
    /**
     *
     *
     * <pre>
     * Output only. The value of the dimension in this slice.
     * </pre>
     *
     * <code>string value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The value of the dimension in this slice.
     * </pre>
     *
     * <code>string value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dimension_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dimension_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, value_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dimension_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dimension_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, value_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice other =
          (com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice) obj;

      if (!getDimension().equals(other.getDimension())) return false;
      if (!getValue().equals(other.getValue())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DIMENSION_FIELD_NUMBER;
      hash = (53 * hash) + getDimension().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Definition of a slice.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice)
        com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.SliceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelEvaluationSliceProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluationSlice_Slice_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelEvaluationSliceProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluationSlice_Slice_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.class,
                com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        dimension_ = "";

        value_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelEvaluationSliceProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluationSlice_Slice_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice build() {
        com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice result =
            new com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice(this);
        result.dimension_ = dimension_;
        result.value_ = value_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.getDefaultInstance())
          return this;
        if (!other.getDimension().isEmpty()) {
          dimension_ = other.dimension_;
          onChanged();
        }
        if (!other.getValue().isEmpty()) {
          value_ = other.value_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object dimension_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The dimension of the slice.
       * Well-known dimensions are:
       *   * `annotationSpec`: This slice is on the test data that has either
       *     ground truth or prediction with [AnnotationSpec.display_name][google.cloud.aiplatform.v1beta1.AnnotationSpec.display_name]
       *     equals to [value][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.value].
       * </pre>
       *
       * <code>string dimension = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The dimension.
       */
      public java.lang.String getDimension() {
        java.lang.Object ref = dimension_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dimension_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The dimension of the slice.
       * Well-known dimensions are:
       *   * `annotationSpec`: This slice is on the test data that has either
       *     ground truth or prediction with [AnnotationSpec.display_name][google.cloud.aiplatform.v1beta1.AnnotationSpec.display_name]
       *     equals to [value][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.value].
       * </pre>
       *
       * <code>string dimension = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for dimension.
       */
      public com.google.protobuf.ByteString getDimensionBytes() {
        java.lang.Object ref = dimension_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dimension_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The dimension of the slice.
       * Well-known dimensions are:
       *   * `annotationSpec`: This slice is on the test data that has either
       *     ground truth or prediction with [AnnotationSpec.display_name][google.cloud.aiplatform.v1beta1.AnnotationSpec.display_name]
       *     equals to [value][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.value].
       * </pre>
       *
       * <code>string dimension = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The dimension to set.
       * @return This builder for chaining.
       */
      public Builder setDimension(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        dimension_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The dimension of the slice.
       * Well-known dimensions are:
       *   * `annotationSpec`: This slice is on the test data that has either
       *     ground truth or prediction with [AnnotationSpec.display_name][google.cloud.aiplatform.v1beta1.AnnotationSpec.display_name]
       *     equals to [value][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.value].
       * </pre>
       *
       * <code>string dimension = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDimension() {

        dimension_ = getDefaultInstance().getDimension();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The dimension of the slice.
       * Well-known dimensions are:
       *   * `annotationSpec`: This slice is on the test data that has either
       *     ground truth or prediction with [AnnotationSpec.display_name][google.cloud.aiplatform.v1beta1.AnnotationSpec.display_name]
       *     equals to [value][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.value].
       * </pre>
       *
       * <code>string dimension = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for dimension to set.
       * @return This builder for chaining.
       */
      public Builder setDimensionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        dimension_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object value_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The value of the dimension in this slice.
       * </pre>
       *
       * <code>string value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          value_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The value of the dimension in this slice.
       * </pre>
       *
       * <code>string value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The value of the dimension in this slice.
       * </pre>
       *
       * <code>string value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The value of the dimension in this slice.
       * </pre>
       *
       * <code>string value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {

        value_ = getDefaultInstance().getValue();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The value of the dimension in this slice.
       * </pre>
       *
       * <code>string value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for value to set.
       * @return This builder for chaining.
       */
      public Builder setValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        value_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice)
    private static final com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice();
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Slice> PARSER =
        new com.google.protobuf.AbstractParser<Slice>() {
          @java.lang.Override
          public Slice parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Slice(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Slice> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Slice> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the ModelEvaluationSlice.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the ModelEvaluationSlice.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SLICE_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice slice_;
  /**
   *
   *
   * <pre>
   * Output only. The slice of the test data that is used to evaluate the Model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the slice field is set.
   */
  @java.lang.Override
  public boolean hasSlice() {
    return slice_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The slice of the test data that is used to evaluate the Model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The slice.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice getSlice() {
    return slice_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.getDefaultInstance()
        : slice_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The slice of the test data that is used to evaluate the Model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.SliceOrBuilder
      getSliceOrBuilder() {
    return getSlice();
  }

  public static final int METRICS_SCHEMA_URI_FIELD_NUMBER = 3;
  private volatile java.lang.Object metricsSchemaUri_;
  /**
   *
   *
   * <pre>
   * Output only. Points to a YAML file stored on Google Cloud Storage describing the
   * [metrics][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.metrics] of this ModelEvaluationSlice. The
   * schema is defined as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * </pre>
   *
   * <code>string metrics_schema_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The metricsSchemaUri.
   */
  @java.lang.Override
  public java.lang.String getMetricsSchemaUri() {
    java.lang.Object ref = metricsSchemaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metricsSchemaUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Points to a YAML file stored on Google Cloud Storage describing the
   * [metrics][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.metrics] of this ModelEvaluationSlice. The
   * schema is defined as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * </pre>
   *
   * <code>string metrics_schema_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for metricsSchemaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetricsSchemaUriBytes() {
    java.lang.Object ref = metricsSchemaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metricsSchemaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METRICS_FIELD_NUMBER = 4;
  private com.google.protobuf.Value metrics_;
  /**
   *
   *
   * <pre>
   * Output only. Sliced evaluation metrics of the Model. The schema of the metrics is stored
   * in [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.metrics_schema_uri]
   * </pre>
   *
   * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the metrics field is set.
   */
  @java.lang.Override
  public boolean hasMetrics() {
    return metrics_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Sliced evaluation metrics of the Model. The schema of the metrics is stored
   * in [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.metrics_schema_uri]
   * </pre>
   *
   * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The metrics.
   */
  @java.lang.Override
  public com.google.protobuf.Value getMetrics() {
    return metrics_ == null ? com.google.protobuf.Value.getDefaultInstance() : metrics_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Sliced evaluation metrics of the Model. The schema of the metrics is stored
   * in [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.metrics_schema_uri]
   * </pre>
   *
   * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getMetricsOrBuilder() {
    return getMetrics();
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelEvaluationSlice was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelEvaluationSlice was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelEvaluationSlice was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (slice_ != null) {
      output.writeMessage(2, getSlice());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricsSchemaUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, metricsSchemaUri_);
    }
    if (metrics_ != null) {
      output.writeMessage(4, getMetrics());
    }
    if (createTime_ != null) {
      output.writeMessage(5, getCreateTime());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (slice_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSlice());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricsSchemaUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, metricsSchemaUri_);
    }
    if (metrics_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getMetrics());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice other =
        (com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasSlice() != other.hasSlice()) return false;
    if (hasSlice()) {
      if (!getSlice().equals(other.getSlice())) return false;
    }
    if (!getMetricsSchemaUri().equals(other.getMetricsSchemaUri())) return false;
    if (hasMetrics() != other.hasMetrics()) return false;
    if (hasMetrics()) {
      if (!getMetrics().equals(other.getMetrics())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasSlice()) {
      hash = (37 * hash) + SLICE_FIELD_NUMBER;
      hash = (53 * hash) + getSlice().hashCode();
    }
    hash = (37 * hash) + METRICS_SCHEMA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getMetricsSchemaUri().hashCode();
    if (hasMetrics()) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetrics().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A collection of metrics calculated by comparing Model's predictions on a
   * slice of the test data against ground truth annotations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelEvaluationSlice}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelEvaluationSlice)
      com.google.cloud.aiplatform.v1beta1.ModelEvaluationSliceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelEvaluationSliceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluationSlice_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelEvaluationSliceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluationSlice_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.class,
              com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (sliceBuilder_ == null) {
        slice_ = null;
      } else {
        slice_ = null;
        sliceBuilder_ = null;
      }
      metricsSchemaUri_ = "";

      if (metricsBuilder_ == null) {
        metrics_ = null;
      } else {
        metrics_ = null;
        metricsBuilder_ = null;
      }
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelEvaluationSliceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluationSlice_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice build() {
      com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice result =
          new com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice(this);
      result.name_ = name_;
      if (sliceBuilder_ == null) {
        result.slice_ = slice_;
      } else {
        result.slice_ = sliceBuilder_.build();
      }
      result.metricsSchemaUri_ = metricsSchemaUri_;
      if (metricsBuilder_ == null) {
        result.metrics_ = metrics_;
      } else {
        result.metrics_ = metricsBuilder_.build();
      }
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasSlice()) {
        mergeSlice(other.getSlice());
      }
      if (!other.getMetricsSchemaUri().isEmpty()) {
        metricsSchemaUri_ = other.metricsSchemaUri_;
        onChanged();
      }
      if (other.hasMetrics()) {
        mergeMetrics(other.getMetrics());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluationSlice.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluationSlice.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluationSlice.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluationSlice.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluationSlice.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice slice_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice,
            com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.SliceOrBuilder>
        sliceBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The slice of the test data that is used to evaluate the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the slice field is set.
     */
    public boolean hasSlice() {
      return sliceBuilder_ != null || slice_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The slice of the test data that is used to evaluate the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The slice.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice getSlice() {
      if (sliceBuilder_ == null) {
        return slice_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.getDefaultInstance()
            : slice_;
      } else {
        return sliceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The slice of the test data that is used to evaluate the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSlice(com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice value) {
      if (sliceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        slice_ = value;
        onChanged();
      } else {
        sliceBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The slice of the test data that is used to evaluate the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSlice(
        com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.Builder builderForValue) {
      if (sliceBuilder_ == null) {
        slice_ = builderForValue.build();
        onChanged();
      } else {
        sliceBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The slice of the test data that is used to evaluate the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSlice(
        com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice value) {
      if (sliceBuilder_ == null) {
        if (slice_ != null) {
          slice_ =
              com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.newBuilder(slice_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          slice_ = value;
        }
        onChanged();
      } else {
        sliceBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The slice of the test data that is used to evaluate the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSlice() {
      if (sliceBuilder_ == null) {
        slice_ = null;
        onChanged();
      } else {
        slice_ = null;
        sliceBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The slice of the test data that is used to evaluate the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.Builder
        getSliceBuilder() {

      onChanged();
      return getSliceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The slice of the test data that is used to evaluate the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.SliceOrBuilder
        getSliceOrBuilder() {
      if (sliceBuilder_ != null) {
        return sliceBuilder_.getMessageOrBuilder();
      } else {
        return slice_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.getDefaultInstance()
            : slice_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The slice of the test data that is used to evaluate the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice,
            com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.SliceOrBuilder>
        getSliceFieldBuilder() {
      if (sliceBuilder_ == null) {
        sliceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice,
                com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.SliceOrBuilder>(
                getSlice(), getParentForChildren(), isClean());
        slice_ = null;
      }
      return sliceBuilder_;
    }

    private java.lang.Object metricsSchemaUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Points to a YAML file stored on Google Cloud Storage describing the
     * [metrics][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.metrics] of this ModelEvaluationSlice. The
     * schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The metricsSchemaUri.
     */
    public java.lang.String getMetricsSchemaUri() {
      java.lang.Object ref = metricsSchemaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metricsSchemaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Points to a YAML file stored on Google Cloud Storage describing the
     * [metrics][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.metrics] of this ModelEvaluationSlice. The
     * schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for metricsSchemaUri.
     */
    public com.google.protobuf.ByteString getMetricsSchemaUriBytes() {
      java.lang.Object ref = metricsSchemaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metricsSchemaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Points to a YAML file stored on Google Cloud Storage describing the
     * [metrics][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.metrics] of this ModelEvaluationSlice. The
     * schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The metricsSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setMetricsSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      metricsSchemaUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Points to a YAML file stored on Google Cloud Storage describing the
     * [metrics][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.metrics] of this ModelEvaluationSlice. The
     * schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetricsSchemaUri() {

      metricsSchemaUri_ = getDefaultInstance().getMetricsSchemaUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Points to a YAML file stored on Google Cloud Storage describing the
     * [metrics][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.metrics] of this ModelEvaluationSlice. The
     * schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for metricsSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setMetricsSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      metricsSchemaUri_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Value metrics_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        metricsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Sliced evaluation metrics of the Model. The schema of the metrics is stored
     * in [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the metrics field is set.
     */
    public boolean hasMetrics() {
      return metricsBuilder_ != null || metrics_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sliced evaluation metrics of the Model. The schema of the metrics is stored
     * in [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The metrics.
     */
    public com.google.protobuf.Value getMetrics() {
      if (metricsBuilder_ == null) {
        return metrics_ == null ? com.google.protobuf.Value.getDefaultInstance() : metrics_;
      } else {
        return metricsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Sliced evaluation metrics of the Model. The schema of the metrics is stored
     * in [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setMetrics(com.google.protobuf.Value value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metrics_ = value;
        onChanged();
      } else {
        metricsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sliced evaluation metrics of the Model. The schema of the metrics is stored
     * in [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setMetrics(com.google.protobuf.Value.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        metrics_ = builderForValue.build();
        onChanged();
      } else {
        metricsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sliced evaluation metrics of the Model. The schema of the metrics is stored
     * in [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeMetrics(com.google.protobuf.Value value) {
      if (metricsBuilder_ == null) {
        if (metrics_ != null) {
          metrics_ = com.google.protobuf.Value.newBuilder(metrics_).mergeFrom(value).buildPartial();
        } else {
          metrics_ = value;
        }
        onChanged();
      } else {
        metricsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sliced evaluation metrics of the Model. The schema of the metrics is stored
     * in [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearMetrics() {
      if (metricsBuilder_ == null) {
        metrics_ = null;
        onChanged();
      } else {
        metrics_ = null;
        metricsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sliced evaluation metrics of the Model. The schema of the metrics is stored
     * in [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.Value.Builder getMetricsBuilder() {

      onChanged();
      return getMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Sliced evaluation metrics of the Model. The schema of the metrics is stored
     * in [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.ValueOrBuilder getMetricsOrBuilder() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilder();
      } else {
        return metrics_ == null ? com.google.protobuf.Value.getDefaultInstance() : metrics_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Sliced evaluation metrics of the Model. The schema of the metrics is stored
     * in [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getMetrics(), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluationSlice was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluationSlice was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluationSlice was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluationSlice was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluationSlice was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluationSlice was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluationSlice was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluationSlice was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluationSlice was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelEvaluationSlice)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelEvaluationSlice)
  private static final com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice();
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelEvaluationSlice> PARSER =
      new com.google.protobuf.AbstractParser<ModelEvaluationSlice>() {
        @java.lang.Override
        public ModelEvaluationSlice parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ModelEvaluationSlice(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ModelEvaluationSlice> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelEvaluationSlice> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
