/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/hyperparameter_tuning_job.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Represents a HyperparameterTuningJob. A HyperparameterTuningJob
 * has a Study specification and multiple CustomJobs with identical
 * CustomJob specification.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.HyperparameterTuningJob}
 */
public final class HyperparameterTuningJob extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.HyperparameterTuningJob)
    HyperparameterTuningJobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HyperparameterTuningJob.newBuilder() to construct.
  private HyperparameterTuningJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HyperparameterTuningJob() {
    name_ = "";
    displayName_ = "";
    trials_ = java.util.Collections.emptyList();
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HyperparameterTuningJob();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private HyperparameterTuningJob(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 34:
            {
              com.google.cloud.aiplatform.v1beta1.StudySpec.Builder subBuilder = null;
              if (studySpec_ != null) {
                subBuilder = studySpec_.toBuilder();
              }
              studySpec_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.StudySpec.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(studySpec_);
                studySpec_ = subBuilder.buildPartial();
              }

              break;
            }
          case 40:
            {
              maxTrialCount_ = input.readInt32();
              break;
            }
          case 48:
            {
              parallelTrialCount_ = input.readInt32();
              break;
            }
          case 56:
            {
              maxFailedTrialCount_ = input.readInt32();
              break;
            }
          case 66:
            {
              com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder subBuilder = null;
              if (trialJobSpec_ != null) {
                subBuilder = trialJobSpec_.toBuilder();
              }
              trialJobSpec_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.CustomJobSpec.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(trialJobSpec_);
                trialJobSpec_ = subBuilder.buildPartial();
              }

              break;
            }
          case 74:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                trials_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Trial>();
                mutable_bitField0_ |= 0x00000001;
              }
              trials_.add(
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.Trial.parser(), extensionRegistry));
              break;
            }
          case 80:
            {
              int rawValue = input.readEnum();

              state_ = rawValue;
              break;
            }
          case 90:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 98:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (startTime_ != null) {
                subBuilder = startTime_.toBuilder();
              }
              startTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(startTime_);
                startTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 106:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (endTime_ != null) {
                subBuilder = endTime_.toBuilder();
              }
              endTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(endTime_);
                endTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 114:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (updateTime_ != null) {
                subBuilder = updateTime_.toBuilder();
              }
              updateTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(updateTime_);
                updateTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 122:
            {
              com.google.rpc.Status.Builder subBuilder = null;
              if (error_ != null) {
                subBuilder = error_.toBuilder();
              }
              error_ = input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(error_);
                error_ = subBuilder.buildPartial();
              }

              break;
            }
          case 130:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                labels_ =
                    com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000002;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                  input.readMessage(
                      LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
              break;
            }
          case 138:
            {
              com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder subBuilder = null;
              if (encryptionSpec_ != null) {
                subBuilder = encryptionSpec_.toBuilder();
              }
              encryptionSpec_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.EncryptionSpec.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(encryptionSpec_);
                encryptionSpec_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        trials_ = java.util.Collections.unmodifiableList(trials_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_HyperparameterTuningJob_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 16:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_HyperparameterTuningJob_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.class,
            com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the HyperparameterTuningJob.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the HyperparameterTuningJob.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Required. The display name of the HyperparameterTuningJob.
   * The name can be up to 128 characters long and can be consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The display name of the HyperparameterTuningJob.
   * The name can be up to 128 characters long and can be consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STUDY_SPEC_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1beta1.StudySpec studySpec_;
  /**
   *
   *
   * <pre>
   * Required. Study configuration of the HyperparameterTuningJob.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.StudySpec study_spec = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the studySpec field is set.
   */
  @java.lang.Override
  public boolean hasStudySpec() {
    return studySpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Study configuration of the HyperparameterTuningJob.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.StudySpec study_spec = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The studySpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.StudySpec getStudySpec() {
    return studySpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.StudySpec.getDefaultInstance()
        : studySpec_;
  }
  /**
   *
   *
   * <pre>
   * Required. Study configuration of the HyperparameterTuningJob.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.StudySpec study_spec = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.StudySpecOrBuilder getStudySpecOrBuilder() {
    return getStudySpec();
  }

  public static final int MAX_TRIAL_COUNT_FIELD_NUMBER = 5;
  private int maxTrialCount_;
  /**
   *
   *
   * <pre>
   * Required. The desired total number of Trials.
   * </pre>
   *
   * <code>int32 max_trial_count = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The maxTrialCount.
   */
  @java.lang.Override
  public int getMaxTrialCount() {
    return maxTrialCount_;
  }

  public static final int PARALLEL_TRIAL_COUNT_FIELD_NUMBER = 6;
  private int parallelTrialCount_;
  /**
   *
   *
   * <pre>
   * Required. The desired number of Trials to run in parallel.
   * </pre>
   *
   * <code>int32 parallel_trial_count = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The parallelTrialCount.
   */
  @java.lang.Override
  public int getParallelTrialCount() {
    return parallelTrialCount_;
  }

  public static final int MAX_FAILED_TRIAL_COUNT_FIELD_NUMBER = 7;
  private int maxFailedTrialCount_;
  /**
   *
   *
   * <pre>
   * The number of failed Trials that need to be seen before failing
   * the HyperparameterTuningJob.
   * If set to 0, Vertex AI decides how many Trials must fail
   * before the whole job fails.
   * </pre>
   *
   * <code>int32 max_failed_trial_count = 7;</code>
   *
   * @return The maxFailedTrialCount.
   */
  @java.lang.Override
  public int getMaxFailedTrialCount() {
    return maxFailedTrialCount_;
  }

  public static final int TRIAL_JOB_SPEC_FIELD_NUMBER = 8;
  private com.google.cloud.aiplatform.v1beta1.CustomJobSpec trialJobSpec_;
  /**
   *
   *
   * <pre>
   * Required. The spec of a trial job. The same spec applies to the CustomJobs created
   * in all the trials.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.CustomJobSpec trial_job_spec = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the trialJobSpec field is set.
   */
  @java.lang.Override
  public boolean hasTrialJobSpec() {
    return trialJobSpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The spec of a trial job. The same spec applies to the CustomJobs created
   * in all the trials.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.CustomJobSpec trial_job_spec = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The trialJobSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.CustomJobSpec getTrialJobSpec() {
    return trialJobSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.CustomJobSpec.getDefaultInstance()
        : trialJobSpec_;
  }
  /**
   *
   *
   * <pre>
   * Required. The spec of a trial job. The same spec applies to the CustomJobs created
   * in all the trials.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.CustomJobSpec trial_job_spec = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.CustomJobSpecOrBuilder getTrialJobSpecOrBuilder() {
    return getTrialJobSpec();
  }

  public static final int TRIALS_FIELD_NUMBER = 9;
  private java.util.List<com.google.cloud.aiplatform.v1beta1.Trial> trials_;
  /**
   *
   *
   * <pre>
   * Output only. Trials of the HyperparameterTuningJob.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.Trial> getTrialsList() {
    return trials_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Trials of the HyperparameterTuningJob.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.TrialOrBuilder>
      getTrialsOrBuilderList() {
    return trials_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Trials of the HyperparameterTuningJob.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getTrialsCount() {
    return trials_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Trials of the HyperparameterTuningJob.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Trial getTrials(int index) {
    return trials_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Trials of the HyperparameterTuningJob.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.TrialOrBuilder getTrialsOrBuilder(int index) {
    return trials_.get(index);
  }

  public static final int STATE_FIELD_NUMBER = 10;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.JobState getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.aiplatform.v1beta1.JobState result =
        com.google.cloud.aiplatform.v1beta1.JobState.valueOf(state_);
    return result == null ? com.google.cloud.aiplatform.v1beta1.JobState.UNRECOGNIZED : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the HyperparameterTuningJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the HyperparameterTuningJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the HyperparameterTuningJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int START_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the HyperparameterTuningJob for the first time entered the
   * `JOB_STATE_RUNNING` state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the HyperparameterTuningJob for the first time entered the
   * `JOB_STATE_RUNNING` state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the HyperparameterTuningJob for the first time entered the
   * `JOB_STATE_RUNNING` state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return getStartTime();
  }

  public static final int END_TIME_FIELD_NUMBER = 13;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the HyperparameterTuningJob entered any of the following states:
   * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the HyperparameterTuningJob entered any of the following states:
   * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the HyperparameterTuningJob entered any of the following states:
   * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return getEndTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 14;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the HyperparameterTuningJob was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the HyperparameterTuningJob was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the HyperparameterTuningJob was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int ERROR_FIELD_NUMBER = 15;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * Output only. Only populated when job's state is JOB_STATE_FAILED or
   * JOB_STATE_CANCELLED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return error_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Only populated when job's state is JOB_STATE_FAILED or
   * JOB_STATE_CANCELLED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Only populated when job's state is JOB_STATE_FAILED or
   * JOB_STATE_CANCELLED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return getError();
  }

  public static final int LABELS_FIELD_NUMBER = 16;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJobProto
                .internal_static_google_cloud_aiplatform_v1beta1_HyperparameterTuningJob_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize HyperparameterTuningJobs.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 16;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize HyperparameterTuningJobs.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 16;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize HyperparameterTuningJobs.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 16;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize HyperparameterTuningJobs.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 16;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 17;
  private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key options for a HyperparameterTuningJob.
   * If this is set, then all resources created by the HyperparameterTuningJob
   * will be encrypted with the provided encryption key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 17;</code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return encryptionSpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key options for a HyperparameterTuningJob.
   * If this is set, then all resources created by the HyperparameterTuningJob
   * will be encrypted with the provided encryption key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 17;</code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key options for a HyperparameterTuningJob.
   * If this is set, then all resources created by the HyperparameterTuningJob
   * will be encrypted with the provided encryption key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 17;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return getEncryptionSpec();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (studySpec_ != null) {
      output.writeMessage(4, getStudySpec());
    }
    if (maxTrialCount_ != 0) {
      output.writeInt32(5, maxTrialCount_);
    }
    if (parallelTrialCount_ != 0) {
      output.writeInt32(6, parallelTrialCount_);
    }
    if (maxFailedTrialCount_ != 0) {
      output.writeInt32(7, maxFailedTrialCount_);
    }
    if (trialJobSpec_ != null) {
      output.writeMessage(8, getTrialJobSpec());
    }
    for (int i = 0; i < trials_.size(); i++) {
      output.writeMessage(9, trials_.get(i));
    }
    if (state_ != com.google.cloud.aiplatform.v1beta1.JobState.JOB_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(10, state_);
    }
    if (createTime_ != null) {
      output.writeMessage(11, getCreateTime());
    }
    if (startTime_ != null) {
      output.writeMessage(12, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(13, getEndTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(14, getUpdateTime());
    }
    if (error_ != null) {
      output.writeMessage(15, getError());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 16);
    if (encryptionSpec_ != null) {
      output.writeMessage(17, getEncryptionSpec());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (studySpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStudySpec());
    }
    if (maxTrialCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, maxTrialCount_);
    }
    if (parallelTrialCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, parallelTrialCount_);
    }
    if (maxFailedTrialCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, maxFailedTrialCount_);
    }
    if (trialJobSpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getTrialJobSpec());
    }
    for (int i = 0; i < trials_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, trials_.get(i));
    }
    if (state_ != com.google.cloud.aiplatform.v1beta1.JobState.JOB_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, state_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getCreateTime());
    }
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getEndTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getUpdateTime());
    }
    if (error_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getError());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, labels__);
    }
    if (encryptionSpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getEncryptionSpec());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob other =
        (com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasStudySpec() != other.hasStudySpec()) return false;
    if (hasStudySpec()) {
      if (!getStudySpec().equals(other.getStudySpec())) return false;
    }
    if (getMaxTrialCount() != other.getMaxTrialCount()) return false;
    if (getParallelTrialCount() != other.getParallelTrialCount()) return false;
    if (getMaxFailedTrialCount() != other.getMaxFailedTrialCount()) return false;
    if (hasTrialJobSpec() != other.hasTrialJobSpec()) return false;
    if (hasTrialJobSpec()) {
      if (!getTrialJobSpec().equals(other.getTrialJobSpec())) return false;
    }
    if (!getTrialsList().equals(other.getTrialsList())) return false;
    if (state_ != other.state_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasStudySpec()) {
      hash = (37 * hash) + STUDY_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getStudySpec().hashCode();
    }
    hash = (37 * hash) + MAX_TRIAL_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getMaxTrialCount();
    hash = (37 * hash) + PARALLEL_TRIAL_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getParallelTrialCount();
    hash = (37 * hash) + MAX_FAILED_TRIAL_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getMaxFailedTrialCount();
    if (hasTrialJobSpec()) {
      hash = (37 * hash) + TRIAL_JOB_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getTrialJobSpec().hashCode();
    }
    if (getTrialsCount() > 0) {
      hash = (37 * hash) + TRIALS_FIELD_NUMBER;
      hash = (53 * hash) + getTrialsList().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a HyperparameterTuningJob. A HyperparameterTuningJob
   * has a Study specification and multiple CustomJobs with identical
   * CustomJob specification.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.HyperparameterTuningJob}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.HyperparameterTuningJob)
      com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_HyperparameterTuningJob_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 16:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 16:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_HyperparameterTuningJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.class,
              com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTrialsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      if (studySpecBuilder_ == null) {
        studySpec_ = null;
      } else {
        studySpec_ = null;
        studySpecBuilder_ = null;
      }
      maxTrialCount_ = 0;

      parallelTrialCount_ = 0;

      maxFailedTrialCount_ = 0;

      if (trialJobSpecBuilder_ == null) {
        trialJobSpec_ = null;
      } else {
        trialJobSpec_ = null;
        trialJobSpecBuilder_ = null;
      }
      if (trialsBuilder_ == null) {
        trials_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        trialsBuilder_.clear();
      }
      state_ = 0;

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (startTimeBuilder_ == null) {
        startTime_ = null;
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }
      if (endTimeBuilder_ == null) {
        endTime_ = null;
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      if (errorBuilder_ == null) {
        error_ = null;
      } else {
        error_ = null;
        errorBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = null;
      } else {
        encryptionSpec_ = null;
        encryptionSpecBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_HyperparameterTuningJob_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob build() {
      com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob buildPartial() {
      com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob result =
          new com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.displayName_ = displayName_;
      if (studySpecBuilder_ == null) {
        result.studySpec_ = studySpec_;
      } else {
        result.studySpec_ = studySpecBuilder_.build();
      }
      result.maxTrialCount_ = maxTrialCount_;
      result.parallelTrialCount_ = parallelTrialCount_;
      result.maxFailedTrialCount_ = maxFailedTrialCount_;
      if (trialJobSpecBuilder_ == null) {
        result.trialJobSpec_ = trialJobSpec_;
      } else {
        result.trialJobSpec_ = trialJobSpecBuilder_.build();
      }
      if (trialsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          trials_ = java.util.Collections.unmodifiableList(trials_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.trials_ = trials_;
      } else {
        result.trials_ = trialsBuilder_.build();
      }
      result.state_ = state_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (startTimeBuilder_ == null) {
        result.startTime_ = startTime_;
      } else {
        result.startTime_ = startTimeBuilder_.build();
      }
      if (endTimeBuilder_ == null) {
        result.endTime_ = endTime_;
      } else {
        result.endTime_ = endTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      if (errorBuilder_ == null) {
        result.error_ = error_;
      } else {
        result.error_ = errorBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (encryptionSpecBuilder_ == null) {
        result.encryptionSpec_ = encryptionSpec_;
      } else {
        result.encryptionSpec_ = encryptionSpecBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob other) {
      if (other == com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (other.hasStudySpec()) {
        mergeStudySpec(other.getStudySpec());
      }
      if (other.getMaxTrialCount() != 0) {
        setMaxTrialCount(other.getMaxTrialCount());
      }
      if (other.getParallelTrialCount() != 0) {
        setParallelTrialCount(other.getParallelTrialCount());
      }
      if (other.getMaxFailedTrialCount() != 0) {
        setMaxFailedTrialCount(other.getMaxFailedTrialCount());
      }
      if (other.hasTrialJobSpec()) {
        mergeTrialJobSpec(other.getTrialJobSpec());
      }
      if (trialsBuilder_ == null) {
        if (!other.trials_.isEmpty()) {
          if (trials_.isEmpty()) {
            trials_ = other.trials_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTrialsIsMutable();
            trials_.addAll(other.trials_);
          }
          onChanged();
        }
      } else {
        if (!other.trials_.isEmpty()) {
          if (trialsBuilder_.isEmpty()) {
            trialsBuilder_.dispose();
            trialsBuilder_ = null;
            trials_ = other.trials_;
            bitField0_ = (bitField0_ & ~0x00000001);
            trialsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTrialsFieldBuilder()
                    : null;
          } else {
            trialsBuilder_.addAllMessages(other.trials_);
          }
        }
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The display name of the HyperparameterTuningJob.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the HyperparameterTuningJob.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the HyperparameterTuningJob.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the HyperparameterTuningJob.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the HyperparameterTuningJob.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.StudySpec studySpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.StudySpec,
            com.google.cloud.aiplatform.v1beta1.StudySpec.Builder,
            com.google.cloud.aiplatform.v1beta1.StudySpecOrBuilder>
        studySpecBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Study configuration of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec study_spec = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the studySpec field is set.
     */
    public boolean hasStudySpec() {
      return studySpecBuilder_ != null || studySpec_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Study configuration of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec study_spec = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The studySpec.
     */
    public com.google.cloud.aiplatform.v1beta1.StudySpec getStudySpec() {
      if (studySpecBuilder_ == null) {
        return studySpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.StudySpec.getDefaultInstance()
            : studySpec_;
      } else {
        return studySpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Study configuration of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec study_spec = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setStudySpec(com.google.cloud.aiplatform.v1beta1.StudySpec value) {
      if (studySpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        studySpec_ = value;
        onChanged();
      } else {
        studySpecBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Study configuration of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec study_spec = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setStudySpec(
        com.google.cloud.aiplatform.v1beta1.StudySpec.Builder builderForValue) {
      if (studySpecBuilder_ == null) {
        studySpec_ = builderForValue.build();
        onChanged();
      } else {
        studySpecBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Study configuration of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec study_spec = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeStudySpec(com.google.cloud.aiplatform.v1beta1.StudySpec value) {
      if (studySpecBuilder_ == null) {
        if (studySpec_ != null) {
          studySpec_ =
              com.google.cloud.aiplatform.v1beta1.StudySpec.newBuilder(studySpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          studySpec_ = value;
        }
        onChanged();
      } else {
        studySpecBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Study configuration of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec study_spec = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearStudySpec() {
      if (studySpecBuilder_ == null) {
        studySpec_ = null;
        onChanged();
      } else {
        studySpec_ = null;
        studySpecBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Study configuration of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec study_spec = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.StudySpec.Builder getStudySpecBuilder() {

      onChanged();
      return getStudySpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Study configuration of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec study_spec = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.StudySpecOrBuilder getStudySpecOrBuilder() {
      if (studySpecBuilder_ != null) {
        return studySpecBuilder_.getMessageOrBuilder();
      } else {
        return studySpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.StudySpec.getDefaultInstance()
            : studySpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Study configuration of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec study_spec = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.StudySpec,
            com.google.cloud.aiplatform.v1beta1.StudySpec.Builder,
            com.google.cloud.aiplatform.v1beta1.StudySpecOrBuilder>
        getStudySpecFieldBuilder() {
      if (studySpecBuilder_ == null) {
        studySpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.StudySpec,
                com.google.cloud.aiplatform.v1beta1.StudySpec.Builder,
                com.google.cloud.aiplatform.v1beta1.StudySpecOrBuilder>(
                getStudySpec(), getParentForChildren(), isClean());
        studySpec_ = null;
      }
      return studySpecBuilder_;
    }

    private int maxTrialCount_;
    /**
     *
     *
     * <pre>
     * Required. The desired total number of Trials.
     * </pre>
     *
     * <code>int32 max_trial_count = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The maxTrialCount.
     */
    @java.lang.Override
    public int getMaxTrialCount() {
      return maxTrialCount_;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired total number of Trials.
     * </pre>
     *
     * <code>int32 max_trial_count = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The maxTrialCount to set.
     * @return This builder for chaining.
     */
    public Builder setMaxTrialCount(int value) {

      maxTrialCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired total number of Trials.
     * </pre>
     *
     * <code>int32 max_trial_count = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxTrialCount() {

      maxTrialCount_ = 0;
      onChanged();
      return this;
    }

    private int parallelTrialCount_;
    /**
     *
     *
     * <pre>
     * Required. The desired number of Trials to run in parallel.
     * </pre>
     *
     * <code>int32 parallel_trial_count = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parallelTrialCount.
     */
    @java.lang.Override
    public int getParallelTrialCount() {
      return parallelTrialCount_;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired number of Trials to run in parallel.
     * </pre>
     *
     * <code>int32 parallel_trial_count = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The parallelTrialCount to set.
     * @return This builder for chaining.
     */
    public Builder setParallelTrialCount(int value) {

      parallelTrialCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired number of Trials to run in parallel.
     * </pre>
     *
     * <code>int32 parallel_trial_count = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParallelTrialCount() {

      parallelTrialCount_ = 0;
      onChanged();
      return this;
    }

    private int maxFailedTrialCount_;
    /**
     *
     *
     * <pre>
     * The number of failed Trials that need to be seen before failing
     * the HyperparameterTuningJob.
     * If set to 0, Vertex AI decides how many Trials must fail
     * before the whole job fails.
     * </pre>
     *
     * <code>int32 max_failed_trial_count = 7;</code>
     *
     * @return The maxFailedTrialCount.
     */
    @java.lang.Override
    public int getMaxFailedTrialCount() {
      return maxFailedTrialCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of failed Trials that need to be seen before failing
     * the HyperparameterTuningJob.
     * If set to 0, Vertex AI decides how many Trials must fail
     * before the whole job fails.
     * </pre>
     *
     * <code>int32 max_failed_trial_count = 7;</code>
     *
     * @param value The maxFailedTrialCount to set.
     * @return This builder for chaining.
     */
    public Builder setMaxFailedTrialCount(int value) {

      maxFailedTrialCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of failed Trials that need to be seen before failing
     * the HyperparameterTuningJob.
     * If set to 0, Vertex AI decides how many Trials must fail
     * before the whole job fails.
     * </pre>
     *
     * <code>int32 max_failed_trial_count = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxFailedTrialCount() {

      maxFailedTrialCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.CustomJobSpec trialJobSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.CustomJobSpec,
            com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.CustomJobSpecOrBuilder>
        trialJobSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The spec of a trial job. The same spec applies to the CustomJobs created
     * in all the trials.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CustomJobSpec trial_job_spec = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the trialJobSpec field is set.
     */
    public boolean hasTrialJobSpec() {
      return trialJobSpecBuilder_ != null || trialJobSpec_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of a trial job. The same spec applies to the CustomJobs created
     * in all the trials.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CustomJobSpec trial_job_spec = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The trialJobSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.CustomJobSpec getTrialJobSpec() {
      if (trialJobSpecBuilder_ == null) {
        return trialJobSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.CustomJobSpec.getDefaultInstance()
            : trialJobSpec_;
      } else {
        return trialJobSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of a trial job. The same spec applies to the CustomJobs created
     * in all the trials.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CustomJobSpec trial_job_spec = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTrialJobSpec(com.google.cloud.aiplatform.v1beta1.CustomJobSpec value) {
      if (trialJobSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trialJobSpec_ = value;
        onChanged();
      } else {
        trialJobSpecBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of a trial job. The same spec applies to the CustomJobs created
     * in all the trials.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CustomJobSpec trial_job_spec = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTrialJobSpec(
        com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder builderForValue) {
      if (trialJobSpecBuilder_ == null) {
        trialJobSpec_ = builderForValue.build();
        onChanged();
      } else {
        trialJobSpecBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of a trial job. The same spec applies to the CustomJobs created
     * in all the trials.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CustomJobSpec trial_job_spec = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeTrialJobSpec(com.google.cloud.aiplatform.v1beta1.CustomJobSpec value) {
      if (trialJobSpecBuilder_ == null) {
        if (trialJobSpec_ != null) {
          trialJobSpec_ =
              com.google.cloud.aiplatform.v1beta1.CustomJobSpec.newBuilder(trialJobSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          trialJobSpec_ = value;
        }
        onChanged();
      } else {
        trialJobSpecBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of a trial job. The same spec applies to the CustomJobs created
     * in all the trials.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CustomJobSpec trial_job_spec = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearTrialJobSpec() {
      if (trialJobSpecBuilder_ == null) {
        trialJobSpec_ = null;
        onChanged();
      } else {
        trialJobSpec_ = null;
        trialJobSpecBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of a trial job. The same spec applies to the CustomJobs created
     * in all the trials.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CustomJobSpec trial_job_spec = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder getTrialJobSpecBuilder() {

      onChanged();
      return getTrialJobSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of a trial job. The same spec applies to the CustomJobs created
     * in all the trials.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CustomJobSpec trial_job_spec = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.CustomJobSpecOrBuilder getTrialJobSpecOrBuilder() {
      if (trialJobSpecBuilder_ != null) {
        return trialJobSpecBuilder_.getMessageOrBuilder();
      } else {
        return trialJobSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.CustomJobSpec.getDefaultInstance()
            : trialJobSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of a trial job. The same spec applies to the CustomJobs created
     * in all the trials.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CustomJobSpec trial_job_spec = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.CustomJobSpec,
            com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.CustomJobSpecOrBuilder>
        getTrialJobSpecFieldBuilder() {
      if (trialJobSpecBuilder_ == null) {
        trialJobSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.CustomJobSpec,
                com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.CustomJobSpecOrBuilder>(
                getTrialJobSpec(), getParentForChildren(), isClean());
        trialJobSpec_ = null;
      }
      return trialJobSpecBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.Trial> trials_ =
        java.util.Collections.emptyList();

    private void ensureTrialsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        trials_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Trial>(trials_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Trial,
            com.google.cloud.aiplatform.v1beta1.Trial.Builder,
            com.google.cloud.aiplatform.v1beta1.TrialOrBuilder>
        trialsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Trials of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Trial> getTrialsList() {
      if (trialsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(trials_);
      } else {
        return trialsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Trials of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getTrialsCount() {
      if (trialsBuilder_ == null) {
        return trials_.size();
      } else {
        return trialsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Trials of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Trial getTrials(int index) {
      if (trialsBuilder_ == null) {
        return trials_.get(index);
      } else {
        return trialsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Trials of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTrials(int index, com.google.cloud.aiplatform.v1beta1.Trial value) {
      if (trialsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrialsIsMutable();
        trials_.set(index, value);
        onChanged();
      } else {
        trialsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Trials of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTrials(
        int index, com.google.cloud.aiplatform.v1beta1.Trial.Builder builderForValue) {
      if (trialsBuilder_ == null) {
        ensureTrialsIsMutable();
        trials_.set(index, builderForValue.build());
        onChanged();
      } else {
        trialsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Trials of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTrials(com.google.cloud.aiplatform.v1beta1.Trial value) {
      if (trialsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrialsIsMutable();
        trials_.add(value);
        onChanged();
      } else {
        trialsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Trials of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTrials(int index, com.google.cloud.aiplatform.v1beta1.Trial value) {
      if (trialsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrialsIsMutable();
        trials_.add(index, value);
        onChanged();
      } else {
        trialsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Trials of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTrials(com.google.cloud.aiplatform.v1beta1.Trial.Builder builderForValue) {
      if (trialsBuilder_ == null) {
        ensureTrialsIsMutable();
        trials_.add(builderForValue.build());
        onChanged();
      } else {
        trialsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Trials of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTrials(
        int index, com.google.cloud.aiplatform.v1beta1.Trial.Builder builderForValue) {
      if (trialsBuilder_ == null) {
        ensureTrialsIsMutable();
        trials_.add(index, builderForValue.build());
        onChanged();
      } else {
        trialsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Trials of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllTrials(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.Trial> values) {
      if (trialsBuilder_ == null) {
        ensureTrialsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, trials_);
        onChanged();
      } else {
        trialsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Trials of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTrials() {
      if (trialsBuilder_ == null) {
        trials_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        trialsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Trials of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeTrials(int index) {
      if (trialsBuilder_ == null) {
        ensureTrialsIsMutable();
        trials_.remove(index);
        onChanged();
      } else {
        trialsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Trials of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Trial.Builder getTrialsBuilder(int index) {
      return getTrialsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Trials of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.TrialOrBuilder getTrialsOrBuilder(int index) {
      if (trialsBuilder_ == null) {
        return trials_.get(index);
      } else {
        return trialsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Trials of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.TrialOrBuilder>
        getTrialsOrBuilderList() {
      if (trialsBuilder_ != null) {
        return trialsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(trials_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Trials of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Trial.Builder addTrialsBuilder() {
      return getTrialsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.Trial.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Trials of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Trial.Builder addTrialsBuilder(int index) {
      return getTrialsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.Trial.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Trials of the HyperparameterTuningJob.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Trial trials = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Trial.Builder>
        getTrialsBuilderList() {
      return getTrialsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Trial,
            com.google.cloud.aiplatform.v1beta1.Trial.Builder,
            com.google.cloud.aiplatform.v1beta1.TrialOrBuilder>
        getTrialsFieldBuilder() {
      if (trialsBuilder_ == null) {
        trialsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Trial,
                com.google.cloud.aiplatform.v1beta1.Trial.Builder,
                com.google.cloud.aiplatform.v1beta1.TrialOrBuilder>(
                trials_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        trials_ = null;
      }
      return trialsBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.JobState getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.aiplatform.v1beta1.JobState result =
          com.google.cloud.aiplatform.v1beta1.JobState.valueOf(state_);
      return result == null ? com.google.cloud.aiplatform.v1beta1.JobState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.aiplatform.v1beta1.JobState value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return startTimeBuilder_ != null || startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
        onChanged();
      } else {
        startTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
        onChanged();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (startTime_ != null) {
          startTime_ =
              com.google.protobuf.Timestamp.newBuilder(startTime_).mergeFrom(value).buildPartial();
        } else {
          startTime_ = value;
        }
        onChanged();
      } else {
        startTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      if (startTimeBuilder_ == null) {
        startTime_ = null;
        onChanged();
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return endTimeBuilder_ != null || endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
        onChanged();
      } else {
        endTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
        onChanged();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (endTime_ != null) {
          endTime_ =
              com.google.protobuf.Timestamp.newBuilder(endTime_).mergeFrom(value).buildPartial();
        } else {
          endTime_ = value;
        }
        onChanged();
      } else {
        endTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      if (endTimeBuilder_ == null) {
        endTime_ = null;
        onChanged();
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {

      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the HyperparameterTuningJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Only populated when job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return errorBuilder_ != null || error_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
        onChanged();
      } else {
        errorBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
        onChanged();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (error_ != null) {
          error_ = com.google.rpc.Status.newBuilder(error_).mergeFrom(value).buildPartial();
        } else {
          error_ = value;
        }
        onChanged();
      } else {
        errorBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearError() {
      if (errorBuilder_ == null) {
        error_ = null;
        onChanged();
      } else {
        error_ = null;
        errorBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {

      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize HyperparameterTuningJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize HyperparameterTuningJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize HyperparameterTuningJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize HyperparameterTuningJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize HyperparameterTuningJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize HyperparameterTuningJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize HyperparameterTuningJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a HyperparameterTuningJob.
     * If this is set, then all resources created by the HyperparameterTuningJob
     * will be encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 17;</code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return encryptionSpecBuilder_ != null || encryptionSpec_ != null;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a HyperparameterTuningJob.
     * If this is set, then all resources created by the HyperparameterTuningJob
     * will be encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 17;</code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a HyperparameterTuningJob.
     * If this is set, then all resources created by the HyperparameterTuningJob
     * will be encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 17;</code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
        onChanged();
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a HyperparameterTuningJob.
     * If this is set, then all resources created by the HyperparameterTuningJob
     * will be encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 17;</code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
        onChanged();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a HyperparameterTuningJob.
     * If this is set, then all resources created by the HyperparameterTuningJob
     * will be encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 17;</code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (encryptionSpec_ != null) {
          encryptionSpec_ =
              com.google.cloud.aiplatform.v1beta1.EncryptionSpec.newBuilder(encryptionSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          encryptionSpec_ = value;
        }
        onChanged();
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a HyperparameterTuningJob.
     * If this is set, then all resources created by the HyperparameterTuningJob
     * will be encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 17;</code>
     */
    public Builder clearEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = null;
        onChanged();
      } else {
        encryptionSpec_ = null;
        encryptionSpecBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a HyperparameterTuningJob.
     * If this is set, then all resources created by the HyperparameterTuningJob
     * will be encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 17;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder getEncryptionSpecBuilder() {

      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a HyperparameterTuningJob.
     * If this is set, then all resources created by the HyperparameterTuningJob
     * will be encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 17;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder
        getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a HyperparameterTuningJob.
     * If this is set, then all resources created by the HyperparameterTuningJob
     * will be encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.HyperparameterTuningJob)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.HyperparameterTuningJob)
  private static final com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob();
  }

  public static com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HyperparameterTuningJob> PARSER =
      new com.google.protobuf.AbstractParser<HyperparameterTuningJob>() {
        @java.lang.Override
        public HyperparameterTuningJob parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new HyperparameterTuningJob(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<HyperparameterTuningJob> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HyperparameterTuningJob> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.HyperparameterTuningJob getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
