/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TrainingPipelineName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String trainingPipeline;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTrainingPipeline() {
        return this.trainingPipeline;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private TrainingPipelineName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.trainingPipeline = (String)Preconditions.checkNotNull((Object)builder.getTrainingPipeline());
    }

    public static TrainingPipelineName of(String project, String location, String trainingPipeline) {
        return TrainingPipelineName.newBuilder().setProject(project).setLocation(location).setTrainingPipeline(trainingPipeline).build();
    }

    public static String format(String project, String location, String trainingPipeline) {
        return TrainingPipelineName.newBuilder().setProject(project).setLocation(location).setTrainingPipeline(trainingPipeline).build().toString();
    }

    public static TrainingPipelineName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "TrainingPipelineName.parse: formattedString not in valid format");
        return TrainingPipelineName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("training_pipeline"));
    }

    public static List<TrainingPipelineName> parseList(List<String> formattedStrings) {
        ArrayList<TrainingPipelineName> list = new ArrayList<TrainingPipelineName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TrainingPipelineName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TrainingPipelineName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TrainingPipelineName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TrainingPipelineName trainingPipelineName = this;
            synchronized (trainingPipelineName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"trainingPipeline", (Object)this.trainingPipeline);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "training_pipeline", this.trainingPipeline});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TrainingPipelineName) {
            TrainingPipelineName that = (TrainingPipelineName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.trainingPipeline.equals(that.trainingPipeline);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.trainingPipeline.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String trainingPipeline;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTrainingPipeline() {
            return this.trainingPipeline;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTrainingPipeline(String trainingPipeline) {
            this.trainingPipeline = trainingPipeline;
            return this;
        }

        private Builder() {
        }

        private Builder(TrainingPipelineName trainingPipelineName) {
            this.project = trainingPipelineName.project;
            this.location = trainingPipelineName.location;
            this.trainingPipeline = trainingPipelineName.trainingPipeline;
        }

        public TrainingPipelineName build() {
            return new TrainingPipelineName(this);
        }
    }
}

