/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DataLabelingJobName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataLabelingJob;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataLabelingJob() {
        return this.dataLabelingJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DataLabelingJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataLabelingJob = (String)Preconditions.checkNotNull((Object)builder.getDataLabelingJob());
    }

    public static DataLabelingJobName of(String project, String location, String dataLabelingJob) {
        return DataLabelingJobName.newBuilder().setProject(project).setLocation(location).setDataLabelingJob(dataLabelingJob).build();
    }

    public static String format(String project, String location, String dataLabelingJob) {
        return DataLabelingJobName.newBuilder().setProject(project).setLocation(location).setDataLabelingJob(dataLabelingJob).build().toString();
    }

    public static DataLabelingJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "DataLabelingJobName.parse: formattedString not in valid format");
        return DataLabelingJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_labeling_job"));
    }

    public static List<DataLabelingJobName> parseList(List<String> formattedStrings) {
        ArrayList<DataLabelingJobName> list = new ArrayList<DataLabelingJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DataLabelingJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DataLabelingJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DataLabelingJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataLabelingJobName dataLabelingJobName = this;
            synchronized (dataLabelingJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"dataLabelingJob", (Object)this.dataLabelingJob);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "data_labeling_job", this.dataLabelingJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DataLabelingJobName) {
            DataLabelingJobName that = (DataLabelingJobName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.dataLabelingJob.equals(that.dataLabelingJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.dataLabelingJob.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataLabelingJob;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataLabelingJob() {
            return this.dataLabelingJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataLabelingJob(String dataLabelingJob) {
            this.dataLabelingJob = dataLabelingJob;
            return this;
        }

        private Builder() {
        }

        private Builder(DataLabelingJobName dataLabelingJobName) {
            this.project = dataLabelingJobName.project;
            this.location = dataLabelingJobName.location;
            this.dataLabelingJob = dataLabelingJobName.dataLabelingJob;
        }

        public DataLabelingJobName build() {
            return new DataLabelingJobName(this);
        }
    }
}

