/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NotebookRuntimeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_NOTEBOOK_RUNTIME = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/notebookRuntimes/{notebook_runtime}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String notebookRuntime;

    @Deprecated
    protected NotebookRuntimeName() {
        this.project = null;
        this.location = null;
        this.notebookRuntime = null;
    }

    private NotebookRuntimeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.notebookRuntime = (String)Preconditions.checkNotNull((Object)builder.getNotebookRuntime());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNotebookRuntime() {
        return this.notebookRuntime;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NotebookRuntimeName of(String project, String location, String notebookRuntime) {
        return NotebookRuntimeName.newBuilder().setProject(project).setLocation(location).setNotebookRuntime(notebookRuntime).build();
    }

    public static String format(String project, String location, String notebookRuntime) {
        return NotebookRuntimeName.newBuilder().setProject(project).setLocation(location).setNotebookRuntime(notebookRuntime).build().toString();
    }

    public static NotebookRuntimeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_NOTEBOOK_RUNTIME.validatedMatch(formattedString, "NotebookRuntimeName.parse: formattedString not in valid format");
        return NotebookRuntimeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("notebook_runtime"));
    }

    public static List<NotebookRuntimeName> parseList(List<String> formattedStrings) {
        ArrayList<NotebookRuntimeName> list = new ArrayList<NotebookRuntimeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NotebookRuntimeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NotebookRuntimeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NotebookRuntimeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_NOTEBOOK_RUNTIME.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NotebookRuntimeName notebookRuntimeName = this;
            synchronized (notebookRuntimeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.notebookRuntime != null) {
                        fieldMapBuilder.put((Object)"notebook_runtime", (Object)this.notebookRuntime);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_NOTEBOOK_RUNTIME.instantiate(new String[]{"project", this.project, "location", this.location, "notebook_runtime", this.notebookRuntime});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            NotebookRuntimeName that = (NotebookRuntimeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.notebookRuntime, that.notebookRuntime);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.notebookRuntime);
    }

    public static class Builder {
        private String project;
        private String location;
        private String notebookRuntime;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNotebookRuntime() {
            return this.notebookRuntime;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setNotebookRuntime(String notebookRuntime) {
            this.notebookRuntime = notebookRuntime;
            return this;
        }

        private Builder(NotebookRuntimeName notebookRuntimeName) {
            this.project = notebookRuntimeName.project;
            this.location = notebookRuntimeName.location;
            this.notebookRuntime = notebookRuntimeName.notebookRuntime;
        }

        public NotebookRuntimeName build() {
            return new NotebookRuntimeName(this);
        }
    }
}

