/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TrainingPipelineName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TRAINING_PIPELINE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String trainingPipeline;

    @Deprecated
    protected TrainingPipelineName() {
        this.project = null;
        this.location = null;
        this.trainingPipeline = null;
    }

    private TrainingPipelineName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.trainingPipeline = (String)Preconditions.checkNotNull((Object)builder.getTrainingPipeline());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTrainingPipeline() {
        return this.trainingPipeline;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TrainingPipelineName of(String project, String location, String trainingPipeline) {
        return TrainingPipelineName.newBuilder().setProject(project).setLocation(location).setTrainingPipeline(trainingPipeline).build();
    }

    public static String format(String project, String location, String trainingPipeline) {
        return TrainingPipelineName.newBuilder().setProject(project).setLocation(location).setTrainingPipeline(trainingPipeline).build().toString();
    }

    public static TrainingPipelineName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TRAINING_PIPELINE.validatedMatch(formattedString, "TrainingPipelineName.parse: formattedString not in valid format");
        return TrainingPipelineName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("training_pipeline"));
    }

    public static List<TrainingPipelineName> parseList(List<String> formattedStrings) {
        ArrayList<TrainingPipelineName> list = new ArrayList<TrainingPipelineName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TrainingPipelineName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TrainingPipelineName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TrainingPipelineName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TRAINING_PIPELINE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TrainingPipelineName trainingPipelineName = this;
            synchronized (trainingPipelineName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.trainingPipeline != null) {
                        fieldMapBuilder.put((Object)"training_pipeline", (Object)this.trainingPipeline);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TRAINING_PIPELINE.instantiate(new String[]{"project", this.project, "location", this.location, "training_pipeline", this.trainingPipeline});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TrainingPipelineName that = (TrainingPipelineName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.trainingPipeline, that.trainingPipeline);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.trainingPipeline);
    }

    public static class Builder {
        private String project;
        private String location;
        private String trainingPipeline;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTrainingPipeline() {
            return this.trainingPipeline;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTrainingPipeline(String trainingPipeline) {
            this.trainingPipeline = trainingPipeline;
            return this;
        }

        private Builder(TrainingPipelineName trainingPipelineName) {
            this.project = trainingPipelineName.project;
            this.location = trainingPipelineName.location;
            this.trainingPipeline = trainingPipelineName.trainingPipeline;
        }

        public TrainingPipelineName build() {
            return new TrainingPipelineName(this);
        }
    }
}

