/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/endpoint.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Configuration for Speculative Decoding.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.SpeculativeDecodingSpec}
 */
public final class SpeculativeDecodingSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.SpeculativeDecodingSpec)
    SpeculativeDecodingSpecOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SpeculativeDecodingSpec.newBuilder() to construct.
  private SpeculativeDecodingSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SpeculativeDecodingSpec() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SpeculativeDecodingSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.EndpointProto
        .internal_static_google_cloud_aiplatform_v1_SpeculativeDecodingSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.EndpointProto
        .internal_static_google_cloud_aiplatform_v1_SpeculativeDecodingSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.class,
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.Builder.class);
  }

  public interface DraftModelSpeculationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The resource name of the draft model.
     * </pre>
     *
     * <code>
     * string draft_model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The draftModel.
     */
    java.lang.String getDraftModel();

    /**
     *
     *
     * <pre>
     * Required. The resource name of the draft model.
     * </pre>
     *
     * <code>
     * string draft_model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for draftModel.
     */
    com.google.protobuf.ByteString getDraftModelBytes();
  }

  /**
   *
   *
   * <pre>
   * Draft model speculation works by using the smaller model to generate
   * candidate tokens for speculative decoding.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation}
   */
  public static final class DraftModelSpeculation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation)
      DraftModelSpeculationOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use DraftModelSpeculation.newBuilder() to construct.
    private DraftModelSpeculation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DraftModelSpeculation() {
      draftModel_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DraftModelSpeculation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1_SpeculativeDecodingSpec_DraftModelSpeculation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1_SpeculativeDecodingSpec_DraftModelSpeculation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation.class,
              com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation.Builder
                  .class);
    }

    public static final int DRAFT_MODEL_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object draftModel_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource name of the draft model.
     * </pre>
     *
     * <code>
     * string draft_model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The draftModel.
     */
    @java.lang.Override
    public java.lang.String getDraftModel() {
      java.lang.Object ref = draftModel_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        draftModel_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the draft model.
     * </pre>
     *
     * <code>
     * string draft_model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for draftModel.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDraftModelBytes() {
      java.lang.Object ref = draftModel_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        draftModel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(draftModel_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, draftModel_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(draftModel_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, draftModel_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation other =
          (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation) obj;

      if (!getDraftModel().equals(other.getDraftModel())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DRAFT_MODEL_FIELD_NUMBER;
      hash = (53 * hash) + getDraftModel().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Draft model speculation works by using the smaller model to generate
     * candidate tokens for speculative decoding.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation)
        com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.EndpointProto
            .internal_static_google_cloud_aiplatform_v1_SpeculativeDecodingSpec_DraftModelSpeculation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.EndpointProto
            .internal_static_google_cloud_aiplatform_v1_SpeculativeDecodingSpec_DraftModelSpeculation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation.class,
                com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        draftModel_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.EndpointProto
            .internal_static_google_cloud_aiplatform_v1_SpeculativeDecodingSpec_DraftModelSpeculation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation build() {
        com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
          buildPartial() {
        com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation result =
            new com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.draftModel_ = draftModel_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation other) {
        if (other
            == com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
                .getDefaultInstance()) return this;
        if (!other.getDraftModel().isEmpty()) {
          draftModel_ = other.draftModel_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  draftModel_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object draftModel_ = "";

      /**
       *
       *
       * <pre>
       * Required. The resource name of the draft model.
       * </pre>
       *
       * <code>
       * string draft_model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The draftModel.
       */
      public java.lang.String getDraftModel() {
        java.lang.Object ref = draftModel_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          draftModel_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The resource name of the draft model.
       * </pre>
       *
       * <code>
       * string draft_model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for draftModel.
       */
      public com.google.protobuf.ByteString getDraftModelBytes() {
        java.lang.Object ref = draftModel_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          draftModel_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The resource name of the draft model.
       * </pre>
       *
       * <code>
       * string draft_model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The draftModel to set.
       * @return This builder for chaining.
       */
      public Builder setDraftModel(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        draftModel_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The resource name of the draft model.
       * </pre>
       *
       * <code>
       * string draft_model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDraftModel() {
        draftModel_ = getDefaultInstance().getDraftModel();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The resource name of the draft model.
       * </pre>
       *
       * <code>
       * string draft_model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for draftModel to set.
       * @return This builder for chaining.
       */
      public Builder setDraftModelBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        draftModel_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation)
    private static final com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec
            .DraftModelSpeculation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation();
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DraftModelSpeculation> PARSER =
        new com.google.protobuf.AbstractParser<DraftModelSpeculation>() {
          @java.lang.Override
          public DraftModelSpeculation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DraftModelSpeculation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DraftModelSpeculation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NgramSpeculationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The number of last N input tokens used as ngram to search/match
     * against the previous prompt sequence.
     * This is equal to the N in N-Gram.
     * The default value is 3 if not specified.
     * </pre>
     *
     * <code>int32 ngram_size = 1;</code>
     *
     * @return The ngramSize.
     */
    int getNgramSize();
  }

  /**
   *
   *
   * <pre>
   * N-Gram speculation works by trying to find matching tokens in the
   * previous prompt sequence and use those as speculation for generating
   * new tokens.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation}
   */
  public static final class NgramSpeculation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation)
      NgramSpeculationOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use NgramSpeculation.newBuilder() to construct.
    private NgramSpeculation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NgramSpeculation() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new NgramSpeculation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1_SpeculativeDecodingSpec_NgramSpeculation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1_SpeculativeDecodingSpec_NgramSpeculation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation.class,
              com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation.Builder
                  .class);
    }

    public static final int NGRAM_SIZE_FIELD_NUMBER = 1;
    private int ngramSize_ = 0;

    /**
     *
     *
     * <pre>
     * The number of last N input tokens used as ngram to search/match
     * against the previous prompt sequence.
     * This is equal to the N in N-Gram.
     * The default value is 3 if not specified.
     * </pre>
     *
     * <code>int32 ngram_size = 1;</code>
     *
     * @return The ngramSize.
     */
    @java.lang.Override
    public int getNgramSize() {
      return ngramSize_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (ngramSize_ != 0) {
        output.writeInt32(1, ngramSize_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (ngramSize_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, ngramSize_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation other =
          (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation) obj;

      if (getNgramSize() != other.getNgramSize()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NGRAM_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getNgramSize();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * N-Gram speculation works by trying to find matching tokens in the
     * previous prompt sequence and use those as speculation for generating
     * new tokens.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation)
        com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.EndpointProto
            .internal_static_google_cloud_aiplatform_v1_SpeculativeDecodingSpec_NgramSpeculation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.EndpointProto
            .internal_static_google_cloud_aiplatform_v1_SpeculativeDecodingSpec_NgramSpeculation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation.class,
                com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        ngramSize_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.EndpointProto
            .internal_static_google_cloud_aiplatform_v1_SpeculativeDecodingSpec_NgramSpeculation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation build() {
        com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation
          buildPartial() {
        com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation result =
            new com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.ngramSize_ = ngramSize_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation other) {
        if (other
            == com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation
                .getDefaultInstance()) return this;
        if (other.getNgramSize() != 0) {
          setNgramSize(other.getNgramSize());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  ngramSize_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int ngramSize_;

      /**
       *
       *
       * <pre>
       * The number of last N input tokens used as ngram to search/match
       * against the previous prompt sequence.
       * This is equal to the N in N-Gram.
       * The default value is 3 if not specified.
       * </pre>
       *
       * <code>int32 ngram_size = 1;</code>
       *
       * @return The ngramSize.
       */
      @java.lang.Override
      public int getNgramSize() {
        return ngramSize_;
      }

      /**
       *
       *
       * <pre>
       * The number of last N input tokens used as ngram to search/match
       * against the previous prompt sequence.
       * This is equal to the N in N-Gram.
       * The default value is 3 if not specified.
       * </pre>
       *
       * <code>int32 ngram_size = 1;</code>
       *
       * @param value The ngramSize to set.
       * @return This builder for chaining.
       */
      public Builder setNgramSize(int value) {

        ngramSize_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The number of last N input tokens used as ngram to search/match
       * against the previous prompt sequence.
       * This is equal to the N in N-Gram.
       * The default value is 3 if not specified.
       * </pre>
       *
       * <code>int32 ngram_size = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNgramSize() {
        bitField0_ = (bitField0_ & ~0x00000001);
        ngramSize_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation)
    private static final com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation();
    }

    public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NgramSpeculation> PARSER =
        new com.google.protobuf.AbstractParser<NgramSpeculation>() {
          @java.lang.Override
          public NgramSpeculation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<NgramSpeculation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NgramSpeculation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int speculationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object speculation_;

  public enum SpeculationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DRAFT_MODEL_SPECULATION(2),
    NGRAM_SPECULATION(3),
    SPECULATION_NOT_SET(0);
    private final int value;

    private SpeculationCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SpeculationCase valueOf(int value) {
      return forNumber(value);
    }

    public static SpeculationCase forNumber(int value) {
      switch (value) {
        case 2:
          return DRAFT_MODEL_SPECULATION;
        case 3:
          return NGRAM_SPECULATION;
        case 0:
          return SPECULATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SpeculationCase getSpeculationCase() {
    return SpeculationCase.forNumber(speculationCase_);
  }

  public static final int DRAFT_MODEL_SPECULATION_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * draft model speculation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation draft_model_speculation = 2;
   * </code>
   *
   * @return Whether the draftModelSpeculation field is set.
   */
  @java.lang.Override
  public boolean hasDraftModelSpeculation() {
    return speculationCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * draft model speculation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation draft_model_speculation = 2;
   * </code>
   *
   * @return The draftModelSpeculation.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
      getDraftModelSpeculation() {
    if (speculationCase_ == 2) {
      return (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation)
          speculation_;
    }
    return com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * draft model speculation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation draft_model_speculation = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculationOrBuilder
      getDraftModelSpeculationOrBuilder() {
    if (speculationCase_ == 2) {
      return (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation)
          speculation_;
    }
    return com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
        .getDefaultInstance();
  }

  public static final int NGRAM_SPECULATION_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * N-Gram speculation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation ngram_speculation = 3;
   * </code>
   *
   * @return Whether the ngramSpeculation field is set.
   */
  @java.lang.Override
  public boolean hasNgramSpeculation() {
    return speculationCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * N-Gram speculation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation ngram_speculation = 3;
   * </code>
   *
   * @return The ngramSpeculation.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation
      getNgramSpeculation() {
    if (speculationCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation) speculation_;
    }
    return com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * N-Gram speculation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation ngram_speculation = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculationOrBuilder
      getNgramSpeculationOrBuilder() {
    if (speculationCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation) speculation_;
    }
    return com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation
        .getDefaultInstance();
  }

  public static final int SPECULATIVE_TOKEN_COUNT_FIELD_NUMBER = 1;
  private int speculativeTokenCount_ = 0;

  /**
   *
   *
   * <pre>
   * The number of speculative tokens to generate at each step.
   * </pre>
   *
   * <code>int32 speculative_token_count = 1;</code>
   *
   * @return The speculativeTokenCount.
   */
  @java.lang.Override
  public int getSpeculativeTokenCount() {
    return speculativeTokenCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (speculativeTokenCount_ != 0) {
      output.writeInt32(1, speculativeTokenCount_);
    }
    if (speculationCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation)
              speculation_);
    }
    if (speculationCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation) speculation_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (speculativeTokenCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, speculativeTokenCount_);
    }
    if (speculationCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation)
                  speculation_);
    }
    if (speculationCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation)
                  speculation_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec other =
        (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec) obj;

    if (getSpeculativeTokenCount() != other.getSpeculativeTokenCount()) return false;
    if (!getSpeculationCase().equals(other.getSpeculationCase())) return false;
    switch (speculationCase_) {
      case 2:
        if (!getDraftModelSpeculation().equals(other.getDraftModelSpeculation())) return false;
        break;
      case 3:
        if (!getNgramSpeculation().equals(other.getNgramSpeculation())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SPECULATIVE_TOKEN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getSpeculativeTokenCount();
    switch (speculationCase_) {
      case 2:
        hash = (37 * hash) + DRAFT_MODEL_SPECULATION_FIELD_NUMBER;
        hash = (53 * hash) + getDraftModelSpeculation().hashCode();
        break;
      case 3:
        hash = (37 * hash) + NGRAM_SPECULATION_FIELD_NUMBER;
        hash = (53 * hash) + getNgramSpeculation().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Configuration for Speculative Decoding.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.SpeculativeDecodingSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.SpeculativeDecodingSpec)
      com.google.cloud.aiplatform.v1.SpeculativeDecodingSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1_SpeculativeDecodingSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1_SpeculativeDecodingSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.class,
              com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (draftModelSpeculationBuilder_ != null) {
        draftModelSpeculationBuilder_.clear();
      }
      if (ngramSpeculationBuilder_ != null) {
        ngramSpeculationBuilder_.clear();
      }
      speculativeTokenCount_ = 0;
      speculationCase_ = 0;
      speculation_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1_SpeculativeDecodingSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec build() {
      com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec buildPartial() {
      com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec result =
          new com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.speculativeTokenCount_ = speculativeTokenCount_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec result) {
      result.speculationCase_ = speculationCase_;
      result.speculation_ = this.speculation_;
      if (speculationCase_ == 2 && draftModelSpeculationBuilder_ != null) {
        result.speculation_ = draftModelSpeculationBuilder_.build();
      }
      if (speculationCase_ == 3 && ngramSpeculationBuilder_ != null) {
        result.speculation_ = ngramSpeculationBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec other) {
      if (other == com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.getDefaultInstance())
        return this;
      if (other.getSpeculativeTokenCount() != 0) {
        setSpeculativeTokenCount(other.getSpeculativeTokenCount());
      }
      switch (other.getSpeculationCase()) {
        case DRAFT_MODEL_SPECULATION:
          {
            mergeDraftModelSpeculation(other.getDraftModelSpeculation());
            break;
          }
        case NGRAM_SPECULATION:
          {
            mergeNgramSpeculation(other.getNgramSpeculation());
            break;
          }
        case SPECULATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                speculativeTokenCount_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(
                    getDraftModelSpeculationFieldBuilder().getBuilder(), extensionRegistry);
                speculationCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getNgramSpeculationFieldBuilder().getBuilder(), extensionRegistry);
                speculationCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int speculationCase_ = 0;
    private java.lang.Object speculation_;

    public SpeculationCase getSpeculationCase() {
      return SpeculationCase.forNumber(speculationCase_);
    }

    public Builder clearSpeculation() {
      speculationCase_ = 0;
      speculation_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation,
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation.Builder,
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculationOrBuilder>
        draftModelSpeculationBuilder_;

    /**
     *
     *
     * <pre>
     * draft model speculation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation draft_model_speculation = 2;
     * </code>
     *
     * @return Whether the draftModelSpeculation field is set.
     */
    @java.lang.Override
    public boolean hasDraftModelSpeculation() {
      return speculationCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * draft model speculation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation draft_model_speculation = 2;
     * </code>
     *
     * @return The draftModelSpeculation.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
        getDraftModelSpeculation() {
      if (draftModelSpeculationBuilder_ == null) {
        if (speculationCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation)
              speculation_;
        }
        return com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
            .getDefaultInstance();
      } else {
        if (speculationCase_ == 2) {
          return draftModelSpeculationBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * draft model speculation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation draft_model_speculation = 2;
     * </code>
     */
    public Builder setDraftModelSpeculation(
        com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation value) {
      if (draftModelSpeculationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        speculation_ = value;
        onChanged();
      } else {
        draftModelSpeculationBuilder_.setMessage(value);
      }
      speculationCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * draft model speculation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation draft_model_speculation = 2;
     * </code>
     */
    public Builder setDraftModelSpeculation(
        com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation.Builder
            builderForValue) {
      if (draftModelSpeculationBuilder_ == null) {
        speculation_ = builderForValue.build();
        onChanged();
      } else {
        draftModelSpeculationBuilder_.setMessage(builderForValue.build());
      }
      speculationCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * draft model speculation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation draft_model_speculation = 2;
     * </code>
     */
    public Builder mergeDraftModelSpeculation(
        com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation value) {
      if (draftModelSpeculationBuilder_ == null) {
        if (speculationCase_ == 2
            && speculation_
                != com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
                    .getDefaultInstance()) {
          speculation_ =
              com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation)
                          speculation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          speculation_ = value;
        }
        onChanged();
      } else {
        if (speculationCase_ == 2) {
          draftModelSpeculationBuilder_.mergeFrom(value);
        } else {
          draftModelSpeculationBuilder_.setMessage(value);
        }
      }
      speculationCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * draft model speculation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation draft_model_speculation = 2;
     * </code>
     */
    public Builder clearDraftModelSpeculation() {
      if (draftModelSpeculationBuilder_ == null) {
        if (speculationCase_ == 2) {
          speculationCase_ = 0;
          speculation_ = null;
          onChanged();
        }
      } else {
        if (speculationCase_ == 2) {
          speculationCase_ = 0;
          speculation_ = null;
        }
        draftModelSpeculationBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * draft model speculation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation draft_model_speculation = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation.Builder
        getDraftModelSpeculationBuilder() {
      return getDraftModelSpeculationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * draft model speculation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation draft_model_speculation = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculationOrBuilder
        getDraftModelSpeculationOrBuilder() {
      if ((speculationCase_ == 2) && (draftModelSpeculationBuilder_ != null)) {
        return draftModelSpeculationBuilder_.getMessageOrBuilder();
      } else {
        if (speculationCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation)
              speculation_;
        }
        return com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * draft model speculation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation draft_model_speculation = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation,
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation.Builder,
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculationOrBuilder>
        getDraftModelSpeculationFieldBuilder() {
      if (draftModelSpeculationBuilder_ == null) {
        if (!(speculationCase_ == 2)) {
          speculation_ =
              com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
                  .getDefaultInstance();
        }
        draftModelSpeculationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation,
                com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation
                    .Builder,
                com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec
                    .DraftModelSpeculationOrBuilder>(
                (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.DraftModelSpeculation)
                    speculation_,
                getParentForChildren(),
                isClean());
        speculation_ = null;
      }
      speculationCase_ = 2;
      onChanged();
      return draftModelSpeculationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation,
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation.Builder,
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculationOrBuilder>
        ngramSpeculationBuilder_;

    /**
     *
     *
     * <pre>
     * N-Gram speculation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation ngram_speculation = 3;
     * </code>
     *
     * @return Whether the ngramSpeculation field is set.
     */
    @java.lang.Override
    public boolean hasNgramSpeculation() {
      return speculationCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * N-Gram speculation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation ngram_speculation = 3;
     * </code>
     *
     * @return The ngramSpeculation.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation
        getNgramSpeculation() {
      if (ngramSpeculationBuilder_ == null) {
        if (speculationCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation)
              speculation_;
        }
        return com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation
            .getDefaultInstance();
      } else {
        if (speculationCase_ == 3) {
          return ngramSpeculationBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * N-Gram speculation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation ngram_speculation = 3;
     * </code>
     */
    public Builder setNgramSpeculation(
        com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation value) {
      if (ngramSpeculationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        speculation_ = value;
        onChanged();
      } else {
        ngramSpeculationBuilder_.setMessage(value);
      }
      speculationCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * N-Gram speculation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation ngram_speculation = 3;
     * </code>
     */
    public Builder setNgramSpeculation(
        com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation.Builder
            builderForValue) {
      if (ngramSpeculationBuilder_ == null) {
        speculation_ = builderForValue.build();
        onChanged();
      } else {
        ngramSpeculationBuilder_.setMessage(builderForValue.build());
      }
      speculationCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * N-Gram speculation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation ngram_speculation = 3;
     * </code>
     */
    public Builder mergeNgramSpeculation(
        com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation value) {
      if (ngramSpeculationBuilder_ == null) {
        if (speculationCase_ == 3
            && speculation_
                != com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation
                    .getDefaultInstance()) {
          speculation_ =
              com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation.newBuilder(
                      (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation)
                          speculation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          speculation_ = value;
        }
        onChanged();
      } else {
        if (speculationCase_ == 3) {
          ngramSpeculationBuilder_.mergeFrom(value);
        } else {
          ngramSpeculationBuilder_.setMessage(value);
        }
      }
      speculationCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * N-Gram speculation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation ngram_speculation = 3;
     * </code>
     */
    public Builder clearNgramSpeculation() {
      if (ngramSpeculationBuilder_ == null) {
        if (speculationCase_ == 3) {
          speculationCase_ = 0;
          speculation_ = null;
          onChanged();
        }
      } else {
        if (speculationCase_ == 3) {
          speculationCase_ = 0;
          speculation_ = null;
        }
        ngramSpeculationBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * N-Gram speculation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation ngram_speculation = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation.Builder
        getNgramSpeculationBuilder() {
      return getNgramSpeculationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * N-Gram speculation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation ngram_speculation = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculationOrBuilder
        getNgramSpeculationOrBuilder() {
      if ((speculationCase_ == 3) && (ngramSpeculationBuilder_ != null)) {
        return ngramSpeculationBuilder_.getMessageOrBuilder();
      } else {
        if (speculationCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation)
              speculation_;
        }
        return com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * N-Gram speculation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation ngram_speculation = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation,
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation.Builder,
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculationOrBuilder>
        getNgramSpeculationFieldBuilder() {
      if (ngramSpeculationBuilder_ == null) {
        if (!(speculationCase_ == 3)) {
          speculation_ =
              com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation
                  .getDefaultInstance();
        }
        ngramSpeculationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation,
                com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation.Builder,
                com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculationOrBuilder>(
                (com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.NgramSpeculation)
                    speculation_,
                getParentForChildren(),
                isClean());
        speculation_ = null;
      }
      speculationCase_ = 3;
      onChanged();
      return ngramSpeculationBuilder_;
    }

    private int speculativeTokenCount_;

    /**
     *
     *
     * <pre>
     * The number of speculative tokens to generate at each step.
     * </pre>
     *
     * <code>int32 speculative_token_count = 1;</code>
     *
     * @return The speculativeTokenCount.
     */
    @java.lang.Override
    public int getSpeculativeTokenCount() {
      return speculativeTokenCount_;
    }

    /**
     *
     *
     * <pre>
     * The number of speculative tokens to generate at each step.
     * </pre>
     *
     * <code>int32 speculative_token_count = 1;</code>
     *
     * @param value The speculativeTokenCount to set.
     * @return This builder for chaining.
     */
    public Builder setSpeculativeTokenCount(int value) {

      speculativeTokenCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The number of speculative tokens to generate at each step.
     * </pre>
     *
     * <code>int32 speculative_token_count = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpeculativeTokenCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      speculativeTokenCount_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.SpeculativeDecodingSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.SpeculativeDecodingSpec)
  private static final com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec();
  }

  public static com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SpeculativeDecodingSpec> PARSER =
      new com.google.protobuf.AbstractParser<SpeculativeDecodingSpec>() {
        @java.lang.Override
        public SpeculativeDecodingSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SpeculativeDecodingSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SpeculativeDecodingSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
