/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/dataset.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Describes the location from where we import data into a Dataset, together
 * with the labels that will be applied to the DataItems and the Annotations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.ImportDataConfig}
 */
public final class ImportDataConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ImportDataConfig)
    ImportDataConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ImportDataConfig.newBuilder() to construct.
  private ImportDataConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportDataConfig() {
    importSchemaUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportDataConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.DatasetProto
        .internal_static_google_cloud_aiplatform_v1_ImportDataConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 2:
        return internalGetDataItemLabels();
      case 3:
        return internalGetAnnotationLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.DatasetProto
        .internal_static_google_cloud_aiplatform_v1_ImportDataConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.ImportDataConfig.class,
            com.google.cloud.aiplatform.v1.ImportDataConfig.Builder.class);
  }

  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_SOURCE(1),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 1:
          return GCS_SOURCE;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int GCS_SOURCE_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * The Google Cloud Storage location for the input content.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.GcsSource gcs_source = 1;</code>
   *
   * @return Whether the gcsSource field is set.
   */
  @java.lang.Override
  public boolean hasGcsSource() {
    return sourceCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * The Google Cloud Storage location for the input content.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.GcsSource gcs_source = 1;</code>
   *
   * @return The gcsSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.GcsSource getGcsSource() {
    if (sourceCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.GcsSource) source_;
    }
    return com.google.cloud.aiplatform.v1.GcsSource.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The Google Cloud Storage location for the input content.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.GcsSource gcs_source = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
    if (sourceCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.GcsSource) source_;
    }
    return com.google.cloud.aiplatform.v1.GcsSource.getDefaultInstance();
  }

  public static final int DATA_ITEM_LABELS_FIELD_NUMBER = 2;

  private static final class DataItemLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1.DatasetProto
                .internal_static_google_cloud_aiplatform_v1_ImportDataConfig_DataItemLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> dataItemLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetDataItemLabels() {
    if (dataItemLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          DataItemLabelsDefaultEntryHolder.defaultEntry);
    }
    return dataItemLabels_;
  }

  public int getDataItemLabelsCount() {
    return internalGetDataItemLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Labels that will be applied to newly imported DataItems. If an identical
   * DataItem as one being imported already exists in the Dataset, then these
   * labels will be appended to these of the already existing one, and if labels
   * with identical key is imported before, the old label value will be
   * overwritten. If two DataItems are identical in the same import data
   * operation, the labels will be combined and if key collision happens in this
   * case, one of the values will be picked randomly. Two DataItems are
   * considered identical if their content bytes are identical (e.g. image bytes
   * or pdf bytes).
   * These labels will be overridden by Annotation labels specified inside index
   * file referenced by
   * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
   * e.g. jsonl file.
   * </pre>
   *
   * <code>map&lt;string, string&gt; data_item_labels = 2;</code>
   */
  @java.lang.Override
  public boolean containsDataItemLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetDataItemLabels().getMap().containsKey(key);
  }

  /** Use {@link #getDataItemLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getDataItemLabels() {
    return getDataItemLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Labels that will be applied to newly imported DataItems. If an identical
   * DataItem as one being imported already exists in the Dataset, then these
   * labels will be appended to these of the already existing one, and if labels
   * with identical key is imported before, the old label value will be
   * overwritten. If two DataItems are identical in the same import data
   * operation, the labels will be combined and if key collision happens in this
   * case, one of the values will be picked randomly. Two DataItems are
   * considered identical if their content bytes are identical (e.g. image bytes
   * or pdf bytes).
   * These labels will be overridden by Annotation labels specified inside index
   * file referenced by
   * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
   * e.g. jsonl file.
   * </pre>
   *
   * <code>map&lt;string, string&gt; data_item_labels = 2;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getDataItemLabelsMap() {
    return internalGetDataItemLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Labels that will be applied to newly imported DataItems. If an identical
   * DataItem as one being imported already exists in the Dataset, then these
   * labels will be appended to these of the already existing one, and if labels
   * with identical key is imported before, the old label value will be
   * overwritten. If two DataItems are identical in the same import data
   * operation, the labels will be combined and if key collision happens in this
   * case, one of the values will be picked randomly. Two DataItems are
   * considered identical if their content bytes are identical (e.g. image bytes
   * or pdf bytes).
   * These labels will be overridden by Annotation labels specified inside index
   * file referenced by
   * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
   * e.g. jsonl file.
   * </pre>
   *
   * <code>map&lt;string, string&gt; data_item_labels = 2;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getDataItemLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDataItemLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Labels that will be applied to newly imported DataItems. If an identical
   * DataItem as one being imported already exists in the Dataset, then these
   * labels will be appended to these of the already existing one, and if labels
   * with identical key is imported before, the old label value will be
   * overwritten. If two DataItems are identical in the same import data
   * operation, the labels will be combined and if key collision happens in this
   * case, one of the values will be picked randomly. Two DataItems are
   * considered identical if their content bytes are identical (e.g. image bytes
   * or pdf bytes).
   * These labels will be overridden by Annotation labels specified inside index
   * file referenced by
   * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
   * e.g. jsonl file.
   * </pre>
   *
   * <code>map&lt;string, string&gt; data_item_labels = 2;</code>
   */
  @java.lang.Override
  public java.lang.String getDataItemLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDataItemLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ANNOTATION_LABELS_FIELD_NUMBER = 3;

  private static final class AnnotationLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1.DatasetProto
                .internal_static_google_cloud_aiplatform_v1_ImportDataConfig_AnnotationLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotationLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotationLabels() {
    if (annotationLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          AnnotationLabelsDefaultEntryHolder.defaultEntry);
    }
    return annotationLabels_;
  }

  public int getAnnotationLabelsCount() {
    return internalGetAnnotationLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Labels that will be applied to newly imported Annotations. If two
   * Annotations are identical, one of them will be deduped. Two Annotations are
   * considered identical if their
   * [payload][google.cloud.aiplatform.v1.Annotation.payload],
   * [payload_schema_uri][google.cloud.aiplatform.v1.Annotation.payload_schema_uri]
   * and all of their [labels][google.cloud.aiplatform.v1.Annotation.labels] are
   * the same. These labels will be overridden by Annotation labels specified
   * inside index file referenced by
   * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
   * e.g. jsonl file.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotation_labels = 3;</code>
   */
  @java.lang.Override
  public boolean containsAnnotationLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotationLabels().getMap().containsKey(key);
  }

  /** Use {@link #getAnnotationLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationLabels() {
    return getAnnotationLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Labels that will be applied to newly imported Annotations. If two
   * Annotations are identical, one of them will be deduped. Two Annotations are
   * considered identical if their
   * [payload][google.cloud.aiplatform.v1.Annotation.payload],
   * [payload_schema_uri][google.cloud.aiplatform.v1.Annotation.payload_schema_uri]
   * and all of their [labels][google.cloud.aiplatform.v1.Annotation.labels] are
   * the same. These labels will be overridden by Annotation labels specified
   * inside index file referenced by
   * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
   * e.g. jsonl file.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotation_labels = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationLabelsMap() {
    return internalGetAnnotationLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Labels that will be applied to newly imported Annotations. If two
   * Annotations are identical, one of them will be deduped. Two Annotations are
   * considered identical if their
   * [payload][google.cloud.aiplatform.v1.Annotation.payload],
   * [payload_schema_uri][google.cloud.aiplatform.v1.Annotation.payload_schema_uri]
   * and all of their [labels][google.cloud.aiplatform.v1.Annotation.labels] are
   * the same. These labels will be overridden by Annotation labels specified
   * inside index file referenced by
   * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
   * e.g. jsonl file.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotation_labels = 3;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotationLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Labels that will be applied to newly imported Annotations. If two
   * Annotations are identical, one of them will be deduped. Two Annotations are
   * considered identical if their
   * [payload][google.cloud.aiplatform.v1.Annotation.payload],
   * [payload_schema_uri][google.cloud.aiplatform.v1.Annotation.payload_schema_uri]
   * and all of their [labels][google.cloud.aiplatform.v1.Annotation.labels] are
   * the same. These labels will be overridden by Annotation labels specified
   * inside index file referenced by
   * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
   * e.g. jsonl file.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotation_labels = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotationLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int IMPORT_SCHEMA_URI_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object importSchemaUri_ = "";

  /**
   *
   *
   * <pre>
   * Required. Points to a YAML file stored on Google Cloud Storage describing
   * the import format. Validation will be done against the schema. The schema
   * is defined as an [OpenAPI 3.0.2 Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * </pre>
   *
   * <code>string import_schema_uri = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The importSchemaUri.
   */
  @java.lang.Override
  public java.lang.String getImportSchemaUri() {
    java.lang.Object ref = importSchemaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      importSchemaUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Points to a YAML file stored on Google Cloud Storage describing
   * the import format. Validation will be done against the schema. The schema
   * is defined as an [OpenAPI 3.0.2 Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * </pre>
   *
   * <code>string import_schema_uri = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for importSchemaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImportSchemaUriBytes() {
    java.lang.Object ref = importSchemaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      importSchemaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (sourceCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.aiplatform.v1.GcsSource) source_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetDataItemLabels(), DataItemLabelsDefaultEntryHolder.defaultEntry, 2);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotationLabels(), AnnotationLabelsDefaultEntryHolder.defaultEntry, 3);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(importSchemaUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, importSchemaUri_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (sourceCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.aiplatform.v1.GcsSource) source_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetDataItemLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> dataItemLabels__ =
          DataItemLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, dataItemLabels__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotationLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotationLabels__ =
          AnnotationLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, annotationLabels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(importSchemaUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, importSchemaUri_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.ImportDataConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.ImportDataConfig other =
        (com.google.cloud.aiplatform.v1.ImportDataConfig) obj;

    if (!internalGetDataItemLabels().equals(other.internalGetDataItemLabels())) return false;
    if (!internalGetAnnotationLabels().equals(other.internalGetAnnotationLabels())) return false;
    if (!getImportSchemaUri().equals(other.getImportSchemaUri())) return false;
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 1:
        if (!getGcsSource().equals(other.getGcsSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetDataItemLabels().getMap().isEmpty()) {
      hash = (37 * hash) + DATA_ITEM_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetDataItemLabels().hashCode();
    }
    if (!internalGetAnnotationLabels().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATION_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotationLabels().hashCode();
    }
    hash = (37 * hash) + IMPORT_SCHEMA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getImportSchemaUri().hashCode();
    switch (sourceCase_) {
      case 1:
        hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGcsSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.ImportDataConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ImportDataConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ImportDataConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ImportDataConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ImportDataConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ImportDataConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ImportDataConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ImportDataConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ImportDataConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ImportDataConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ImportDataConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ImportDataConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.ImportDataConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Describes the location from where we import data into a Dataset, together
   * with the labels that will be applied to the DataItems and the Annotations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ImportDataConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ImportDataConfig)
      com.google.cloud.aiplatform.v1.ImportDataConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.DatasetProto
          .internal_static_google_cloud_aiplatform_v1_ImportDataConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetDataItemLabels();
        case 3:
          return internalGetAnnotationLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetMutableDataItemLabels();
        case 3:
          return internalGetMutableAnnotationLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.DatasetProto
          .internal_static_google_cloud_aiplatform_v1_ImportDataConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ImportDataConfig.class,
              com.google.cloud.aiplatform.v1.ImportDataConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.ImportDataConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gcsSourceBuilder_ != null) {
        gcsSourceBuilder_.clear();
      }
      internalGetMutableDataItemLabels().clear();
      internalGetMutableAnnotationLabels().clear();
      importSchemaUri_ = "";
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.DatasetProto
          .internal_static_google_cloud_aiplatform_v1_ImportDataConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ImportDataConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.ImportDataConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ImportDataConfig build() {
      com.google.cloud.aiplatform.v1.ImportDataConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ImportDataConfig buildPartial() {
      com.google.cloud.aiplatform.v1.ImportDataConfig result =
          new com.google.cloud.aiplatform.v1.ImportDataConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.ImportDataConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dataItemLabels_ = internalGetDataItemLabels();
        result.dataItemLabels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.annotationLabels_ = internalGetAnnotationLabels();
        result.annotationLabels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.importSchemaUri_ = importSchemaUri_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.ImportDataConfig result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 1 && gcsSourceBuilder_ != null) {
        result.source_ = gcsSourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.ImportDataConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1.ImportDataConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.ImportDataConfig other) {
      if (other == com.google.cloud.aiplatform.v1.ImportDataConfig.getDefaultInstance())
        return this;
      internalGetMutableDataItemLabels().mergeFrom(other.internalGetDataItemLabels());
      bitField0_ |= 0x00000002;
      internalGetMutableAnnotationLabels().mergeFrom(other.internalGetAnnotationLabels());
      bitField0_ |= 0x00000004;
      if (!other.getImportSchemaUri().isEmpty()) {
        importSchemaUri_ = other.importSchemaUri_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      switch (other.getSourceCase()) {
        case GCS_SOURCE:
          {
            mergeGcsSource(other.getGcsSource());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getGcsSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> dataItemLabels__ =
                    input.readMessage(
                        DataItemLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableDataItemLabels()
                    .getMutableMap()
                    .put(dataItemLabels__.getKey(), dataItemLabels__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    annotationLabels__ =
                        input.readMessage(
                            AnnotationLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableAnnotationLabels()
                    .getMutableMap()
                    .put(annotationLabels__.getKey(), annotationLabels__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                importSchemaUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.GcsSource,
            com.google.cloud.aiplatform.v1.GcsSource.Builder,
            com.google.cloud.aiplatform.v1.GcsSourceOrBuilder>
        gcsSourceBuilder_;

    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GcsSource gcs_source = 1;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return sourceCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GcsSource gcs_source = 1;</code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.GcsSource getGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.GcsSource) source_;
        }
        return com.google.cloud.aiplatform.v1.GcsSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 1) {
          return gcsSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.GcsSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GcsSource gcs_source = 1;</code>
     */
    public Builder setGcsSource(com.google.cloud.aiplatform.v1.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GcsSource gcs_source = 1;</code>
     */
    public Builder setGcsSource(com.google.cloud.aiplatform.v1.GcsSource.Builder builderForValue) {
      if (gcsSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GcsSource gcs_source = 1;</code>
     */
    public Builder mergeGcsSource(com.google.cloud.aiplatform.v1.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 1
            && source_ != com.google.cloud.aiplatform.v1.GcsSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.aiplatform.v1.GcsSource.newBuilder(
                      (com.google.cloud.aiplatform.v1.GcsSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 1) {
          gcsSourceBuilder_.mergeFrom(value);
        } else {
          gcsSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GcsSource gcs_source = 1;</code>
     */
    public Builder clearGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 1) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 1) {
          sourceCase_ = 0;
          source_ = null;
        }
        gcsSourceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GcsSource gcs_source = 1;</code>
     */
    public com.google.cloud.aiplatform.v1.GcsSource.Builder getGcsSourceBuilder() {
      return getGcsSourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GcsSource gcs_source = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
      if ((sourceCase_ == 1) && (gcsSourceBuilder_ != null)) {
        return gcsSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.GcsSource) source_;
        }
        return com.google.cloud.aiplatform.v1.GcsSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GcsSource gcs_source = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.GcsSource,
            com.google.cloud.aiplatform.v1.GcsSource.Builder,
            com.google.cloud.aiplatform.v1.GcsSourceOrBuilder>
        getGcsSourceFieldBuilder() {
      if (gcsSourceBuilder_ == null) {
        if (!(sourceCase_ == 1)) {
          source_ = com.google.cloud.aiplatform.v1.GcsSource.getDefaultInstance();
        }
        gcsSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.GcsSource,
                com.google.cloud.aiplatform.v1.GcsSource.Builder,
                com.google.cloud.aiplatform.v1.GcsSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1.GcsSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 1;
      onChanged();
      return gcsSourceBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> dataItemLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetDataItemLabels() {
      if (dataItemLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            DataItemLabelsDefaultEntryHolder.defaultEntry);
      }
      return dataItemLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableDataItemLabels() {
      if (dataItemLabels_ == null) {
        dataItemLabels_ =
            com.google.protobuf.MapField.newMapField(DataItemLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!dataItemLabels_.isMutable()) {
        dataItemLabels_ = dataItemLabels_.copy();
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return dataItemLabels_;
    }

    public int getDataItemLabelsCount() {
      return internalGetDataItemLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Labels that will be applied to newly imported DataItems. If an identical
     * DataItem as one being imported already exists in the Dataset, then these
     * labels will be appended to these of the already existing one, and if labels
     * with identical key is imported before, the old label value will be
     * overwritten. If two DataItems are identical in the same import data
     * operation, the labels will be combined and if key collision happens in this
     * case, one of the values will be picked randomly. Two DataItems are
     * considered identical if their content bytes are identical (e.g. image bytes
     * or pdf bytes).
     * These labels will be overridden by Annotation labels specified inside index
     * file referenced by
     * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
     * e.g. jsonl file.
     * </pre>
     *
     * <code>map&lt;string, string&gt; data_item_labels = 2;</code>
     */
    @java.lang.Override
    public boolean containsDataItemLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetDataItemLabels().getMap().containsKey(key);
    }

    /** Use {@link #getDataItemLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getDataItemLabels() {
      return getDataItemLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Labels that will be applied to newly imported DataItems. If an identical
     * DataItem as one being imported already exists in the Dataset, then these
     * labels will be appended to these of the already existing one, and if labels
     * with identical key is imported before, the old label value will be
     * overwritten. If two DataItems are identical in the same import data
     * operation, the labels will be combined and if key collision happens in this
     * case, one of the values will be picked randomly. Two DataItems are
     * considered identical if their content bytes are identical (e.g. image bytes
     * or pdf bytes).
     * These labels will be overridden by Annotation labels specified inside index
     * file referenced by
     * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
     * e.g. jsonl file.
     * </pre>
     *
     * <code>map&lt;string, string&gt; data_item_labels = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getDataItemLabelsMap() {
      return internalGetDataItemLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Labels that will be applied to newly imported DataItems. If an identical
     * DataItem as one being imported already exists in the Dataset, then these
     * labels will be appended to these of the already existing one, and if labels
     * with identical key is imported before, the old label value will be
     * overwritten. If two DataItems are identical in the same import data
     * operation, the labels will be combined and if key collision happens in this
     * case, one of the values will be picked randomly. Two DataItems are
     * considered identical if their content bytes are identical (e.g. image bytes
     * or pdf bytes).
     * These labels will be overridden by Annotation labels specified inside index
     * file referenced by
     * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
     * e.g. jsonl file.
     * </pre>
     *
     * <code>map&lt;string, string&gt; data_item_labels = 2;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getDataItemLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDataItemLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Labels that will be applied to newly imported DataItems. If an identical
     * DataItem as one being imported already exists in the Dataset, then these
     * labels will be appended to these of the already existing one, and if labels
     * with identical key is imported before, the old label value will be
     * overwritten. If two DataItems are identical in the same import data
     * operation, the labels will be combined and if key collision happens in this
     * case, one of the values will be picked randomly. Two DataItems are
     * considered identical if their content bytes are identical (e.g. image bytes
     * or pdf bytes).
     * These labels will be overridden by Annotation labels specified inside index
     * file referenced by
     * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
     * e.g. jsonl file.
     * </pre>
     *
     * <code>map&lt;string, string&gt; data_item_labels = 2;</code>
     */
    @java.lang.Override
    public java.lang.String getDataItemLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDataItemLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearDataItemLabels() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableDataItemLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Labels that will be applied to newly imported DataItems. If an identical
     * DataItem as one being imported already exists in the Dataset, then these
     * labels will be appended to these of the already existing one, and if labels
     * with identical key is imported before, the old label value will be
     * overwritten. If two DataItems are identical in the same import data
     * operation, the labels will be combined and if key collision happens in this
     * case, one of the values will be picked randomly. Two DataItems are
     * considered identical if their content bytes are identical (e.g. image bytes
     * or pdf bytes).
     * These labels will be overridden by Annotation labels specified inside index
     * file referenced by
     * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
     * e.g. jsonl file.
     * </pre>
     *
     * <code>map&lt;string, string&gt; data_item_labels = 2;</code>
     */
    public Builder removeDataItemLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableDataItemLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableDataItemLabels() {
      bitField0_ |= 0x00000002;
      return internalGetMutableDataItemLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Labels that will be applied to newly imported DataItems. If an identical
     * DataItem as one being imported already exists in the Dataset, then these
     * labels will be appended to these of the already existing one, and if labels
     * with identical key is imported before, the old label value will be
     * overwritten. If two DataItems are identical in the same import data
     * operation, the labels will be combined and if key collision happens in this
     * case, one of the values will be picked randomly. Two DataItems are
     * considered identical if their content bytes are identical (e.g. image bytes
     * or pdf bytes).
     * These labels will be overridden by Annotation labels specified inside index
     * file referenced by
     * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
     * e.g. jsonl file.
     * </pre>
     *
     * <code>map&lt;string, string&gt; data_item_labels = 2;</code>
     */
    public Builder putDataItemLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableDataItemLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Labels that will be applied to newly imported DataItems. If an identical
     * DataItem as one being imported already exists in the Dataset, then these
     * labels will be appended to these of the already existing one, and if labels
     * with identical key is imported before, the old label value will be
     * overwritten. If two DataItems are identical in the same import data
     * operation, the labels will be combined and if key collision happens in this
     * case, one of the values will be picked randomly. Two DataItems are
     * considered identical if their content bytes are identical (e.g. image bytes
     * or pdf bytes).
     * These labels will be overridden by Annotation labels specified inside index
     * file referenced by
     * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
     * e.g. jsonl file.
     * </pre>
     *
     * <code>map&lt;string, string&gt; data_item_labels = 2;</code>
     */
    public Builder putAllDataItemLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableDataItemLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotationLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotationLabels() {
      if (annotationLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationLabelsDefaultEntryHolder.defaultEntry);
      }
      return annotationLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotationLabels() {
      if (annotationLabels_ == null) {
        annotationLabels_ =
            com.google.protobuf.MapField.newMapField(
                AnnotationLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!annotationLabels_.isMutable()) {
        annotationLabels_ = annotationLabels_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return annotationLabels_;
    }

    public int getAnnotationLabelsCount() {
      return internalGetAnnotationLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Labels that will be applied to newly imported Annotations. If two
     * Annotations are identical, one of them will be deduped. Two Annotations are
     * considered identical if their
     * [payload][google.cloud.aiplatform.v1.Annotation.payload],
     * [payload_schema_uri][google.cloud.aiplatform.v1.Annotation.payload_schema_uri]
     * and all of their [labels][google.cloud.aiplatform.v1.Annotation.labels] are
     * the same. These labels will be overridden by Annotation labels specified
     * inside index file referenced by
     * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
     * e.g. jsonl file.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotation_labels = 3;</code>
     */
    @java.lang.Override
    public boolean containsAnnotationLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotationLabels().getMap().containsKey(key);
    }

    /** Use {@link #getAnnotationLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationLabels() {
      return getAnnotationLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Labels that will be applied to newly imported Annotations. If two
     * Annotations are identical, one of them will be deduped. Two Annotations are
     * considered identical if their
     * [payload][google.cloud.aiplatform.v1.Annotation.payload],
     * [payload_schema_uri][google.cloud.aiplatform.v1.Annotation.payload_schema_uri]
     * and all of their [labels][google.cloud.aiplatform.v1.Annotation.labels] are
     * the same. These labels will be overridden by Annotation labels specified
     * inside index file referenced by
     * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
     * e.g. jsonl file.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotation_labels = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationLabelsMap() {
      return internalGetAnnotationLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Labels that will be applied to newly imported Annotations. If two
     * Annotations are identical, one of them will be deduped. Two Annotations are
     * considered identical if their
     * [payload][google.cloud.aiplatform.v1.Annotation.payload],
     * [payload_schema_uri][google.cloud.aiplatform.v1.Annotation.payload_schema_uri]
     * and all of their [labels][google.cloud.aiplatform.v1.Annotation.labels] are
     * the same. These labels will be overridden by Annotation labels specified
     * inside index file referenced by
     * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
     * e.g. jsonl file.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotation_labels = 3;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetAnnotationLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Labels that will be applied to newly imported Annotations. If two
     * Annotations are identical, one of them will be deduped. Two Annotations are
     * considered identical if their
     * [payload][google.cloud.aiplatform.v1.Annotation.payload],
     * [payload_schema_uri][google.cloud.aiplatform.v1.Annotation.payload_schema_uri]
     * and all of their [labels][google.cloud.aiplatform.v1.Annotation.labels] are
     * the same. These labels will be overridden by Annotation labels specified
     * inside index file referenced by
     * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
     * e.g. jsonl file.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotation_labels = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetAnnotationLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotationLabels() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableAnnotationLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Labels that will be applied to newly imported Annotations. If two
     * Annotations are identical, one of them will be deduped. Two Annotations are
     * considered identical if their
     * [payload][google.cloud.aiplatform.v1.Annotation.payload],
     * [payload_schema_uri][google.cloud.aiplatform.v1.Annotation.payload_schema_uri]
     * and all of their [labels][google.cloud.aiplatform.v1.Annotation.labels] are
     * the same. These labels will be overridden by Annotation labels specified
     * inside index file referenced by
     * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
     * e.g. jsonl file.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotation_labels = 3;</code>
     */
    public Builder removeAnnotationLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotationLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotationLabels() {
      bitField0_ |= 0x00000004;
      return internalGetMutableAnnotationLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Labels that will be applied to newly imported Annotations. If two
     * Annotations are identical, one of them will be deduped. Two Annotations are
     * considered identical if their
     * [payload][google.cloud.aiplatform.v1.Annotation.payload],
     * [payload_schema_uri][google.cloud.aiplatform.v1.Annotation.payload_schema_uri]
     * and all of their [labels][google.cloud.aiplatform.v1.Annotation.labels] are
     * the same. These labels will be overridden by Annotation labels specified
     * inside index file referenced by
     * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
     * e.g. jsonl file.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotation_labels = 3;</code>
     */
    public Builder putAnnotationLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotationLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Labels that will be applied to newly imported Annotations. If two
     * Annotations are identical, one of them will be deduped. Two Annotations are
     * considered identical if their
     * [payload][google.cloud.aiplatform.v1.Annotation.payload],
     * [payload_schema_uri][google.cloud.aiplatform.v1.Annotation.payload_schema_uri]
     * and all of their [labels][google.cloud.aiplatform.v1.Annotation.labels] are
     * the same. These labels will be overridden by Annotation labels specified
     * inside index file referenced by
     * [import_schema_uri][google.cloud.aiplatform.v1.ImportDataConfig.import_schema_uri],
     * e.g. jsonl file.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotation_labels = 3;</code>
     */
    public Builder putAllAnnotationLabels(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotationLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    private java.lang.Object importSchemaUri_ = "";

    /**
     *
     *
     * <pre>
     * Required. Points to a YAML file stored on Google Cloud Storage describing
     * the import format. Validation will be done against the schema. The schema
     * is defined as an [OpenAPI 3.0.2 Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string import_schema_uri = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The importSchemaUri.
     */
    public java.lang.String getImportSchemaUri() {
      java.lang.Object ref = importSchemaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        importSchemaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Points to a YAML file stored on Google Cloud Storage describing
     * the import format. Validation will be done against the schema. The schema
     * is defined as an [OpenAPI 3.0.2 Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string import_schema_uri = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for importSchemaUri.
     */
    public com.google.protobuf.ByteString getImportSchemaUriBytes() {
      java.lang.Object ref = importSchemaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        importSchemaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Points to a YAML file stored on Google Cloud Storage describing
     * the import format. Validation will be done against the schema. The schema
     * is defined as an [OpenAPI 3.0.2 Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string import_schema_uri = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The importSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setImportSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      importSchemaUri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Points to a YAML file stored on Google Cloud Storage describing
     * the import format. Validation will be done against the schema. The schema
     * is defined as an [OpenAPI 3.0.2 Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string import_schema_uri = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportSchemaUri() {
      importSchemaUri_ = getDefaultInstance().getImportSchemaUri();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Points to a YAML file stored on Google Cloud Storage describing
     * the import format. Validation will be done against the schema. The schema
     * is defined as an [OpenAPI 3.0.2 Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string import_schema_uri = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for importSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setImportSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      importSchemaUri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ImportDataConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ImportDataConfig)
  private static final com.google.cloud.aiplatform.v1.ImportDataConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ImportDataConfig();
  }

  public static com.google.cloud.aiplatform.v1.ImportDataConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportDataConfig> PARSER =
      new com.google.protobuf.AbstractParser<ImportDataConfig>() {
        @java.lang.Override
        public ImportDataConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportDataConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportDataConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ImportDataConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
