/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/model_garden_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [ModelGardenService.GetPublisherModel][google.cloud.aiplatform.v1.ModelGardenService.GetPublisherModel]
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.GetPublisherModelRequest}
 */
public final class GetPublisherModelRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.GetPublisherModelRequest)
    GetPublisherModelRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use GetPublisherModelRequest.newBuilder() to construct.
  private GetPublisherModelRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GetPublisherModelRequest() {
    name_ = "";
    languageCode_ = "";
    view_ = 0;
    huggingFaceToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GetPublisherModelRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ModelGardenServiceProto
        .internal_static_google_cloud_aiplatform_v1_GetPublisherModelRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ModelGardenServiceProto
        .internal_static_google_cloud_aiplatform_v1_GetPublisherModelRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.GetPublisherModelRequest.class,
            com.google.cloud.aiplatform.v1.GetPublisherModelRequest.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Required. The name of the PublisherModel resource.
   * Format:
   * `publishers/{publisher}/models/{publisher_model}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the PublisherModel resource.
   * Format:
   * `publishers/{publisher}/models/{publisher_model}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The IETF BCP-47 language code representing the language in which
   * the publisher model's text information should be written in.
   * </pre>
   *
   * <code>string language_code = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The IETF BCP-47 language code representing the language in which
   * the publisher model's text information should be written in.
   * </pre>
   *
   * <code>string language_code = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VIEW_FIELD_NUMBER = 3;
  private int view_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. PublisherModel view specifying which fields to read.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PublisherModelView view = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for view.
   */
  @java.lang.Override
  public int getViewValue() {
    return view_;
  }

  /**
   *
   *
   * <pre>
   * Optional. PublisherModel view specifying which fields to read.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PublisherModelView view = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The view.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PublisherModelView getView() {
    com.google.cloud.aiplatform.v1.PublisherModelView result =
        com.google.cloud.aiplatform.v1.PublisherModelView.forNumber(view_);
    return result == null ? com.google.cloud.aiplatform.v1.PublisherModelView.UNRECOGNIZED : result;
  }

  public static final int IS_HUGGING_FACE_MODEL_FIELD_NUMBER = 5;
  private boolean isHuggingFaceModel_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Boolean indicates whether the requested model is a Hugging Face
   * model.
   * </pre>
   *
   * <code>bool is_hugging_face_model = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The isHuggingFaceModel.
   */
  @java.lang.Override
  public boolean getIsHuggingFaceModel() {
    return isHuggingFaceModel_;
  }

  public static final int HUGGING_FACE_TOKEN_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object huggingFaceToken_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Token used to access Hugging Face gated models.
   * </pre>
   *
   * <code>string hugging_face_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The huggingFaceToken.
   */
  @java.lang.Override
  public java.lang.String getHuggingFaceToken() {
    java.lang.Object ref = huggingFaceToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      huggingFaceToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Token used to access Hugging Face gated models.
   * </pre>
   *
   * <code>string hugging_face_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for huggingFaceToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHuggingFaceTokenBytes() {
    java.lang.Object ref = huggingFaceToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      huggingFaceToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, languageCode_);
    }
    if (view_
        != com.google.cloud.aiplatform.v1.PublisherModelView.PUBLISHER_MODEL_VIEW_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, view_);
    }
    if (isHuggingFaceModel_ != false) {
      output.writeBool(5, isHuggingFaceModel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(huggingFaceToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, huggingFaceToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, languageCode_);
    }
    if (view_
        != com.google.cloud.aiplatform.v1.PublisherModelView.PUBLISHER_MODEL_VIEW_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, view_);
    }
    if (isHuggingFaceModel_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, isHuggingFaceModel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(huggingFaceToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, huggingFaceToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.GetPublisherModelRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.GetPublisherModelRequest other =
        (com.google.cloud.aiplatform.v1.GetPublisherModelRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (view_ != other.view_) return false;
    if (getIsHuggingFaceModel() != other.getIsHuggingFaceModel()) return false;
    if (!getHuggingFaceToken().equals(other.getHuggingFaceToken())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (37 * hash) + VIEW_FIELD_NUMBER;
    hash = (53 * hash) + view_;
    hash = (37 * hash) + IS_HUGGING_FACE_MODEL_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsHuggingFaceModel());
    hash = (37 * hash) + HUGGING_FACE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getHuggingFaceToken().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.GetPublisherModelRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.GetPublisherModelRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.GetPublisherModelRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.GetPublisherModelRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.GetPublisherModelRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.GetPublisherModelRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.GetPublisherModelRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.GetPublisherModelRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.GetPublisherModelRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.GetPublisherModelRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.GetPublisherModelRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.GetPublisherModelRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.GetPublisherModelRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [ModelGardenService.GetPublisherModel][google.cloud.aiplatform.v1.ModelGardenService.GetPublisherModel]
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.GetPublisherModelRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.GetPublisherModelRequest)
      com.google.cloud.aiplatform.v1.GetPublisherModelRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ModelGardenServiceProto
          .internal_static_google_cloud_aiplatform_v1_GetPublisherModelRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ModelGardenServiceProto
          .internal_static_google_cloud_aiplatform_v1_GetPublisherModelRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.GetPublisherModelRequest.class,
              com.google.cloud.aiplatform.v1.GetPublisherModelRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.GetPublisherModelRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      languageCode_ = "";
      view_ = 0;
      isHuggingFaceModel_ = false;
      huggingFaceToken_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ModelGardenServiceProto
          .internal_static_google_cloud_aiplatform_v1_GetPublisherModelRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.GetPublisherModelRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.GetPublisherModelRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.GetPublisherModelRequest build() {
      com.google.cloud.aiplatform.v1.GetPublisherModelRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.GetPublisherModelRequest buildPartial() {
      com.google.cloud.aiplatform.v1.GetPublisherModelRequest result =
          new com.google.cloud.aiplatform.v1.GetPublisherModelRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.GetPublisherModelRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.languageCode_ = languageCode_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.view_ = view_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.isHuggingFaceModel_ = isHuggingFaceModel_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.huggingFaceToken_ = huggingFaceToken_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.GetPublisherModelRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1.GetPublisherModelRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.GetPublisherModelRequest other) {
      if (other == com.google.cloud.aiplatform.v1.GetPublisherModelRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.view_ != 0) {
        setViewValue(other.getViewValue());
      }
      if (other.getIsHuggingFaceModel() != false) {
        setIsHuggingFaceModel(other.getIsHuggingFaceModel());
      }
      if (!other.getHuggingFaceToken().isEmpty()) {
        huggingFaceToken_ = other.huggingFaceToken_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                view_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 40:
              {
                isHuggingFaceModel_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            case 50:
              {
                huggingFaceToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the PublisherModel resource.
     * Format:
     * `publishers/{publisher}/models/{publisher_model}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the PublisherModel resource.
     * Format:
     * `publishers/{publisher}/models/{publisher_model}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the PublisherModel resource.
     * Format:
     * `publishers/{publisher}/models/{publisher_model}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the PublisherModel resource.
     * Format:
     * `publishers/{publisher}/models/{publisher_model}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the PublisherModel resource.
     * Format:
     * `publishers/{publisher}/models/{publisher_model}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The IETF BCP-47 language code representing the language in which
     * the publisher model's text information should be written in.
     * </pre>
     *
     * <code>string language_code = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The IETF BCP-47 language code representing the language in which
     * the publisher model's text information should be written in.
     * </pre>
     *
     * <code>string language_code = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The IETF BCP-47 language code representing the language in which
     * the publisher model's text information should be written in.
     * </pre>
     *
     * <code>string language_code = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The IETF BCP-47 language code representing the language in which
     * the publisher model's text information should be written in.
     * </pre>
     *
     * <code>string language_code = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The IETF BCP-47 language code representing the language in which
     * the publisher model's text information should be written in.
     * </pre>
     *
     * <code>string language_code = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int view_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. PublisherModel view specifying which fields to read.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModelView view = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for view.
     */
    @java.lang.Override
    public int getViewValue() {
      return view_;
    }

    /**
     *
     *
     * <pre>
     * Optional. PublisherModel view specifying which fields to read.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModelView view = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for view to set.
     * @return This builder for chaining.
     */
    public Builder setViewValue(int value) {
      view_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. PublisherModel view specifying which fields to read.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModelView view = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The view.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModelView getView() {
      com.google.cloud.aiplatform.v1.PublisherModelView result =
          com.google.cloud.aiplatform.v1.PublisherModelView.forNumber(view_);
      return result == null
          ? com.google.cloud.aiplatform.v1.PublisherModelView.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. PublisherModel view specifying which fields to read.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModelView view = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The view to set.
     * @return This builder for chaining.
     */
    public Builder setView(com.google.cloud.aiplatform.v1.PublisherModelView value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      view_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. PublisherModel view specifying which fields to read.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModelView view = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearView() {
      bitField0_ = (bitField0_ & ~0x00000004);
      view_ = 0;
      onChanged();
      return this;
    }

    private boolean isHuggingFaceModel_;

    /**
     *
     *
     * <pre>
     * Optional. Boolean indicates whether the requested model is a Hugging Face
     * model.
     * </pre>
     *
     * <code>bool is_hugging_face_model = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The isHuggingFaceModel.
     */
    @java.lang.Override
    public boolean getIsHuggingFaceModel() {
      return isHuggingFaceModel_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Boolean indicates whether the requested model is a Hugging Face
     * model.
     * </pre>
     *
     * <code>bool is_hugging_face_model = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The isHuggingFaceModel to set.
     * @return This builder for chaining.
     */
    public Builder setIsHuggingFaceModel(boolean value) {

      isHuggingFaceModel_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Boolean indicates whether the requested model is a Hugging Face
     * model.
     * </pre>
     *
     * <code>bool is_hugging_face_model = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsHuggingFaceModel() {
      bitField0_ = (bitField0_ & ~0x00000008);
      isHuggingFaceModel_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object huggingFaceToken_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Token used to access Hugging Face gated models.
     * </pre>
     *
     * <code>string hugging_face_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The huggingFaceToken.
     */
    public java.lang.String getHuggingFaceToken() {
      java.lang.Object ref = huggingFaceToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        huggingFaceToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Token used to access Hugging Face gated models.
     * </pre>
     *
     * <code>string hugging_face_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for huggingFaceToken.
     */
    public com.google.protobuf.ByteString getHuggingFaceTokenBytes() {
      java.lang.Object ref = huggingFaceToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        huggingFaceToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Token used to access Hugging Face gated models.
     * </pre>
     *
     * <code>string hugging_face_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The huggingFaceToken to set.
     * @return This builder for chaining.
     */
    public Builder setHuggingFaceToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      huggingFaceToken_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Token used to access Hugging Face gated models.
     * </pre>
     *
     * <code>string hugging_face_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHuggingFaceToken() {
      huggingFaceToken_ = getDefaultInstance().getHuggingFaceToken();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Token used to access Hugging Face gated models.
     * </pre>
     *
     * <code>string hugging_face_token = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for huggingFaceToken to set.
     * @return This builder for chaining.
     */
    public Builder setHuggingFaceTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      huggingFaceToken_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.GetPublisherModelRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.GetPublisherModelRequest)
  private static final com.google.cloud.aiplatform.v1.GetPublisherModelRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.GetPublisherModelRequest();
  }

  public static com.google.cloud.aiplatform.v1.GetPublisherModelRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GetPublisherModelRequest> PARSER =
      new com.google.protobuf.AbstractParser<GetPublisherModelRequest>() {
        @java.lang.Override
        public GetPublisherModelRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GetPublisherModelRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GetPublisherModelRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.GetPublisherModelRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
