/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DeploymentResourcePoolName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DEPLOYMENT_RESOURCE_POOL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String deploymentResourcePool;

    @Deprecated
    protected DeploymentResourcePoolName() {
        this.project = null;
        this.location = null;
        this.deploymentResourcePool = null;
    }

    private DeploymentResourcePoolName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.deploymentResourcePool = (String)Preconditions.checkNotNull((Object)builder.getDeploymentResourcePool());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDeploymentResourcePool() {
        return this.deploymentResourcePool;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DeploymentResourcePoolName of(String project, String location, String deploymentResourcePool) {
        return DeploymentResourcePoolName.newBuilder().setProject(project).setLocation(location).setDeploymentResourcePool(deploymentResourcePool).build();
    }

    public static String format(String project, String location, String deploymentResourcePool) {
        return DeploymentResourcePoolName.newBuilder().setProject(project).setLocation(location).setDeploymentResourcePool(deploymentResourcePool).build().toString();
    }

    public static DeploymentResourcePoolName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DEPLOYMENT_RESOURCE_POOL.validatedMatch(formattedString, "DeploymentResourcePoolName.parse: formattedString not in valid format");
        return DeploymentResourcePoolName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("deployment_resource_pool"));
    }

    public static List<DeploymentResourcePoolName> parseList(List<String> formattedStrings) {
        ArrayList<DeploymentResourcePoolName> list = new ArrayList<DeploymentResourcePoolName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DeploymentResourcePoolName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DeploymentResourcePoolName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DeploymentResourcePoolName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DEPLOYMENT_RESOURCE_POOL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DeploymentResourcePoolName deploymentResourcePoolName = this;
            synchronized (deploymentResourcePoolName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.deploymentResourcePool != null) {
                        fieldMapBuilder.put((Object)"deployment_resource_pool", (Object)this.deploymentResourcePool);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DEPLOYMENT_RESOURCE_POOL.instantiate(new String[]{"project", this.project, "location", this.location, "deployment_resource_pool", this.deploymentResourcePool});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DeploymentResourcePoolName that = (DeploymentResourcePoolName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.deploymentResourcePool, that.deploymentResourcePool);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.deploymentResourcePool);
    }

    public static class Builder {
        private String project;
        private String location;
        private String deploymentResourcePool;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDeploymentResourcePool() {
            return this.deploymentResourcePool;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDeploymentResourcePool(String deploymentResourcePool) {
            this.deploymentResourcePool = deploymentResourcePool;
            return this;
        }

        private Builder(DeploymentResourcePoolName deploymentResourcePoolName) {
            this.project = deploymentResourcePoolName.project;
            this.location = deploymentResourcePoolName.location;
            this.deploymentResourcePool = deploymentResourcePoolName.deploymentResourcePool;
        }

        public DeploymentResourcePoolName build() {
            return new DeploymentResourcePoolName(this);
        }
    }
}

