/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TensorboardRunName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TENSORBOARD_EXPERIMENT_RUN = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String tensorboard;
    private final String experiment;
    private final String run;

    @Deprecated
    protected TensorboardRunName() {
        this.project = null;
        this.location = null;
        this.tensorboard = null;
        this.experiment = null;
        this.run = null;
    }

    private TensorboardRunName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.tensorboard = (String)Preconditions.checkNotNull((Object)builder.getTensorboard());
        this.experiment = (String)Preconditions.checkNotNull((Object)builder.getExperiment());
        this.run = (String)Preconditions.checkNotNull((Object)builder.getRun());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTensorboard() {
        return this.tensorboard;
    }

    public String getExperiment() {
        return this.experiment;
    }

    public String getRun() {
        return this.run;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TensorboardRunName of(String project, String location, String tensorboard, String experiment, String run) {
        return TensorboardRunName.newBuilder().setProject(project).setLocation(location).setTensorboard(tensorboard).setExperiment(experiment).setRun(run).build();
    }

    public static String format(String project, String location, String tensorboard, String experiment, String run) {
        return TensorboardRunName.newBuilder().setProject(project).setLocation(location).setTensorboard(tensorboard).setExperiment(experiment).setRun(run).build().toString();
    }

    public static TensorboardRunName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TENSORBOARD_EXPERIMENT_RUN.validatedMatch(formattedString, "TensorboardRunName.parse: formattedString not in valid format");
        return TensorboardRunName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("tensorboard"), (String)matchMap.get("experiment"), (String)matchMap.get("run"));
    }

    public static List<TensorboardRunName> parseList(List<String> formattedStrings) {
        ArrayList<TensorboardRunName> list = new ArrayList<TensorboardRunName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TensorboardRunName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TensorboardRunName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TensorboardRunName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TENSORBOARD_EXPERIMENT_RUN.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TensorboardRunName tensorboardRunName = this;
            synchronized (tensorboardRunName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.tensorboard != null) {
                        fieldMapBuilder.put((Object)"tensorboard", (Object)this.tensorboard);
                    }
                    if (this.experiment != null) {
                        fieldMapBuilder.put((Object)"experiment", (Object)this.experiment);
                    }
                    if (this.run != null) {
                        fieldMapBuilder.put((Object)"run", (Object)this.run);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TENSORBOARD_EXPERIMENT_RUN.instantiate(new String[]{"project", this.project, "location", this.location, "tensorboard", this.tensorboard, "experiment", this.experiment, "run", this.run});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TensorboardRunName that = (TensorboardRunName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.tensorboard, that.tensorboard) && Objects.equals(this.experiment, that.experiment) && Objects.equals(this.run, that.run);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.tensorboard);
        h *= 1000003;
        h ^= Objects.hashCode(this.experiment);
        h *= 1000003;
        return h ^= Objects.hashCode(this.run);
    }

    public static class Builder {
        private String project;
        private String location;
        private String tensorboard;
        private String experiment;
        private String run;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTensorboard() {
            return this.tensorboard;
        }

        public String getExperiment() {
            return this.experiment;
        }

        public String getRun() {
            return this.run;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTensorboard(String tensorboard) {
            this.tensorboard = tensorboard;
            return this;
        }

        public Builder setExperiment(String experiment) {
            this.experiment = experiment;
            return this;
        }

        public Builder setRun(String run) {
            this.run = run;
            return this;
        }

        private Builder(TensorboardRunName tensorboardRunName) {
            this.project = tensorboardRunName.project;
            this.location = tensorboardRunName.location;
            this.tensorboard = tensorboardRunName.tensorboard;
            this.experiment = tensorboardRunName.experiment;
            this.run = tensorboardRunName.run;
        }

        public TensorboardRunName build() {
            return new TensorboardRunName(this);
        }
    }
}

