/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PublisherModelName
implements ResourceName {
    private static final PathTemplate PUBLISHER_MODEL = PathTemplate.createWithoutUrlEncoding((String)"publishers/{publisher}/models/{model}");
    private volatile Map<String, String> fieldValuesMap;
    private final String publisher;
    private final String model;

    @Deprecated
    protected PublisherModelName() {
        this.publisher = null;
        this.model = null;
    }

    private PublisherModelName(Builder builder) {
        this.publisher = (String)Preconditions.checkNotNull((Object)builder.getPublisher());
        this.model = (String)Preconditions.checkNotNull((Object)builder.getModel());
    }

    public String getPublisher() {
        return this.publisher;
    }

    public String getModel() {
        return this.model;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PublisherModelName of(String publisher, String model) {
        return PublisherModelName.newBuilder().setPublisher(publisher).setModel(model).build();
    }

    public static String format(String publisher, String model) {
        return PublisherModelName.newBuilder().setPublisher(publisher).setModel(model).build().toString();
    }

    public static PublisherModelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PUBLISHER_MODEL.validatedMatch(formattedString, "PublisherModelName.parse: formattedString not in valid format");
        return PublisherModelName.of((String)matchMap.get("publisher"), (String)matchMap.get("model"));
    }

    public static List<PublisherModelName> parseList(List<String> formattedStrings) {
        ArrayList<PublisherModelName> list = new ArrayList<PublisherModelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PublisherModelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PublisherModelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PublisherModelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PUBLISHER_MODEL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PublisherModelName publisherModelName = this;
            synchronized (publisherModelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.publisher != null) {
                        fieldMapBuilder.put((Object)"publisher", (Object)this.publisher);
                    }
                    if (this.model != null) {
                        fieldMapBuilder.put((Object)"model", (Object)this.model);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PUBLISHER_MODEL.instantiate(new String[]{"publisher", this.publisher, "model", this.model});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PublisherModelName that = (PublisherModelName)o;
            return Objects.equals(this.publisher, that.publisher) && Objects.equals(this.model, that.model);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.publisher);
        h *= 1000003;
        return h ^= Objects.hashCode(this.model);
    }

    public static class Builder {
        private String publisher;
        private String model;

        protected Builder() {
        }

        public String getPublisher() {
            return this.publisher;
        }

        public String getModel() {
            return this.model;
        }

        public Builder setPublisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder setModel(String model) {
            this.model = model;
            return this;
        }

        private Builder(PublisherModelName publisherModelName) {
            this.publisher = publisherModelName.publisher;
            this.model = publisherModelName.model;
        }

        public PublisherModelName build() {
            return new PublisherModelName(this);
        }
    }
}

