/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/model_service.proto

package com.google.cloud.aiplatform.v1;

public interface UploadModelRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.UploadModelRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location into which to upload the Model.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location into which to upload the Model.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Optional. The resource name of the model into which to upload the version. Only
   * specify this field when uploading a new version.
   * </pre>
   *
   * <code>string parent_model = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The parentModel.
   */
  java.lang.String getParentModel();
  /**
   *
   *
   * <pre>
   * Optional. The resource name of the model into which to upload the version. Only
   * specify this field when uploading a new version.
   * </pre>
   *
   * <code>string parent_model = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for parentModel.
   */
  com.google.protobuf.ByteString getParentModelBytes();

  /**
   *
   *
   * <pre>
   * Optional. The ID to use for the uploaded Model, which will become the final
   * component of the model resource name.
   * This value may be up to 63 characters, and valid characters are
   * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
   * </pre>
   *
   * <code>string model_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The modelId.
   */
  java.lang.String getModelId();
  /**
   *
   *
   * <pre>
   * Optional. The ID to use for the uploaded Model, which will become the final
   * component of the model resource name.
   * This value may be up to 63 characters, and valid characters are
   * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
   * </pre>
   *
   * <code>string model_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for modelId.
   */
  com.google.protobuf.ByteString getModelIdBytes();

  /**
   *
   *
   * <pre>
   * Required. The Model to create.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Model model = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the model field is set.
   */
  boolean hasModel();
  /**
   *
   *
   * <pre>
   * Required. The Model to create.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Model model = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The model.
   */
  com.google.cloud.aiplatform.v1.Model getModel();
  /**
   *
   *
   * <pre>
   * Required. The Model to create.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Model model = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.aiplatform.v1.ModelOrBuilder getModelOrBuilder();
}
