/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/training_pipeline.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * The TrainingPipeline orchestrates tasks associated with training a Model. It
 * always executes the training task, and optionally may also
 * export data from Vertex AI's Dataset which becomes the training input,
 * [upload][google.cloud.aiplatform.v1.ModelService.UploadModel] the Model to Vertex AI, and evaluate the
 * Model.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.TrainingPipeline}
 */
public final class TrainingPipeline extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.TrainingPipeline)
    TrainingPipelineOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TrainingPipeline.newBuilder() to construct.
  private TrainingPipeline(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TrainingPipeline() {
    name_ = "";
    displayName_ = "";
    trainingTaskDefinition_ = "";
    modelId_ = "";
    parentModel_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TrainingPipeline();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private TrainingPipeline(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 26:
            {
              com.google.cloud.aiplatform.v1.InputDataConfig.Builder subBuilder = null;
              if (inputDataConfig_ != null) {
                subBuilder = inputDataConfig_.toBuilder();
              }
              inputDataConfig_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.InputDataConfig.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(inputDataConfig_);
                inputDataConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              trainingTaskDefinition_ = s;
              break;
            }
          case 42:
            {
              com.google.protobuf.Value.Builder subBuilder = null;
              if (trainingTaskInputs_ != null) {
                subBuilder = trainingTaskInputs_.toBuilder();
              }
              trainingTaskInputs_ =
                  input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(trainingTaskInputs_);
                trainingTaskInputs_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              com.google.protobuf.Value.Builder subBuilder = null;
              if (trainingTaskMetadata_ != null) {
                subBuilder = trainingTaskMetadata_.toBuilder();
              }
              trainingTaskMetadata_ =
                  input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(trainingTaskMetadata_);
                trainingTaskMetadata_ = subBuilder.buildPartial();
              }

              break;
            }
          case 58:
            {
              com.google.cloud.aiplatform.v1.Model.Builder subBuilder = null;
              if (modelToUpload_ != null) {
                subBuilder = modelToUpload_.toBuilder();
              }
              modelToUpload_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.Model.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(modelToUpload_);
                modelToUpload_ = subBuilder.buildPartial();
              }

              break;
            }
          case 72:
            {
              int rawValue = input.readEnum();

              state_ = rawValue;
              break;
            }
          case 82:
            {
              com.google.rpc.Status.Builder subBuilder = null;
              if (error_ != null) {
                subBuilder = error_.toBuilder();
              }
              error_ = input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(error_);
                error_ = subBuilder.buildPartial();
              }

              break;
            }
          case 90:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 98:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (startTime_ != null) {
                subBuilder = startTime_.toBuilder();
              }
              startTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(startTime_);
                startTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 106:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (endTime_ != null) {
                subBuilder = endTime_.toBuilder();
              }
              endTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(endTime_);
                endTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 114:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (updateTime_ != null) {
                subBuilder = updateTime_.toBuilder();
              }
              updateTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(updateTime_);
                updateTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 122:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                labels_ =
                    com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                  input.readMessage(
                      LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
              break;
            }
          case 146:
            {
              com.google.cloud.aiplatform.v1.EncryptionSpec.Builder subBuilder = null;
              if (encryptionSpec_ != null) {
                subBuilder = encryptionSpec_.toBuilder();
              }
              encryptionSpec_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.EncryptionSpec.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(encryptionSpec_);
                encryptionSpec_ = subBuilder.buildPartial();
              }

              break;
            }
          case 170:
            {
              java.lang.String s = input.readStringRequireUtf8();

              parentModel_ = s;
              break;
            }
          case 178:
            {
              java.lang.String s = input.readStringRequireUtf8();

              modelId_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.TrainingPipelineProto
        .internal_static_google_cloud_aiplatform_v1_TrainingPipeline_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 15:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.TrainingPipelineProto
        .internal_static_google_cloud_aiplatform_v1_TrainingPipeline_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.TrainingPipeline.class,
            com.google.cloud.aiplatform.v1.TrainingPipeline.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the TrainingPipeline.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the TrainingPipeline.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Required. The user-defined name of this TrainingPipeline.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The user-defined name of this TrainingPipeline.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUT_DATA_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1.InputDataConfig inputDataConfig_;
  /**
   *
   *
   * <pre>
   * Specifies Vertex AI owned input data that may be used for training the
   * Model. The TrainingPipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make
   * clear whether this config is used and if there are any special requirements
   * on how it should be filled. If nothing about this config is mentioned in
   * the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that the
   * TrainingPipeline does not depend on this configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.InputDataConfig input_data_config = 3;</code>
   *
   * @return Whether the inputDataConfig field is set.
   */
  @java.lang.Override
  public boolean hasInputDataConfig() {
    return inputDataConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Specifies Vertex AI owned input data that may be used for training the
   * Model. The TrainingPipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make
   * clear whether this config is used and if there are any special requirements
   * on how it should be filled. If nothing about this config is mentioned in
   * the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that the
   * TrainingPipeline does not depend on this configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.InputDataConfig input_data_config = 3;</code>
   *
   * @return The inputDataConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.InputDataConfig getInputDataConfig() {
    return inputDataConfig_ == null
        ? com.google.cloud.aiplatform.v1.InputDataConfig.getDefaultInstance()
        : inputDataConfig_;
  }
  /**
   *
   *
   * <pre>
   * Specifies Vertex AI owned input data that may be used for training the
   * Model. The TrainingPipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make
   * clear whether this config is used and if there are any special requirements
   * on how it should be filled. If nothing about this config is mentioned in
   * the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that the
   * TrainingPipeline does not depend on this configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.InputDataConfig input_data_config = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.InputDataConfigOrBuilder getInputDataConfigOrBuilder() {
    return getInputDataConfig();
  }

  public static final int TRAINING_TASK_DEFINITION_FIELD_NUMBER = 4;
  private volatile java.lang.Object trainingTaskDefinition_;
  /**
   *
   *
   * <pre>
   * Required. A Google Cloud Storage path to the YAML file that defines the training task
   * which is responsible for producing the model artifact, and may also include
   * additional auxiliary work.
   * The definition files that can be used here are found in
   * gs://google-cloud-aiplatform/schema/trainingjob/definition/.
   * Note: The URI given on output will be immutable and probably different,
   * including the URI scheme, than the one given on input. The output URI will
   * point to a location where the user only has a read access.
   * </pre>
   *
   * <code>string training_task_definition = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The trainingTaskDefinition.
   */
  @java.lang.Override
  public java.lang.String getTrainingTaskDefinition() {
    java.lang.Object ref = trainingTaskDefinition_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      trainingTaskDefinition_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. A Google Cloud Storage path to the YAML file that defines the training task
   * which is responsible for producing the model artifact, and may also include
   * additional auxiliary work.
   * The definition files that can be used here are found in
   * gs://google-cloud-aiplatform/schema/trainingjob/definition/.
   * Note: The URI given on output will be immutable and probably different,
   * including the URI scheme, than the one given on input. The output URI will
   * point to a location where the user only has a read access.
   * </pre>
   *
   * <code>string training_task_definition = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for trainingTaskDefinition.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTrainingTaskDefinitionBytes() {
    java.lang.Object ref = trainingTaskDefinition_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      trainingTaskDefinition_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRAINING_TASK_INPUTS_FIELD_NUMBER = 5;
  private com.google.protobuf.Value trainingTaskInputs_;
  /**
   *
   *
   * <pre>
   * Required. The training task's parameter(s), as specified in the
   * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s `inputs`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Value training_task_inputs = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the trainingTaskInputs field is set.
   */
  @java.lang.Override
  public boolean hasTrainingTaskInputs() {
    return trainingTaskInputs_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The training task's parameter(s), as specified in the
   * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s `inputs`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Value training_task_inputs = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The trainingTaskInputs.
   */
  @java.lang.Override
  public com.google.protobuf.Value getTrainingTaskInputs() {
    return trainingTaskInputs_ == null
        ? com.google.protobuf.Value.getDefaultInstance()
        : trainingTaskInputs_;
  }
  /**
   *
   *
   * <pre>
   * Required. The training task's parameter(s), as specified in the
   * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s `inputs`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Value training_task_inputs = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getTrainingTaskInputsOrBuilder() {
    return getTrainingTaskInputs();
  }

  public static final int TRAINING_TASK_METADATA_FIELD_NUMBER = 6;
  private com.google.protobuf.Value trainingTaskMetadata_;
  /**
   *
   *
   * <pre>
   * Output only. The metadata information as specified in the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s
   * `metadata`. This metadata is an auxiliary runtime and final information
   * about the training task. While the pipeline is running this information is
   * populated only at a best effort basis. Only present if the
   * pipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] contains `metadata` object.
   * </pre>
   *
   * <code>
   * .google.protobuf.Value training_task_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the trainingTaskMetadata field is set.
   */
  @java.lang.Override
  public boolean hasTrainingTaskMetadata() {
    return trainingTaskMetadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The metadata information as specified in the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s
   * `metadata`. This metadata is an auxiliary runtime and final information
   * about the training task. While the pipeline is running this information is
   * populated only at a best effort basis. Only present if the
   * pipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] contains `metadata` object.
   * </pre>
   *
   * <code>
   * .google.protobuf.Value training_task_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The trainingTaskMetadata.
   */
  @java.lang.Override
  public com.google.protobuf.Value getTrainingTaskMetadata() {
    return trainingTaskMetadata_ == null
        ? com.google.protobuf.Value.getDefaultInstance()
        : trainingTaskMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The metadata information as specified in the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s
   * `metadata`. This metadata is an auxiliary runtime and final information
   * about the training task. While the pipeline is running this information is
   * populated only at a best effort basis. Only present if the
   * pipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] contains `metadata` object.
   * </pre>
   *
   * <code>
   * .google.protobuf.Value training_task_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getTrainingTaskMetadataOrBuilder() {
    return getTrainingTaskMetadata();
  }

  public static final int MODEL_TO_UPLOAD_FIELD_NUMBER = 7;
  private com.google.cloud.aiplatform.v1.Model modelToUpload_;
  /**
   *
   *
   * <pre>
   * Describes the Model that may be uploaded (via [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel])
   * by this TrainingPipeline. The TrainingPipeline's
   * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make clear whether this Model
   * description should be populated, and if there are any special requirements
   * regarding how it should be filled. If nothing is mentioned in the
   * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that this field
   * should not be filled and the training task either uploads the Model without
   * a need of this information, or that training task does not support
   * uploading a Model as part of the pipeline.
   * When the Pipeline's state becomes `PIPELINE_STATE_SUCCEEDED` and
   * the trained Model had been uploaded into Vertex AI, then the
   * model_to_upload's resource [name][google.cloud.aiplatform.v1.Model.name] is populated. The Model
   * is always uploaded into the Project and Location in which this pipeline
   * is.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Model model_to_upload = 7;</code>
   *
   * @return Whether the modelToUpload field is set.
   */
  @java.lang.Override
  public boolean hasModelToUpload() {
    return modelToUpload_ != null;
  }
  /**
   *
   *
   * <pre>
   * Describes the Model that may be uploaded (via [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel])
   * by this TrainingPipeline. The TrainingPipeline's
   * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make clear whether this Model
   * description should be populated, and if there are any special requirements
   * regarding how it should be filled. If nothing is mentioned in the
   * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that this field
   * should not be filled and the training task either uploads the Model without
   * a need of this information, or that training task does not support
   * uploading a Model as part of the pipeline.
   * When the Pipeline's state becomes `PIPELINE_STATE_SUCCEEDED` and
   * the trained Model had been uploaded into Vertex AI, then the
   * model_to_upload's resource [name][google.cloud.aiplatform.v1.Model.name] is populated. The Model
   * is always uploaded into the Project and Location in which this pipeline
   * is.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Model model_to_upload = 7;</code>
   *
   * @return The modelToUpload.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Model getModelToUpload() {
    return modelToUpload_ == null
        ? com.google.cloud.aiplatform.v1.Model.getDefaultInstance()
        : modelToUpload_;
  }
  /**
   *
   *
   * <pre>
   * Describes the Model that may be uploaded (via [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel])
   * by this TrainingPipeline. The TrainingPipeline's
   * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make clear whether this Model
   * description should be populated, and if there are any special requirements
   * regarding how it should be filled. If nothing is mentioned in the
   * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that this field
   * should not be filled and the training task either uploads the Model without
   * a need of this information, or that training task does not support
   * uploading a Model as part of the pipeline.
   * When the Pipeline's state becomes `PIPELINE_STATE_SUCCEEDED` and
   * the trained Model had been uploaded into Vertex AI, then the
   * model_to_upload's resource [name][google.cloud.aiplatform.v1.Model.name] is populated. The Model
   * is always uploaded into the Project and Location in which this pipeline
   * is.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Model model_to_upload = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModelOrBuilder getModelToUploadOrBuilder() {
    return getModelToUpload();
  }

  public static final int MODEL_ID_FIELD_NUMBER = 22;
  private volatile java.lang.Object modelId_;
  /**
   *
   *
   * <pre>
   * Optional. The ID to use for the uploaded Model, which will become the final
   * component of the model resource name.
   * This value may be up to 63 characters, and valid characters are
   * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
   * </pre>
   *
   * <code>string model_id = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The modelId.
   */
  @java.lang.Override
  public java.lang.String getModelId() {
    java.lang.Object ref = modelId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The ID to use for the uploaded Model, which will become the final
   * component of the model resource name.
   * This value may be up to 63 characters, and valid characters are
   * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
   * </pre>
   *
   * <code>string model_id = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for modelId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelIdBytes() {
    java.lang.Object ref = modelId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_MODEL_FIELD_NUMBER = 21;
  private volatile java.lang.Object parentModel_;
  /**
   *
   *
   * <pre>
   * Optional. When specify this field, the `model_to_upload` will not be uploaded as a
   * new model, instead, it will become a new version of this `parent_model`.
   * </pre>
   *
   * <code>string parent_model = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The parentModel.
   */
  @java.lang.Override
  public java.lang.String getParentModel() {
    java.lang.Object ref = parentModel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parentModel_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. When specify this field, the `model_to_upload` will not be uploaded as a
   * new model, instead, it will become a new version of this `parent_model`.
   * </pre>
   *
   * <code>string parent_model = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for parentModel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentModelBytes() {
    java.lang.Object ref = parentModel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parentModel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 9;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the pipeline.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PipelineState state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the pipeline.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PipelineState state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PipelineState getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.aiplatform.v1.PipelineState result =
        com.google.cloud.aiplatform.v1.PipelineState.valueOf(state_);
    return result == null ? com.google.cloud.aiplatform.v1.PipelineState.UNRECOGNIZED : result;
  }

  public static final int ERROR_FIELD_NUMBER = 10;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * Output only. Only populated when the pipeline's state is `PIPELINE_STATE_FAILED` or
   * `PIPELINE_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return error_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Only populated when the pipeline's state is `PIPELINE_STATE_FAILED` or
   * `PIPELINE_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Only populated when the pipeline's state is `PIPELINE_STATE_FAILED` or
   * `PIPELINE_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return getError();
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the TrainingPipeline was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the TrainingPipeline was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the TrainingPipeline was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int START_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the TrainingPipeline for the first time entered the
   * `PIPELINE_STATE_RUNNING` state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the TrainingPipeline for the first time entered the
   * `PIPELINE_STATE_RUNNING` state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the TrainingPipeline for the first time entered the
   * `PIPELINE_STATE_RUNNING` state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return getStartTime();
  }

  public static final int END_TIME_FIELD_NUMBER = 13;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the TrainingPipeline entered any of the following states:
   * `PIPELINE_STATE_SUCCEEDED`, `PIPELINE_STATE_FAILED`,
   * `PIPELINE_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the TrainingPipeline entered any of the following states:
   * `PIPELINE_STATE_SUCCEEDED`, `PIPELINE_STATE_FAILED`,
   * `PIPELINE_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the TrainingPipeline entered any of the following states:
   * `PIPELINE_STATE_SUCCEEDED`, `PIPELINE_STATE_FAILED`,
   * `PIPELINE_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return getEndTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 14;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the TrainingPipeline was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the TrainingPipeline was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the TrainingPipeline was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int LABELS_FIELD_NUMBER = 15;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1.TrainingPipelineProto
                .internal_static_google_cloud_aiplatform_v1_TrainingPipeline_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize TrainingPipelines.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize TrainingPipelines.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize TrainingPipelines.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize TrainingPipelines.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 18;
  private com.google.cloud.aiplatform.v1.EncryptionSpec encryptionSpec_;
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a TrainingPipeline. If set, this
   * TrainingPipeline will be secured by this key.
   * Note: Model trained by this TrainingPipeline is also secured by this key if
   * [model_to_upload][google.cloud.aiplatform.v1.TrainingPipeline.encryption_spec] is not set separately.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 18;</code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return encryptionSpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a TrainingPipeline. If set, this
   * TrainingPipeline will be secured by this key.
   * Note: Model trained by this TrainingPipeline is also secured by this key if
   * [model_to_upload][google.cloud.aiplatform.v1.TrainingPipeline.encryption_spec] is not set separately.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 18;</code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a TrainingPipeline. If set, this
   * TrainingPipeline will be secured by this key.
   * Note: Model trained by this TrainingPipeline is also secured by this key if
   * [model_to_upload][google.cloud.aiplatform.v1.TrainingPipeline.encryption_spec] is not set separately.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 18;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return getEncryptionSpec();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (inputDataConfig_ != null) {
      output.writeMessage(3, getInputDataConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trainingTaskDefinition_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, trainingTaskDefinition_);
    }
    if (trainingTaskInputs_ != null) {
      output.writeMessage(5, getTrainingTaskInputs());
    }
    if (trainingTaskMetadata_ != null) {
      output.writeMessage(6, getTrainingTaskMetadata());
    }
    if (modelToUpload_ != null) {
      output.writeMessage(7, getModelToUpload());
    }
    if (state_
        != com.google.cloud.aiplatform.v1.PipelineState.PIPELINE_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(9, state_);
    }
    if (error_ != null) {
      output.writeMessage(10, getError());
    }
    if (createTime_ != null) {
      output.writeMessage(11, getCreateTime());
    }
    if (startTime_ != null) {
      output.writeMessage(12, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(13, getEndTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(14, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 15);
    if (encryptionSpec_ != null) {
      output.writeMessage(18, getEncryptionSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentModel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 21, parentModel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 22, modelId_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (inputDataConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getInputDataConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trainingTaskDefinition_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, trainingTaskDefinition_);
    }
    if (trainingTaskInputs_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getTrainingTaskInputs());
    }
    if (trainingTaskMetadata_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(6, getTrainingTaskMetadata());
    }
    if (modelToUpload_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getModelToUpload());
    }
    if (state_
        != com.google.cloud.aiplatform.v1.PipelineState.PIPELINE_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, state_);
    }
    if (error_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getError());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getCreateTime());
    }
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getEndTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, labels__);
    }
    if (encryptionSpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getEncryptionSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentModel_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(21, parentModel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(22, modelId_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.TrainingPipeline)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.TrainingPipeline other =
        (com.google.cloud.aiplatform.v1.TrainingPipeline) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasInputDataConfig() != other.hasInputDataConfig()) return false;
    if (hasInputDataConfig()) {
      if (!getInputDataConfig().equals(other.getInputDataConfig())) return false;
    }
    if (!getTrainingTaskDefinition().equals(other.getTrainingTaskDefinition())) return false;
    if (hasTrainingTaskInputs() != other.hasTrainingTaskInputs()) return false;
    if (hasTrainingTaskInputs()) {
      if (!getTrainingTaskInputs().equals(other.getTrainingTaskInputs())) return false;
    }
    if (hasTrainingTaskMetadata() != other.hasTrainingTaskMetadata()) return false;
    if (hasTrainingTaskMetadata()) {
      if (!getTrainingTaskMetadata().equals(other.getTrainingTaskMetadata())) return false;
    }
    if (hasModelToUpload() != other.hasModelToUpload()) return false;
    if (hasModelToUpload()) {
      if (!getModelToUpload().equals(other.getModelToUpload())) return false;
    }
    if (!getModelId().equals(other.getModelId())) return false;
    if (!getParentModel().equals(other.getParentModel())) return false;
    if (state_ != other.state_) return false;
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasInputDataConfig()) {
      hash = (37 * hash) + INPUT_DATA_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInputDataConfig().hashCode();
    }
    hash = (37 * hash) + TRAINING_TASK_DEFINITION_FIELD_NUMBER;
    hash = (53 * hash) + getTrainingTaskDefinition().hashCode();
    if (hasTrainingTaskInputs()) {
      hash = (37 * hash) + TRAINING_TASK_INPUTS_FIELD_NUMBER;
      hash = (53 * hash) + getTrainingTaskInputs().hashCode();
    }
    if (hasTrainingTaskMetadata()) {
      hash = (37 * hash) + TRAINING_TASK_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getTrainingTaskMetadata().hashCode();
    }
    if (hasModelToUpload()) {
      hash = (37 * hash) + MODEL_TO_UPLOAD_FIELD_NUMBER;
      hash = (53 * hash) + getModelToUpload().hashCode();
    }
    hash = (37 * hash) + MODEL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getModelId().hashCode();
    hash = (37 * hash) + PARENT_MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getParentModel().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.TrainingPipeline parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.TrainingPipeline parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TrainingPipeline parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.TrainingPipeline parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TrainingPipeline parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.TrainingPipeline parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TrainingPipeline parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.TrainingPipeline parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TrainingPipeline parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.TrainingPipeline parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TrainingPipeline parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.TrainingPipeline parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.TrainingPipeline prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The TrainingPipeline orchestrates tasks associated with training a Model. It
   * always executes the training task, and optionally may also
   * export data from Vertex AI's Dataset which becomes the training input,
   * [upload][google.cloud.aiplatform.v1.ModelService.UploadModel] the Model to Vertex AI, and evaluate the
   * Model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.TrainingPipeline}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.TrainingPipeline)
      com.google.cloud.aiplatform.v1.TrainingPipelineOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.TrainingPipelineProto
          .internal_static_google_cloud_aiplatform_v1_TrainingPipeline_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 15:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 15:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.TrainingPipelineProto
          .internal_static_google_cloud_aiplatform_v1_TrainingPipeline_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.TrainingPipeline.class,
              com.google.cloud.aiplatform.v1.TrainingPipeline.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.TrainingPipeline.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      if (inputDataConfigBuilder_ == null) {
        inputDataConfig_ = null;
      } else {
        inputDataConfig_ = null;
        inputDataConfigBuilder_ = null;
      }
      trainingTaskDefinition_ = "";

      if (trainingTaskInputsBuilder_ == null) {
        trainingTaskInputs_ = null;
      } else {
        trainingTaskInputs_ = null;
        trainingTaskInputsBuilder_ = null;
      }
      if (trainingTaskMetadataBuilder_ == null) {
        trainingTaskMetadata_ = null;
      } else {
        trainingTaskMetadata_ = null;
        trainingTaskMetadataBuilder_ = null;
      }
      if (modelToUploadBuilder_ == null) {
        modelToUpload_ = null;
      } else {
        modelToUpload_ = null;
        modelToUploadBuilder_ = null;
      }
      modelId_ = "";

      parentModel_ = "";

      state_ = 0;

      if (errorBuilder_ == null) {
        error_ = null;
      } else {
        error_ = null;
        errorBuilder_ = null;
      }
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (startTimeBuilder_ == null) {
        startTime_ = null;
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }
      if (endTimeBuilder_ == null) {
        endTime_ = null;
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = null;
      } else {
        encryptionSpec_ = null;
        encryptionSpecBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.TrainingPipelineProto
          .internal_static_google_cloud_aiplatform_v1_TrainingPipeline_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TrainingPipeline getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.TrainingPipeline.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TrainingPipeline build() {
      com.google.cloud.aiplatform.v1.TrainingPipeline result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TrainingPipeline buildPartial() {
      com.google.cloud.aiplatform.v1.TrainingPipeline result =
          new com.google.cloud.aiplatform.v1.TrainingPipeline(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.displayName_ = displayName_;
      if (inputDataConfigBuilder_ == null) {
        result.inputDataConfig_ = inputDataConfig_;
      } else {
        result.inputDataConfig_ = inputDataConfigBuilder_.build();
      }
      result.trainingTaskDefinition_ = trainingTaskDefinition_;
      if (trainingTaskInputsBuilder_ == null) {
        result.trainingTaskInputs_ = trainingTaskInputs_;
      } else {
        result.trainingTaskInputs_ = trainingTaskInputsBuilder_.build();
      }
      if (trainingTaskMetadataBuilder_ == null) {
        result.trainingTaskMetadata_ = trainingTaskMetadata_;
      } else {
        result.trainingTaskMetadata_ = trainingTaskMetadataBuilder_.build();
      }
      if (modelToUploadBuilder_ == null) {
        result.modelToUpload_ = modelToUpload_;
      } else {
        result.modelToUpload_ = modelToUploadBuilder_.build();
      }
      result.modelId_ = modelId_;
      result.parentModel_ = parentModel_;
      result.state_ = state_;
      if (errorBuilder_ == null) {
        result.error_ = error_;
      } else {
        result.error_ = errorBuilder_.build();
      }
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (startTimeBuilder_ == null) {
        result.startTime_ = startTime_;
      } else {
        result.startTime_ = startTimeBuilder_.build();
      }
      if (endTimeBuilder_ == null) {
        result.endTime_ = endTime_;
      } else {
        result.endTime_ = endTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (encryptionSpecBuilder_ == null) {
        result.encryptionSpec_ = encryptionSpec_;
      } else {
        result.encryptionSpec_ = encryptionSpecBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.TrainingPipeline) {
        return mergeFrom((com.google.cloud.aiplatform.v1.TrainingPipeline) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.TrainingPipeline other) {
      if (other == com.google.cloud.aiplatform.v1.TrainingPipeline.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (other.hasInputDataConfig()) {
        mergeInputDataConfig(other.getInputDataConfig());
      }
      if (!other.getTrainingTaskDefinition().isEmpty()) {
        trainingTaskDefinition_ = other.trainingTaskDefinition_;
        onChanged();
      }
      if (other.hasTrainingTaskInputs()) {
        mergeTrainingTaskInputs(other.getTrainingTaskInputs());
      }
      if (other.hasTrainingTaskMetadata()) {
        mergeTrainingTaskMetadata(other.getTrainingTaskMetadata());
      }
      if (other.hasModelToUpload()) {
        mergeModelToUpload(other.getModelToUpload());
      }
      if (!other.getModelId().isEmpty()) {
        modelId_ = other.modelId_;
        onChanged();
      }
      if (!other.getParentModel().isEmpty()) {
        parentModel_ = other.parentModel_;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1.TrainingPipeline parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.aiplatform.v1.TrainingPipeline) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the TrainingPipeline.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the TrainingPipeline.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the TrainingPipeline.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the TrainingPipeline.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the TrainingPipeline.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of this TrainingPipeline.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of this TrainingPipeline.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of this TrainingPipeline.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of this TrainingPipeline.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of this TrainingPipeline.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.InputDataConfig inputDataConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.InputDataConfig,
            com.google.cloud.aiplatform.v1.InputDataConfig.Builder,
            com.google.cloud.aiplatform.v1.InputDataConfigOrBuilder>
        inputDataConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies Vertex AI owned input data that may be used for training the
     * Model. The TrainingPipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make
     * clear whether this config is used and if there are any special requirements
     * on how it should be filled. If nothing about this config is mentioned in
     * the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that the
     * TrainingPipeline does not depend on this configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.InputDataConfig input_data_config = 3;</code>
     *
     * @return Whether the inputDataConfig field is set.
     */
    public boolean hasInputDataConfig() {
      return inputDataConfigBuilder_ != null || inputDataConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Specifies Vertex AI owned input data that may be used for training the
     * Model. The TrainingPipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make
     * clear whether this config is used and if there are any special requirements
     * on how it should be filled. If nothing about this config is mentioned in
     * the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that the
     * TrainingPipeline does not depend on this configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.InputDataConfig input_data_config = 3;</code>
     *
     * @return The inputDataConfig.
     */
    public com.google.cloud.aiplatform.v1.InputDataConfig getInputDataConfig() {
      if (inputDataConfigBuilder_ == null) {
        return inputDataConfig_ == null
            ? com.google.cloud.aiplatform.v1.InputDataConfig.getDefaultInstance()
            : inputDataConfig_;
      } else {
        return inputDataConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies Vertex AI owned input data that may be used for training the
     * Model. The TrainingPipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make
     * clear whether this config is used and if there are any special requirements
     * on how it should be filled. If nothing about this config is mentioned in
     * the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that the
     * TrainingPipeline does not depend on this configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.InputDataConfig input_data_config = 3;</code>
     */
    public Builder setInputDataConfig(com.google.cloud.aiplatform.v1.InputDataConfig value) {
      if (inputDataConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputDataConfig_ = value;
        onChanged();
      } else {
        inputDataConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies Vertex AI owned input data that may be used for training the
     * Model. The TrainingPipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make
     * clear whether this config is used and if there are any special requirements
     * on how it should be filled. If nothing about this config is mentioned in
     * the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that the
     * TrainingPipeline does not depend on this configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.InputDataConfig input_data_config = 3;</code>
     */
    public Builder setInputDataConfig(
        com.google.cloud.aiplatform.v1.InputDataConfig.Builder builderForValue) {
      if (inputDataConfigBuilder_ == null) {
        inputDataConfig_ = builderForValue.build();
        onChanged();
      } else {
        inputDataConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies Vertex AI owned input data that may be used for training the
     * Model. The TrainingPipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make
     * clear whether this config is used and if there are any special requirements
     * on how it should be filled. If nothing about this config is mentioned in
     * the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that the
     * TrainingPipeline does not depend on this configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.InputDataConfig input_data_config = 3;</code>
     */
    public Builder mergeInputDataConfig(com.google.cloud.aiplatform.v1.InputDataConfig value) {
      if (inputDataConfigBuilder_ == null) {
        if (inputDataConfig_ != null) {
          inputDataConfig_ =
              com.google.cloud.aiplatform.v1.InputDataConfig.newBuilder(inputDataConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          inputDataConfig_ = value;
        }
        onChanged();
      } else {
        inputDataConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies Vertex AI owned input data that may be used for training the
     * Model. The TrainingPipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make
     * clear whether this config is used and if there are any special requirements
     * on how it should be filled. If nothing about this config is mentioned in
     * the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that the
     * TrainingPipeline does not depend on this configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.InputDataConfig input_data_config = 3;</code>
     */
    public Builder clearInputDataConfig() {
      if (inputDataConfigBuilder_ == null) {
        inputDataConfig_ = null;
        onChanged();
      } else {
        inputDataConfig_ = null;
        inputDataConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies Vertex AI owned input data that may be used for training the
     * Model. The TrainingPipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make
     * clear whether this config is used and if there are any special requirements
     * on how it should be filled. If nothing about this config is mentioned in
     * the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that the
     * TrainingPipeline does not depend on this configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.InputDataConfig input_data_config = 3;</code>
     */
    public com.google.cloud.aiplatform.v1.InputDataConfig.Builder getInputDataConfigBuilder() {

      onChanged();
      return getInputDataConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies Vertex AI owned input data that may be used for training the
     * Model. The TrainingPipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make
     * clear whether this config is used and if there are any special requirements
     * on how it should be filled. If nothing about this config is mentioned in
     * the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that the
     * TrainingPipeline does not depend on this configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.InputDataConfig input_data_config = 3;</code>
     */
    public com.google.cloud.aiplatform.v1.InputDataConfigOrBuilder getInputDataConfigOrBuilder() {
      if (inputDataConfigBuilder_ != null) {
        return inputDataConfigBuilder_.getMessageOrBuilder();
      } else {
        return inputDataConfig_ == null
            ? com.google.cloud.aiplatform.v1.InputDataConfig.getDefaultInstance()
            : inputDataConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies Vertex AI owned input data that may be used for training the
     * Model. The TrainingPipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make
     * clear whether this config is used and if there are any special requirements
     * on how it should be filled. If nothing about this config is mentioned in
     * the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that the
     * TrainingPipeline does not depend on this configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.InputDataConfig input_data_config = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.InputDataConfig,
            com.google.cloud.aiplatform.v1.InputDataConfig.Builder,
            com.google.cloud.aiplatform.v1.InputDataConfigOrBuilder>
        getInputDataConfigFieldBuilder() {
      if (inputDataConfigBuilder_ == null) {
        inputDataConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.InputDataConfig,
                com.google.cloud.aiplatform.v1.InputDataConfig.Builder,
                com.google.cloud.aiplatform.v1.InputDataConfigOrBuilder>(
                getInputDataConfig(), getParentForChildren(), isClean());
        inputDataConfig_ = null;
      }
      return inputDataConfigBuilder_;
    }

    private java.lang.Object trainingTaskDefinition_ = "";
    /**
     *
     *
     * <pre>
     * Required. A Google Cloud Storage path to the YAML file that defines the training task
     * which is responsible for producing the model artifact, and may also include
     * additional auxiliary work.
     * The definition files that can be used here are found in
     * gs://google-cloud-aiplatform/schema/trainingjob/definition/.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string training_task_definition = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The trainingTaskDefinition.
     */
    public java.lang.String getTrainingTaskDefinition() {
      java.lang.Object ref = trainingTaskDefinition_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        trainingTaskDefinition_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A Google Cloud Storage path to the YAML file that defines the training task
     * which is responsible for producing the model artifact, and may also include
     * additional auxiliary work.
     * The definition files that can be used here are found in
     * gs://google-cloud-aiplatform/schema/trainingjob/definition/.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string training_task_definition = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for trainingTaskDefinition.
     */
    public com.google.protobuf.ByteString getTrainingTaskDefinitionBytes() {
      java.lang.Object ref = trainingTaskDefinition_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        trainingTaskDefinition_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A Google Cloud Storage path to the YAML file that defines the training task
     * which is responsible for producing the model artifact, and may also include
     * additional auxiliary work.
     * The definition files that can be used here are found in
     * gs://google-cloud-aiplatform/schema/trainingjob/definition/.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string training_task_definition = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The trainingTaskDefinition to set.
     * @return This builder for chaining.
     */
    public Builder setTrainingTaskDefinition(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      trainingTaskDefinition_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A Google Cloud Storage path to the YAML file that defines the training task
     * which is responsible for producing the model artifact, and may also include
     * additional auxiliary work.
     * The definition files that can be used here are found in
     * gs://google-cloud-aiplatform/schema/trainingjob/definition/.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string training_task_definition = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrainingTaskDefinition() {

      trainingTaskDefinition_ = getDefaultInstance().getTrainingTaskDefinition();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A Google Cloud Storage path to the YAML file that defines the training task
     * which is responsible for producing the model artifact, and may also include
     * additional auxiliary work.
     * The definition files that can be used here are found in
     * gs://google-cloud-aiplatform/schema/trainingjob/definition/.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string training_task_definition = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for trainingTaskDefinition to set.
     * @return This builder for chaining.
     */
    public Builder setTrainingTaskDefinitionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      trainingTaskDefinition_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Value trainingTaskInputs_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        trainingTaskInputsBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The training task's parameter(s), as specified in the
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s `inputs`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value training_task_inputs = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the trainingTaskInputs field is set.
     */
    public boolean hasTrainingTaskInputs() {
      return trainingTaskInputsBuilder_ != null || trainingTaskInputs_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The training task's parameter(s), as specified in the
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s `inputs`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value training_task_inputs = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The trainingTaskInputs.
     */
    public com.google.protobuf.Value getTrainingTaskInputs() {
      if (trainingTaskInputsBuilder_ == null) {
        return trainingTaskInputs_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : trainingTaskInputs_;
      } else {
        return trainingTaskInputsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The training task's parameter(s), as specified in the
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s `inputs`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value training_task_inputs = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTrainingTaskInputs(com.google.protobuf.Value value) {
      if (trainingTaskInputsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trainingTaskInputs_ = value;
        onChanged();
      } else {
        trainingTaskInputsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The training task's parameter(s), as specified in the
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s `inputs`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value training_task_inputs = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTrainingTaskInputs(com.google.protobuf.Value.Builder builderForValue) {
      if (trainingTaskInputsBuilder_ == null) {
        trainingTaskInputs_ = builderForValue.build();
        onChanged();
      } else {
        trainingTaskInputsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The training task's parameter(s), as specified in the
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s `inputs`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value training_task_inputs = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeTrainingTaskInputs(com.google.protobuf.Value value) {
      if (trainingTaskInputsBuilder_ == null) {
        if (trainingTaskInputs_ != null) {
          trainingTaskInputs_ =
              com.google.protobuf.Value.newBuilder(trainingTaskInputs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          trainingTaskInputs_ = value;
        }
        onChanged();
      } else {
        trainingTaskInputsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The training task's parameter(s), as specified in the
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s `inputs`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value training_task_inputs = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearTrainingTaskInputs() {
      if (trainingTaskInputsBuilder_ == null) {
        trainingTaskInputs_ = null;
        onChanged();
      } else {
        trainingTaskInputs_ = null;
        trainingTaskInputsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The training task's parameter(s), as specified in the
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s `inputs`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value training_task_inputs = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.Value.Builder getTrainingTaskInputsBuilder() {

      onChanged();
      return getTrainingTaskInputsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The training task's parameter(s), as specified in the
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s `inputs`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value training_task_inputs = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.ValueOrBuilder getTrainingTaskInputsOrBuilder() {
      if (trainingTaskInputsBuilder_ != null) {
        return trainingTaskInputsBuilder_.getMessageOrBuilder();
      } else {
        return trainingTaskInputs_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : trainingTaskInputs_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The training task's parameter(s), as specified in the
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s `inputs`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value training_task_inputs = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getTrainingTaskInputsFieldBuilder() {
      if (trainingTaskInputsBuilder_ == null) {
        trainingTaskInputsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getTrainingTaskInputs(), getParentForChildren(), isClean());
        trainingTaskInputs_ = null;
      }
      return trainingTaskInputsBuilder_;
    }

    private com.google.protobuf.Value trainingTaskMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        trainingTaskMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The metadata information as specified in the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s
     * `metadata`. This metadata is an auxiliary runtime and final information
     * about the training task. While the pipeline is running this information is
     * populated only at a best effort basis. Only present if the
     * pipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] contains `metadata` object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value training_task_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the trainingTaskMetadata field is set.
     */
    public boolean hasTrainingTaskMetadata() {
      return trainingTaskMetadataBuilder_ != null || trainingTaskMetadata_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata information as specified in the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s
     * `metadata`. This metadata is an auxiliary runtime and final information
     * about the training task. While the pipeline is running this information is
     * populated only at a best effort basis. Only present if the
     * pipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] contains `metadata` object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value training_task_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The trainingTaskMetadata.
     */
    public com.google.protobuf.Value getTrainingTaskMetadata() {
      if (trainingTaskMetadataBuilder_ == null) {
        return trainingTaskMetadata_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : trainingTaskMetadata_;
      } else {
        return trainingTaskMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata information as specified in the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s
     * `metadata`. This metadata is an auxiliary runtime and final information
     * about the training task. While the pipeline is running this information is
     * populated only at a best effort basis. Only present if the
     * pipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] contains `metadata` object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value training_task_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTrainingTaskMetadata(com.google.protobuf.Value value) {
      if (trainingTaskMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trainingTaskMetadata_ = value;
        onChanged();
      } else {
        trainingTaskMetadataBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata information as specified in the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s
     * `metadata`. This metadata is an auxiliary runtime and final information
     * about the training task. While the pipeline is running this information is
     * populated only at a best effort basis. Only present if the
     * pipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] contains `metadata` object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value training_task_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTrainingTaskMetadata(com.google.protobuf.Value.Builder builderForValue) {
      if (trainingTaskMetadataBuilder_ == null) {
        trainingTaskMetadata_ = builderForValue.build();
        onChanged();
      } else {
        trainingTaskMetadataBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata information as specified in the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s
     * `metadata`. This metadata is an auxiliary runtime and final information
     * about the training task. While the pipeline is running this information is
     * populated only at a best effort basis. Only present if the
     * pipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] contains `metadata` object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value training_task_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTrainingTaskMetadata(com.google.protobuf.Value value) {
      if (trainingTaskMetadataBuilder_ == null) {
        if (trainingTaskMetadata_ != null) {
          trainingTaskMetadata_ =
              com.google.protobuf.Value.newBuilder(trainingTaskMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          trainingTaskMetadata_ = value;
        }
        onChanged();
      } else {
        trainingTaskMetadataBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata information as specified in the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s
     * `metadata`. This metadata is an auxiliary runtime and final information
     * about the training task. While the pipeline is running this information is
     * populated only at a best effort basis. Only present if the
     * pipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] contains `metadata` object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value training_task_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTrainingTaskMetadata() {
      if (trainingTaskMetadataBuilder_ == null) {
        trainingTaskMetadata_ = null;
        onChanged();
      } else {
        trainingTaskMetadata_ = null;
        trainingTaskMetadataBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata information as specified in the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s
     * `metadata`. This metadata is an auxiliary runtime and final information
     * about the training task. While the pipeline is running this information is
     * populated only at a best effort basis. Only present if the
     * pipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] contains `metadata` object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value training_task_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Value.Builder getTrainingTaskMetadataBuilder() {

      onChanged();
      return getTrainingTaskMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata information as specified in the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s
     * `metadata`. This metadata is an auxiliary runtime and final information
     * about the training task. While the pipeline is running this information is
     * populated only at a best effort basis. Only present if the
     * pipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] contains `metadata` object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value training_task_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.ValueOrBuilder getTrainingTaskMetadataOrBuilder() {
      if (trainingTaskMetadataBuilder_ != null) {
        return trainingTaskMetadataBuilder_.getMessageOrBuilder();
      } else {
        return trainingTaskMetadata_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : trainingTaskMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata information as specified in the [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition]'s
     * `metadata`. This metadata is an auxiliary runtime and final information
     * about the training task. While the pipeline is running this information is
     * populated only at a best effort basis. Only present if the
     * pipeline's [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] contains `metadata` object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value training_task_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getTrainingTaskMetadataFieldBuilder() {
      if (trainingTaskMetadataBuilder_ == null) {
        trainingTaskMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getTrainingTaskMetadata(), getParentForChildren(), isClean());
        trainingTaskMetadata_ = null;
      }
      return trainingTaskMetadataBuilder_;
    }

    private com.google.cloud.aiplatform.v1.Model modelToUpload_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Model,
            com.google.cloud.aiplatform.v1.Model.Builder,
            com.google.cloud.aiplatform.v1.ModelOrBuilder>
        modelToUploadBuilder_;
    /**
     *
     *
     * <pre>
     * Describes the Model that may be uploaded (via [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel])
     * by this TrainingPipeline. The TrainingPipeline's
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make clear whether this Model
     * description should be populated, and if there are any special requirements
     * regarding how it should be filled. If nothing is mentioned in the
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that this field
     * should not be filled and the training task either uploads the Model without
     * a need of this information, or that training task does not support
     * uploading a Model as part of the pipeline.
     * When the Pipeline's state becomes `PIPELINE_STATE_SUCCEEDED` and
     * the trained Model had been uploaded into Vertex AI, then the
     * model_to_upload's resource [name][google.cloud.aiplatform.v1.Model.name] is populated. The Model
     * is always uploaded into the Project and Location in which this pipeline
     * is.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Model model_to_upload = 7;</code>
     *
     * @return Whether the modelToUpload field is set.
     */
    public boolean hasModelToUpload() {
      return modelToUploadBuilder_ != null || modelToUpload_ != null;
    }
    /**
     *
     *
     * <pre>
     * Describes the Model that may be uploaded (via [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel])
     * by this TrainingPipeline. The TrainingPipeline's
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make clear whether this Model
     * description should be populated, and if there are any special requirements
     * regarding how it should be filled. If nothing is mentioned in the
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that this field
     * should not be filled and the training task either uploads the Model without
     * a need of this information, or that training task does not support
     * uploading a Model as part of the pipeline.
     * When the Pipeline's state becomes `PIPELINE_STATE_SUCCEEDED` and
     * the trained Model had been uploaded into Vertex AI, then the
     * model_to_upload's resource [name][google.cloud.aiplatform.v1.Model.name] is populated. The Model
     * is always uploaded into the Project and Location in which this pipeline
     * is.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Model model_to_upload = 7;</code>
     *
     * @return The modelToUpload.
     */
    public com.google.cloud.aiplatform.v1.Model getModelToUpload() {
      if (modelToUploadBuilder_ == null) {
        return modelToUpload_ == null
            ? com.google.cloud.aiplatform.v1.Model.getDefaultInstance()
            : modelToUpload_;
      } else {
        return modelToUploadBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the Model that may be uploaded (via [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel])
     * by this TrainingPipeline. The TrainingPipeline's
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make clear whether this Model
     * description should be populated, and if there are any special requirements
     * regarding how it should be filled. If nothing is mentioned in the
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that this field
     * should not be filled and the training task either uploads the Model without
     * a need of this information, or that training task does not support
     * uploading a Model as part of the pipeline.
     * When the Pipeline's state becomes `PIPELINE_STATE_SUCCEEDED` and
     * the trained Model had been uploaded into Vertex AI, then the
     * model_to_upload's resource [name][google.cloud.aiplatform.v1.Model.name] is populated. The Model
     * is always uploaded into the Project and Location in which this pipeline
     * is.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Model model_to_upload = 7;</code>
     */
    public Builder setModelToUpload(com.google.cloud.aiplatform.v1.Model value) {
      if (modelToUploadBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelToUpload_ = value;
        onChanged();
      } else {
        modelToUploadBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the Model that may be uploaded (via [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel])
     * by this TrainingPipeline. The TrainingPipeline's
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make clear whether this Model
     * description should be populated, and if there are any special requirements
     * regarding how it should be filled. If nothing is mentioned in the
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that this field
     * should not be filled and the training task either uploads the Model without
     * a need of this information, or that training task does not support
     * uploading a Model as part of the pipeline.
     * When the Pipeline's state becomes `PIPELINE_STATE_SUCCEEDED` and
     * the trained Model had been uploaded into Vertex AI, then the
     * model_to_upload's resource [name][google.cloud.aiplatform.v1.Model.name] is populated. The Model
     * is always uploaded into the Project and Location in which this pipeline
     * is.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Model model_to_upload = 7;</code>
     */
    public Builder setModelToUpload(com.google.cloud.aiplatform.v1.Model.Builder builderForValue) {
      if (modelToUploadBuilder_ == null) {
        modelToUpload_ = builderForValue.build();
        onChanged();
      } else {
        modelToUploadBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the Model that may be uploaded (via [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel])
     * by this TrainingPipeline. The TrainingPipeline's
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make clear whether this Model
     * description should be populated, and if there are any special requirements
     * regarding how it should be filled. If nothing is mentioned in the
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that this field
     * should not be filled and the training task either uploads the Model without
     * a need of this information, or that training task does not support
     * uploading a Model as part of the pipeline.
     * When the Pipeline's state becomes `PIPELINE_STATE_SUCCEEDED` and
     * the trained Model had been uploaded into Vertex AI, then the
     * model_to_upload's resource [name][google.cloud.aiplatform.v1.Model.name] is populated. The Model
     * is always uploaded into the Project and Location in which this pipeline
     * is.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Model model_to_upload = 7;</code>
     */
    public Builder mergeModelToUpload(com.google.cloud.aiplatform.v1.Model value) {
      if (modelToUploadBuilder_ == null) {
        if (modelToUpload_ != null) {
          modelToUpload_ =
              com.google.cloud.aiplatform.v1.Model.newBuilder(modelToUpload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          modelToUpload_ = value;
        }
        onChanged();
      } else {
        modelToUploadBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the Model that may be uploaded (via [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel])
     * by this TrainingPipeline. The TrainingPipeline's
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make clear whether this Model
     * description should be populated, and if there are any special requirements
     * regarding how it should be filled. If nothing is mentioned in the
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that this field
     * should not be filled and the training task either uploads the Model without
     * a need of this information, or that training task does not support
     * uploading a Model as part of the pipeline.
     * When the Pipeline's state becomes `PIPELINE_STATE_SUCCEEDED` and
     * the trained Model had been uploaded into Vertex AI, then the
     * model_to_upload's resource [name][google.cloud.aiplatform.v1.Model.name] is populated. The Model
     * is always uploaded into the Project and Location in which this pipeline
     * is.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Model model_to_upload = 7;</code>
     */
    public Builder clearModelToUpload() {
      if (modelToUploadBuilder_ == null) {
        modelToUpload_ = null;
        onChanged();
      } else {
        modelToUpload_ = null;
        modelToUploadBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the Model that may be uploaded (via [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel])
     * by this TrainingPipeline. The TrainingPipeline's
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make clear whether this Model
     * description should be populated, and if there are any special requirements
     * regarding how it should be filled. If nothing is mentioned in the
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that this field
     * should not be filled and the training task either uploads the Model without
     * a need of this information, or that training task does not support
     * uploading a Model as part of the pipeline.
     * When the Pipeline's state becomes `PIPELINE_STATE_SUCCEEDED` and
     * the trained Model had been uploaded into Vertex AI, then the
     * model_to_upload's resource [name][google.cloud.aiplatform.v1.Model.name] is populated. The Model
     * is always uploaded into the Project and Location in which this pipeline
     * is.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Model model_to_upload = 7;</code>
     */
    public com.google.cloud.aiplatform.v1.Model.Builder getModelToUploadBuilder() {

      onChanged();
      return getModelToUploadFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Describes the Model that may be uploaded (via [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel])
     * by this TrainingPipeline. The TrainingPipeline's
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make clear whether this Model
     * description should be populated, and if there are any special requirements
     * regarding how it should be filled. If nothing is mentioned in the
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that this field
     * should not be filled and the training task either uploads the Model without
     * a need of this information, or that training task does not support
     * uploading a Model as part of the pipeline.
     * When the Pipeline's state becomes `PIPELINE_STATE_SUCCEEDED` and
     * the trained Model had been uploaded into Vertex AI, then the
     * model_to_upload's resource [name][google.cloud.aiplatform.v1.Model.name] is populated. The Model
     * is always uploaded into the Project and Location in which this pipeline
     * is.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Model model_to_upload = 7;</code>
     */
    public com.google.cloud.aiplatform.v1.ModelOrBuilder getModelToUploadOrBuilder() {
      if (modelToUploadBuilder_ != null) {
        return modelToUploadBuilder_.getMessageOrBuilder();
      } else {
        return modelToUpload_ == null
            ? com.google.cloud.aiplatform.v1.Model.getDefaultInstance()
            : modelToUpload_;
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the Model that may be uploaded (via [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel])
     * by this TrainingPipeline. The TrainingPipeline's
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition] should make clear whether this Model
     * description should be populated, and if there are any special requirements
     * regarding how it should be filled. If nothing is mentioned in the
     * [training_task_definition][google.cloud.aiplatform.v1.TrainingPipeline.training_task_definition], then it should be assumed that this field
     * should not be filled and the training task either uploads the Model without
     * a need of this information, or that training task does not support
     * uploading a Model as part of the pipeline.
     * When the Pipeline's state becomes `PIPELINE_STATE_SUCCEEDED` and
     * the trained Model had been uploaded into Vertex AI, then the
     * model_to_upload's resource [name][google.cloud.aiplatform.v1.Model.name] is populated. The Model
     * is always uploaded into the Project and Location in which this pipeline
     * is.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Model model_to_upload = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Model,
            com.google.cloud.aiplatform.v1.Model.Builder,
            com.google.cloud.aiplatform.v1.ModelOrBuilder>
        getModelToUploadFieldBuilder() {
      if (modelToUploadBuilder_ == null) {
        modelToUploadBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Model,
                com.google.cloud.aiplatform.v1.Model.Builder,
                com.google.cloud.aiplatform.v1.ModelOrBuilder>(
                getModelToUpload(), getParentForChildren(), isClean());
        modelToUpload_ = null;
      }
      return modelToUploadBuilder_;
    }

    private java.lang.Object modelId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The ID to use for the uploaded Model, which will become the final
     * component of the model resource name.
     * This value may be up to 63 characters, and valid characters are
     * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
     * </pre>
     *
     * <code>string model_id = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The modelId.
     */
    public java.lang.String getModelId() {
      java.lang.Object ref = modelId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID to use for the uploaded Model, which will become the final
     * component of the model resource name.
     * This value may be up to 63 characters, and valid characters are
     * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
     * </pre>
     *
     * <code>string model_id = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for modelId.
     */
    public com.google.protobuf.ByteString getModelIdBytes() {
      java.lang.Object ref = modelId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID to use for the uploaded Model, which will become the final
     * component of the model resource name.
     * This value may be up to 63 characters, and valid characters are
     * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
     * </pre>
     *
     * <code>string model_id = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The modelId to set.
     * @return This builder for chaining.
     */
    public Builder setModelId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      modelId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID to use for the uploaded Model, which will become the final
     * component of the model resource name.
     * This value may be up to 63 characters, and valid characters are
     * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
     * </pre>
     *
     * <code>string model_id = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelId() {

      modelId_ = getDefaultInstance().getModelId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID to use for the uploaded Model, which will become the final
     * component of the model resource name.
     * This value may be up to 63 characters, and valid characters are
     * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
     * </pre>
     *
     * <code>string model_id = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for modelId to set.
     * @return This builder for chaining.
     */
    public Builder setModelIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      modelId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object parentModel_ = "";
    /**
     *
     *
     * <pre>
     * Optional. When specify this field, the `model_to_upload` will not be uploaded as a
     * new model, instead, it will become a new version of this `parent_model`.
     * </pre>
     *
     * <code>string parent_model = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The parentModel.
     */
    public java.lang.String getParentModel() {
      java.lang.Object ref = parentModel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parentModel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. When specify this field, the `model_to_upload` will not be uploaded as a
     * new model, instead, it will become a new version of this `parent_model`.
     * </pre>
     *
     * <code>string parent_model = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for parentModel.
     */
    public com.google.protobuf.ByteString getParentModelBytes() {
      java.lang.Object ref = parentModel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parentModel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. When specify this field, the `model_to_upload` will not be uploaded as a
     * new model, instead, it will become a new version of this `parent_model`.
     * </pre>
     *
     * <code>string parent_model = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The parentModel to set.
     * @return This builder for chaining.
     */
    public Builder setParentModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parentModel_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When specify this field, the `model_to_upload` will not be uploaded as a
     * new model, instead, it will become a new version of this `parent_model`.
     * </pre>
     *
     * <code>string parent_model = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentModel() {

      parentModel_ = getDefaultInstance().getParentModel();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When specify this field, the `model_to_upload` will not be uploaded as a
     * new model, instead, it will become a new version of this `parent_model`.
     * </pre>
     *
     * <code>string parent_model = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for parentModel to set.
     * @return This builder for chaining.
     */
    public Builder setParentModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parentModel_ = value;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the pipeline.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineState state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the pipeline.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineState state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the pipeline.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineState state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PipelineState getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.aiplatform.v1.PipelineState result =
          com.google.cloud.aiplatform.v1.PipelineState.valueOf(state_);
      return result == null ? com.google.cloud.aiplatform.v1.PipelineState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the pipeline.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineState state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.aiplatform.v1.PipelineState value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the pipeline.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineState state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the pipeline's state is `PIPELINE_STATE_FAILED` or
     * `PIPELINE_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return errorBuilder_ != null || error_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the pipeline's state is `PIPELINE_STATE_FAILED` or
     * `PIPELINE_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the pipeline's state is `PIPELINE_STATE_FAILED` or
     * `PIPELINE_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
        onChanged();
      } else {
        errorBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the pipeline's state is `PIPELINE_STATE_FAILED` or
     * `PIPELINE_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
        onChanged();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the pipeline's state is `PIPELINE_STATE_FAILED` or
     * `PIPELINE_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (error_ != null) {
          error_ = com.google.rpc.Status.newBuilder(error_).mergeFrom(value).buildPartial();
        } else {
          error_ = value;
        }
        onChanged();
      } else {
        errorBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the pipeline's state is `PIPELINE_STATE_FAILED` or
     * `PIPELINE_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearError() {
      if (errorBuilder_ == null) {
        error_ = null;
        onChanged();
      } else {
        error_ = null;
        errorBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the pipeline's state is `PIPELINE_STATE_FAILED` or
     * `PIPELINE_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {

      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the pipeline's state is `PIPELINE_STATE_FAILED` or
     * `PIPELINE_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the pipeline's state is `PIPELINE_STATE_FAILED` or
     * `PIPELINE_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline for the first time entered the
     * `PIPELINE_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return startTimeBuilder_ != null || startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline for the first time entered the
     * `PIPELINE_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline for the first time entered the
     * `PIPELINE_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
        onChanged();
      } else {
        startTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline for the first time entered the
     * `PIPELINE_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
        onChanged();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline for the first time entered the
     * `PIPELINE_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (startTime_ != null) {
          startTime_ =
              com.google.protobuf.Timestamp.newBuilder(startTime_).mergeFrom(value).buildPartial();
        } else {
          startTime_ = value;
        }
        onChanged();
      } else {
        startTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline for the first time entered the
     * `PIPELINE_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      if (startTimeBuilder_ == null) {
        startTime_ = null;
        onChanged();
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline for the first time entered the
     * `PIPELINE_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline for the first time entered the
     * `PIPELINE_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline for the first time entered the
     * `PIPELINE_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline entered any of the following states:
     * `PIPELINE_STATE_SUCCEEDED`, `PIPELINE_STATE_FAILED`,
     * `PIPELINE_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return endTimeBuilder_ != null || endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline entered any of the following states:
     * `PIPELINE_STATE_SUCCEEDED`, `PIPELINE_STATE_FAILED`,
     * `PIPELINE_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline entered any of the following states:
     * `PIPELINE_STATE_SUCCEEDED`, `PIPELINE_STATE_FAILED`,
     * `PIPELINE_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
        onChanged();
      } else {
        endTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline entered any of the following states:
     * `PIPELINE_STATE_SUCCEEDED`, `PIPELINE_STATE_FAILED`,
     * `PIPELINE_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
        onChanged();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline entered any of the following states:
     * `PIPELINE_STATE_SUCCEEDED`, `PIPELINE_STATE_FAILED`,
     * `PIPELINE_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (endTime_ != null) {
          endTime_ =
              com.google.protobuf.Timestamp.newBuilder(endTime_).mergeFrom(value).buildPartial();
        } else {
          endTime_ = value;
        }
        onChanged();
      } else {
        endTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline entered any of the following states:
     * `PIPELINE_STATE_SUCCEEDED`, `PIPELINE_STATE_FAILED`,
     * `PIPELINE_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      if (endTimeBuilder_ == null) {
        endTime_ = null;
        onChanged();
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline entered any of the following states:
     * `PIPELINE_STATE_SUCCEEDED`, `PIPELINE_STATE_FAILED`,
     * `PIPELINE_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {

      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline entered any of the following states:
     * `PIPELINE_STATE_SUCCEEDED`, `PIPELINE_STATE_FAILED`,
     * `PIPELINE_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline entered any of the following states:
     * `PIPELINE_STATE_SUCCEEDED`, `PIPELINE_STATE_FAILED`,
     * `PIPELINE_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the TrainingPipeline was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize TrainingPipelines.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize TrainingPipelines.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize TrainingPipelines.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize TrainingPipelines.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize TrainingPipelines.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize TrainingPipelines.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize TrainingPipelines.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private com.google.cloud.aiplatform.v1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EncryptionSpec,
            com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a TrainingPipeline. If set, this
     * TrainingPipeline will be secured by this key.
     * Note: Model trained by this TrainingPipeline is also secured by this key if
     * [model_to_upload][google.cloud.aiplatform.v1.TrainingPipeline.encryption_spec] is not set separately.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 18;</code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return encryptionSpecBuilder_ != null || encryptionSpec_ != null;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a TrainingPipeline. If set, this
     * TrainingPipeline will be secured by this key.
     * Note: Model trained by this TrainingPipeline is also secured by this key if
     * [model_to_upload][google.cloud.aiplatform.v1.TrainingPipeline.encryption_spec] is not set separately.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 18;</code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a TrainingPipeline. If set, this
     * TrainingPipeline will be secured by this key.
     * Note: Model trained by this TrainingPipeline is also secured by this key if
     * [model_to_upload][google.cloud.aiplatform.v1.TrainingPipeline.encryption_spec] is not set separately.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 18;</code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
        onChanged();
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a TrainingPipeline. If set, this
     * TrainingPipeline will be secured by this key.
     * Note: Model trained by this TrainingPipeline is also secured by this key if
     * [model_to_upload][google.cloud.aiplatform.v1.TrainingPipeline.encryption_spec] is not set separately.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 18;</code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
        onChanged();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a TrainingPipeline. If set, this
     * TrainingPipeline will be secured by this key.
     * Note: Model trained by this TrainingPipeline is also secured by this key if
     * [model_to_upload][google.cloud.aiplatform.v1.TrainingPipeline.encryption_spec] is not set separately.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 18;</code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (encryptionSpec_ != null) {
          encryptionSpec_ =
              com.google.cloud.aiplatform.v1.EncryptionSpec.newBuilder(encryptionSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          encryptionSpec_ = value;
        }
        onChanged();
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a TrainingPipeline. If set, this
     * TrainingPipeline will be secured by this key.
     * Note: Model trained by this TrainingPipeline is also secured by this key if
     * [model_to_upload][google.cloud.aiplatform.v1.TrainingPipeline.encryption_spec] is not set separately.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 18;</code>
     */
    public Builder clearEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = null;
        onChanged();
      } else {
        encryptionSpec_ = null;
        encryptionSpecBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a TrainingPipeline. If set, this
     * TrainingPipeline will be secured by this key.
     * Note: Model trained by this TrainingPipeline is also secured by this key if
     * [model_to_upload][google.cloud.aiplatform.v1.TrainingPipeline.encryption_spec] is not set separately.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 18;</code>
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpec.Builder getEncryptionSpecBuilder() {

      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a TrainingPipeline. If set, this
     * TrainingPipeline will be secured by this key.
     * Note: Model trained by this TrainingPipeline is also secured by this key if
     * [model_to_upload][google.cloud.aiplatform.v1.TrainingPipeline.encryption_spec] is not set separately.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 18;</code>
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a TrainingPipeline. If set, this
     * TrainingPipeline will be secured by this key.
     * Note: Model trained by this TrainingPipeline is also secured by this key if
     * [model_to_upload][google.cloud.aiplatform.v1.TrainingPipeline.encryption_spec] is not set separately.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EncryptionSpec,
            com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.EncryptionSpec,
                com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.TrainingPipeline)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.TrainingPipeline)
  private static final com.google.cloud.aiplatform.v1.TrainingPipeline DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.TrainingPipeline();
  }

  public static com.google.cloud.aiplatform.v1.TrainingPipeline getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TrainingPipeline> PARSER =
      new com.google.protobuf.AbstractParser<TrainingPipeline>() {
        @java.lang.Override
        public TrainingPipeline parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new TrainingPipeline(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<TrainingPipeline> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TrainingPipeline> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.TrainingPipeline getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
