/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/model_evaluation.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * A collection of metrics calculated by comparing Model's predictions on all of
 * the test data against annotations from the test data.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.ModelEvaluation}
 */
public final class ModelEvaluation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ModelEvaluation)
    ModelEvaluationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ModelEvaluation.newBuilder() to construct.
  private ModelEvaluation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelEvaluation() {
    name_ = "";
    displayName_ = "";
    metricsSchemaUri_ = "";
    sliceDimensions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    dataItemSchemaUri_ = "";
    annotationSchemaUri_ = "";
    explanationSpecs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelEvaluation();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ModelEvaluation(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              metricsSchemaUri_ = s;
              break;
            }
          case 26:
            {
              com.google.protobuf.Value.Builder subBuilder = null;
              if (metrics_ != null) {
                subBuilder = metrics_.toBuilder();
              }
              metrics_ = input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(metrics_);
                metrics_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                sliceDimensions_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              sliceDimensions_.add(s);
              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              dataItemSchemaUri_ = s;
              break;
            }
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();

              annotationSchemaUri_ = s;
              break;
            }
          case 66:
            {
              com.google.cloud.aiplatform.v1.ModelExplanation.Builder subBuilder = null;
              if (modelExplanation_ != null) {
                subBuilder = modelExplanation_.toBuilder();
              }
              modelExplanation_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.ModelExplanation.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(modelExplanation_);
                modelExplanation_ = subBuilder.buildPartial();
              }

              break;
            }
          case 74:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                explanationSpecs_ =
                    new java.util.ArrayList<
                        com.google.cloud.aiplatform.v1.ModelEvaluation
                            .ModelEvaluationExplanationSpec>();
                mutable_bitField0_ |= 0x00000002;
              }
              explanationSpecs_.add(
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
                          .parser(),
                      extensionRegistry));
              break;
            }
          case 82:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 90:
            {
              com.google.protobuf.Value.Builder subBuilder = null;
              if (metadata_ != null) {
                subBuilder = metadata_.toBuilder();
              }
              metadata_ = input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(metadata_);
                metadata_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        sliceDimensions_ = sliceDimensions_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        explanationSpecs_ = java.util.Collections.unmodifiableList(explanationSpecs_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ModelEvaluationProto
        .internal_static_google_cloud_aiplatform_v1_ModelEvaluation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ModelEvaluationProto
        .internal_static_google_cloud_aiplatform_v1_ModelEvaluation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.ModelEvaluation.class,
            com.google.cloud.aiplatform.v1.ModelEvaluation.Builder.class);
  }

  public interface ModelEvaluationExplanationSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Explanation type.
     * For AutoML Image Classification models, possible values are:
     *   * `image-integrated-gradients`
     *   * `image-xrai`
     * </pre>
     *
     * <code>string explanation_type = 1;</code>
     *
     * @return The explanationType.
     */
    java.lang.String getExplanationType();
    /**
     *
     *
     * <pre>
     * Explanation type.
     * For AutoML Image Classification models, possible values are:
     *   * `image-integrated-gradients`
     *   * `image-xrai`
     * </pre>
     *
     * <code>string explanation_type = 1;</code>
     *
     * @return The bytes for explanationType.
     */
    com.google.protobuf.ByteString getExplanationTypeBytes();

    /**
     *
     *
     * <pre>
     * Explanation spec details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 2;</code>
     *
     * @return Whether the explanationSpec field is set.
     */
    boolean hasExplanationSpec();
    /**
     *
     *
     * <pre>
     * Explanation spec details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 2;</code>
     *
     * @return The explanationSpec.
     */
    com.google.cloud.aiplatform.v1.ExplanationSpec getExplanationSpec();
    /**
     *
     *
     * <pre>
     * Explanation spec details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 2;</code>
     */
    com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder getExplanationSpecOrBuilder();
  }
  /**
   * Protobuf type {@code google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec}
   */
  public static final class ModelEvaluationExplanationSpec
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec)
      ModelEvaluationExplanationSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ModelEvaluationExplanationSpec.newBuilder() to construct.
    private ModelEvaluationExplanationSpec(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ModelEvaluationExplanationSpec() {
      explanationType_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ModelEvaluationExplanationSpec();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ModelEvaluationExplanationSpec(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                explanationType_ = s;
                break;
              }
            case 18:
              {
                com.google.cloud.aiplatform.v1.ExplanationSpec.Builder subBuilder = null;
                if (explanationSpec_ != null) {
                  subBuilder = explanationSpec_.toBuilder();
                }
                explanationSpec_ =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.ExplanationSpec.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(explanationSpec_);
                  explanationSpec_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ModelEvaluationProto
          .internal_static_google_cloud_aiplatform_v1_ModelEvaluation_ModelEvaluationExplanationSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ModelEvaluationProto
          .internal_static_google_cloud_aiplatform_v1_ModelEvaluation_ModelEvaluationExplanationSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec.class,
              com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec.Builder
                  .class);
    }

    public static final int EXPLANATION_TYPE_FIELD_NUMBER = 1;
    private volatile java.lang.Object explanationType_;
    /**
     *
     *
     * <pre>
     * Explanation type.
     * For AutoML Image Classification models, possible values are:
     *   * `image-integrated-gradients`
     *   * `image-xrai`
     * </pre>
     *
     * <code>string explanation_type = 1;</code>
     *
     * @return The explanationType.
     */
    @java.lang.Override
    public java.lang.String getExplanationType() {
      java.lang.Object ref = explanationType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        explanationType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Explanation type.
     * For AutoML Image Classification models, possible values are:
     *   * `image-integrated-gradients`
     *   * `image-xrai`
     * </pre>
     *
     * <code>string explanation_type = 1;</code>
     *
     * @return The bytes for explanationType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getExplanationTypeBytes() {
      java.lang.Object ref = explanationType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        explanationType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int EXPLANATION_SPEC_FIELD_NUMBER = 2;
    private com.google.cloud.aiplatform.v1.ExplanationSpec explanationSpec_;
    /**
     *
     *
     * <pre>
     * Explanation spec details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 2;</code>
     *
     * @return Whether the explanationSpec field is set.
     */
    @java.lang.Override
    public boolean hasExplanationSpec() {
      return explanationSpec_ != null;
    }
    /**
     *
     *
     * <pre>
     * Explanation spec details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 2;</code>
     *
     * @return The explanationSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExplanationSpec getExplanationSpec() {
      return explanationSpec_ == null
          ? com.google.cloud.aiplatform.v1.ExplanationSpec.getDefaultInstance()
          : explanationSpec_;
    }
    /**
     *
     *
     * <pre>
     * Explanation spec details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder getExplanationSpecOrBuilder() {
      return getExplanationSpec();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(explanationType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, explanationType_);
      }
      if (explanationSpec_ != null) {
        output.writeMessage(2, getExplanationSpec());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(explanationType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, explanationType_);
      }
      if (explanationSpec_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getExplanationSpec());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec other =
          (com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec) obj;

      if (!getExplanationType().equals(other.getExplanationType())) return false;
      if (hasExplanationSpec() != other.hasExplanationSpec()) return false;
      if (hasExplanationSpec()) {
        if (!getExplanationSpec().equals(other.getExplanationSpec())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + EXPLANATION_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getExplanationType().hashCode();
      if (hasExplanationSpec()) {
        hash = (37 * hash) + EXPLANATION_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getExplanationSpec().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec)
        com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ModelEvaluationProto
            .internal_static_google_cloud_aiplatform_v1_ModelEvaluation_ModelEvaluationExplanationSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ModelEvaluationProto
            .internal_static_google_cloud_aiplatform_v1_ModelEvaluation_ModelEvaluationExplanationSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec.class,
                com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        explanationType_ = "";

        if (explanationSpecBuilder_ == null) {
          explanationSpec_ = null;
        } else {
          explanationSpec_ = null;
          explanationSpecBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ModelEvaluationProto
            .internal_static_google_cloud_aiplatform_v1_ModelEvaluation_ModelEvaluationExplanationSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec build() {
        com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
          buildPartial() {
        com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec result =
            new com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec(this);
        result.explanationType_ = explanationType_;
        if (explanationSpecBuilder_ == null) {
          result.explanationSpec_ = explanationSpec_;
        } else {
          result.explanationSpec_ = explanationSpecBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec other) {
        if (other
            == com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
                .getDefaultInstance()) return this;
        if (!other.getExplanationType().isEmpty()) {
          explanationType_ = other.explanationType_;
          onChanged();
        }
        if (other.hasExplanationSpec()) {
          mergeExplanationSpec(other.getExplanationSpec());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object explanationType_ = "";
      /**
       *
       *
       * <pre>
       * Explanation type.
       * For AutoML Image Classification models, possible values are:
       *   * `image-integrated-gradients`
       *   * `image-xrai`
       * </pre>
       *
       * <code>string explanation_type = 1;</code>
       *
       * @return The explanationType.
       */
      public java.lang.String getExplanationType() {
        java.lang.Object ref = explanationType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          explanationType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Explanation type.
       * For AutoML Image Classification models, possible values are:
       *   * `image-integrated-gradients`
       *   * `image-xrai`
       * </pre>
       *
       * <code>string explanation_type = 1;</code>
       *
       * @return The bytes for explanationType.
       */
      public com.google.protobuf.ByteString getExplanationTypeBytes() {
        java.lang.Object ref = explanationType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          explanationType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Explanation type.
       * For AutoML Image Classification models, possible values are:
       *   * `image-integrated-gradients`
       *   * `image-xrai`
       * </pre>
       *
       * <code>string explanation_type = 1;</code>
       *
       * @param value The explanationType to set.
       * @return This builder for chaining.
       */
      public Builder setExplanationType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        explanationType_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Explanation type.
       * For AutoML Image Classification models, possible values are:
       *   * `image-integrated-gradients`
       *   * `image-xrai`
       * </pre>
       *
       * <code>string explanation_type = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExplanationType() {

        explanationType_ = getDefaultInstance().getExplanationType();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Explanation type.
       * For AutoML Image Classification models, possible values are:
       *   * `image-integrated-gradients`
       *   * `image-xrai`
       * </pre>
       *
       * <code>string explanation_type = 1;</code>
       *
       * @param value The bytes for explanationType to set.
       * @return This builder for chaining.
       */
      public Builder setExplanationTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        explanationType_ = value;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1.ExplanationSpec explanationSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.ExplanationSpec,
              com.google.cloud.aiplatform.v1.ExplanationSpec.Builder,
              com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder>
          explanationSpecBuilder_;
      /**
       *
       *
       * <pre>
       * Explanation spec details.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 2;</code>
       *
       * @return Whether the explanationSpec field is set.
       */
      public boolean hasExplanationSpec() {
        return explanationSpecBuilder_ != null || explanationSpec_ != null;
      }
      /**
       *
       *
       * <pre>
       * Explanation spec details.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 2;</code>
       *
       * @return The explanationSpec.
       */
      public com.google.cloud.aiplatform.v1.ExplanationSpec getExplanationSpec() {
        if (explanationSpecBuilder_ == null) {
          return explanationSpec_ == null
              ? com.google.cloud.aiplatform.v1.ExplanationSpec.getDefaultInstance()
              : explanationSpec_;
        } else {
          return explanationSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Explanation spec details.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 2;</code>
       */
      public Builder setExplanationSpec(com.google.cloud.aiplatform.v1.ExplanationSpec value) {
        if (explanationSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          explanationSpec_ = value;
          onChanged();
        } else {
          explanationSpecBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Explanation spec details.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 2;</code>
       */
      public Builder setExplanationSpec(
          com.google.cloud.aiplatform.v1.ExplanationSpec.Builder builderForValue) {
        if (explanationSpecBuilder_ == null) {
          explanationSpec_ = builderForValue.build();
          onChanged();
        } else {
          explanationSpecBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Explanation spec details.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 2;</code>
       */
      public Builder mergeExplanationSpec(com.google.cloud.aiplatform.v1.ExplanationSpec value) {
        if (explanationSpecBuilder_ == null) {
          if (explanationSpec_ != null) {
            explanationSpec_ =
                com.google.cloud.aiplatform.v1.ExplanationSpec.newBuilder(explanationSpec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            explanationSpec_ = value;
          }
          onChanged();
        } else {
          explanationSpecBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Explanation spec details.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 2;</code>
       */
      public Builder clearExplanationSpec() {
        if (explanationSpecBuilder_ == null) {
          explanationSpec_ = null;
          onChanged();
        } else {
          explanationSpec_ = null;
          explanationSpecBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Explanation spec details.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 2;</code>
       */
      public com.google.cloud.aiplatform.v1.ExplanationSpec.Builder getExplanationSpecBuilder() {

        onChanged();
        return getExplanationSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Explanation spec details.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 2;</code>
       */
      public com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder getExplanationSpecOrBuilder() {
        if (explanationSpecBuilder_ != null) {
          return explanationSpecBuilder_.getMessageOrBuilder();
        } else {
          return explanationSpec_ == null
              ? com.google.cloud.aiplatform.v1.ExplanationSpec.getDefaultInstance()
              : explanationSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Explanation spec details.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.ExplanationSpec,
              com.google.cloud.aiplatform.v1.ExplanationSpec.Builder,
              com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder>
          getExplanationSpecFieldBuilder() {
        if (explanationSpecBuilder_ == null) {
          explanationSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.ExplanationSpec,
                  com.google.cloud.aiplatform.v1.ExplanationSpec.Builder,
                  com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder>(
                  getExplanationSpec(), getParentForChildren(), isClean());
          explanationSpec_ = null;
        }
        return explanationSpecBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec)
    private static final com.google.cloud.aiplatform.v1.ModelEvaluation
            .ModelEvaluationExplanationSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec();
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ModelEvaluationExplanationSpec> PARSER =
        new com.google.protobuf.AbstractParser<ModelEvaluationExplanationSpec>() {
          @java.lang.Override
          public ModelEvaluationExplanationSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ModelEvaluationExplanationSpec(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ModelEvaluationExplanationSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ModelEvaluationExplanationSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the ModelEvaluation.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the ModelEvaluation.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 10;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * The display name of the ModelEvaluation.
   * </pre>
   *
   * <code>string display_name = 10;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the ModelEvaluation.
   * </pre>
   *
   * <code>string display_name = 10;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METRICS_SCHEMA_URI_FIELD_NUMBER = 2;
  private volatile java.lang.Object metricsSchemaUri_;
  /**
   *
   *
   * <pre>
   * Points to a YAML file stored on Google Cloud Storage describing the
   * [metrics][google.cloud.aiplatform.v1.ModelEvaluation.metrics] of this ModelEvaluation. The schema is
   * defined as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * </pre>
   *
   * <code>string metrics_schema_uri = 2;</code>
   *
   * @return The metricsSchemaUri.
   */
  @java.lang.Override
  public java.lang.String getMetricsSchemaUri() {
    java.lang.Object ref = metricsSchemaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metricsSchemaUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Points to a YAML file stored on Google Cloud Storage describing the
   * [metrics][google.cloud.aiplatform.v1.ModelEvaluation.metrics] of this ModelEvaluation. The schema is
   * defined as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * </pre>
   *
   * <code>string metrics_schema_uri = 2;</code>
   *
   * @return The bytes for metricsSchemaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetricsSchemaUriBytes() {
    java.lang.Object ref = metricsSchemaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metricsSchemaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METRICS_FIELD_NUMBER = 3;
  private com.google.protobuf.Value metrics_;
  /**
   *
   *
   * <pre>
   * Evaluation metrics of the Model. The schema of the metrics is stored in
   * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.metrics_schema_uri]
   * </pre>
   *
   * <code>.google.protobuf.Value metrics = 3;</code>
   *
   * @return Whether the metrics field is set.
   */
  @java.lang.Override
  public boolean hasMetrics() {
    return metrics_ != null;
  }
  /**
   *
   *
   * <pre>
   * Evaluation metrics of the Model. The schema of the metrics is stored in
   * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.metrics_schema_uri]
   * </pre>
   *
   * <code>.google.protobuf.Value metrics = 3;</code>
   *
   * @return The metrics.
   */
  @java.lang.Override
  public com.google.protobuf.Value getMetrics() {
    return metrics_ == null ? com.google.protobuf.Value.getDefaultInstance() : metrics_;
  }
  /**
   *
   *
   * <pre>
   * Evaluation metrics of the Model. The schema of the metrics is stored in
   * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.metrics_schema_uri]
   * </pre>
   *
   * <code>.google.protobuf.Value metrics = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getMetricsOrBuilder() {
    return getMetrics();
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelEvaluation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelEvaluation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelEvaluation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int SLICE_DIMENSIONS_FIELD_NUMBER = 5;
  private com.google.protobuf.LazyStringList sliceDimensions_;
  /**
   *
   *
   * <pre>
   * All possible [dimensions][ModelEvaluationSlice.slice.dimension] of
   * ModelEvaluationSlices. The dimensions can be used as the filter of the
   * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1.ModelService.ListModelEvaluationSlices] request, in the form of
   * `slice.dimension = &lt;dimension&gt;`.
   * </pre>
   *
   * <code>repeated string slice_dimensions = 5;</code>
   *
   * @return A list containing the sliceDimensions.
   */
  public com.google.protobuf.ProtocolStringList getSliceDimensionsList() {
    return sliceDimensions_;
  }
  /**
   *
   *
   * <pre>
   * All possible [dimensions][ModelEvaluationSlice.slice.dimension] of
   * ModelEvaluationSlices. The dimensions can be used as the filter of the
   * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1.ModelService.ListModelEvaluationSlices] request, in the form of
   * `slice.dimension = &lt;dimension&gt;`.
   * </pre>
   *
   * <code>repeated string slice_dimensions = 5;</code>
   *
   * @return The count of sliceDimensions.
   */
  public int getSliceDimensionsCount() {
    return sliceDimensions_.size();
  }
  /**
   *
   *
   * <pre>
   * All possible [dimensions][ModelEvaluationSlice.slice.dimension] of
   * ModelEvaluationSlices. The dimensions can be used as the filter of the
   * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1.ModelService.ListModelEvaluationSlices] request, in the form of
   * `slice.dimension = &lt;dimension&gt;`.
   * </pre>
   *
   * <code>repeated string slice_dimensions = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The sliceDimensions at the given index.
   */
  public java.lang.String getSliceDimensions(int index) {
    return sliceDimensions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * All possible [dimensions][ModelEvaluationSlice.slice.dimension] of
   * ModelEvaluationSlices. The dimensions can be used as the filter of the
   * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1.ModelService.ListModelEvaluationSlices] request, in the form of
   * `slice.dimension = &lt;dimension&gt;`.
   * </pre>
   *
   * <code>repeated string slice_dimensions = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sliceDimensions at the given index.
   */
  public com.google.protobuf.ByteString getSliceDimensionsBytes(int index) {
    return sliceDimensions_.getByteString(index);
  }

  public static final int DATA_ITEM_SCHEMA_URI_FIELD_NUMBER = 6;
  private volatile java.lang.Object dataItemSchemaUri_;
  /**
   *
   *
   * <pre>
   * Points to a YAML file stored on Google Cloud Storage describing
   * [EvaluatedDataItemView.data_item_payload][] and
   * [EvaluatedAnnotation.data_item_payload][]. The schema is defined as an
   * OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * This field is not populated if there are neither EvaluatedDataItemViews nor
   * EvaluatedAnnotations under this ModelEvaluation.
   * </pre>
   *
   * <code>string data_item_schema_uri = 6;</code>
   *
   * @return The dataItemSchemaUri.
   */
  @java.lang.Override
  public java.lang.String getDataItemSchemaUri() {
    java.lang.Object ref = dataItemSchemaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataItemSchemaUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Points to a YAML file stored on Google Cloud Storage describing
   * [EvaluatedDataItemView.data_item_payload][] and
   * [EvaluatedAnnotation.data_item_payload][]. The schema is defined as an
   * OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * This field is not populated if there are neither EvaluatedDataItemViews nor
   * EvaluatedAnnotations under this ModelEvaluation.
   * </pre>
   *
   * <code>string data_item_schema_uri = 6;</code>
   *
   * @return The bytes for dataItemSchemaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDataItemSchemaUriBytes() {
    java.lang.Object ref = dataItemSchemaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataItemSchemaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATION_SCHEMA_URI_FIELD_NUMBER = 7;
  private volatile java.lang.Object annotationSchemaUri_;
  /**
   *
   *
   * <pre>
   * Points to a YAML file stored on Google Cloud Storage describing
   * [EvaluatedDataItemView.predictions][],
   * [EvaluatedDataItemView.ground_truths][],
   * [EvaluatedAnnotation.predictions][], and
   * [EvaluatedAnnotation.ground_truths][]. The schema is defined as an
   * OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * This field is not populated if there are neither EvaluatedDataItemViews nor
   * EvaluatedAnnotations under this ModelEvaluation.
   * </pre>
   *
   * <code>string annotation_schema_uri = 7;</code>
   *
   * @return The annotationSchemaUri.
   */
  @java.lang.Override
  public java.lang.String getAnnotationSchemaUri() {
    java.lang.Object ref = annotationSchemaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      annotationSchemaUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Points to a YAML file stored on Google Cloud Storage describing
   * [EvaluatedDataItemView.predictions][],
   * [EvaluatedDataItemView.ground_truths][],
   * [EvaluatedAnnotation.predictions][], and
   * [EvaluatedAnnotation.ground_truths][]. The schema is defined as an
   * OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * This field is not populated if there are neither EvaluatedDataItemViews nor
   * EvaluatedAnnotations under this ModelEvaluation.
   * </pre>
   *
   * <code>string annotation_schema_uri = 7;</code>
   *
   * @return The bytes for annotationSchemaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnnotationSchemaUriBytes() {
    java.lang.Object ref = annotationSchemaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      annotationSchemaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_EXPLANATION_FIELD_NUMBER = 8;
  private com.google.cloud.aiplatform.v1.ModelExplanation modelExplanation_;
  /**
   *
   *
   * <pre>
   * Aggregated explanation metrics for the Model's prediction output over the
   * data this ModelEvaluation uses. This field is populated only if the Model
   * is evaluated with explanations, and only for AutoML tabular Models.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ModelExplanation model_explanation = 8;</code>
   *
   * @return Whether the modelExplanation field is set.
   */
  @java.lang.Override
  public boolean hasModelExplanation() {
    return modelExplanation_ != null;
  }
  /**
   *
   *
   * <pre>
   * Aggregated explanation metrics for the Model's prediction output over the
   * data this ModelEvaluation uses. This field is populated only if the Model
   * is evaluated with explanations, and only for AutoML tabular Models.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ModelExplanation model_explanation = 8;</code>
   *
   * @return The modelExplanation.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModelExplanation getModelExplanation() {
    return modelExplanation_ == null
        ? com.google.cloud.aiplatform.v1.ModelExplanation.getDefaultInstance()
        : modelExplanation_;
  }
  /**
   *
   *
   * <pre>
   * Aggregated explanation metrics for the Model's prediction output over the
   * data this ModelEvaluation uses. This field is populated only if the Model
   * is evaluated with explanations, and only for AutoML tabular Models.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ModelExplanation model_explanation = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModelExplanationOrBuilder getModelExplanationOrBuilder() {
    return getModelExplanation();
  }

  public static final int EXPLANATION_SPECS_FIELD_NUMBER = 9;
  private java.util.List<
          com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec>
      explanationSpecs_;
  /**
   *
   *
   * <pre>
   * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
   * the predicted values on the evaluated data.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec>
      getExplanationSpecsList() {
    return explanationSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
   * the predicted values on the evaluated data.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1.ModelEvaluation
                  .ModelEvaluationExplanationSpecOrBuilder>
      getExplanationSpecsOrBuilderList() {
    return explanationSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
   * the predicted values on the evaluated data.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
   * </code>
   */
  @java.lang.Override
  public int getExplanationSpecsCount() {
    return explanationSpecs_.size();
  }
  /**
   *
   *
   * <pre>
   * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
   * the predicted values on the evaluated data.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
      getExplanationSpecs(int index) {
    return explanationSpecs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
   * the predicted values on the evaluated data.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpecOrBuilder
      getExplanationSpecsOrBuilder(int index) {
    return explanationSpecs_.get(index);
  }

  public static final int METADATA_FIELD_NUMBER = 11;
  private com.google.protobuf.Value metadata_;
  /**
   *
   *
   * <pre>
   * The metadata of the ModelEvaluation.
   * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
   * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
   * "evaluation_dataset_path".
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 11;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return metadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * The metadata of the ModelEvaluation.
   * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
   * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
   * "evaluation_dataset_path".
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 11;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.protobuf.Value getMetadata() {
    return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
  }
  /**
   *
   *
   * <pre>
   * The metadata of the ModelEvaluation.
   * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
   * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
   * "evaluation_dataset_path".
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 11;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getMetadataOrBuilder() {
    return getMetadata();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricsSchemaUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, metricsSchemaUri_);
    }
    if (metrics_ != null) {
      output.writeMessage(3, getMetrics());
    }
    if (createTime_ != null) {
      output.writeMessage(4, getCreateTime());
    }
    for (int i = 0; i < sliceDimensions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, sliceDimensions_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataItemSchemaUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, dataItemSchemaUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotationSchemaUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, annotationSchemaUri_);
    }
    if (modelExplanation_ != null) {
      output.writeMessage(8, getModelExplanation());
    }
    for (int i = 0; i < explanationSpecs_.size(); i++) {
      output.writeMessage(9, explanationSpecs_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, displayName_);
    }
    if (metadata_ != null) {
      output.writeMessage(11, getMetadata());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricsSchemaUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, metricsSchemaUri_);
    }
    if (metrics_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMetrics());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sliceDimensions_.size(); i++) {
        dataSize += computeStringSizeNoTag(sliceDimensions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSliceDimensionsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataItemSchemaUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, dataItemSchemaUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotationSchemaUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, annotationSchemaUri_);
    }
    if (modelExplanation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getModelExplanation());
    }
    for (int i = 0; i < explanationSpecs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, explanationSpecs_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, displayName_);
    }
    if (metadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getMetadata());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.ModelEvaluation)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.ModelEvaluation other =
        (com.google.cloud.aiplatform.v1.ModelEvaluation) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getMetricsSchemaUri().equals(other.getMetricsSchemaUri())) return false;
    if (hasMetrics() != other.hasMetrics()) return false;
    if (hasMetrics()) {
      if (!getMetrics().equals(other.getMetrics())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getSliceDimensionsList().equals(other.getSliceDimensionsList())) return false;
    if (!getDataItemSchemaUri().equals(other.getDataItemSchemaUri())) return false;
    if (!getAnnotationSchemaUri().equals(other.getAnnotationSchemaUri())) return false;
    if (hasModelExplanation() != other.hasModelExplanation()) return false;
    if (hasModelExplanation()) {
      if (!getModelExplanation().equals(other.getModelExplanation())) return false;
    }
    if (!getExplanationSpecsList().equals(other.getExplanationSpecsList())) return false;
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + METRICS_SCHEMA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getMetricsSchemaUri().hashCode();
    if (hasMetrics()) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetrics().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (getSliceDimensionsCount() > 0) {
      hash = (37 * hash) + SLICE_DIMENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getSliceDimensionsList().hashCode();
    }
    hash = (37 * hash) + DATA_ITEM_SCHEMA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getDataItemSchemaUri().hashCode();
    hash = (37 * hash) + ANNOTATION_SCHEMA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getAnnotationSchemaUri().hashCode();
    if (hasModelExplanation()) {
      hash = (37 * hash) + MODEL_EXPLANATION_FIELD_NUMBER;
      hash = (53 * hash) + getModelExplanation().hashCode();
    }
    if (getExplanationSpecsCount() > 0) {
      hash = (37 * hash) + EXPLANATION_SPECS_FIELD_NUMBER;
      hash = (53 * hash) + getExplanationSpecsList().hashCode();
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.ModelEvaluation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A collection of metrics calculated by comparing Model's predictions on all of
   * the test data against annotations from the test data.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ModelEvaluation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ModelEvaluation)
      com.google.cloud.aiplatform.v1.ModelEvaluationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ModelEvaluationProto
          .internal_static_google_cloud_aiplatform_v1_ModelEvaluation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ModelEvaluationProto
          .internal_static_google_cloud_aiplatform_v1_ModelEvaluation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ModelEvaluation.class,
              com.google.cloud.aiplatform.v1.ModelEvaluation.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.ModelEvaluation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getExplanationSpecsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      metricsSchemaUri_ = "";

      if (metricsBuilder_ == null) {
        metrics_ = null;
      } else {
        metrics_ = null;
        metricsBuilder_ = null;
      }
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      sliceDimensions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      dataItemSchemaUri_ = "";

      annotationSchemaUri_ = "";

      if (modelExplanationBuilder_ == null) {
        modelExplanation_ = null;
      } else {
        modelExplanation_ = null;
        modelExplanationBuilder_ = null;
      }
      if (explanationSpecsBuilder_ == null) {
        explanationSpecs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        explanationSpecsBuilder_.clear();
      }
      if (metadataBuilder_ == null) {
        metadata_ = null;
      } else {
        metadata_ = null;
        metadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ModelEvaluationProto
          .internal_static_google_cloud_aiplatform_v1_ModelEvaluation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ModelEvaluation getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.ModelEvaluation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ModelEvaluation build() {
      com.google.cloud.aiplatform.v1.ModelEvaluation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ModelEvaluation buildPartial() {
      com.google.cloud.aiplatform.v1.ModelEvaluation result =
          new com.google.cloud.aiplatform.v1.ModelEvaluation(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.displayName_ = displayName_;
      result.metricsSchemaUri_ = metricsSchemaUri_;
      if (metricsBuilder_ == null) {
        result.metrics_ = metrics_;
      } else {
        result.metrics_ = metricsBuilder_.build();
      }
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        sliceDimensions_ = sliceDimensions_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.sliceDimensions_ = sliceDimensions_;
      result.dataItemSchemaUri_ = dataItemSchemaUri_;
      result.annotationSchemaUri_ = annotationSchemaUri_;
      if (modelExplanationBuilder_ == null) {
        result.modelExplanation_ = modelExplanation_;
      } else {
        result.modelExplanation_ = modelExplanationBuilder_.build();
      }
      if (explanationSpecsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          explanationSpecs_ = java.util.Collections.unmodifiableList(explanationSpecs_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.explanationSpecs_ = explanationSpecs_;
      } else {
        result.explanationSpecs_ = explanationSpecsBuilder_.build();
      }
      if (metadataBuilder_ == null) {
        result.metadata_ = metadata_;
      } else {
        result.metadata_ = metadataBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.ModelEvaluation) {
        return mergeFrom((com.google.cloud.aiplatform.v1.ModelEvaluation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.ModelEvaluation other) {
      if (other == com.google.cloud.aiplatform.v1.ModelEvaluation.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (!other.getMetricsSchemaUri().isEmpty()) {
        metricsSchemaUri_ = other.metricsSchemaUri_;
        onChanged();
      }
      if (other.hasMetrics()) {
        mergeMetrics(other.getMetrics());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (!other.sliceDimensions_.isEmpty()) {
        if (sliceDimensions_.isEmpty()) {
          sliceDimensions_ = other.sliceDimensions_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureSliceDimensionsIsMutable();
          sliceDimensions_.addAll(other.sliceDimensions_);
        }
        onChanged();
      }
      if (!other.getDataItemSchemaUri().isEmpty()) {
        dataItemSchemaUri_ = other.dataItemSchemaUri_;
        onChanged();
      }
      if (!other.getAnnotationSchemaUri().isEmpty()) {
        annotationSchemaUri_ = other.annotationSchemaUri_;
        onChanged();
      }
      if (other.hasModelExplanation()) {
        mergeModelExplanation(other.getModelExplanation());
      }
      if (explanationSpecsBuilder_ == null) {
        if (!other.explanationSpecs_.isEmpty()) {
          if (explanationSpecs_.isEmpty()) {
            explanationSpecs_ = other.explanationSpecs_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureExplanationSpecsIsMutable();
            explanationSpecs_.addAll(other.explanationSpecs_);
          }
          onChanged();
        }
      } else {
        if (!other.explanationSpecs_.isEmpty()) {
          if (explanationSpecsBuilder_.isEmpty()) {
            explanationSpecsBuilder_.dispose();
            explanationSpecsBuilder_ = null;
            explanationSpecs_ = other.explanationSpecs_;
            bitField0_ = (bitField0_ & ~0x00000002);
            explanationSpecsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getExplanationSpecsFieldBuilder()
                    : null;
          } else {
            explanationSpecsBuilder_.addAllMessages(other.explanationSpecs_);
          }
        }
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1.ModelEvaluation parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.aiplatform.v1.ModelEvaluation) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the ModelEvaluation.
     * </pre>
     *
     * <code>string display_name = 10;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the ModelEvaluation.
     * </pre>
     *
     * <code>string display_name = 10;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the ModelEvaluation.
     * </pre>
     *
     * <code>string display_name = 10;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the ModelEvaluation.
     * </pre>
     *
     * <code>string display_name = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the ModelEvaluation.
     * </pre>
     *
     * <code>string display_name = 10;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object metricsSchemaUri_ = "";
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing the
     * [metrics][google.cloud.aiplatform.v1.ModelEvaluation.metrics] of this ModelEvaluation. The schema is
     * defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 2;</code>
     *
     * @return The metricsSchemaUri.
     */
    public java.lang.String getMetricsSchemaUri() {
      java.lang.Object ref = metricsSchemaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metricsSchemaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing the
     * [metrics][google.cloud.aiplatform.v1.ModelEvaluation.metrics] of this ModelEvaluation. The schema is
     * defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 2;</code>
     *
     * @return The bytes for metricsSchemaUri.
     */
    public com.google.protobuf.ByteString getMetricsSchemaUriBytes() {
      java.lang.Object ref = metricsSchemaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metricsSchemaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing the
     * [metrics][google.cloud.aiplatform.v1.ModelEvaluation.metrics] of this ModelEvaluation. The schema is
     * defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 2;</code>
     *
     * @param value The metricsSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setMetricsSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      metricsSchemaUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing the
     * [metrics][google.cloud.aiplatform.v1.ModelEvaluation.metrics] of this ModelEvaluation. The schema is
     * defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetricsSchemaUri() {

      metricsSchemaUri_ = getDefaultInstance().getMetricsSchemaUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing the
     * [metrics][google.cloud.aiplatform.v1.ModelEvaluation.metrics] of this ModelEvaluation. The schema is
     * defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 2;</code>
     *
     * @param value The bytes for metricsSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setMetricsSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      metricsSchemaUri_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Value metrics_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        metricsBuilder_;
    /**
     *
     *
     * <pre>
     * Evaluation metrics of the Model. The schema of the metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 3;</code>
     *
     * @return Whether the metrics field is set.
     */
    public boolean hasMetrics() {
      return metricsBuilder_ != null || metrics_ != null;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics of the Model. The schema of the metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 3;</code>
     *
     * @return The metrics.
     */
    public com.google.protobuf.Value getMetrics() {
      if (metricsBuilder_ == null) {
        return metrics_ == null ? com.google.protobuf.Value.getDefaultInstance() : metrics_;
      } else {
        return metricsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics of the Model. The schema of the metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 3;</code>
     */
    public Builder setMetrics(com.google.protobuf.Value value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metrics_ = value;
        onChanged();
      } else {
        metricsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics of the Model. The schema of the metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 3;</code>
     */
    public Builder setMetrics(com.google.protobuf.Value.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        metrics_ = builderForValue.build();
        onChanged();
      } else {
        metricsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics of the Model. The schema of the metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 3;</code>
     */
    public Builder mergeMetrics(com.google.protobuf.Value value) {
      if (metricsBuilder_ == null) {
        if (metrics_ != null) {
          metrics_ = com.google.protobuf.Value.newBuilder(metrics_).mergeFrom(value).buildPartial();
        } else {
          metrics_ = value;
        }
        onChanged();
      } else {
        metricsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics of the Model. The schema of the metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 3;</code>
     */
    public Builder clearMetrics() {
      if (metricsBuilder_ == null) {
        metrics_ = null;
        onChanged();
      } else {
        metrics_ = null;
        metricsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics of the Model. The schema of the metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 3;</code>
     */
    public com.google.protobuf.Value.Builder getMetricsBuilder() {

      onChanged();
      return getMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics of the Model. The schema of the metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 3;</code>
     */
    public com.google.protobuf.ValueOrBuilder getMetricsOrBuilder() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilder();
      } else {
        return metrics_ == null ? com.google.protobuf.Value.getDefaultInstance() : metrics_;
      }
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics of the Model. The schema of the metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getMetrics(), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.LazyStringList sliceDimensions_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureSliceDimensionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        sliceDimensions_ = new com.google.protobuf.LazyStringArrayList(sliceDimensions_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * All possible [dimensions][ModelEvaluationSlice.slice.dimension] of
     * ModelEvaluationSlices. The dimensions can be used as the filter of the
     * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1.ModelService.ListModelEvaluationSlices] request, in the form of
     * `slice.dimension = &lt;dimension&gt;`.
     * </pre>
     *
     * <code>repeated string slice_dimensions = 5;</code>
     *
     * @return A list containing the sliceDimensions.
     */
    public com.google.protobuf.ProtocolStringList getSliceDimensionsList() {
      return sliceDimensions_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * All possible [dimensions][ModelEvaluationSlice.slice.dimension] of
     * ModelEvaluationSlices. The dimensions can be used as the filter of the
     * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1.ModelService.ListModelEvaluationSlices] request, in the form of
     * `slice.dimension = &lt;dimension&gt;`.
     * </pre>
     *
     * <code>repeated string slice_dimensions = 5;</code>
     *
     * @return The count of sliceDimensions.
     */
    public int getSliceDimensionsCount() {
      return sliceDimensions_.size();
    }
    /**
     *
     *
     * <pre>
     * All possible [dimensions][ModelEvaluationSlice.slice.dimension] of
     * ModelEvaluationSlices. The dimensions can be used as the filter of the
     * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1.ModelService.ListModelEvaluationSlices] request, in the form of
     * `slice.dimension = &lt;dimension&gt;`.
     * </pre>
     *
     * <code>repeated string slice_dimensions = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The sliceDimensions at the given index.
     */
    public java.lang.String getSliceDimensions(int index) {
      return sliceDimensions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * All possible [dimensions][ModelEvaluationSlice.slice.dimension] of
     * ModelEvaluationSlices. The dimensions can be used as the filter of the
     * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1.ModelService.ListModelEvaluationSlices] request, in the form of
     * `slice.dimension = &lt;dimension&gt;`.
     * </pre>
     *
     * <code>repeated string slice_dimensions = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the sliceDimensions at the given index.
     */
    public com.google.protobuf.ByteString getSliceDimensionsBytes(int index) {
      return sliceDimensions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * All possible [dimensions][ModelEvaluationSlice.slice.dimension] of
     * ModelEvaluationSlices. The dimensions can be used as the filter of the
     * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1.ModelService.ListModelEvaluationSlices] request, in the form of
     * `slice.dimension = &lt;dimension&gt;`.
     * </pre>
     *
     * <code>repeated string slice_dimensions = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The sliceDimensions to set.
     * @return This builder for chaining.
     */
    public Builder setSliceDimensions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSliceDimensionsIsMutable();
      sliceDimensions_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All possible [dimensions][ModelEvaluationSlice.slice.dimension] of
     * ModelEvaluationSlices. The dimensions can be used as the filter of the
     * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1.ModelService.ListModelEvaluationSlices] request, in the form of
     * `slice.dimension = &lt;dimension&gt;`.
     * </pre>
     *
     * <code>repeated string slice_dimensions = 5;</code>
     *
     * @param value The sliceDimensions to add.
     * @return This builder for chaining.
     */
    public Builder addSliceDimensions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSliceDimensionsIsMutable();
      sliceDimensions_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All possible [dimensions][ModelEvaluationSlice.slice.dimension] of
     * ModelEvaluationSlices. The dimensions can be used as the filter of the
     * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1.ModelService.ListModelEvaluationSlices] request, in the form of
     * `slice.dimension = &lt;dimension&gt;`.
     * </pre>
     *
     * <code>repeated string slice_dimensions = 5;</code>
     *
     * @param values The sliceDimensions to add.
     * @return This builder for chaining.
     */
    public Builder addAllSliceDimensions(java.lang.Iterable<java.lang.String> values) {
      ensureSliceDimensionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sliceDimensions_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All possible [dimensions][ModelEvaluationSlice.slice.dimension] of
     * ModelEvaluationSlices. The dimensions can be used as the filter of the
     * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1.ModelService.ListModelEvaluationSlices] request, in the form of
     * `slice.dimension = &lt;dimension&gt;`.
     * </pre>
     *
     * <code>repeated string slice_dimensions = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSliceDimensions() {
      sliceDimensions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All possible [dimensions][ModelEvaluationSlice.slice.dimension] of
     * ModelEvaluationSlices. The dimensions can be used as the filter of the
     * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1.ModelService.ListModelEvaluationSlices] request, in the form of
     * `slice.dimension = &lt;dimension&gt;`.
     * </pre>
     *
     * <code>repeated string slice_dimensions = 5;</code>
     *
     * @param value The bytes of the sliceDimensions to add.
     * @return This builder for chaining.
     */
    public Builder addSliceDimensionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSliceDimensionsIsMutable();
      sliceDimensions_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object dataItemSchemaUri_ = "";
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing
     * [EvaluatedDataItemView.data_item_payload][] and
     * [EvaluatedAnnotation.data_item_payload][]. The schema is defined as an
     * OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * This field is not populated if there are neither EvaluatedDataItemViews nor
     * EvaluatedAnnotations under this ModelEvaluation.
     * </pre>
     *
     * <code>string data_item_schema_uri = 6;</code>
     *
     * @return The dataItemSchemaUri.
     */
    public java.lang.String getDataItemSchemaUri() {
      java.lang.Object ref = dataItemSchemaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataItemSchemaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing
     * [EvaluatedDataItemView.data_item_payload][] and
     * [EvaluatedAnnotation.data_item_payload][]. The schema is defined as an
     * OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * This field is not populated if there are neither EvaluatedDataItemViews nor
     * EvaluatedAnnotations under this ModelEvaluation.
     * </pre>
     *
     * <code>string data_item_schema_uri = 6;</code>
     *
     * @return The bytes for dataItemSchemaUri.
     */
    public com.google.protobuf.ByteString getDataItemSchemaUriBytes() {
      java.lang.Object ref = dataItemSchemaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataItemSchemaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing
     * [EvaluatedDataItemView.data_item_payload][] and
     * [EvaluatedAnnotation.data_item_payload][]. The schema is defined as an
     * OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * This field is not populated if there are neither EvaluatedDataItemViews nor
     * EvaluatedAnnotations under this ModelEvaluation.
     * </pre>
     *
     * <code>string data_item_schema_uri = 6;</code>
     *
     * @param value The dataItemSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setDataItemSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      dataItemSchemaUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing
     * [EvaluatedDataItemView.data_item_payload][] and
     * [EvaluatedAnnotation.data_item_payload][]. The schema is defined as an
     * OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * This field is not populated if there are neither EvaluatedDataItemViews nor
     * EvaluatedAnnotations under this ModelEvaluation.
     * </pre>
     *
     * <code>string data_item_schema_uri = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataItemSchemaUri() {

      dataItemSchemaUri_ = getDefaultInstance().getDataItemSchemaUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing
     * [EvaluatedDataItemView.data_item_payload][] and
     * [EvaluatedAnnotation.data_item_payload][]. The schema is defined as an
     * OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * This field is not populated if there are neither EvaluatedDataItemViews nor
     * EvaluatedAnnotations under this ModelEvaluation.
     * </pre>
     *
     * <code>string data_item_schema_uri = 6;</code>
     *
     * @param value The bytes for dataItemSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setDataItemSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      dataItemSchemaUri_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object annotationSchemaUri_ = "";
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing
     * [EvaluatedDataItemView.predictions][],
     * [EvaluatedDataItemView.ground_truths][],
     * [EvaluatedAnnotation.predictions][], and
     * [EvaluatedAnnotation.ground_truths][]. The schema is defined as an
     * OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * This field is not populated if there are neither EvaluatedDataItemViews nor
     * EvaluatedAnnotations under this ModelEvaluation.
     * </pre>
     *
     * <code>string annotation_schema_uri = 7;</code>
     *
     * @return The annotationSchemaUri.
     */
    public java.lang.String getAnnotationSchemaUri() {
      java.lang.Object ref = annotationSchemaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        annotationSchemaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing
     * [EvaluatedDataItemView.predictions][],
     * [EvaluatedDataItemView.ground_truths][],
     * [EvaluatedAnnotation.predictions][], and
     * [EvaluatedAnnotation.ground_truths][]. The schema is defined as an
     * OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * This field is not populated if there are neither EvaluatedDataItemViews nor
     * EvaluatedAnnotations under this ModelEvaluation.
     * </pre>
     *
     * <code>string annotation_schema_uri = 7;</code>
     *
     * @return The bytes for annotationSchemaUri.
     */
    public com.google.protobuf.ByteString getAnnotationSchemaUriBytes() {
      java.lang.Object ref = annotationSchemaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        annotationSchemaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing
     * [EvaluatedDataItemView.predictions][],
     * [EvaluatedDataItemView.ground_truths][],
     * [EvaluatedAnnotation.predictions][], and
     * [EvaluatedAnnotation.ground_truths][]. The schema is defined as an
     * OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * This field is not populated if there are neither EvaluatedDataItemViews nor
     * EvaluatedAnnotations under this ModelEvaluation.
     * </pre>
     *
     * <code>string annotation_schema_uri = 7;</code>
     *
     * @param value The annotationSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      annotationSchemaUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing
     * [EvaluatedDataItemView.predictions][],
     * [EvaluatedDataItemView.ground_truths][],
     * [EvaluatedAnnotation.predictions][], and
     * [EvaluatedAnnotation.ground_truths][]. The schema is defined as an
     * OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * This field is not populated if there are neither EvaluatedDataItemViews nor
     * EvaluatedAnnotations under this ModelEvaluation.
     * </pre>
     *
     * <code>string annotation_schema_uri = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotationSchemaUri() {

      annotationSchemaUri_ = getDefaultInstance().getAnnotationSchemaUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing
     * [EvaluatedDataItemView.predictions][],
     * [EvaluatedDataItemView.ground_truths][],
     * [EvaluatedAnnotation.predictions][], and
     * [EvaluatedAnnotation.ground_truths][]. The schema is defined as an
     * OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * This field is not populated if there are neither EvaluatedDataItemViews nor
     * EvaluatedAnnotations under this ModelEvaluation.
     * </pre>
     *
     * <code>string annotation_schema_uri = 7;</code>
     *
     * @param value The bytes for annotationSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      annotationSchemaUri_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.ModelExplanation modelExplanation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModelExplanation,
            com.google.cloud.aiplatform.v1.ModelExplanation.Builder,
            com.google.cloud.aiplatform.v1.ModelExplanationOrBuilder>
        modelExplanationBuilder_;
    /**
     *
     *
     * <pre>
     * Aggregated explanation metrics for the Model's prediction output over the
     * data this ModelEvaluation uses. This field is populated only if the Model
     * is evaluated with explanations, and only for AutoML tabular Models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ModelExplanation model_explanation = 8;</code>
     *
     * @return Whether the modelExplanation field is set.
     */
    public boolean hasModelExplanation() {
      return modelExplanationBuilder_ != null || modelExplanation_ != null;
    }
    /**
     *
     *
     * <pre>
     * Aggregated explanation metrics for the Model's prediction output over the
     * data this ModelEvaluation uses. This field is populated only if the Model
     * is evaluated with explanations, and only for AutoML tabular Models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ModelExplanation model_explanation = 8;</code>
     *
     * @return The modelExplanation.
     */
    public com.google.cloud.aiplatform.v1.ModelExplanation getModelExplanation() {
      if (modelExplanationBuilder_ == null) {
        return modelExplanation_ == null
            ? com.google.cloud.aiplatform.v1.ModelExplanation.getDefaultInstance()
            : modelExplanation_;
      } else {
        return modelExplanationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Aggregated explanation metrics for the Model's prediction output over the
     * data this ModelEvaluation uses. This field is populated only if the Model
     * is evaluated with explanations, and only for AutoML tabular Models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ModelExplanation model_explanation = 8;</code>
     */
    public Builder setModelExplanation(com.google.cloud.aiplatform.v1.ModelExplanation value) {
      if (modelExplanationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelExplanation_ = value;
        onChanged();
      } else {
        modelExplanationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregated explanation metrics for the Model's prediction output over the
     * data this ModelEvaluation uses. This field is populated only if the Model
     * is evaluated with explanations, and only for AutoML tabular Models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ModelExplanation model_explanation = 8;</code>
     */
    public Builder setModelExplanation(
        com.google.cloud.aiplatform.v1.ModelExplanation.Builder builderForValue) {
      if (modelExplanationBuilder_ == null) {
        modelExplanation_ = builderForValue.build();
        onChanged();
      } else {
        modelExplanationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregated explanation metrics for the Model's prediction output over the
     * data this ModelEvaluation uses. This field is populated only if the Model
     * is evaluated with explanations, and only for AutoML tabular Models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ModelExplanation model_explanation = 8;</code>
     */
    public Builder mergeModelExplanation(com.google.cloud.aiplatform.v1.ModelExplanation value) {
      if (modelExplanationBuilder_ == null) {
        if (modelExplanation_ != null) {
          modelExplanation_ =
              com.google.cloud.aiplatform.v1.ModelExplanation.newBuilder(modelExplanation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          modelExplanation_ = value;
        }
        onChanged();
      } else {
        modelExplanationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregated explanation metrics for the Model's prediction output over the
     * data this ModelEvaluation uses. This field is populated only if the Model
     * is evaluated with explanations, and only for AutoML tabular Models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ModelExplanation model_explanation = 8;</code>
     */
    public Builder clearModelExplanation() {
      if (modelExplanationBuilder_ == null) {
        modelExplanation_ = null;
        onChanged();
      } else {
        modelExplanation_ = null;
        modelExplanationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregated explanation metrics for the Model's prediction output over the
     * data this ModelEvaluation uses. This field is populated only if the Model
     * is evaluated with explanations, and only for AutoML tabular Models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ModelExplanation model_explanation = 8;</code>
     */
    public com.google.cloud.aiplatform.v1.ModelExplanation.Builder getModelExplanationBuilder() {

      onChanged();
      return getModelExplanationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Aggregated explanation metrics for the Model's prediction output over the
     * data this ModelEvaluation uses. This field is populated only if the Model
     * is evaluated with explanations, and only for AutoML tabular Models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ModelExplanation model_explanation = 8;</code>
     */
    public com.google.cloud.aiplatform.v1.ModelExplanationOrBuilder getModelExplanationOrBuilder() {
      if (modelExplanationBuilder_ != null) {
        return modelExplanationBuilder_.getMessageOrBuilder();
      } else {
        return modelExplanation_ == null
            ? com.google.cloud.aiplatform.v1.ModelExplanation.getDefaultInstance()
            : modelExplanation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Aggregated explanation metrics for the Model's prediction output over the
     * data this ModelEvaluation uses. This field is populated only if the Model
     * is evaluated with explanations, and only for AutoML tabular Models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ModelExplanation model_explanation = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModelExplanation,
            com.google.cloud.aiplatform.v1.ModelExplanation.Builder,
            com.google.cloud.aiplatform.v1.ModelExplanationOrBuilder>
        getModelExplanationFieldBuilder() {
      if (modelExplanationBuilder_ == null) {
        modelExplanationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ModelExplanation,
                com.google.cloud.aiplatform.v1.ModelExplanation.Builder,
                com.google.cloud.aiplatform.v1.ModelExplanationOrBuilder>(
                getModelExplanation(), getParentForChildren(), isClean());
        modelExplanation_ = null;
      }
      return modelExplanationBuilder_;
    }

    private java.util.List<
            com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec>
        explanationSpecs_ = java.util.Collections.emptyList();

    private void ensureExplanationSpecsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        explanationSpecs_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec>(
                explanationSpecs_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec,
            com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec.Builder,
            com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpecOrBuilder>
        explanationSpecsBuilder_;

    /**
     *
     *
     * <pre>
     * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
     * the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec>
        getExplanationSpecsList() {
      if (explanationSpecsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(explanationSpecs_);
      } else {
        return explanationSpecsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
     * the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public int getExplanationSpecsCount() {
      if (explanationSpecsBuilder_ == null) {
        return explanationSpecs_.size();
      } else {
        return explanationSpecsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
     * the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
        getExplanationSpecs(int index) {
      if (explanationSpecsBuilder_ == null) {
        return explanationSpecs_.get(index);
      } else {
        return explanationSpecsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
     * the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public Builder setExplanationSpecs(
        int index,
        com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec value) {
      if (explanationSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExplanationSpecsIsMutable();
        explanationSpecs_.set(index, value);
        onChanged();
      } else {
        explanationSpecsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
     * the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public Builder setExplanationSpecs(
        int index,
        com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec.Builder
            builderForValue) {
      if (explanationSpecsBuilder_ == null) {
        ensureExplanationSpecsIsMutable();
        explanationSpecs_.set(index, builderForValue.build());
        onChanged();
      } else {
        explanationSpecsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
     * the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public Builder addExplanationSpecs(
        com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec value) {
      if (explanationSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExplanationSpecsIsMutable();
        explanationSpecs_.add(value);
        onChanged();
      } else {
        explanationSpecsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
     * the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public Builder addExplanationSpecs(
        int index,
        com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec value) {
      if (explanationSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExplanationSpecsIsMutable();
        explanationSpecs_.add(index, value);
        onChanged();
      } else {
        explanationSpecsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
     * the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public Builder addExplanationSpecs(
        com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec.Builder
            builderForValue) {
      if (explanationSpecsBuilder_ == null) {
        ensureExplanationSpecsIsMutable();
        explanationSpecs_.add(builderForValue.build());
        onChanged();
      } else {
        explanationSpecsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
     * the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public Builder addExplanationSpecs(
        int index,
        com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec.Builder
            builderForValue) {
      if (explanationSpecsBuilder_ == null) {
        ensureExplanationSpecsIsMutable();
        explanationSpecs_.add(index, builderForValue.build());
        onChanged();
      } else {
        explanationSpecsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
     * the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public Builder addAllExplanationSpecs(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec>
            values) {
      if (explanationSpecsBuilder_ == null) {
        ensureExplanationSpecsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, explanationSpecs_);
        onChanged();
      } else {
        explanationSpecsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
     * the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public Builder clearExplanationSpecs() {
      if (explanationSpecsBuilder_ == null) {
        explanationSpecs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        explanationSpecsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
     * the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public Builder removeExplanationSpecs(int index) {
      if (explanationSpecsBuilder_ == null) {
        ensureExplanationSpecsIsMutable();
        explanationSpecs_.remove(index);
        onChanged();
      } else {
        explanationSpecsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
     * the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec.Builder
        getExplanationSpecsBuilder(int index) {
      return getExplanationSpecsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
     * the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpecOrBuilder
        getExplanationSpecsOrBuilder(int index) {
      if (explanationSpecsBuilder_ == null) {
        return explanationSpecs_.get(index);
      } else {
        return explanationSpecsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
     * the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1.ModelEvaluation
                    .ModelEvaluationExplanationSpecOrBuilder>
        getExplanationSpecsOrBuilderList() {
      if (explanationSpecsBuilder_ != null) {
        return explanationSpecsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(explanationSpecs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
     * the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec.Builder
        addExplanationSpecsBuilder() {
      return getExplanationSpecsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
     * the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec.Builder
        addExplanationSpecsBuilder(int index) {
      return getExplanationSpecsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Describes the values of [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] that are used for explaining
     * the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec.Builder>
        getExplanationSpecsBuilderList() {
      return getExplanationSpecsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec,
            com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec.Builder,
            com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpecOrBuilder>
        getExplanationSpecsFieldBuilder() {
      if (explanationSpecsBuilder_ == null) {
        explanationSpecsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec,
                com.google.cloud.aiplatform.v1.ModelEvaluation.ModelEvaluationExplanationSpec
                    .Builder,
                com.google.cloud.aiplatform.v1.ModelEvaluation
                    .ModelEvaluationExplanationSpecOrBuilder>(
                explanationSpecs_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        explanationSpecs_ = null;
      }
      return explanationSpecsBuilder_;
    }

    private com.google.protobuf.Value metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * The metadata of the ModelEvaluation.
     * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
     * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
     * "evaluation_dataset_path".
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 11;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return metadataBuilder_ != null || metadata_ != null;
    }
    /**
     *
     *
     * <pre>
     * The metadata of the ModelEvaluation.
     * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
     * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
     * "evaluation_dataset_path".
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 11;</code>
     *
     * @return The metadata.
     */
    public com.google.protobuf.Value getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The metadata of the ModelEvaluation.
     * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
     * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
     * "evaluation_dataset_path".
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 11;</code>
     */
    public Builder setMetadata(com.google.protobuf.Value value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
        onChanged();
      } else {
        metadataBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata of the ModelEvaluation.
     * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
     * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
     * "evaluation_dataset_path".
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 11;</code>
     */
    public Builder setMetadata(com.google.protobuf.Value.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
        onChanged();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata of the ModelEvaluation.
     * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
     * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
     * "evaluation_dataset_path".
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 11;</code>
     */
    public Builder mergeMetadata(com.google.protobuf.Value value) {
      if (metadataBuilder_ == null) {
        if (metadata_ != null) {
          metadata_ =
              com.google.protobuf.Value.newBuilder(metadata_).mergeFrom(value).buildPartial();
        } else {
          metadata_ = value;
        }
        onChanged();
      } else {
        metadataBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata of the ModelEvaluation.
     * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
     * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
     * "evaluation_dataset_path".
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 11;</code>
     */
    public Builder clearMetadata() {
      if (metadataBuilder_ == null) {
        metadata_ = null;
        onChanged();
      } else {
        metadata_ = null;
        metadataBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata of the ModelEvaluation.
     * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
     * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
     * "evaluation_dataset_path".
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 11;</code>
     */
    public com.google.protobuf.Value.Builder getMetadataBuilder() {

      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The metadata of the ModelEvaluation.
     * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
     * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
     * "evaluation_dataset_path".
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 11;</code>
     */
    public com.google.protobuf.ValueOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * The metadata of the ModelEvaluation.
     * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
     * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
     * "evaluation_dataset_path".
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ModelEvaluation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ModelEvaluation)
  private static final com.google.cloud.aiplatform.v1.ModelEvaluation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ModelEvaluation();
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelEvaluation> PARSER =
      new com.google.protobuf.AbstractParser<ModelEvaluation>() {
        @java.lang.Override
        public ModelEvaluation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ModelEvaluation(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ModelEvaluation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelEvaluation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModelEvaluation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
