/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/metadata_service.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Request message for [MetadataService.ListExecutions][google.cloud.aiplatform.v1.MetadataService.ListExecutions].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.ListExecutionsRequest}
 */
public final class ListExecutionsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ListExecutionsRequest)
    ListExecutionsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListExecutionsRequest.newBuilder() to construct.
  private ListExecutionsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListExecutionsRequest() {
    parent_ = "";
    pageToken_ = "";
    filter_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListExecutionsRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ListExecutionsRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              parent_ = s;
              break;
            }
          case 16:
            {
              pageSize_ = input.readInt32();
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              pageToken_ = s;
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              filter_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.MetadataServiceProto
        .internal_static_google_cloud_aiplatform_v1_ListExecutionsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.MetadataServiceProto
        .internal_static_google_cloud_aiplatform_v1_ListExecutionsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.ListExecutionsRequest.class,
            com.google.cloud.aiplatform.v1.ListExecutionsRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. The MetadataStore whose Executions should be listed.
   * Format:
   * `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The MetadataStore whose Executions should be listed.
   * Format:
   * `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 2;
  private int pageSize_;
  /**
   *
   *
   * <pre>
   * The maximum number of Executions to return. The service may return fewer.
   * Must be in range 1-1000, inclusive. Defaults to 100.
   * </pre>
   *
   * <code>int32 page_size = 2;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 3;
  private volatile java.lang.Object pageToken_;
  /**
   *
   *
   * <pre>
   * A page token, received from a previous [MetadataService.ListExecutions][google.cloud.aiplatform.v1.MetadataService.ListExecutions]
   * call. Provide this to retrieve the subsequent page.
   * When paginating, all other provided parameters must match the call that
   * provided the page token. (Otherwise the request will fail with an
   * INVALID_ARGUMENT error.)
   * </pre>
   *
   * <code>string page_token = 3;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A page token, received from a previous [MetadataService.ListExecutions][google.cloud.aiplatform.v1.MetadataService.ListExecutions]
   * call. Provide this to retrieve the subsequent page.
   * When paginating, all other provided parameters must match the call that
   * provided the page token. (Otherwise the request will fail with an
   * INVALID_ARGUMENT error.)
   * </pre>
   *
   * <code>string page_token = 3;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 4;
  private volatile java.lang.Object filter_;
  /**
   *
   *
   * <pre>
   * Filter specifying the boolean condition for the Executions to satisfy in
   * order to be part of the result set.
   * The syntax to define filter query is based on https://google.aip.dev/160.
   * Following are the supported set of filters:
   * *  **Attribute filtering**:
   *    For example: `display_name = "test"`.
   *    Supported fields include: `name`, `display_name`, `state`,
   *    `schema_title`, `create_time`, and `update_time`.
   *    Time fields, such as `create_time` and `update_time`, require values
   *    specified in RFC-3339 format.
   *    For example: `create_time = "2020-11-19T11:30:00-04:00"`.
   * *  **Metadata field**:
   *    To filter on metadata fields use traversal operation as follows:
   *    `metadata.&lt;field_name&gt;.&lt;type_value&gt;`
   *    For example: `metadata.field_1.number_value = 10.0`
   * *  **Context based filtering**:
   *    To filter Executions based on the contexts to which they belong use
   *    the function operator with the full resource name:
   *    `in_context(&lt;context-name&gt;)`.
   *    For example:
   *    `in_context("projects/&lt;project_number&gt;/locations/&lt;location&gt;/metadataStores/&lt;metadatastore_name&gt;/contexts/&lt;context-id&gt;")`
   * Each of the above supported filters can be combined together using
   * logical operators (`AND` &amp; `OR`).
   * For example: `display_name = "test" AND metadata.field1.bool_value = true`.
   * </pre>
   *
   * <code>string filter = 4;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Filter specifying the boolean condition for the Executions to satisfy in
   * order to be part of the result set.
   * The syntax to define filter query is based on https://google.aip.dev/160.
   * Following are the supported set of filters:
   * *  **Attribute filtering**:
   *    For example: `display_name = "test"`.
   *    Supported fields include: `name`, `display_name`, `state`,
   *    `schema_title`, `create_time`, and `update_time`.
   *    Time fields, such as `create_time` and `update_time`, require values
   *    specified in RFC-3339 format.
   *    For example: `create_time = "2020-11-19T11:30:00-04:00"`.
   * *  **Metadata field**:
   *    To filter on metadata fields use traversal operation as follows:
   *    `metadata.&lt;field_name&gt;.&lt;type_value&gt;`
   *    For example: `metadata.field_1.number_value = 10.0`
   * *  **Context based filtering**:
   *    To filter Executions based on the contexts to which they belong use
   *    the function operator with the full resource name:
   *    `in_context(&lt;context-name&gt;)`.
   *    For example:
   *    `in_context("projects/&lt;project_number&gt;/locations/&lt;location&gt;/metadataStores/&lt;metadatastore_name&gt;/contexts/&lt;context-id&gt;")`
   * Each of the above supported filters can be combined together using
   * logical operators (`AND` &amp; `OR`).
   * For example: `display_name = "test" AND metadata.field1.bool_value = true`.
   * </pre>
   *
   * <code>string filter = 4;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(2, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, filter_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, filter_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.ListExecutionsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.ListExecutionsRequest other =
        (com.google.cloud.aiplatform.v1.ListExecutionsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.ListExecutionsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ListExecutionsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ListExecutionsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ListExecutionsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ListExecutionsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ListExecutionsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ListExecutionsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ListExecutionsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ListExecutionsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ListExecutionsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ListExecutionsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ListExecutionsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.ListExecutionsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for [MetadataService.ListExecutions][google.cloud.aiplatform.v1.MetadataService.ListExecutions].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ListExecutionsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ListExecutionsRequest)
      com.google.cloud.aiplatform.v1.ListExecutionsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.MetadataServiceProto
          .internal_static_google_cloud_aiplatform_v1_ListExecutionsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.MetadataServiceProto
          .internal_static_google_cloud_aiplatform_v1_ListExecutionsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ListExecutionsRequest.class,
              com.google.cloud.aiplatform.v1.ListExecutionsRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.ListExecutionsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      pageSize_ = 0;

      pageToken_ = "";

      filter_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.MetadataServiceProto
          .internal_static_google_cloud_aiplatform_v1_ListExecutionsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ListExecutionsRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.ListExecutionsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ListExecutionsRequest build() {
      com.google.cloud.aiplatform.v1.ListExecutionsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ListExecutionsRequest buildPartial() {
      com.google.cloud.aiplatform.v1.ListExecutionsRequest result =
          new com.google.cloud.aiplatform.v1.ListExecutionsRequest(this);
      result.parent_ = parent_;
      result.pageSize_ = pageSize_;
      result.pageToken_ = pageToken_;
      result.filter_ = filter_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.ListExecutionsRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1.ListExecutionsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.ListExecutionsRequest other) {
      if (other == com.google.cloud.aiplatform.v1.ListExecutionsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1.ListExecutionsRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1.ListExecutionsRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The MetadataStore whose Executions should be listed.
     * Format:
     * `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The MetadataStore whose Executions should be listed.
     * Format:
     * `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The MetadataStore whose Executions should be listed.
     * Format:
     * `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The MetadataStore whose Executions should be listed.
     * Format:
     * `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The MetadataStore whose Executions should be listed.
     * Format:
     * `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * The maximum number of Executions to return. The service may return fewer.
     * Must be in range 1-1000, inclusive. Defaults to 100.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of Executions to return. The service may return fewer.
     * Must be in range 1-1000, inclusive. Defaults to 100.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of Executions to return. The service may return fewer.
     * Must be in range 1-1000, inclusive. Defaults to 100.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {

      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * A page token, received from a previous [MetadataService.ListExecutions][google.cloud.aiplatform.v1.MetadataService.ListExecutions]
     * call. Provide this to retrieve the subsequent page.
     * When paginating, all other provided parameters must match the call that
     * provided the page token. (Otherwise the request will fail with an
     * INVALID_ARGUMENT error.)
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A page token, received from a previous [MetadataService.ListExecutions][google.cloud.aiplatform.v1.MetadataService.ListExecutions]
     * call. Provide this to retrieve the subsequent page.
     * When paginating, all other provided parameters must match the call that
     * provided the page token. (Otherwise the request will fail with an
     * INVALID_ARGUMENT error.)
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A page token, received from a previous [MetadataService.ListExecutions][google.cloud.aiplatform.v1.MetadataService.ListExecutions]
     * call. Provide this to retrieve the subsequent page.
     * When paginating, all other provided parameters must match the call that
     * provided the page token. (Otherwise the request will fail with an
     * INVALID_ARGUMENT error.)
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      pageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A page token, received from a previous [MetadataService.ListExecutions][google.cloud.aiplatform.v1.MetadataService.ListExecutions]
     * call. Provide this to retrieve the subsequent page.
     * When paginating, all other provided parameters must match the call that
     * provided the page token. (Otherwise the request will fail with an
     * INVALID_ARGUMENT error.)
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {

      pageToken_ = getDefaultInstance().getPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A page token, received from a previous [MetadataService.ListExecutions][google.cloud.aiplatform.v1.MetadataService.ListExecutions]
     * call. Provide this to retrieve the subsequent page.
     * When paginating, all other provided parameters must match the call that
     * provided the page token. (Otherwise the request will fail with an
     * INVALID_ARGUMENT error.)
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      pageToken_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * Filter specifying the boolean condition for the Executions to satisfy in
     * order to be part of the result set.
     * The syntax to define filter query is based on https://google.aip.dev/160.
     * Following are the supported set of filters:
     * *  **Attribute filtering**:
     *    For example: `display_name = "test"`.
     *    Supported fields include: `name`, `display_name`, `state`,
     *    `schema_title`, `create_time`, and `update_time`.
     *    Time fields, such as `create_time` and `update_time`, require values
     *    specified in RFC-3339 format.
     *    For example: `create_time = "2020-11-19T11:30:00-04:00"`.
     * *  **Metadata field**:
     *    To filter on metadata fields use traversal operation as follows:
     *    `metadata.&lt;field_name&gt;.&lt;type_value&gt;`
     *    For example: `metadata.field_1.number_value = 10.0`
     * *  **Context based filtering**:
     *    To filter Executions based on the contexts to which they belong use
     *    the function operator with the full resource name:
     *    `in_context(&lt;context-name&gt;)`.
     *    For example:
     *    `in_context("projects/&lt;project_number&gt;/locations/&lt;location&gt;/metadataStores/&lt;metadatastore_name&gt;/contexts/&lt;context-id&gt;")`
     * Each of the above supported filters can be combined together using
     * logical operators (`AND` &amp; `OR`).
     * For example: `display_name = "test" AND metadata.field1.bool_value = true`.
     * </pre>
     *
     * <code>string filter = 4;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Filter specifying the boolean condition for the Executions to satisfy in
     * order to be part of the result set.
     * The syntax to define filter query is based on https://google.aip.dev/160.
     * Following are the supported set of filters:
     * *  **Attribute filtering**:
     *    For example: `display_name = "test"`.
     *    Supported fields include: `name`, `display_name`, `state`,
     *    `schema_title`, `create_time`, and `update_time`.
     *    Time fields, such as `create_time` and `update_time`, require values
     *    specified in RFC-3339 format.
     *    For example: `create_time = "2020-11-19T11:30:00-04:00"`.
     * *  **Metadata field**:
     *    To filter on metadata fields use traversal operation as follows:
     *    `metadata.&lt;field_name&gt;.&lt;type_value&gt;`
     *    For example: `metadata.field_1.number_value = 10.0`
     * *  **Context based filtering**:
     *    To filter Executions based on the contexts to which they belong use
     *    the function operator with the full resource name:
     *    `in_context(&lt;context-name&gt;)`.
     *    For example:
     *    `in_context("projects/&lt;project_number&gt;/locations/&lt;location&gt;/metadataStores/&lt;metadatastore_name&gt;/contexts/&lt;context-id&gt;")`
     * Each of the above supported filters can be combined together using
     * logical operators (`AND` &amp; `OR`).
     * For example: `display_name = "test" AND metadata.field1.bool_value = true`.
     * </pre>
     *
     * <code>string filter = 4;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Filter specifying the boolean condition for the Executions to satisfy in
     * order to be part of the result set.
     * The syntax to define filter query is based on https://google.aip.dev/160.
     * Following are the supported set of filters:
     * *  **Attribute filtering**:
     *    For example: `display_name = "test"`.
     *    Supported fields include: `name`, `display_name`, `state`,
     *    `schema_title`, `create_time`, and `update_time`.
     *    Time fields, such as `create_time` and `update_time`, require values
     *    specified in RFC-3339 format.
     *    For example: `create_time = "2020-11-19T11:30:00-04:00"`.
     * *  **Metadata field**:
     *    To filter on metadata fields use traversal operation as follows:
     *    `metadata.&lt;field_name&gt;.&lt;type_value&gt;`
     *    For example: `metadata.field_1.number_value = 10.0`
     * *  **Context based filtering**:
     *    To filter Executions based on the contexts to which they belong use
     *    the function operator with the full resource name:
     *    `in_context(&lt;context-name&gt;)`.
     *    For example:
     *    `in_context("projects/&lt;project_number&gt;/locations/&lt;location&gt;/metadataStores/&lt;metadatastore_name&gt;/contexts/&lt;context-id&gt;")`
     * Each of the above supported filters can be combined together using
     * logical operators (`AND` &amp; `OR`).
     * For example: `display_name = "test" AND metadata.field1.bool_value = true`.
     * </pre>
     *
     * <code>string filter = 4;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter specifying the boolean condition for the Executions to satisfy in
     * order to be part of the result set.
     * The syntax to define filter query is based on https://google.aip.dev/160.
     * Following are the supported set of filters:
     * *  **Attribute filtering**:
     *    For example: `display_name = "test"`.
     *    Supported fields include: `name`, `display_name`, `state`,
     *    `schema_title`, `create_time`, and `update_time`.
     *    Time fields, such as `create_time` and `update_time`, require values
     *    specified in RFC-3339 format.
     *    For example: `create_time = "2020-11-19T11:30:00-04:00"`.
     * *  **Metadata field**:
     *    To filter on metadata fields use traversal operation as follows:
     *    `metadata.&lt;field_name&gt;.&lt;type_value&gt;`
     *    For example: `metadata.field_1.number_value = 10.0`
     * *  **Context based filtering**:
     *    To filter Executions based on the contexts to which they belong use
     *    the function operator with the full resource name:
     *    `in_context(&lt;context-name&gt;)`.
     *    For example:
     *    `in_context("projects/&lt;project_number&gt;/locations/&lt;location&gt;/metadataStores/&lt;metadatastore_name&gt;/contexts/&lt;context-id&gt;")`
     * Each of the above supported filters can be combined together using
     * logical operators (`AND` &amp; `OR`).
     * For example: `display_name = "test" AND metadata.field1.bool_value = true`.
     * </pre>
     *
     * <code>string filter = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {

      filter_ = getDefaultInstance().getFilter();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter specifying the boolean condition for the Executions to satisfy in
     * order to be part of the result set.
     * The syntax to define filter query is based on https://google.aip.dev/160.
     * Following are the supported set of filters:
     * *  **Attribute filtering**:
     *    For example: `display_name = "test"`.
     *    Supported fields include: `name`, `display_name`, `state`,
     *    `schema_title`, `create_time`, and `update_time`.
     *    Time fields, such as `create_time` and `update_time`, require values
     *    specified in RFC-3339 format.
     *    For example: `create_time = "2020-11-19T11:30:00-04:00"`.
     * *  **Metadata field**:
     *    To filter on metadata fields use traversal operation as follows:
     *    `metadata.&lt;field_name&gt;.&lt;type_value&gt;`
     *    For example: `metadata.field_1.number_value = 10.0`
     * *  **Context based filtering**:
     *    To filter Executions based on the contexts to which they belong use
     *    the function operator with the full resource name:
     *    `in_context(&lt;context-name&gt;)`.
     *    For example:
     *    `in_context("projects/&lt;project_number&gt;/locations/&lt;location&gt;/metadataStores/&lt;metadatastore_name&gt;/contexts/&lt;context-id&gt;")`
     * Each of the above supported filters can be combined together using
     * logical operators (`AND` &amp; `OR`).
     * For example: `display_name = "test" AND metadata.field1.bool_value = true`.
     * </pre>
     *
     * <code>string filter = 4;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      filter_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ListExecutionsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ListExecutionsRequest)
  private static final com.google.cloud.aiplatform.v1.ListExecutionsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ListExecutionsRequest();
  }

  public static com.google.cloud.aiplatform.v1.ListExecutionsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListExecutionsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListExecutionsRequest>() {
        @java.lang.Override
        public ListExecutionsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ListExecutionsRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ListExecutionsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListExecutionsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ListExecutionsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
