/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/lineage_subgraph.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * A subgraph of the overall lineage graph. Event edges connect Artifact and
 * Execution nodes.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.LineageSubgraph}
 */
public final class LineageSubgraph extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.LineageSubgraph)
    LineageSubgraphOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LineageSubgraph.newBuilder() to construct.
  private LineageSubgraph(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LineageSubgraph() {
    artifacts_ = java.util.Collections.emptyList();
    executions_ = java.util.Collections.emptyList();
    events_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LineageSubgraph();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private LineageSubgraph(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                artifacts_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1.Artifact>();
                mutable_bitField0_ |= 0x00000001;
              }
              artifacts_.add(
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.Artifact.parser(), extensionRegistry));
              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                executions_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1.Execution>();
                mutable_bitField0_ |= 0x00000002;
              }
              executions_.add(
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.Execution.parser(), extensionRegistry));
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                events_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1.Event>();
                mutable_bitField0_ |= 0x00000004;
              }
              events_.add(
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.Event.parser(), extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        artifacts_ = java.util.Collections.unmodifiableList(artifacts_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        executions_ = java.util.Collections.unmodifiableList(executions_);
      }
      if (((mutable_bitField0_ & 0x00000004) != 0)) {
        events_ = java.util.Collections.unmodifiableList(events_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.LineageSubgraphProto
        .internal_static_google_cloud_aiplatform_v1_LineageSubgraph_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.LineageSubgraphProto
        .internal_static_google_cloud_aiplatform_v1_LineageSubgraph_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.LineageSubgraph.class,
            com.google.cloud.aiplatform.v1.LineageSubgraph.Builder.class);
  }

  public static final int ARTIFACTS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.aiplatform.v1.Artifact> artifacts_;
  /**
   *
   *
   * <pre>
   * The Artifact nodes in the subgraph.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.Artifact> getArtifactsList() {
    return artifacts_;
  }
  /**
   *
   *
   * <pre>
   * The Artifact nodes in the subgraph.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.ArtifactOrBuilder>
      getArtifactsOrBuilderList() {
    return artifacts_;
  }
  /**
   *
   *
   * <pre>
   * The Artifact nodes in the subgraph.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
   */
  @java.lang.Override
  public int getArtifactsCount() {
    return artifacts_.size();
  }
  /**
   *
   *
   * <pre>
   * The Artifact nodes in the subgraph.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Artifact getArtifacts(int index) {
    return artifacts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The Artifact nodes in the subgraph.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ArtifactOrBuilder getArtifactsOrBuilder(int index) {
    return artifacts_.get(index);
  }

  public static final int EXECUTIONS_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.aiplatform.v1.Execution> executions_;
  /**
   *
   *
   * <pre>
   * The Execution nodes in the subgraph.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.Execution> getExecutionsList() {
    return executions_;
  }
  /**
   *
   *
   * <pre>
   * The Execution nodes in the subgraph.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.ExecutionOrBuilder>
      getExecutionsOrBuilderList() {
    return executions_;
  }
  /**
   *
   *
   * <pre>
   * The Execution nodes in the subgraph.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
   */
  @java.lang.Override
  public int getExecutionsCount() {
    return executions_.size();
  }
  /**
   *
   *
   * <pre>
   * The Execution nodes in the subgraph.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Execution getExecutions(int index) {
    return executions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The Execution nodes in the subgraph.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExecutionOrBuilder getExecutionsOrBuilder(int index) {
    return executions_.get(index);
  }

  public static final int EVENTS_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.aiplatform.v1.Event> events_;
  /**
   *
   *
   * <pre>
   * The Event edges between Artifacts and Executions in the subgraph.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.Event> getEventsList() {
    return events_;
  }
  /**
   *
   *
   * <pre>
   * The Event edges between Artifacts and Executions in the subgraph.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.EventOrBuilder>
      getEventsOrBuilderList() {
    return events_;
  }
  /**
   *
   *
   * <pre>
   * The Event edges between Artifacts and Executions in the subgraph.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
   */
  @java.lang.Override
  public int getEventsCount() {
    return events_.size();
  }
  /**
   *
   *
   * <pre>
   * The Event edges between Artifacts and Executions in the subgraph.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Event getEvents(int index) {
    return events_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The Event edges between Artifacts and Executions in the subgraph.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EventOrBuilder getEventsOrBuilder(int index) {
    return events_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < artifacts_.size(); i++) {
      output.writeMessage(1, artifacts_.get(i));
    }
    for (int i = 0; i < executions_.size(); i++) {
      output.writeMessage(2, executions_.get(i));
    }
    for (int i = 0; i < events_.size(); i++) {
      output.writeMessage(3, events_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < artifacts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, artifacts_.get(i));
    }
    for (int i = 0; i < executions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, executions_.get(i));
    }
    for (int i = 0; i < events_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, events_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.LineageSubgraph)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.LineageSubgraph other =
        (com.google.cloud.aiplatform.v1.LineageSubgraph) obj;

    if (!getArtifactsList().equals(other.getArtifactsList())) return false;
    if (!getExecutionsList().equals(other.getExecutionsList())) return false;
    if (!getEventsList().equals(other.getEventsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getArtifactsCount() > 0) {
      hash = (37 * hash) + ARTIFACTS_FIELD_NUMBER;
      hash = (53 * hash) + getArtifactsList().hashCode();
    }
    if (getExecutionsCount() > 0) {
      hash = (37 * hash) + EXECUTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getExecutionsList().hashCode();
    }
    if (getEventsCount() > 0) {
      hash = (37 * hash) + EVENTS_FIELD_NUMBER;
      hash = (53 * hash) + getEventsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.LineageSubgraph parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.LineageSubgraph parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.LineageSubgraph parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.LineageSubgraph parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.LineageSubgraph parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.LineageSubgraph parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.LineageSubgraph parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.LineageSubgraph parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.LineageSubgraph parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.LineageSubgraph parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.LineageSubgraph parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.LineageSubgraph parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.LineageSubgraph prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A subgraph of the overall lineage graph. Event edges connect Artifact and
   * Execution nodes.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.LineageSubgraph}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.LineageSubgraph)
      com.google.cloud.aiplatform.v1.LineageSubgraphOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.LineageSubgraphProto
          .internal_static_google_cloud_aiplatform_v1_LineageSubgraph_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.LineageSubgraphProto
          .internal_static_google_cloud_aiplatform_v1_LineageSubgraph_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.LineageSubgraph.class,
              com.google.cloud.aiplatform.v1.LineageSubgraph.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.LineageSubgraph.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getArtifactsFieldBuilder();
        getExecutionsFieldBuilder();
        getEventsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (artifactsBuilder_ == null) {
        artifacts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        artifactsBuilder_.clear();
      }
      if (executionsBuilder_ == null) {
        executions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        executionsBuilder_.clear();
      }
      if (eventsBuilder_ == null) {
        events_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
      } else {
        eventsBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.LineageSubgraphProto
          .internal_static_google_cloud_aiplatform_v1_LineageSubgraph_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.LineageSubgraph getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.LineageSubgraph.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.LineageSubgraph build() {
      com.google.cloud.aiplatform.v1.LineageSubgraph result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.LineageSubgraph buildPartial() {
      com.google.cloud.aiplatform.v1.LineageSubgraph result =
          new com.google.cloud.aiplatform.v1.LineageSubgraph(this);
      int from_bitField0_ = bitField0_;
      if (artifactsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          artifacts_ = java.util.Collections.unmodifiableList(artifacts_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.artifacts_ = artifacts_;
      } else {
        result.artifacts_ = artifactsBuilder_.build();
      }
      if (executionsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          executions_ = java.util.Collections.unmodifiableList(executions_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.executions_ = executions_;
      } else {
        result.executions_ = executionsBuilder_.build();
      }
      if (eventsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          events_ = java.util.Collections.unmodifiableList(events_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.events_ = events_;
      } else {
        result.events_ = eventsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.LineageSubgraph) {
        return mergeFrom((com.google.cloud.aiplatform.v1.LineageSubgraph) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.LineageSubgraph other) {
      if (other == com.google.cloud.aiplatform.v1.LineageSubgraph.getDefaultInstance()) return this;
      if (artifactsBuilder_ == null) {
        if (!other.artifacts_.isEmpty()) {
          if (artifacts_.isEmpty()) {
            artifacts_ = other.artifacts_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureArtifactsIsMutable();
            artifacts_.addAll(other.artifacts_);
          }
          onChanged();
        }
      } else {
        if (!other.artifacts_.isEmpty()) {
          if (artifactsBuilder_.isEmpty()) {
            artifactsBuilder_.dispose();
            artifactsBuilder_ = null;
            artifacts_ = other.artifacts_;
            bitField0_ = (bitField0_ & ~0x00000001);
            artifactsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getArtifactsFieldBuilder()
                    : null;
          } else {
            artifactsBuilder_.addAllMessages(other.artifacts_);
          }
        }
      }
      if (executionsBuilder_ == null) {
        if (!other.executions_.isEmpty()) {
          if (executions_.isEmpty()) {
            executions_ = other.executions_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureExecutionsIsMutable();
            executions_.addAll(other.executions_);
          }
          onChanged();
        }
      } else {
        if (!other.executions_.isEmpty()) {
          if (executionsBuilder_.isEmpty()) {
            executionsBuilder_.dispose();
            executionsBuilder_ = null;
            executions_ = other.executions_;
            bitField0_ = (bitField0_ & ~0x00000002);
            executionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getExecutionsFieldBuilder()
                    : null;
          } else {
            executionsBuilder_.addAllMessages(other.executions_);
          }
        }
      }
      if (eventsBuilder_ == null) {
        if (!other.events_.isEmpty()) {
          if (events_.isEmpty()) {
            events_ = other.events_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureEventsIsMutable();
            events_.addAll(other.events_);
          }
          onChanged();
        }
      } else {
        if (!other.events_.isEmpty()) {
          if (eventsBuilder_.isEmpty()) {
            eventsBuilder_.dispose();
            eventsBuilder_ = null;
            events_ = other.events_;
            bitField0_ = (bitField0_ & ~0x00000004);
            eventsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEventsFieldBuilder()
                    : null;
          } else {
            eventsBuilder_.addAllMessages(other.events_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1.LineageSubgraph parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.aiplatform.v1.LineageSubgraph) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.aiplatform.v1.Artifact> artifacts_ =
        java.util.Collections.emptyList();

    private void ensureArtifactsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        artifacts_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1.Artifact>(artifacts_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Artifact,
            com.google.cloud.aiplatform.v1.Artifact.Builder,
            com.google.cloud.aiplatform.v1.ArtifactOrBuilder>
        artifactsBuilder_;

    /**
     *
     *
     * <pre>
     * The Artifact nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Artifact> getArtifactsList() {
      if (artifactsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(artifacts_);
      } else {
        return artifactsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The Artifact nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
     */
    public int getArtifactsCount() {
      if (artifactsBuilder_ == null) {
        return artifacts_.size();
      } else {
        return artifactsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The Artifact nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
     */
    public com.google.cloud.aiplatform.v1.Artifact getArtifacts(int index) {
      if (artifactsBuilder_ == null) {
        return artifacts_.get(index);
      } else {
        return artifactsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The Artifact nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
     */
    public Builder setArtifacts(int index, com.google.cloud.aiplatform.v1.Artifact value) {
      if (artifactsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArtifactsIsMutable();
        artifacts_.set(index, value);
        onChanged();
      } else {
        artifactsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Artifact nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
     */
    public Builder setArtifacts(
        int index, com.google.cloud.aiplatform.v1.Artifact.Builder builderForValue) {
      if (artifactsBuilder_ == null) {
        ensureArtifactsIsMutable();
        artifacts_.set(index, builderForValue.build());
        onChanged();
      } else {
        artifactsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Artifact nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
     */
    public Builder addArtifacts(com.google.cloud.aiplatform.v1.Artifact value) {
      if (artifactsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArtifactsIsMutable();
        artifacts_.add(value);
        onChanged();
      } else {
        artifactsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Artifact nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
     */
    public Builder addArtifacts(int index, com.google.cloud.aiplatform.v1.Artifact value) {
      if (artifactsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArtifactsIsMutable();
        artifacts_.add(index, value);
        onChanged();
      } else {
        artifactsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Artifact nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
     */
    public Builder addArtifacts(com.google.cloud.aiplatform.v1.Artifact.Builder builderForValue) {
      if (artifactsBuilder_ == null) {
        ensureArtifactsIsMutable();
        artifacts_.add(builderForValue.build());
        onChanged();
      } else {
        artifactsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Artifact nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
     */
    public Builder addArtifacts(
        int index, com.google.cloud.aiplatform.v1.Artifact.Builder builderForValue) {
      if (artifactsBuilder_ == null) {
        ensureArtifactsIsMutable();
        artifacts_.add(index, builderForValue.build());
        onChanged();
      } else {
        artifactsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Artifact nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
     */
    public Builder addAllArtifacts(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.Artifact> values) {
      if (artifactsBuilder_ == null) {
        ensureArtifactsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, artifacts_);
        onChanged();
      } else {
        artifactsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Artifact nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
     */
    public Builder clearArtifacts() {
      if (artifactsBuilder_ == null) {
        artifacts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        artifactsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Artifact nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
     */
    public Builder removeArtifacts(int index) {
      if (artifactsBuilder_ == null) {
        ensureArtifactsIsMutable();
        artifacts_.remove(index);
        onChanged();
      } else {
        artifactsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Artifact nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
     */
    public com.google.cloud.aiplatform.v1.Artifact.Builder getArtifactsBuilder(int index) {
      return getArtifactsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The Artifact nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
     */
    public com.google.cloud.aiplatform.v1.ArtifactOrBuilder getArtifactsOrBuilder(int index) {
      if (artifactsBuilder_ == null) {
        return artifacts_.get(index);
      } else {
        return artifactsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The Artifact nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.ArtifactOrBuilder>
        getArtifactsOrBuilderList() {
      if (artifactsBuilder_ != null) {
        return artifactsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(artifacts_);
      }
    }
    /**
     *
     *
     * <pre>
     * The Artifact nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
     */
    public com.google.cloud.aiplatform.v1.Artifact.Builder addArtifactsBuilder() {
      return getArtifactsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.Artifact.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The Artifact nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
     */
    public com.google.cloud.aiplatform.v1.Artifact.Builder addArtifactsBuilder(int index) {
      return getArtifactsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1.Artifact.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The Artifact nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Artifact artifacts = 1;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Artifact.Builder>
        getArtifactsBuilderList() {
      return getArtifactsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Artifact,
            com.google.cloud.aiplatform.v1.Artifact.Builder,
            com.google.cloud.aiplatform.v1.ArtifactOrBuilder>
        getArtifactsFieldBuilder() {
      if (artifactsBuilder_ == null) {
        artifactsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Artifact,
                com.google.cloud.aiplatform.v1.Artifact.Builder,
                com.google.cloud.aiplatform.v1.ArtifactOrBuilder>(
                artifacts_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        artifacts_ = null;
      }
      return artifactsBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.Execution> executions_ =
        java.util.Collections.emptyList();

    private void ensureExecutionsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        executions_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.Execution>(executions_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Execution,
            com.google.cloud.aiplatform.v1.Execution.Builder,
            com.google.cloud.aiplatform.v1.ExecutionOrBuilder>
        executionsBuilder_;

    /**
     *
     *
     * <pre>
     * The Execution nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Execution> getExecutionsList() {
      if (executionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(executions_);
      } else {
        return executionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The Execution nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
     */
    public int getExecutionsCount() {
      if (executionsBuilder_ == null) {
        return executions_.size();
      } else {
        return executionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The Execution nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
     */
    public com.google.cloud.aiplatform.v1.Execution getExecutions(int index) {
      if (executionsBuilder_ == null) {
        return executions_.get(index);
      } else {
        return executionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The Execution nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
     */
    public Builder setExecutions(int index, com.google.cloud.aiplatform.v1.Execution value) {
      if (executionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExecutionsIsMutable();
        executions_.set(index, value);
        onChanged();
      } else {
        executionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Execution nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
     */
    public Builder setExecutions(
        int index, com.google.cloud.aiplatform.v1.Execution.Builder builderForValue) {
      if (executionsBuilder_ == null) {
        ensureExecutionsIsMutable();
        executions_.set(index, builderForValue.build());
        onChanged();
      } else {
        executionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Execution nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
     */
    public Builder addExecutions(com.google.cloud.aiplatform.v1.Execution value) {
      if (executionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExecutionsIsMutable();
        executions_.add(value);
        onChanged();
      } else {
        executionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Execution nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
     */
    public Builder addExecutions(int index, com.google.cloud.aiplatform.v1.Execution value) {
      if (executionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExecutionsIsMutable();
        executions_.add(index, value);
        onChanged();
      } else {
        executionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Execution nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
     */
    public Builder addExecutions(com.google.cloud.aiplatform.v1.Execution.Builder builderForValue) {
      if (executionsBuilder_ == null) {
        ensureExecutionsIsMutable();
        executions_.add(builderForValue.build());
        onChanged();
      } else {
        executionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Execution nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
     */
    public Builder addExecutions(
        int index, com.google.cloud.aiplatform.v1.Execution.Builder builderForValue) {
      if (executionsBuilder_ == null) {
        ensureExecutionsIsMutable();
        executions_.add(index, builderForValue.build());
        onChanged();
      } else {
        executionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Execution nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
     */
    public Builder addAllExecutions(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.Execution> values) {
      if (executionsBuilder_ == null) {
        ensureExecutionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, executions_);
        onChanged();
      } else {
        executionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Execution nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
     */
    public Builder clearExecutions() {
      if (executionsBuilder_ == null) {
        executions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        executionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Execution nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
     */
    public Builder removeExecutions(int index) {
      if (executionsBuilder_ == null) {
        ensureExecutionsIsMutable();
        executions_.remove(index);
        onChanged();
      } else {
        executionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Execution nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
     */
    public com.google.cloud.aiplatform.v1.Execution.Builder getExecutionsBuilder(int index) {
      return getExecutionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The Execution nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
     */
    public com.google.cloud.aiplatform.v1.ExecutionOrBuilder getExecutionsOrBuilder(int index) {
      if (executionsBuilder_ == null) {
        return executions_.get(index);
      } else {
        return executionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The Execution nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.ExecutionOrBuilder>
        getExecutionsOrBuilderList() {
      if (executionsBuilder_ != null) {
        return executionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(executions_);
      }
    }
    /**
     *
     *
     * <pre>
     * The Execution nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
     */
    public com.google.cloud.aiplatform.v1.Execution.Builder addExecutionsBuilder() {
      return getExecutionsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.Execution.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The Execution nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
     */
    public com.google.cloud.aiplatform.v1.Execution.Builder addExecutionsBuilder(int index) {
      return getExecutionsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1.Execution.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The Execution nodes in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Execution executions = 2;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Execution.Builder>
        getExecutionsBuilderList() {
      return getExecutionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Execution,
            com.google.cloud.aiplatform.v1.Execution.Builder,
            com.google.cloud.aiplatform.v1.ExecutionOrBuilder>
        getExecutionsFieldBuilder() {
      if (executionsBuilder_ == null) {
        executionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Execution,
                com.google.cloud.aiplatform.v1.Execution.Builder,
                com.google.cloud.aiplatform.v1.ExecutionOrBuilder>(
                executions_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        executions_ = null;
      }
      return executionsBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.Event> events_ =
        java.util.Collections.emptyList();

    private void ensureEventsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        events_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1.Event>(events_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Event,
            com.google.cloud.aiplatform.v1.Event.Builder,
            com.google.cloud.aiplatform.v1.EventOrBuilder>
        eventsBuilder_;

    /**
     *
     *
     * <pre>
     * The Event edges between Artifacts and Executions in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Event> getEventsList() {
      if (eventsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(events_);
      } else {
        return eventsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The Event edges between Artifacts and Executions in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
     */
    public int getEventsCount() {
      if (eventsBuilder_ == null) {
        return events_.size();
      } else {
        return eventsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The Event edges between Artifacts and Executions in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
     */
    public com.google.cloud.aiplatform.v1.Event getEvents(int index) {
      if (eventsBuilder_ == null) {
        return events_.get(index);
      } else {
        return eventsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The Event edges between Artifacts and Executions in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
     */
    public Builder setEvents(int index, com.google.cloud.aiplatform.v1.Event value) {
      if (eventsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEventsIsMutable();
        events_.set(index, value);
        onChanged();
      } else {
        eventsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Event edges between Artifacts and Executions in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
     */
    public Builder setEvents(
        int index, com.google.cloud.aiplatform.v1.Event.Builder builderForValue) {
      if (eventsBuilder_ == null) {
        ensureEventsIsMutable();
        events_.set(index, builderForValue.build());
        onChanged();
      } else {
        eventsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Event edges between Artifacts and Executions in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
     */
    public Builder addEvents(com.google.cloud.aiplatform.v1.Event value) {
      if (eventsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEventsIsMutable();
        events_.add(value);
        onChanged();
      } else {
        eventsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Event edges between Artifacts and Executions in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
     */
    public Builder addEvents(int index, com.google.cloud.aiplatform.v1.Event value) {
      if (eventsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEventsIsMutable();
        events_.add(index, value);
        onChanged();
      } else {
        eventsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Event edges between Artifacts and Executions in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
     */
    public Builder addEvents(com.google.cloud.aiplatform.v1.Event.Builder builderForValue) {
      if (eventsBuilder_ == null) {
        ensureEventsIsMutable();
        events_.add(builderForValue.build());
        onChanged();
      } else {
        eventsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Event edges between Artifacts and Executions in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
     */
    public Builder addEvents(
        int index, com.google.cloud.aiplatform.v1.Event.Builder builderForValue) {
      if (eventsBuilder_ == null) {
        ensureEventsIsMutable();
        events_.add(index, builderForValue.build());
        onChanged();
      } else {
        eventsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Event edges between Artifacts and Executions in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
     */
    public Builder addAllEvents(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.Event> values) {
      if (eventsBuilder_ == null) {
        ensureEventsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, events_);
        onChanged();
      } else {
        eventsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Event edges between Artifacts and Executions in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
     */
    public Builder clearEvents() {
      if (eventsBuilder_ == null) {
        events_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        eventsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Event edges between Artifacts and Executions in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
     */
    public Builder removeEvents(int index) {
      if (eventsBuilder_ == null) {
        ensureEventsIsMutable();
        events_.remove(index);
        onChanged();
      } else {
        eventsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Event edges between Artifacts and Executions in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
     */
    public com.google.cloud.aiplatform.v1.Event.Builder getEventsBuilder(int index) {
      return getEventsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The Event edges between Artifacts and Executions in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
     */
    public com.google.cloud.aiplatform.v1.EventOrBuilder getEventsOrBuilder(int index) {
      if (eventsBuilder_ == null) {
        return events_.get(index);
      } else {
        return eventsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The Event edges between Artifacts and Executions in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.EventOrBuilder>
        getEventsOrBuilderList() {
      if (eventsBuilder_ != null) {
        return eventsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(events_);
      }
    }
    /**
     *
     *
     * <pre>
     * The Event edges between Artifacts and Executions in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
     */
    public com.google.cloud.aiplatform.v1.Event.Builder addEventsBuilder() {
      return getEventsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.Event.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The Event edges between Artifacts and Executions in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
     */
    public com.google.cloud.aiplatform.v1.Event.Builder addEventsBuilder(int index) {
      return getEventsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1.Event.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The Event edges between Artifacts and Executions in the subgraph.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Event events = 3;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Event.Builder> getEventsBuilderList() {
      return getEventsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Event,
            com.google.cloud.aiplatform.v1.Event.Builder,
            com.google.cloud.aiplatform.v1.EventOrBuilder>
        getEventsFieldBuilder() {
      if (eventsBuilder_ == null) {
        eventsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Event,
                com.google.cloud.aiplatform.v1.Event.Builder,
                com.google.cloud.aiplatform.v1.EventOrBuilder>(
                events_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        events_ = null;
      }
      return eventsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.LineageSubgraph)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.LineageSubgraph)
  private static final com.google.cloud.aiplatform.v1.LineageSubgraph DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.LineageSubgraph();
  }

  public static com.google.cloud.aiplatform.v1.LineageSubgraph getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LineageSubgraph> PARSER =
      new com.google.protobuf.AbstractParser<LineageSubgraph>() {
        @java.lang.Override
        public LineageSubgraph parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new LineageSubgraph(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<LineageSubgraph> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LineageSubgraph> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.LineageSubgraph getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
