/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/endpoint.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Models are deployed into it, and afterwards Endpoint is called to obtain
 * predictions and explanations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.Endpoint}
 */
public final class Endpoint extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Endpoint)
    EndpointOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Endpoint.newBuilder() to construct.
  private Endpoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Endpoint() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    deployedModels_ = java.util.Collections.emptyList();
    etag_ = "";
    network_ = "";
    modelDeploymentMonitoringJob_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Endpoint();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Endpoint(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
          case 34:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                deployedModels_ =
                    new java.util.ArrayList<com.google.cloud.aiplatform.v1.DeployedModel>();
                mutable_bitField0_ |= 0x00000001;
              }
              deployedModels_.add(
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.DeployedModel.parser(), extensionRegistry));
              break;
            }
          case 42:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                trafficSplit_ =
                    com.google.protobuf.MapField.newMapField(
                        TrafficSplitDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000002;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> trafficSplit__ =
                  input.readMessage(
                      TrafficSplitDefaultEntryHolder.defaultEntry.getParserForType(),
                      extensionRegistry);
              trafficSplit_.getMutableMap().put(trafficSplit__.getKey(), trafficSplit__.getValue());
              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              etag_ = s;
              break;
            }
          case 58:
            {
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                labels_ =
                    com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000004;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                  input.readMessage(
                      LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
              break;
            }
          case 66:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 74:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (updateTime_ != null) {
                subBuilder = updateTime_.toBuilder();
              }
              updateTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(updateTime_);
                updateTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 82:
            {
              com.google.cloud.aiplatform.v1.EncryptionSpec.Builder subBuilder = null;
              if (encryptionSpec_ != null) {
                subBuilder = encryptionSpec_.toBuilder();
              }
              encryptionSpec_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.EncryptionSpec.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(encryptionSpec_);
                encryptionSpec_ = subBuilder.buildPartial();
              }

              break;
            }
          case 106:
            {
              java.lang.String s = input.readStringRequireUtf8();

              network_ = s;
              break;
            }
          case 114:
            {
              java.lang.String s = input.readStringRequireUtf8();

              modelDeploymentMonitoringJob_ = s;
              break;
            }
          case 136:
            {
              enablePrivateServiceConnect_ = input.readBool();
              break;
            }
          case 146:
            {
              com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig.Builder
                  subBuilder = null;
              if (predictRequestResponseLoggingConfig_ != null) {
                subBuilder = predictRequestResponseLoggingConfig_.toBuilder();
              }
              predictRequestResponseLoggingConfig_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(predictRequestResponseLoggingConfig_);
                predictRequestResponseLoggingConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        deployedModels_ = java.util.Collections.unmodifiableList(deployedModels_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.EndpointProto
        .internal_static_google_cloud_aiplatform_v1_Endpoint_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 5:
        return internalGetTrafficSplit();
      case 7:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.EndpointProto
        .internal_static_google_cloud_aiplatform_v1_Endpoint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.Endpoint.class,
            com.google.cloud.aiplatform.v1.Endpoint.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Endpoint.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Endpoint.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Required. The display name of the Endpoint.
   * The name can be up to 128 characters long and can be consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The display name of the Endpoint.
   * The name can be up to 128 characters long and can be consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * The description of the Endpoint.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The description of the Endpoint.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPLOYED_MODELS_FIELD_NUMBER = 4;
  private java.util.List<com.google.cloud.aiplatform.v1.DeployedModel> deployedModels_;
  /**
   *
   *
   * <pre>
   * Output only. The models deployed in this Endpoint.
   * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
   * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.DeployedModel> getDeployedModelsList() {
    return deployedModels_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The models deployed in this Endpoint.
   * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
   * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.DeployedModelOrBuilder>
      getDeployedModelsOrBuilderList() {
    return deployedModels_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The models deployed in this Endpoint.
   * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
   * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getDeployedModelsCount() {
    return deployedModels_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The models deployed in this Endpoint.
   * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
   * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeployedModel getDeployedModels(int index) {
    return deployedModels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The models deployed in this Endpoint.
   * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
   * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeployedModelOrBuilder getDeployedModelsOrBuilder(
      int index) {
    return deployedModels_.get(index);
  }

  public static final int TRAFFIC_SPLIT_FIELD_NUMBER = 5;

  private static final class TrafficSplitDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.Integer>newDefaultInstance(
            com.google.cloud.aiplatform.v1.EndpointProto
                .internal_static_google_cloud_aiplatform_v1_Endpoint_TrafficSplitEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.INT32,
            0);
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer> trafficSplit_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
      internalGetTrafficSplit() {
    if (trafficSplit_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          TrafficSplitDefaultEntryHolder.defaultEntry);
    }
    return trafficSplit_;
  }

  public int getTrafficSplitCount() {
    return internalGetTrafficSplit().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A map from a DeployedModel's ID to the percentage of this Endpoint's
   * traffic that should be forwarded to that DeployedModel.
   * If a DeployedModel's ID is not listed in this map, then it receives no
   * traffic.
   * The traffic percentage values must add up to 100, or map must be empty if
   * the Endpoint is to not accept any traffic at a moment.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
   */
  @java.lang.Override
  public boolean containsTrafficSplit(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetTrafficSplit().getMap().containsKey(key);
  }
  /** Use {@link #getTrafficSplitMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Integer> getTrafficSplit() {
    return getTrafficSplitMap();
  }
  /**
   *
   *
   * <pre>
   * A map from a DeployedModel's ID to the percentage of this Endpoint's
   * traffic that should be forwarded to that DeployedModel.
   * If a DeployedModel's ID is not listed in this map, then it receives no
   * traffic.
   * The traffic percentage values must add up to 100, or map must be empty if
   * the Endpoint is to not accept any traffic at a moment.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.Integer> getTrafficSplitMap() {
    return internalGetTrafficSplit().getMap();
  }
  /**
   *
   *
   * <pre>
   * A map from a DeployedModel's ID to the percentage of this Endpoint's
   * traffic that should be forwarded to that DeployedModel.
   * If a DeployedModel's ID is not listed in this map, then it receives no
   * traffic.
   * The traffic percentage values must add up to 100, or map must be empty if
   * the Endpoint is to not accept any traffic at a moment.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
   */
  @java.lang.Override
  public int getTrafficSplitOrDefault(java.lang.String key, int defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetTrafficSplit().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A map from a DeployedModel's ID to the percentage of this Endpoint's
   * traffic that should be forwarded to that DeployedModel.
   * If a DeployedModel's ID is not listed in this map, then it receives no
   * traffic.
   * The traffic percentage values must add up to 100, or map must be empty if
   * the Endpoint is to not accept any traffic at a moment.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
   */
  @java.lang.Override
  public int getTrafficSplitOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetTrafficSplit().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ETAG_FIELD_NUMBER = 6;
  private volatile java.lang.Object etag_;
  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 6;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 6;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 7;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1.EndpointProto
                .internal_static_google_cloud_aiplatform_v1_Endpoint_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Endpoints.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Endpoints.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Endpoints.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Endpoints.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Endpoint was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Endpoint was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Endpoint was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Endpoint was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Endpoint was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Endpoint was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 10;
  private com.google.cloud.aiplatform.v1.EncryptionSpec encryptionSpec_;
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for an Endpoint. If set, this
   * Endpoint and all sub-resources of this Endpoint will be secured by
   * this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 10;</code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return encryptionSpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for an Endpoint. If set, this
   * Endpoint and all sub-resources of this Endpoint will be secured by
   * this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 10;</code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for an Endpoint. If set, this
   * Endpoint and all sub-resources of this Endpoint will be secured by
   * this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return getEncryptionSpec();
  }

  public static final int NETWORK_FIELD_NUMBER = 13;
  private volatile java.lang.Object network_;
  /**
   *
   *
   * <pre>
   * The full name of the Google Compute Engine
   * [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks)
   * to which the Endpoint should be peered.
   * Private services access must already be configured for the network. If left
   * unspecified, the Endpoint is not peered with any network.
   * Only one of the fields, [network][google.cloud.aiplatform.v1.Endpoint.network] or
   * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
   * can be set.
   * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
   * `projects/{project}/global/networks/{network}`.
   * Where `{project}` is a project number, as in `12345`, and `{network}` is
   * network name.
   * </pre>
   *
   * <code>string network = 13 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full name of the Google Compute Engine
   * [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks)
   * to which the Endpoint should be peered.
   * Private services access must already be configured for the network. If left
   * unspecified, the Endpoint is not peered with any network.
   * Only one of the fields, [network][google.cloud.aiplatform.v1.Endpoint.network] or
   * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
   * can be set.
   * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
   * `projects/{project}/global/networks/{network}`.
   * Where `{project}` is a project number, as in `12345`, and `{network}` is
   * network name.
   * </pre>
   *
   * <code>string network = 13 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_PRIVATE_SERVICE_CONNECT_FIELD_NUMBER = 17;
  private boolean enablePrivateServiceConnect_;
  /**
   *
   *
   * <pre>
   * Deprecated: If true, expose the Endpoint via private service connect.
   * Only one of the fields, [network][google.cloud.aiplatform.v1.Endpoint.network] or
   * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
   * can be set.
   * </pre>
   *
   * <code>bool enable_private_service_connect = 17 [deprecated = true];</code>
   *
   * @deprecated google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect is deprecated.
   *     See google/cloud/aiplatform/v1/endpoint.proto;l=116
   * @return The enablePrivateServiceConnect.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getEnablePrivateServiceConnect() {
    return enablePrivateServiceConnect_;
  }

  public static final int MODEL_DEPLOYMENT_MONITORING_JOB_FIELD_NUMBER = 14;
  private volatile java.lang.Object modelDeploymentMonitoringJob_;
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the Model Monitoring job associated with this Endpoint
   * if monitoring is enabled by [CreateModelDeploymentMonitoringJob][].
   * Format:
   * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
   * </pre>
   *
   * <code>
   * string model_deployment_monitoring_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The modelDeploymentMonitoringJob.
   */
  @java.lang.Override
  public java.lang.String getModelDeploymentMonitoringJob() {
    java.lang.Object ref = modelDeploymentMonitoringJob_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelDeploymentMonitoringJob_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the Model Monitoring job associated with this Endpoint
   * if monitoring is enabled by [CreateModelDeploymentMonitoringJob][].
   * Format:
   * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
   * </pre>
   *
   * <code>
   * string model_deployment_monitoring_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for modelDeploymentMonitoringJob.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelDeploymentMonitoringJobBytes() {
    java.lang.Object ref = modelDeploymentMonitoringJob_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelDeploymentMonitoringJob_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREDICT_REQUEST_RESPONSE_LOGGING_CONFIG_FIELD_NUMBER = 18;
  private com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig
      predictRequestResponseLoggingConfig_;
  /**
   *
   *
   * <pre>
   * Configures the request-response logging for online prediction.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
   * </code>
   *
   * @return Whether the predictRequestResponseLoggingConfig field is set.
   */
  @java.lang.Override
  public boolean hasPredictRequestResponseLoggingConfig() {
    return predictRequestResponseLoggingConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configures the request-response logging for online prediction.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
   * </code>
   *
   * @return The predictRequestResponseLoggingConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig
      getPredictRequestResponseLoggingConfig() {
    return predictRequestResponseLoggingConfig_ == null
        ? com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig.getDefaultInstance()
        : predictRequestResponseLoggingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configures the request-response logging for online prediction.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfigOrBuilder
      getPredictRequestResponseLoggingConfigOrBuilder() {
    return getPredictRequestResponseLoggingConfig();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    for (int i = 0; i < deployedModels_.size(); i++) {
      output.writeMessage(4, deployedModels_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetTrafficSplit(), TrafficSplitDefaultEntryHolder.defaultEntry, 5);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, etag_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 7);
    if (createTime_ != null) {
      output.writeMessage(8, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(9, getUpdateTime());
    }
    if (encryptionSpec_ != null) {
      output.writeMessage(10, getEncryptionSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelDeploymentMonitoringJob_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, modelDeploymentMonitoringJob_);
    }
    if (enablePrivateServiceConnect_ != false) {
      output.writeBool(17, enablePrivateServiceConnect_);
    }
    if (predictRequestResponseLoggingConfig_ != null) {
      output.writeMessage(18, getPredictRequestResponseLoggingConfig());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    for (int i = 0; i < deployedModels_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, deployedModels_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.Integer> entry :
        internalGetTrafficSplit().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> trafficSplit__ =
          TrafficSplitDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, trafficSplit__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, etag_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, labels__);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getUpdateTime());
    }
    if (encryptionSpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getEncryptionSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelDeploymentMonitoringJob_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              14, modelDeploymentMonitoringJob_);
    }
    if (enablePrivateServiceConnect_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(17, enablePrivateServiceConnect_);
    }
    if (predictRequestResponseLoggingConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18, getPredictRequestResponseLoggingConfig());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.Endpoint)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.Endpoint other = (com.google.cloud.aiplatform.v1.Endpoint) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getDeployedModelsList().equals(other.getDeployedModelsList())) return false;
    if (!internalGetTrafficSplit().equals(other.internalGetTrafficSplit())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (!getNetwork().equals(other.getNetwork())) return false;
    if (getEnablePrivateServiceConnect() != other.getEnablePrivateServiceConnect()) return false;
    if (!getModelDeploymentMonitoringJob().equals(other.getModelDeploymentMonitoringJob()))
      return false;
    if (hasPredictRequestResponseLoggingConfig() != other.hasPredictRequestResponseLoggingConfig())
      return false;
    if (hasPredictRequestResponseLoggingConfig()) {
      if (!getPredictRequestResponseLoggingConfig()
          .equals(other.getPredictRequestResponseLoggingConfig())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getDeployedModelsCount() > 0) {
      hash = (37 * hash) + DEPLOYED_MODELS_FIELD_NUMBER;
      hash = (53 * hash) + getDeployedModelsList().hashCode();
    }
    if (!internalGetTrafficSplit().getMap().isEmpty()) {
      hash = (37 * hash) + TRAFFIC_SPLIT_FIELD_NUMBER;
      hash = (53 * hash) + internalGetTrafficSplit().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    hash = (37 * hash) + ENABLE_PRIVATE_SERVICE_CONNECT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnablePrivateServiceConnect());
    hash = (37 * hash) + MODEL_DEPLOYMENT_MONITORING_JOB_FIELD_NUMBER;
    hash = (53 * hash) + getModelDeploymentMonitoringJob().hashCode();
    if (hasPredictRequestResponseLoggingConfig()) {
      hash = (37 * hash) + PREDICT_REQUEST_RESPONSE_LOGGING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPredictRequestResponseLoggingConfig().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.Endpoint parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Endpoint parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Endpoint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Endpoint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Endpoint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Endpoint parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Endpoint parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Endpoint parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Endpoint parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Endpoint parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Endpoint parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Endpoint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.Endpoint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Models are deployed into it, and afterwards Endpoint is called to obtain
   * predictions and explanations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Endpoint}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Endpoint)
      com.google.cloud.aiplatform.v1.EndpointOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1_Endpoint_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 5:
          return internalGetTrafficSplit();
        case 7:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 5:
          return internalGetMutableTrafficSplit();
        case 7:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1_Endpoint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Endpoint.class,
              com.google.cloud.aiplatform.v1.Endpoint.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.Endpoint.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDeployedModelsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      description_ = "";

      if (deployedModelsBuilder_ == null) {
        deployedModels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        deployedModelsBuilder_.clear();
      }
      internalGetMutableTrafficSplit().clear();
      etag_ = "";

      internalGetMutableLabels().clear();
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = null;
      } else {
        encryptionSpec_ = null;
        encryptionSpecBuilder_ = null;
      }
      network_ = "";

      enablePrivateServiceConnect_ = false;

      modelDeploymentMonitoringJob_ = "";

      if (predictRequestResponseLoggingConfigBuilder_ == null) {
        predictRequestResponseLoggingConfig_ = null;
      } else {
        predictRequestResponseLoggingConfig_ = null;
        predictRequestResponseLoggingConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1_Endpoint_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Endpoint getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.Endpoint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Endpoint build() {
      com.google.cloud.aiplatform.v1.Endpoint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Endpoint buildPartial() {
      com.google.cloud.aiplatform.v1.Endpoint result =
          new com.google.cloud.aiplatform.v1.Endpoint(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.displayName_ = displayName_;
      result.description_ = description_;
      if (deployedModelsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          deployedModels_ = java.util.Collections.unmodifiableList(deployedModels_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.deployedModels_ = deployedModels_;
      } else {
        result.deployedModels_ = deployedModelsBuilder_.build();
      }
      result.trafficSplit_ = internalGetTrafficSplit();
      result.trafficSplit_.makeImmutable();
      result.etag_ = etag_;
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      if (encryptionSpecBuilder_ == null) {
        result.encryptionSpec_ = encryptionSpec_;
      } else {
        result.encryptionSpec_ = encryptionSpecBuilder_.build();
      }
      result.network_ = network_;
      result.enablePrivateServiceConnect_ = enablePrivateServiceConnect_;
      result.modelDeploymentMonitoringJob_ = modelDeploymentMonitoringJob_;
      if (predictRequestResponseLoggingConfigBuilder_ == null) {
        result.predictRequestResponseLoggingConfig_ = predictRequestResponseLoggingConfig_;
      } else {
        result.predictRequestResponseLoggingConfig_ =
            predictRequestResponseLoggingConfigBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.Endpoint) {
        return mergeFrom((com.google.cloud.aiplatform.v1.Endpoint) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.Endpoint other) {
      if (other == com.google.cloud.aiplatform.v1.Endpoint.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (deployedModelsBuilder_ == null) {
        if (!other.deployedModels_.isEmpty()) {
          if (deployedModels_.isEmpty()) {
            deployedModels_ = other.deployedModels_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureDeployedModelsIsMutable();
            deployedModels_.addAll(other.deployedModels_);
          }
          onChanged();
        }
      } else {
        if (!other.deployedModels_.isEmpty()) {
          if (deployedModelsBuilder_.isEmpty()) {
            deployedModelsBuilder_.dispose();
            deployedModelsBuilder_ = null;
            deployedModels_ = other.deployedModels_;
            bitField0_ = (bitField0_ & ~0x00000001);
            deployedModelsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDeployedModelsFieldBuilder()
                    : null;
          } else {
            deployedModelsBuilder_.addAllMessages(other.deployedModels_);
          }
        }
      }
      internalGetMutableTrafficSplit().mergeFrom(other.internalGetTrafficSplit());
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        onChanged();
      }
      if (other.getEnablePrivateServiceConnect() != false) {
        setEnablePrivateServiceConnect(other.getEnablePrivateServiceConnect());
      }
      if (!other.getModelDeploymentMonitoringJob().isEmpty()) {
        modelDeploymentMonitoringJob_ = other.modelDeploymentMonitoringJob_;
        onChanged();
      }
      if (other.hasPredictRequestResponseLoggingConfig()) {
        mergePredictRequestResponseLoggingConfig(other.getPredictRequestResponseLoggingConfig());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1.Endpoint parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.aiplatform.v1.Endpoint) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Endpoint.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Endpoint.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Endpoint.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Endpoint.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Endpoint.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The display name of the Endpoint.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Endpoint.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Endpoint.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Endpoint.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Endpoint.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The description of the Endpoint.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the Endpoint.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the Endpoint.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the Endpoint.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the Endpoint.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.DeployedModel> deployedModels_ =
        java.util.Collections.emptyList();

    private void ensureDeployedModelsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        deployedModels_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.DeployedModel>(deployedModels_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeployedModel,
            com.google.cloud.aiplatform.v1.DeployedModel.Builder,
            com.google.cloud.aiplatform.v1.DeployedModelOrBuilder>
        deployedModelsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.DeployedModel> getDeployedModelsList() {
      if (deployedModelsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(deployedModels_);
      } else {
        return deployedModelsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getDeployedModelsCount() {
      if (deployedModelsBuilder_ == null) {
        return deployedModels_.size();
      } else {
        return deployedModelsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedModel getDeployedModels(int index) {
      if (deployedModelsBuilder_ == null) {
        return deployedModels_.get(index);
      } else {
        return deployedModelsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeployedModels(
        int index, com.google.cloud.aiplatform.v1.DeployedModel value) {
      if (deployedModelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployedModelsIsMutable();
        deployedModels_.set(index, value);
        onChanged();
      } else {
        deployedModelsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeployedModels(
        int index, com.google.cloud.aiplatform.v1.DeployedModel.Builder builderForValue) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        deployedModels_.set(index, builderForValue.build());
        onChanged();
      } else {
        deployedModelsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDeployedModels(com.google.cloud.aiplatform.v1.DeployedModel value) {
      if (deployedModelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployedModelsIsMutable();
        deployedModels_.add(value);
        onChanged();
      } else {
        deployedModelsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDeployedModels(
        int index, com.google.cloud.aiplatform.v1.DeployedModel value) {
      if (deployedModelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployedModelsIsMutable();
        deployedModels_.add(index, value);
        onChanged();
      } else {
        deployedModelsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDeployedModels(
        com.google.cloud.aiplatform.v1.DeployedModel.Builder builderForValue) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        deployedModels_.add(builderForValue.build());
        onChanged();
      } else {
        deployedModelsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDeployedModels(
        int index, com.google.cloud.aiplatform.v1.DeployedModel.Builder builderForValue) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        deployedModels_.add(index, builderForValue.build());
        onChanged();
      } else {
        deployedModelsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllDeployedModels(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.DeployedModel> values) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, deployedModels_);
        onChanged();
      } else {
        deployedModelsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeployedModels() {
      if (deployedModelsBuilder_ == null) {
        deployedModels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        deployedModelsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeDeployedModels(int index) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        deployedModels_.remove(index);
        onChanged();
      } else {
        deployedModelsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedModel.Builder getDeployedModelsBuilder(
        int index) {
      return getDeployedModelsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedModelOrBuilder getDeployedModelsOrBuilder(
        int index) {
      if (deployedModelsBuilder_ == null) {
        return deployedModels_.get(index);
      } else {
        return deployedModelsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.DeployedModelOrBuilder>
        getDeployedModelsOrBuilderList() {
      if (deployedModelsBuilder_ != null) {
        return deployedModelsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(deployedModels_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedModel.Builder addDeployedModelsBuilder() {
      return getDeployedModelsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.DeployedModel.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedModel.Builder addDeployedModelsBuilder(
        int index) {
      return getDeployedModelsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1.DeployedModel.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel] and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel] respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.DeployedModel.Builder>
        getDeployedModelsBuilderList() {
      return getDeployedModelsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeployedModel,
            com.google.cloud.aiplatform.v1.DeployedModel.Builder,
            com.google.cloud.aiplatform.v1.DeployedModelOrBuilder>
        getDeployedModelsFieldBuilder() {
      if (deployedModelsBuilder_ == null) {
        deployedModelsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.DeployedModel,
                com.google.cloud.aiplatform.v1.DeployedModel.Builder,
                com.google.cloud.aiplatform.v1.DeployedModelOrBuilder>(
                deployedModels_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        deployedModels_ = null;
      }
      return deployedModelsBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer> trafficSplit_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetTrafficSplit() {
      if (trafficSplit_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            TrafficSplitDefaultEntryHolder.defaultEntry);
      }
      return trafficSplit_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetMutableTrafficSplit() {
      onChanged();
      ;
      if (trafficSplit_ == null) {
        trafficSplit_ =
            com.google.protobuf.MapField.newMapField(TrafficSplitDefaultEntryHolder.defaultEntry);
      }
      if (!trafficSplit_.isMutable()) {
        trafficSplit_ = trafficSplit_.copy();
      }
      return trafficSplit_;
    }

    public int getTrafficSplitCount() {
      return internalGetTrafficSplit().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     * If a DeployedModel's ID is not listed in this map, then it receives no
     * traffic.
     * The traffic percentage values must add up to 100, or map must be empty if
     * the Endpoint is to not accept any traffic at a moment.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
     */
    @java.lang.Override
    public boolean containsTrafficSplit(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetTrafficSplit().getMap().containsKey(key);
    }
    /** Use {@link #getTrafficSplitMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getTrafficSplit() {
      return getTrafficSplitMap();
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     * If a DeployedModel's ID is not listed in this map, then it receives no
     * traffic.
     * The traffic percentage values must add up to 100, or map must be empty if
     * the Endpoint is to not accept any traffic at a moment.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Integer> getTrafficSplitMap() {
      return internalGetTrafficSplit().getMap();
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     * If a DeployedModel's ID is not listed in this map, then it receives no
     * traffic.
     * The traffic percentage values must add up to 100, or map must be empty if
     * the Endpoint is to not accept any traffic at a moment.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
     */
    @java.lang.Override
    public int getTrafficSplitOrDefault(java.lang.String key, int defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map = internalGetTrafficSplit().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     * If a DeployedModel's ID is not listed in this map, then it receives no
     * traffic.
     * The traffic percentage values must add up to 100, or map must be empty if
     * the Endpoint is to not accept any traffic at a moment.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
     */
    @java.lang.Override
    public int getTrafficSplitOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map = internalGetTrafficSplit().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearTrafficSplit() {
      internalGetMutableTrafficSplit().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     * If a DeployedModel's ID is not listed in this map, then it receives no
     * traffic.
     * The traffic percentage values must add up to 100, or map must be empty if
     * the Endpoint is to not accept any traffic at a moment.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
     */
    public Builder removeTrafficSplit(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableTrafficSplit().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getMutableTrafficSplit() {
      return internalGetMutableTrafficSplit().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     * If a DeployedModel's ID is not listed in this map, then it receives no
     * traffic.
     * The traffic percentage values must add up to 100, or map must be empty if
     * the Endpoint is to not accept any traffic at a moment.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
     */
    public Builder putTrafficSplit(java.lang.String key, int value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableTrafficSplit().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     * If a DeployedModel's ID is not listed in this map, then it receives no
     * traffic.
     * The traffic percentage values must add up to 100, or map must be empty if
     * the Endpoint is to not accept any traffic at a moment.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
     */
    public Builder putAllTrafficSplit(java.util.Map<java.lang.String, java.lang.Integer> values) {
      internalGetMutableTrafficSplit().getMutableMap().putAll(values);
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      etag_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {

      etag_ = getDefaultInstance().getEtag();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      etag_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Endpoints.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Endpoints.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Endpoints.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Endpoints.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Endpoints.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Endpoints.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Endpoints.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.cloud.aiplatform.v1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EncryptionSpec,
            com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for an Endpoint. If set, this
     * Endpoint and all sub-resources of this Endpoint will be secured by
     * this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 10;</code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return encryptionSpecBuilder_ != null || encryptionSpec_ != null;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for an Endpoint. If set, this
     * Endpoint and all sub-resources of this Endpoint will be secured by
     * this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 10;</code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for an Endpoint. If set, this
     * Endpoint and all sub-resources of this Endpoint will be secured by
     * this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 10;</code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
        onChanged();
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for an Endpoint. If set, this
     * Endpoint and all sub-resources of this Endpoint will be secured by
     * this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 10;</code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
        onChanged();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for an Endpoint. If set, this
     * Endpoint and all sub-resources of this Endpoint will be secured by
     * this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 10;</code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (encryptionSpec_ != null) {
          encryptionSpec_ =
              com.google.cloud.aiplatform.v1.EncryptionSpec.newBuilder(encryptionSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          encryptionSpec_ = value;
        }
        onChanged();
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for an Endpoint. If set, this
     * Endpoint and all sub-resources of this Endpoint will be secured by
     * this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 10;</code>
     */
    public Builder clearEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = null;
        onChanged();
      } else {
        encryptionSpec_ = null;
        encryptionSpecBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for an Endpoint. If set, this
     * Endpoint and all sub-resources of this Endpoint will be secured by
     * this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 10;</code>
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpec.Builder getEncryptionSpecBuilder() {

      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for an Endpoint. If set, this
     * Endpoint and all sub-resources of this Endpoint will be secured by
     * this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 10;</code>
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for an Endpoint. If set, this
     * Endpoint and all sub-resources of this Endpoint will be secured by
     * this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EncryptionSpec,
            com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.EncryptionSpec,
                com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * The full name of the Google Compute Engine
     * [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks)
     * to which the Endpoint should be peered.
     * Private services access must already be configured for the network. If left
     * unspecified, the Endpoint is not peered with any network.
     * Only one of the fields, [network][google.cloud.aiplatform.v1.Endpoint.network] or
     * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
     * can be set.
     * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
     * `projects/{project}/global/networks/{network}`.
     * Where `{project}` is a project number, as in `12345`, and `{network}` is
     * network name.
     * </pre>
     *
     * <code>string network = 13 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the Google Compute Engine
     * [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks)
     * to which the Endpoint should be peered.
     * Private services access must already be configured for the network. If left
     * unspecified, the Endpoint is not peered with any network.
     * Only one of the fields, [network][google.cloud.aiplatform.v1.Endpoint.network] or
     * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
     * can be set.
     * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
     * `projects/{project}/global/networks/{network}`.
     * Where `{project}` is a project number, as in `12345`, and `{network}` is
     * network name.
     * </pre>
     *
     * <code>string network = 13 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the Google Compute Engine
     * [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks)
     * to which the Endpoint should be peered.
     * Private services access must already be configured for the network. If left
     * unspecified, the Endpoint is not peered with any network.
     * Only one of the fields, [network][google.cloud.aiplatform.v1.Endpoint.network] or
     * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
     * can be set.
     * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
     * `projects/{project}/global/networks/{network}`.
     * Where `{project}` is a project number, as in `12345`, and `{network}` is
     * network name.
     * </pre>
     *
     * <code>string network = 13 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      network_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the Google Compute Engine
     * [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks)
     * to which the Endpoint should be peered.
     * Private services access must already be configured for the network. If left
     * unspecified, the Endpoint is not peered with any network.
     * Only one of the fields, [network][google.cloud.aiplatform.v1.Endpoint.network] or
     * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
     * can be set.
     * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
     * `projects/{project}/global/networks/{network}`.
     * Where `{project}` is a project number, as in `12345`, and `{network}` is
     * network name.
     * </pre>
     *
     * <code>string network = 13 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {

      network_ = getDefaultInstance().getNetwork();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the Google Compute Engine
     * [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks)
     * to which the Endpoint should be peered.
     * Private services access must already be configured for the network. If left
     * unspecified, the Endpoint is not peered with any network.
     * Only one of the fields, [network][google.cloud.aiplatform.v1.Endpoint.network] or
     * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
     * can be set.
     * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
     * `projects/{project}/global/networks/{network}`.
     * Where `{project}` is a project number, as in `12345`, and `{network}` is
     * network name.
     * </pre>
     *
     * <code>string network = 13 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      network_ = value;
      onChanged();
      return this;
    }

    private boolean enablePrivateServiceConnect_;
    /**
     *
     *
     * <pre>
     * Deprecated: If true, expose the Endpoint via private service connect.
     * Only one of the fields, [network][google.cloud.aiplatform.v1.Endpoint.network] or
     * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
     * can be set.
     * </pre>
     *
     * <code>bool enable_private_service_connect = 17 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect is deprecated.
     *     See google/cloud/aiplatform/v1/endpoint.proto;l=116
     * @return The enablePrivateServiceConnect.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getEnablePrivateServiceConnect() {
      return enablePrivateServiceConnect_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: If true, expose the Endpoint via private service connect.
     * Only one of the fields, [network][google.cloud.aiplatform.v1.Endpoint.network] or
     * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
     * can be set.
     * </pre>
     *
     * <code>bool enable_private_service_connect = 17 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect is deprecated.
     *     See google/cloud/aiplatform/v1/endpoint.proto;l=116
     * @param value The enablePrivateServiceConnect to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setEnablePrivateServiceConnect(boolean value) {

      enablePrivateServiceConnect_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: If true, expose the Endpoint via private service connect.
     * Only one of the fields, [network][google.cloud.aiplatform.v1.Endpoint.network] or
     * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
     * can be set.
     * </pre>
     *
     * <code>bool enable_private_service_connect = 17 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect is deprecated.
     *     See google/cloud/aiplatform/v1/endpoint.proto;l=116
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearEnablePrivateServiceConnect() {

      enablePrivateServiceConnect_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object modelDeploymentMonitoringJob_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the Model Monitoring job associated with this Endpoint
     * if monitoring is enabled by [CreateModelDeploymentMonitoringJob][].
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The modelDeploymentMonitoringJob.
     */
    public java.lang.String getModelDeploymentMonitoringJob() {
      java.lang.Object ref = modelDeploymentMonitoringJob_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelDeploymentMonitoringJob_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the Model Monitoring job associated with this Endpoint
     * if monitoring is enabled by [CreateModelDeploymentMonitoringJob][].
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for modelDeploymentMonitoringJob.
     */
    public com.google.protobuf.ByteString getModelDeploymentMonitoringJobBytes() {
      java.lang.Object ref = modelDeploymentMonitoringJob_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelDeploymentMonitoringJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the Model Monitoring job associated with this Endpoint
     * if monitoring is enabled by [CreateModelDeploymentMonitoringJob][].
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The modelDeploymentMonitoringJob to set.
     * @return This builder for chaining.
     */
    public Builder setModelDeploymentMonitoringJob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      modelDeploymentMonitoringJob_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the Model Monitoring job associated with this Endpoint
     * if monitoring is enabled by [CreateModelDeploymentMonitoringJob][].
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelDeploymentMonitoringJob() {

      modelDeploymentMonitoringJob_ = getDefaultInstance().getModelDeploymentMonitoringJob();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the Model Monitoring job associated with this Endpoint
     * if monitoring is enabled by [CreateModelDeploymentMonitoringJob][].
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for modelDeploymentMonitoringJob to set.
     * @return This builder for chaining.
     */
    public Builder setModelDeploymentMonitoringJobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      modelDeploymentMonitoringJob_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig
        predictRequestResponseLoggingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig,
            com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig.Builder,
            com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfigOrBuilder>
        predictRequestResponseLoggingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configures the request-response logging for online prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
     * </code>
     *
     * @return Whether the predictRequestResponseLoggingConfig field is set.
     */
    public boolean hasPredictRequestResponseLoggingConfig() {
      return predictRequestResponseLoggingConfigBuilder_ != null
          || predictRequestResponseLoggingConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Configures the request-response logging for online prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
     * </code>
     *
     * @return The predictRequestResponseLoggingConfig.
     */
    public com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig
        getPredictRequestResponseLoggingConfig() {
      if (predictRequestResponseLoggingConfigBuilder_ == null) {
        return predictRequestResponseLoggingConfig_ == null
            ? com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig
                .getDefaultInstance()
            : predictRequestResponseLoggingConfig_;
      } else {
        return predictRequestResponseLoggingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configures the request-response logging for online prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
     * </code>
     */
    public Builder setPredictRequestResponseLoggingConfig(
        com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig value) {
      if (predictRequestResponseLoggingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        predictRequestResponseLoggingConfig_ = value;
        onChanged();
      } else {
        predictRequestResponseLoggingConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the request-response logging for online prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
     * </code>
     */
    public Builder setPredictRequestResponseLoggingConfig(
        com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig.Builder
            builderForValue) {
      if (predictRequestResponseLoggingConfigBuilder_ == null) {
        predictRequestResponseLoggingConfig_ = builderForValue.build();
        onChanged();
      } else {
        predictRequestResponseLoggingConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the request-response logging for online prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
     * </code>
     */
    public Builder mergePredictRequestResponseLoggingConfig(
        com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig value) {
      if (predictRequestResponseLoggingConfigBuilder_ == null) {
        if (predictRequestResponseLoggingConfig_ != null) {
          predictRequestResponseLoggingConfig_ =
              com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig.newBuilder(
                      predictRequestResponseLoggingConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          predictRequestResponseLoggingConfig_ = value;
        }
        onChanged();
      } else {
        predictRequestResponseLoggingConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the request-response logging for online prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
     * </code>
     */
    public Builder clearPredictRequestResponseLoggingConfig() {
      if (predictRequestResponseLoggingConfigBuilder_ == null) {
        predictRequestResponseLoggingConfig_ = null;
        onChanged();
      } else {
        predictRequestResponseLoggingConfig_ = null;
        predictRequestResponseLoggingConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the request-response logging for online prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig.Builder
        getPredictRequestResponseLoggingConfigBuilder() {

      onChanged();
      return getPredictRequestResponseLoggingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configures the request-response logging for online prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfigOrBuilder
        getPredictRequestResponseLoggingConfigOrBuilder() {
      if (predictRequestResponseLoggingConfigBuilder_ != null) {
        return predictRequestResponseLoggingConfigBuilder_.getMessageOrBuilder();
      } else {
        return predictRequestResponseLoggingConfig_ == null
            ? com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig
                .getDefaultInstance()
            : predictRequestResponseLoggingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configures the request-response logging for online prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig,
            com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig.Builder,
            com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfigOrBuilder>
        getPredictRequestResponseLoggingConfigFieldBuilder() {
      if (predictRequestResponseLoggingConfigBuilder_ == null) {
        predictRequestResponseLoggingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig,
                com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfig.Builder,
                com.google.cloud.aiplatform.v1.PredictRequestResponseLoggingConfigOrBuilder>(
                getPredictRequestResponseLoggingConfig(), getParentForChildren(), isClean());
        predictRequestResponseLoggingConfig_ = null;
      }
      return predictRequestResponseLoggingConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Endpoint)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Endpoint)
  private static final com.google.cloud.aiplatform.v1.Endpoint DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Endpoint();
  }

  public static com.google.cloud.aiplatform.v1.Endpoint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Endpoint> PARSER =
      new com.google.protobuf.AbstractParser<Endpoint>() {
        @java.lang.Override
        public Endpoint parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Endpoint(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Endpoint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Endpoint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Endpoint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
