/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/endpoint.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * A deployment of a Model. Endpoints contain one or more DeployedModels.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.DeployedModel}
 */
public final class DeployedModel extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.DeployedModel)
    DeployedModelOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DeployedModel.newBuilder() to construct.
  private DeployedModel(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DeployedModel() {
    id_ = "";
    model_ = "";
    modelVersionId_ = "";
    displayName_ = "";
    serviceAccount_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DeployedModel();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private DeployedModel(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              id_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              model_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 50:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 58:
            {
              com.google.cloud.aiplatform.v1.DedicatedResources.Builder subBuilder = null;
              if (predictionResourcesCase_ == 7) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_)
                        .toBuilder();
              }
              predictionResources_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.DedicatedResources.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_);
                predictionResources_ = subBuilder.buildPartial();
              }
              predictionResourcesCase_ = 7;
              break;
            }
          case 66:
            {
              com.google.cloud.aiplatform.v1.AutomaticResources.Builder subBuilder = null;
              if (predictionResourcesCase_ == 8) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_)
                        .toBuilder();
              }
              predictionResources_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.AutomaticResources.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_);
                predictionResources_ = subBuilder.buildPartial();
              }
              predictionResourcesCase_ = 8;
              break;
            }
          case 74:
            {
              com.google.cloud.aiplatform.v1.ExplanationSpec.Builder subBuilder = null;
              if (explanationSpec_ != null) {
                subBuilder = explanationSpec_.toBuilder();
              }
              explanationSpec_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.ExplanationSpec.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(explanationSpec_);
                explanationSpec_ = subBuilder.buildPartial();
              }

              break;
            }
          case 90:
            {
              java.lang.String s = input.readStringRequireUtf8();

              serviceAccount_ = s;
              break;
            }
          case 104:
            {
              enableAccessLogging_ = input.readBool();
              break;
            }
          case 114:
            {
              com.google.cloud.aiplatform.v1.PrivateEndpoints.Builder subBuilder = null;
              if (privateEndpoints_ != null) {
                subBuilder = privateEndpoints_.toBuilder();
              }
              privateEndpoints_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.PrivateEndpoints.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(privateEndpoints_);
                privateEndpoints_ = subBuilder.buildPartial();
              }

              break;
            }
          case 120:
            {
              disableContainerLogging_ = input.readBool();
              break;
            }
          case 146:
            {
              java.lang.String s = input.readStringRequireUtf8();

              modelVersionId_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.EndpointProto
        .internal_static_google_cloud_aiplatform_v1_DeployedModel_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.EndpointProto
        .internal_static_google_cloud_aiplatform_v1_DeployedModel_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.DeployedModel.class,
            com.google.cloud.aiplatform.v1.DeployedModel.Builder.class);
  }

  private int predictionResourcesCase_ = 0;
  private java.lang.Object predictionResources_;

  public enum PredictionResourcesCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DEDICATED_RESOURCES(7),
    AUTOMATIC_RESOURCES(8),
    PREDICTIONRESOURCES_NOT_SET(0);
    private final int value;

    private PredictionResourcesCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PredictionResourcesCase valueOf(int value) {
      return forNumber(value);
    }

    public static PredictionResourcesCase forNumber(int value) {
      switch (value) {
        case 7:
          return DEDICATED_RESOURCES;
        case 8:
          return AUTOMATIC_RESOURCES;
        case 0:
          return PREDICTIONRESOURCES_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PredictionResourcesCase getPredictionResourcesCase() {
    return PredictionResourcesCase.forNumber(predictionResourcesCase_);
  }

  public static final int DEDICATED_RESOURCES_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * A description of resources that are dedicated to the DeployedModel, and
   * that need a higher degree of manual configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
   *
   * @return Whether the dedicatedResources field is set.
   */
  @java.lang.Override
  public boolean hasDedicatedResources() {
    return predictionResourcesCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * A description of resources that are dedicated to the DeployedModel, and
   * that need a higher degree of manual configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
   *
   * @return The dedicatedResources.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DedicatedResources getDedicatedResources() {
    if (predictionResourcesCase_ == 7) {
      return (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_;
    }
    return com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A description of resources that are dedicated to the DeployedModel, and
   * that need a higher degree of manual configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DedicatedResourcesOrBuilder
      getDedicatedResourcesOrBuilder() {
    if (predictionResourcesCase_ == 7) {
      return (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_;
    }
    return com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance();
  }

  public static final int AUTOMATIC_RESOURCES_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * A description of resources that to large degree are decided by Vertex
   * AI, and require only a modest additional configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
   *
   * @return Whether the automaticResources field is set.
   */
  @java.lang.Override
  public boolean hasAutomaticResources() {
    return predictionResourcesCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * A description of resources that to large degree are decided by Vertex
   * AI, and require only a modest additional configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
   *
   * @return The automaticResources.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.AutomaticResources getAutomaticResources() {
    if (predictionResourcesCase_ == 8) {
      return (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_;
    }
    return com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A description of resources that to large degree are decided by Vertex
   * AI, and require only a modest additional configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.AutomaticResourcesOrBuilder
      getAutomaticResourcesOrBuilder() {
    if (predictionResourcesCase_ == 8) {
      return (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_;
    }
    return com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance();
  }

  public static final int ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object id_;
  /**
   *
   *
   * <pre>
   * Immutable. The ID of the DeployedModel. If not provided upon deployment, Vertex AI
   * will generate a value for this ID.
   * This value should be 1-10 characters, and valid characters are /[0-9]/.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The ID of the DeployedModel. If not provided upon deployment, Vertex AI
   * will generate a value for this ID.
   * This value should be 1-10 characters, and valid characters are /[0-9]/.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_FIELD_NUMBER = 2;
  private volatile java.lang.Object model_;
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Model that this is the deployment of. Note that
   * the Model may be in a different location than the DeployedModel's Endpoint.
   * The resource name may contain version id or version alias to specify the
   * version, if no version is specified, the default version will be deployed.
   * </pre>
   *
   * <code>
   * string model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The model.
   */
  @java.lang.Override
  public java.lang.String getModel() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      model_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Model that this is the deployment of. Note that
   * the Model may be in a different location than the DeployedModel's Endpoint.
   * The resource name may contain version id or version alias to specify the
   * version, if no version is specified, the default version will be deployed.
   * </pre>
   *
   * <code>
   * string model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for model.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelBytes() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      model_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_VERSION_ID_FIELD_NUMBER = 18;
  private volatile java.lang.Object modelVersionId_;
  /**
   *
   *
   * <pre>
   * Output only. The version ID of the model that is deployed.
   * </pre>
   *
   * <code>string model_version_id = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The modelVersionId.
   */
  @java.lang.Override
  public java.lang.String getModelVersionId() {
    java.lang.Object ref = modelVersionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelVersionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The version ID of the model that is deployed.
   * </pre>
   *
   * <code>string model_version_id = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for modelVersionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelVersionIdBytes() {
    java.lang.Object ref = modelVersionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelVersionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 3;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * The display name of the DeployedModel. If not provided upon creation,
   * the Model's display_name is used.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the DeployedModel. If not provided upon creation,
   * the Model's display_name is used.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the DeployedModel was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the DeployedModel was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the DeployedModel was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int EXPLANATION_SPEC_FIELD_NUMBER = 9;
  private com.google.cloud.aiplatform.v1.ExplanationSpec explanationSpec_;
  /**
   *
   *
   * <pre>
   * Explanation configuration for this DeployedModel.
   * When deploying a Model using [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel], this value
   * overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]. All fields of
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] are optional in the request. If a field of
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] is not populated, the value of the same field of
   * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is inherited. If the corresponding
   * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is not populated, all fields of the
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] will be used for the explanation configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
   *
   * @return Whether the explanationSpec field is set.
   */
  @java.lang.Override
  public boolean hasExplanationSpec() {
    return explanationSpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * Explanation configuration for this DeployedModel.
   * When deploying a Model using [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel], this value
   * overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]. All fields of
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] are optional in the request. If a field of
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] is not populated, the value of the same field of
   * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is inherited. If the corresponding
   * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is not populated, all fields of the
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] will be used for the explanation configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
   *
   * @return The explanationSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExplanationSpec getExplanationSpec() {
    return explanationSpec_ == null
        ? com.google.cloud.aiplatform.v1.ExplanationSpec.getDefaultInstance()
        : explanationSpec_;
  }
  /**
   *
   *
   * <pre>
   * Explanation configuration for this DeployedModel.
   * When deploying a Model using [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel], this value
   * overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]. All fields of
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] are optional in the request. If a field of
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] is not populated, the value of the same field of
   * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is inherited. If the corresponding
   * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is not populated, all fields of the
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] will be used for the explanation configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder getExplanationSpecOrBuilder() {
    return getExplanationSpec();
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 11;
  private volatile java.lang.Object serviceAccount_;
  /**
   *
   *
   * <pre>
   * The service account that the DeployedModel's container runs as. Specify the
   * email address of the service account. If this service account is not
   * specified, the container runs as a service account that doesn't have access
   * to the resource project.
   * Users deploying the Model must have the `iam.serviceAccounts.actAs`
   * permission on this service account.
   * </pre>
   *
   * <code>string service_account = 11;</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The service account that the DeployedModel's container runs as. Specify the
   * email address of the service account. If this service account is not
   * specified, the container runs as a service account that doesn't have access
   * to the resource project.
   * Users deploying the Model must have the `iam.serviceAccounts.actAs`
   * permission on this service account.
   * </pre>
   *
   * <code>string service_account = 11;</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISABLE_CONTAINER_LOGGING_FIELD_NUMBER = 15;
  private boolean disableContainerLogging_;
  /**
   *
   *
   * <pre>
   * For custom-trained Models and AutoML Tabular Models, the container of the
   * DeployedModel instances will send `stderr` and `stdout` streams to
   * Stackdriver Logging by default. Please note that the logs incur cost,
   * which are subject to [Cloud Logging
   * pricing](https://cloud.google.com/stackdriver/pricing).
   * User can disable container logging by setting this flag to true.
   * </pre>
   *
   * <code>bool disable_container_logging = 15;</code>
   *
   * @return The disableContainerLogging.
   */
  @java.lang.Override
  public boolean getDisableContainerLogging() {
    return disableContainerLogging_;
  }

  public static final int ENABLE_ACCESS_LOGGING_FIELD_NUMBER = 13;
  private boolean enableAccessLogging_;
  /**
   *
   *
   * <pre>
   * These logs are like standard server access logs, containing
   * information like timestamp and latency for each prediction request.
   * Note that Stackdriver logs may incur a cost, especially if your project
   * receives prediction requests at a high queries per second rate (QPS).
   * Estimate your costs before enabling this option.
   * </pre>
   *
   * <code>bool enable_access_logging = 13;</code>
   *
   * @return The enableAccessLogging.
   */
  @java.lang.Override
  public boolean getEnableAccessLogging() {
    return enableAccessLogging_;
  }

  public static final int PRIVATE_ENDPOINTS_FIELD_NUMBER = 14;
  private com.google.cloud.aiplatform.v1.PrivateEndpoints privateEndpoints_;
  /**
   *
   *
   * <pre>
   * Output only. Provide paths for users to send predict/explain/health requests directly to
   * the deployed model services running on Cloud via private services access.
   * This field is populated if [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the privateEndpoints field is set.
   */
  @java.lang.Override
  public boolean hasPrivateEndpoints() {
    return privateEndpoints_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Provide paths for users to send predict/explain/health requests directly to
   * the deployed model services running on Cloud via private services access.
   * This field is populated if [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The privateEndpoints.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PrivateEndpoints getPrivateEndpoints() {
    return privateEndpoints_ == null
        ? com.google.cloud.aiplatform.v1.PrivateEndpoints.getDefaultInstance()
        : privateEndpoints_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Provide paths for users to send predict/explain/health requests directly to
   * the deployed model services running on Cloud via private services access.
   * This field is populated if [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PrivateEndpointsOrBuilder getPrivateEndpointsOrBuilder() {
    return getPrivateEndpoints();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, model_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
    }
    if (createTime_ != null) {
      output.writeMessage(6, getCreateTime());
    }
    if (predictionResourcesCase_ == 7) {
      output.writeMessage(
          7, (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_);
    }
    if (predictionResourcesCase_ == 8) {
      output.writeMessage(
          8, (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_);
    }
    if (explanationSpec_ != null) {
      output.writeMessage(9, getExplanationSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, serviceAccount_);
    }
    if (enableAccessLogging_ != false) {
      output.writeBool(13, enableAccessLogging_);
    }
    if (privateEndpoints_ != null) {
      output.writeMessage(14, getPrivateEndpoints());
    }
    if (disableContainerLogging_ != false) {
      output.writeBool(15, disableContainerLogging_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, modelVersionId_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, model_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (predictionResourcesCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_);
    }
    if (predictionResourcesCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_);
    }
    if (explanationSpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getExplanationSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, serviceAccount_);
    }
    if (enableAccessLogging_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, enableAccessLogging_);
    }
    if (privateEndpoints_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getPrivateEndpoints());
    }
    if (disableContainerLogging_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(15, disableContainerLogging_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, modelVersionId_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.DeployedModel)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.DeployedModel other =
        (com.google.cloud.aiplatform.v1.DeployedModel) obj;

    if (!getId().equals(other.getId())) return false;
    if (!getModel().equals(other.getModel())) return false;
    if (!getModelVersionId().equals(other.getModelVersionId())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasExplanationSpec() != other.hasExplanationSpec()) return false;
    if (hasExplanationSpec()) {
      if (!getExplanationSpec().equals(other.getExplanationSpec())) return false;
    }
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (getDisableContainerLogging() != other.getDisableContainerLogging()) return false;
    if (getEnableAccessLogging() != other.getEnableAccessLogging()) return false;
    if (hasPrivateEndpoints() != other.hasPrivateEndpoints()) return false;
    if (hasPrivateEndpoints()) {
      if (!getPrivateEndpoints().equals(other.getPrivateEndpoints())) return false;
    }
    if (!getPredictionResourcesCase().equals(other.getPredictionResourcesCase())) return false;
    switch (predictionResourcesCase_) {
      case 7:
        if (!getDedicatedResources().equals(other.getDedicatedResources())) return false;
        break;
      case 8:
        if (!getAutomaticResources().equals(other.getAutomaticResources())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getModel().hashCode();
    hash = (37 * hash) + MODEL_VERSION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getModelVersionId().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasExplanationSpec()) {
      hash = (37 * hash) + EXPLANATION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getExplanationSpec().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (37 * hash) + DISABLE_CONTAINER_LOGGING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableContainerLogging());
    hash = (37 * hash) + ENABLE_ACCESS_LOGGING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableAccessLogging());
    if (hasPrivateEndpoints()) {
      hash = (37 * hash) + PRIVATE_ENDPOINTS_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateEndpoints().hashCode();
    }
    switch (predictionResourcesCase_) {
      case 7:
        hash = (37 * hash) + DEDICATED_RESOURCES_FIELD_NUMBER;
        hash = (53 * hash) + getDedicatedResources().hashCode();
        break;
      case 8:
        hash = (37 * hash) + AUTOMATIC_RESOURCES_FIELD_NUMBER;
        hash = (53 * hash) + getAutomaticResources().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.DeployedModel prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A deployment of a Model. Endpoints contain one or more DeployedModels.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.DeployedModel}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.DeployedModel)
      com.google.cloud.aiplatform.v1.DeployedModelOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1_DeployedModel_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1_DeployedModel_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.DeployedModel.class,
              com.google.cloud.aiplatform.v1.DeployedModel.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.DeployedModel.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      id_ = "";

      model_ = "";

      modelVersionId_ = "";

      displayName_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (explanationSpecBuilder_ == null) {
        explanationSpec_ = null;
      } else {
        explanationSpec_ = null;
        explanationSpecBuilder_ = null;
      }
      serviceAccount_ = "";

      disableContainerLogging_ = false;

      enableAccessLogging_ = false;

      if (privateEndpointsBuilder_ == null) {
        privateEndpoints_ = null;
      } else {
        privateEndpoints_ = null;
        privateEndpointsBuilder_ = null;
      }
      predictionResourcesCase_ = 0;
      predictionResources_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1_DeployedModel_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeployedModel getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.DeployedModel.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeployedModel build() {
      com.google.cloud.aiplatform.v1.DeployedModel result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeployedModel buildPartial() {
      com.google.cloud.aiplatform.v1.DeployedModel result =
          new com.google.cloud.aiplatform.v1.DeployedModel(this);
      if (predictionResourcesCase_ == 7) {
        if (dedicatedResourcesBuilder_ == null) {
          result.predictionResources_ = predictionResources_;
        } else {
          result.predictionResources_ = dedicatedResourcesBuilder_.build();
        }
      }
      if (predictionResourcesCase_ == 8) {
        if (automaticResourcesBuilder_ == null) {
          result.predictionResources_ = predictionResources_;
        } else {
          result.predictionResources_ = automaticResourcesBuilder_.build();
        }
      }
      result.id_ = id_;
      result.model_ = model_;
      result.modelVersionId_ = modelVersionId_;
      result.displayName_ = displayName_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (explanationSpecBuilder_ == null) {
        result.explanationSpec_ = explanationSpec_;
      } else {
        result.explanationSpec_ = explanationSpecBuilder_.build();
      }
      result.serviceAccount_ = serviceAccount_;
      result.disableContainerLogging_ = disableContainerLogging_;
      result.enableAccessLogging_ = enableAccessLogging_;
      if (privateEndpointsBuilder_ == null) {
        result.privateEndpoints_ = privateEndpoints_;
      } else {
        result.privateEndpoints_ = privateEndpointsBuilder_.build();
      }
      result.predictionResourcesCase_ = predictionResourcesCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.DeployedModel) {
        return mergeFrom((com.google.cloud.aiplatform.v1.DeployedModel) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.DeployedModel other) {
      if (other == com.google.cloud.aiplatform.v1.DeployedModel.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (!other.getModel().isEmpty()) {
        model_ = other.model_;
        onChanged();
      }
      if (!other.getModelVersionId().isEmpty()) {
        modelVersionId_ = other.modelVersionId_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasExplanationSpec()) {
        mergeExplanationSpec(other.getExplanationSpec());
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        onChanged();
      }
      if (other.getDisableContainerLogging() != false) {
        setDisableContainerLogging(other.getDisableContainerLogging());
      }
      if (other.getEnableAccessLogging() != false) {
        setEnableAccessLogging(other.getEnableAccessLogging());
      }
      if (other.hasPrivateEndpoints()) {
        mergePrivateEndpoints(other.getPrivateEndpoints());
      }
      switch (other.getPredictionResourcesCase()) {
        case DEDICATED_RESOURCES:
          {
            mergeDedicatedResources(other.getDedicatedResources());
            break;
          }
        case AUTOMATIC_RESOURCES:
          {
            mergeAutomaticResources(other.getAutomaticResources());
            break;
          }
        case PREDICTIONRESOURCES_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1.DeployedModel parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.aiplatform.v1.DeployedModel) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int predictionResourcesCase_ = 0;
    private java.lang.Object predictionResources_;

    public PredictionResourcesCase getPredictionResourcesCase() {
      return PredictionResourcesCase.forNumber(predictionResourcesCase_);
    }

    public Builder clearPredictionResources() {
      predictionResourcesCase_ = 0;
      predictionResources_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DedicatedResources,
            com.google.cloud.aiplatform.v1.DedicatedResources.Builder,
            com.google.cloud.aiplatform.v1.DedicatedResourcesOrBuilder>
        dedicatedResourcesBuilder_;
    /**
     *
     *
     * <pre>
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
     *
     * @return Whether the dedicatedResources field is set.
     */
    @java.lang.Override
    public boolean hasDedicatedResources() {
      return predictionResourcesCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
     *
     * @return The dedicatedResources.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DedicatedResources getDedicatedResources() {
      if (dedicatedResourcesBuilder_ == null) {
        if (predictionResourcesCase_ == 7) {
          return (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_;
        }
        return com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance();
      } else {
        if (predictionResourcesCase_ == 7) {
          return dedicatedResourcesBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
     */
    public Builder setDedicatedResources(com.google.cloud.aiplatform.v1.DedicatedResources value) {
      if (dedicatedResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        predictionResources_ = value;
        onChanged();
      } else {
        dedicatedResourcesBuilder_.setMessage(value);
      }
      predictionResourcesCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
     */
    public Builder setDedicatedResources(
        com.google.cloud.aiplatform.v1.DedicatedResources.Builder builderForValue) {
      if (dedicatedResourcesBuilder_ == null) {
        predictionResources_ = builderForValue.build();
        onChanged();
      } else {
        dedicatedResourcesBuilder_.setMessage(builderForValue.build());
      }
      predictionResourcesCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
     */
    public Builder mergeDedicatedResources(
        com.google.cloud.aiplatform.v1.DedicatedResources value) {
      if (dedicatedResourcesBuilder_ == null) {
        if (predictionResourcesCase_ == 7
            && predictionResources_
                != com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance()) {
          predictionResources_ =
              com.google.cloud.aiplatform.v1.DedicatedResources.newBuilder(
                      (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          predictionResources_ = value;
        }
        onChanged();
      } else {
        if (predictionResourcesCase_ == 7) {
          dedicatedResourcesBuilder_.mergeFrom(value);
        } else {
          dedicatedResourcesBuilder_.setMessage(value);
        }
      }
      predictionResourcesCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
     */
    public Builder clearDedicatedResources() {
      if (dedicatedResourcesBuilder_ == null) {
        if (predictionResourcesCase_ == 7) {
          predictionResourcesCase_ = 0;
          predictionResources_ = null;
          onChanged();
        }
      } else {
        if (predictionResourcesCase_ == 7) {
          predictionResourcesCase_ = 0;
          predictionResources_ = null;
        }
        dedicatedResourcesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
     */
    public com.google.cloud.aiplatform.v1.DedicatedResources.Builder
        getDedicatedResourcesBuilder() {
      return getDedicatedResourcesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DedicatedResourcesOrBuilder
        getDedicatedResourcesOrBuilder() {
      if ((predictionResourcesCase_ == 7) && (dedicatedResourcesBuilder_ != null)) {
        return dedicatedResourcesBuilder_.getMessageOrBuilder();
      } else {
        if (predictionResourcesCase_ == 7) {
          return (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_;
        }
        return com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DedicatedResources,
            com.google.cloud.aiplatform.v1.DedicatedResources.Builder,
            com.google.cloud.aiplatform.v1.DedicatedResourcesOrBuilder>
        getDedicatedResourcesFieldBuilder() {
      if (dedicatedResourcesBuilder_ == null) {
        if (!(predictionResourcesCase_ == 7)) {
          predictionResources_ =
              com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance();
        }
        dedicatedResourcesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.DedicatedResources,
                com.google.cloud.aiplatform.v1.DedicatedResources.Builder,
                com.google.cloud.aiplatform.v1.DedicatedResourcesOrBuilder>(
                (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_,
                getParentForChildren(),
                isClean());
        predictionResources_ = null;
      }
      predictionResourcesCase_ = 7;
      onChanged();
      ;
      return dedicatedResourcesBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.AutomaticResources,
            com.google.cloud.aiplatform.v1.AutomaticResources.Builder,
            com.google.cloud.aiplatform.v1.AutomaticResourcesOrBuilder>
        automaticResourcesBuilder_;
    /**
     *
     *
     * <pre>
     * A description of resources that to large degree are decided by Vertex
     * AI, and require only a modest additional configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
     *
     * @return Whether the automaticResources field is set.
     */
    @java.lang.Override
    public boolean hasAutomaticResources() {
      return predictionResourcesCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that to large degree are decided by Vertex
     * AI, and require only a modest additional configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
     *
     * @return The automaticResources.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.AutomaticResources getAutomaticResources() {
      if (automaticResourcesBuilder_ == null) {
        if (predictionResourcesCase_ == 8) {
          return (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_;
        }
        return com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance();
      } else {
        if (predictionResourcesCase_ == 8) {
          return automaticResourcesBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A description of resources that to large degree are decided by Vertex
     * AI, and require only a modest additional configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
     */
    public Builder setAutomaticResources(com.google.cloud.aiplatform.v1.AutomaticResources value) {
      if (automaticResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        predictionResources_ = value;
        onChanged();
      } else {
        automaticResourcesBuilder_.setMessage(value);
      }
      predictionResourcesCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that to large degree are decided by Vertex
     * AI, and require only a modest additional configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
     */
    public Builder setAutomaticResources(
        com.google.cloud.aiplatform.v1.AutomaticResources.Builder builderForValue) {
      if (automaticResourcesBuilder_ == null) {
        predictionResources_ = builderForValue.build();
        onChanged();
      } else {
        automaticResourcesBuilder_.setMessage(builderForValue.build());
      }
      predictionResourcesCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that to large degree are decided by Vertex
     * AI, and require only a modest additional configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
     */
    public Builder mergeAutomaticResources(
        com.google.cloud.aiplatform.v1.AutomaticResources value) {
      if (automaticResourcesBuilder_ == null) {
        if (predictionResourcesCase_ == 8
            && predictionResources_
                != com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance()) {
          predictionResources_ =
              com.google.cloud.aiplatform.v1.AutomaticResources.newBuilder(
                      (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          predictionResources_ = value;
        }
        onChanged();
      } else {
        if (predictionResourcesCase_ == 8) {
          automaticResourcesBuilder_.mergeFrom(value);
        } else {
          automaticResourcesBuilder_.setMessage(value);
        }
      }
      predictionResourcesCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that to large degree are decided by Vertex
     * AI, and require only a modest additional configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
     */
    public Builder clearAutomaticResources() {
      if (automaticResourcesBuilder_ == null) {
        if (predictionResourcesCase_ == 8) {
          predictionResourcesCase_ = 0;
          predictionResources_ = null;
          onChanged();
        }
      } else {
        if (predictionResourcesCase_ == 8) {
          predictionResourcesCase_ = 0;
          predictionResources_ = null;
        }
        automaticResourcesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that to large degree are decided by Vertex
     * AI, and require only a modest additional configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
     */
    public com.google.cloud.aiplatform.v1.AutomaticResources.Builder
        getAutomaticResourcesBuilder() {
      return getAutomaticResourcesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A description of resources that to large degree are decided by Vertex
     * AI, and require only a modest additional configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.AutomaticResourcesOrBuilder
        getAutomaticResourcesOrBuilder() {
      if ((predictionResourcesCase_ == 8) && (automaticResourcesBuilder_ != null)) {
        return automaticResourcesBuilder_.getMessageOrBuilder();
      } else {
        if (predictionResourcesCase_ == 8) {
          return (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_;
        }
        return com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A description of resources that to large degree are decided by Vertex
     * AI, and require only a modest additional configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.AutomaticResources,
            com.google.cloud.aiplatform.v1.AutomaticResources.Builder,
            com.google.cloud.aiplatform.v1.AutomaticResourcesOrBuilder>
        getAutomaticResourcesFieldBuilder() {
      if (automaticResourcesBuilder_ == null) {
        if (!(predictionResourcesCase_ == 8)) {
          predictionResources_ =
              com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance();
        }
        automaticResourcesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.AutomaticResources,
                com.google.cloud.aiplatform.v1.AutomaticResources.Builder,
                com.google.cloud.aiplatform.v1.AutomaticResourcesOrBuilder>(
                (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_,
                getParentForChildren(),
                isClean());
        predictionResources_ = null;
      }
      predictionResourcesCase_ = 8;
      onChanged();
      ;
      return automaticResourcesBuilder_;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The ID of the DeployedModel. If not provided upon deployment, Vertex AI
     * will generate a value for this ID.
     * This value should be 1-10 characters, and valid characters are /[0-9]/.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The ID of the DeployedModel. If not provided upon deployment, Vertex AI
     * will generate a value for this ID.
     * This value should be 1-10 characters, and valid characters are /[0-9]/.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The ID of the DeployedModel. If not provided upon deployment, Vertex AI
     * will generate a value for this ID.
     * This value should be 1-10 characters, and valid characters are /[0-9]/.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      id_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The ID of the DeployedModel. If not provided upon deployment, Vertex AI
     * will generate a value for this ID.
     * This value should be 1-10 characters, and valid characters are /[0-9]/.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {

      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The ID of the DeployedModel. If not provided upon deployment, Vertex AI
     * will generate a value for this ID.
     * This value should be 1-10 characters, and valid characters are /[0-9]/.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      id_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object model_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model that this is the deployment of. Note that
     * the Model may be in a different location than the DeployedModel's Endpoint.
     * The resource name may contain version id or version alias to specify the
     * version, if no version is specified, the default version will be deployed.
     * </pre>
     *
     * <code>
     * string model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The model.
     */
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model that this is the deployment of. Note that
     * the Model may be in a different location than the DeployedModel's Endpoint.
     * The resource name may contain version id or version alias to specify the
     * version, if no version is specified, the default version will be deployed.
     * </pre>
     *
     * <code>
     * string model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for model.
     */
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model that this is the deployment of. Note that
     * the Model may be in a different location than the DeployedModel's Endpoint.
     * The resource name may contain version id or version alias to specify the
     * version, if no version is specified, the default version will be deployed.
     * </pre>
     *
     * <code>
     * string model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The model to set.
     * @return This builder for chaining.
     */
    public Builder setModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      model_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model that this is the deployment of. Note that
     * the Model may be in a different location than the DeployedModel's Endpoint.
     * The resource name may contain version id or version alias to specify the
     * version, if no version is specified, the default version will be deployed.
     * </pre>
     *
     * <code>
     * string model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModel() {

      model_ = getDefaultInstance().getModel();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model that this is the deployment of. Note that
     * the Model may be in a different location than the DeployedModel's Endpoint.
     * The resource name may contain version id or version alias to specify the
     * version, if no version is specified, the default version will be deployed.
     * </pre>
     *
     * <code>
     * string model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for model to set.
     * @return This builder for chaining.
     */
    public Builder setModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      model_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object modelVersionId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the model that is deployed.
     * </pre>
     *
     * <code>string model_version_id = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The modelVersionId.
     */
    public java.lang.String getModelVersionId() {
      java.lang.Object ref = modelVersionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelVersionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the model that is deployed.
     * </pre>
     *
     * <code>string model_version_id = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for modelVersionId.
     */
    public com.google.protobuf.ByteString getModelVersionIdBytes() {
      java.lang.Object ref = modelVersionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelVersionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the model that is deployed.
     * </pre>
     *
     * <code>string model_version_id = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The modelVersionId to set.
     * @return This builder for chaining.
     */
    public Builder setModelVersionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      modelVersionId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the model that is deployed.
     * </pre>
     *
     * <code>string model_version_id = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelVersionId() {

      modelVersionId_ = getDefaultInstance().getModelVersionId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the model that is deployed.
     * </pre>
     *
     * <code>string model_version_id = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for modelVersionId to set.
     * @return This builder for chaining.
     */
    public Builder setModelVersionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      modelVersionId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the DeployedModel. If not provided upon creation,
     * the Model's display_name is used.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the DeployedModel. If not provided upon creation,
     * the Model's display_name is used.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the DeployedModel. If not provided upon creation,
     * the Model's display_name is used.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the DeployedModel. If not provided upon creation,
     * the Model's display_name is used.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the DeployedModel. If not provided upon creation,
     * the Model's display_name is used.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedModel was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedModel was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedModel was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedModel was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedModel was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedModel was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedModel was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedModel was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedModel was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.cloud.aiplatform.v1.ExplanationSpec explanationSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ExplanationSpec,
            com.google.cloud.aiplatform.v1.ExplanationSpec.Builder,
            com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder>
        explanationSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Explanation configuration for this DeployedModel.
     * When deploying a Model using [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel], this value
     * overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] are optional in the request. If a field of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] is not populated, the value of the same field of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is inherited. If the corresponding
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is not populated, all fields of the
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] will be used for the explanation configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
     *
     * @return Whether the explanationSpec field is set.
     */
    public boolean hasExplanationSpec() {
      return explanationSpecBuilder_ != null || explanationSpec_ != null;
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this DeployedModel.
     * When deploying a Model using [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel], this value
     * overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] are optional in the request. If a field of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] is not populated, the value of the same field of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is inherited. If the corresponding
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is not populated, all fields of the
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] will be used for the explanation configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
     *
     * @return The explanationSpec.
     */
    public com.google.cloud.aiplatform.v1.ExplanationSpec getExplanationSpec() {
      if (explanationSpecBuilder_ == null) {
        return explanationSpec_ == null
            ? com.google.cloud.aiplatform.v1.ExplanationSpec.getDefaultInstance()
            : explanationSpec_;
      } else {
        return explanationSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this DeployedModel.
     * When deploying a Model using [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel], this value
     * overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] are optional in the request. If a field of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] is not populated, the value of the same field of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is inherited. If the corresponding
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is not populated, all fields of the
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] will be used for the explanation configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
     */
    public Builder setExplanationSpec(com.google.cloud.aiplatform.v1.ExplanationSpec value) {
      if (explanationSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        explanationSpec_ = value;
        onChanged();
      } else {
        explanationSpecBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this DeployedModel.
     * When deploying a Model using [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel], this value
     * overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] are optional in the request. If a field of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] is not populated, the value of the same field of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is inherited. If the corresponding
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is not populated, all fields of the
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] will be used for the explanation configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
     */
    public Builder setExplanationSpec(
        com.google.cloud.aiplatform.v1.ExplanationSpec.Builder builderForValue) {
      if (explanationSpecBuilder_ == null) {
        explanationSpec_ = builderForValue.build();
        onChanged();
      } else {
        explanationSpecBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this DeployedModel.
     * When deploying a Model using [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel], this value
     * overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] are optional in the request. If a field of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] is not populated, the value of the same field of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is inherited. If the corresponding
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is not populated, all fields of the
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] will be used for the explanation configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
     */
    public Builder mergeExplanationSpec(com.google.cloud.aiplatform.v1.ExplanationSpec value) {
      if (explanationSpecBuilder_ == null) {
        if (explanationSpec_ != null) {
          explanationSpec_ =
              com.google.cloud.aiplatform.v1.ExplanationSpec.newBuilder(explanationSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          explanationSpec_ = value;
        }
        onChanged();
      } else {
        explanationSpecBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this DeployedModel.
     * When deploying a Model using [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel], this value
     * overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] are optional in the request. If a field of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] is not populated, the value of the same field of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is inherited. If the corresponding
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is not populated, all fields of the
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] will be used for the explanation configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
     */
    public Builder clearExplanationSpec() {
      if (explanationSpecBuilder_ == null) {
        explanationSpec_ = null;
        onChanged();
      } else {
        explanationSpec_ = null;
        explanationSpecBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this DeployedModel.
     * When deploying a Model using [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel], this value
     * overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] are optional in the request. If a field of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] is not populated, the value of the same field of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is inherited. If the corresponding
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is not populated, all fields of the
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] will be used for the explanation configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
     */
    public com.google.cloud.aiplatform.v1.ExplanationSpec.Builder getExplanationSpecBuilder() {

      onChanged();
      return getExplanationSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this DeployedModel.
     * When deploying a Model using [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel], this value
     * overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] are optional in the request. If a field of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] is not populated, the value of the same field of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is inherited. If the corresponding
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is not populated, all fields of the
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] will be used for the explanation configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
     */
    public com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder getExplanationSpecOrBuilder() {
      if (explanationSpecBuilder_ != null) {
        return explanationSpecBuilder_.getMessageOrBuilder();
      } else {
        return explanationSpec_ == null
            ? com.google.cloud.aiplatform.v1.ExplanationSpec.getDefaultInstance()
            : explanationSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this DeployedModel.
     * When deploying a Model using [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel], this value
     * overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] are optional in the request. If a field of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] is not populated, the value of the same field of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is inherited. If the corresponding
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] is not populated, all fields of the
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec] will be used for the explanation configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ExplanationSpec,
            com.google.cloud.aiplatform.v1.ExplanationSpec.Builder,
            com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder>
        getExplanationSpecFieldBuilder() {
      if (explanationSpecBuilder_ == null) {
        explanationSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ExplanationSpec,
                com.google.cloud.aiplatform.v1.ExplanationSpec.Builder,
                com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder>(
                getExplanationSpec(), getParentForChildren(), isClean());
        explanationSpec_ = null;
      }
      return explanationSpecBuilder_;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * The service account that the DeployedModel's container runs as. Specify the
     * email address of the service account. If this service account is not
     * specified, the container runs as a service account that doesn't have access
     * to the resource project.
     * Users deploying the Model must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 11;</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service account that the DeployedModel's container runs as. Specify the
     * email address of the service account. If this service account is not
     * specified, the container runs as a service account that doesn't have access
     * to the resource project.
     * Users deploying the Model must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 11;</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service account that the DeployedModel's container runs as. Specify the
     * email address of the service account. If this service account is not
     * specified, the container runs as a service account that doesn't have access
     * to the resource project.
     * Users deploying the Model must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 11;</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      serviceAccount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account that the DeployedModel's container runs as. Specify the
     * email address of the service account. If this service account is not
     * specified, the container runs as a service account that doesn't have access
     * to the resource project.
     * Users deploying the Model must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {

      serviceAccount_ = getDefaultInstance().getServiceAccount();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account that the DeployedModel's container runs as. Specify the
     * email address of the service account. If this service account is not
     * specified, the container runs as a service account that doesn't have access
     * to the resource project.
     * Users deploying the Model must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 11;</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      serviceAccount_ = value;
      onChanged();
      return this;
    }

    private boolean disableContainerLogging_;
    /**
     *
     *
     * <pre>
     * For custom-trained Models and AutoML Tabular Models, the container of the
     * DeployedModel instances will send `stderr` and `stdout` streams to
     * Stackdriver Logging by default. Please note that the logs incur cost,
     * which are subject to [Cloud Logging
     * pricing](https://cloud.google.com/stackdriver/pricing).
     * User can disable container logging by setting this flag to true.
     * </pre>
     *
     * <code>bool disable_container_logging = 15;</code>
     *
     * @return The disableContainerLogging.
     */
    @java.lang.Override
    public boolean getDisableContainerLogging() {
      return disableContainerLogging_;
    }
    /**
     *
     *
     * <pre>
     * For custom-trained Models and AutoML Tabular Models, the container of the
     * DeployedModel instances will send `stderr` and `stdout` streams to
     * Stackdriver Logging by default. Please note that the logs incur cost,
     * which are subject to [Cloud Logging
     * pricing](https://cloud.google.com/stackdriver/pricing).
     * User can disable container logging by setting this flag to true.
     * </pre>
     *
     * <code>bool disable_container_logging = 15;</code>
     *
     * @param value The disableContainerLogging to set.
     * @return This builder for chaining.
     */
    public Builder setDisableContainerLogging(boolean value) {

      disableContainerLogging_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For custom-trained Models and AutoML Tabular Models, the container of the
     * DeployedModel instances will send `stderr` and `stdout` streams to
     * Stackdriver Logging by default. Please note that the logs incur cost,
     * which are subject to [Cloud Logging
     * pricing](https://cloud.google.com/stackdriver/pricing).
     * User can disable container logging by setting this flag to true.
     * </pre>
     *
     * <code>bool disable_container_logging = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableContainerLogging() {

      disableContainerLogging_ = false;
      onChanged();
      return this;
    }

    private boolean enableAccessLogging_;
    /**
     *
     *
     * <pre>
     * These logs are like standard server access logs, containing
     * information like timestamp and latency for each prediction request.
     * Note that Stackdriver logs may incur a cost, especially if your project
     * receives prediction requests at a high queries per second rate (QPS).
     * Estimate your costs before enabling this option.
     * </pre>
     *
     * <code>bool enable_access_logging = 13;</code>
     *
     * @return The enableAccessLogging.
     */
    @java.lang.Override
    public boolean getEnableAccessLogging() {
      return enableAccessLogging_;
    }
    /**
     *
     *
     * <pre>
     * These logs are like standard server access logs, containing
     * information like timestamp and latency for each prediction request.
     * Note that Stackdriver logs may incur a cost, especially if your project
     * receives prediction requests at a high queries per second rate (QPS).
     * Estimate your costs before enabling this option.
     * </pre>
     *
     * <code>bool enable_access_logging = 13;</code>
     *
     * @param value The enableAccessLogging to set.
     * @return This builder for chaining.
     */
    public Builder setEnableAccessLogging(boolean value) {

      enableAccessLogging_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * These logs are like standard server access logs, containing
     * information like timestamp and latency for each prediction request.
     * Note that Stackdriver logs may incur a cost, especially if your project
     * receives prediction requests at a high queries per second rate (QPS).
     * Estimate your costs before enabling this option.
     * </pre>
     *
     * <code>bool enable_access_logging = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableAccessLogging() {

      enableAccessLogging_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.PrivateEndpoints privateEndpoints_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PrivateEndpoints,
            com.google.cloud.aiplatform.v1.PrivateEndpoints.Builder,
            com.google.cloud.aiplatform.v1.PrivateEndpointsOrBuilder>
        privateEndpointsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Provide paths for users to send predict/explain/health requests directly to
     * the deployed model services running on Cloud via private services access.
     * This field is populated if [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the privateEndpoints field is set.
     */
    public boolean hasPrivateEndpoints() {
      return privateEndpointsBuilder_ != null || privateEndpoints_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provide paths for users to send predict/explain/health requests directly to
     * the deployed model services running on Cloud via private services access.
     * This field is populated if [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The privateEndpoints.
     */
    public com.google.cloud.aiplatform.v1.PrivateEndpoints getPrivateEndpoints() {
      if (privateEndpointsBuilder_ == null) {
        return privateEndpoints_ == null
            ? com.google.cloud.aiplatform.v1.PrivateEndpoints.getDefaultInstance()
            : privateEndpoints_;
      } else {
        return privateEndpointsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Provide paths for users to send predict/explain/health requests directly to
     * the deployed model services running on Cloud via private services access.
     * This field is populated if [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPrivateEndpoints(com.google.cloud.aiplatform.v1.PrivateEndpoints value) {
      if (privateEndpointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        privateEndpoints_ = value;
        onChanged();
      } else {
        privateEndpointsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provide paths for users to send predict/explain/health requests directly to
     * the deployed model services running on Cloud via private services access.
     * This field is populated if [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPrivateEndpoints(
        com.google.cloud.aiplatform.v1.PrivateEndpoints.Builder builderForValue) {
      if (privateEndpointsBuilder_ == null) {
        privateEndpoints_ = builderForValue.build();
        onChanged();
      } else {
        privateEndpointsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provide paths for users to send predict/explain/health requests directly to
     * the deployed model services running on Cloud via private services access.
     * This field is populated if [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePrivateEndpoints(com.google.cloud.aiplatform.v1.PrivateEndpoints value) {
      if (privateEndpointsBuilder_ == null) {
        if (privateEndpoints_ != null) {
          privateEndpoints_ =
              com.google.cloud.aiplatform.v1.PrivateEndpoints.newBuilder(privateEndpoints_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          privateEndpoints_ = value;
        }
        onChanged();
      } else {
        privateEndpointsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provide paths for users to send predict/explain/health requests directly to
     * the deployed model services running on Cloud via private services access.
     * This field is populated if [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPrivateEndpoints() {
      if (privateEndpointsBuilder_ == null) {
        privateEndpoints_ = null;
        onChanged();
      } else {
        privateEndpoints_ = null;
        privateEndpointsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provide paths for users to send predict/explain/health requests directly to
     * the deployed model services running on Cloud via private services access.
     * This field is populated if [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.PrivateEndpoints.Builder getPrivateEndpointsBuilder() {

      onChanged();
      return getPrivateEndpointsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Provide paths for users to send predict/explain/health requests directly to
     * the deployed model services running on Cloud via private services access.
     * This field is populated if [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.PrivateEndpointsOrBuilder getPrivateEndpointsOrBuilder() {
      if (privateEndpointsBuilder_ != null) {
        return privateEndpointsBuilder_.getMessageOrBuilder();
      } else {
        return privateEndpoints_ == null
            ? com.google.cloud.aiplatform.v1.PrivateEndpoints.getDefaultInstance()
            : privateEndpoints_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Provide paths for users to send predict/explain/health requests directly to
     * the deployed model services running on Cloud via private services access.
     * This field is populated if [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PrivateEndpoints,
            com.google.cloud.aiplatform.v1.PrivateEndpoints.Builder,
            com.google.cloud.aiplatform.v1.PrivateEndpointsOrBuilder>
        getPrivateEndpointsFieldBuilder() {
      if (privateEndpointsBuilder_ == null) {
        privateEndpointsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.PrivateEndpoints,
                com.google.cloud.aiplatform.v1.PrivateEndpoints.Builder,
                com.google.cloud.aiplatform.v1.PrivateEndpointsOrBuilder>(
                getPrivateEndpoints(), getParentForChildren(), isClean());
        privateEndpoints_ = null;
      }
      return privateEndpointsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.DeployedModel)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.DeployedModel)
  private static final com.google.cloud.aiplatform.v1.DeployedModel DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.DeployedModel();
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeployedModel> PARSER =
      new com.google.protobuf.AbstractParser<DeployedModel>() {
        @java.lang.Override
        public DeployedModel parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new DeployedModel(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<DeployedModel> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeployedModel> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeployedModel getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
