/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/endpoint_service.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Request message for [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.DeployModelRequest}
 */
public final class DeployModelRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.DeployModelRequest)
    DeployModelRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DeployModelRequest.newBuilder() to construct.
  private DeployModelRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DeployModelRequest() {
    endpoint_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DeployModelRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private DeployModelRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              endpoint_ = s;
              break;
            }
          case 18:
            {
              com.google.cloud.aiplatform.v1.DeployedModel.Builder subBuilder = null;
              if (deployedModel_ != null) {
                subBuilder = deployedModel_.toBuilder();
              }
              deployedModel_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.DeployedModel.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(deployedModel_);
                deployedModel_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                trafficSplit_ =
                    com.google.protobuf.MapField.newMapField(
                        TrafficSplitDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> trafficSplit__ =
                  input.readMessage(
                      TrafficSplitDefaultEntryHolder.defaultEntry.getParserForType(),
                      extensionRegistry);
              trafficSplit_.getMutableMap().put(trafficSplit__.getKey(), trafficSplit__.getValue());
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.EndpointServiceProto
        .internal_static_google_cloud_aiplatform_v1_DeployModelRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetTrafficSplit();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.EndpointServiceProto
        .internal_static_google_cloud_aiplatform_v1_DeployModelRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.DeployModelRequest.class,
            com.google.cloud.aiplatform.v1.DeployModelRequest.Builder.class);
  }

  public static final int ENDPOINT_FIELD_NUMBER = 1;
  private volatile java.lang.Object endpoint_;
  /**
   *
   *
   * <pre>
   * Required. The name of the Endpoint resource into which to deploy a Model.
   * Format:
   * `projects/{project}/locations/{location}/endpoints/{endpoint}`
   * </pre>
   *
   * <code>
   * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The endpoint.
   */
  @java.lang.Override
  public java.lang.String getEndpoint() {
    java.lang.Object ref = endpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endpoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the Endpoint resource into which to deploy a Model.
   * Format:
   * `projects/{project}/locations/{location}/endpoints/{endpoint}`
   * </pre>
   *
   * <code>
   * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for endpoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEndpointBytes() {
    java.lang.Object ref = endpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      endpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPLOYED_MODEL_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1.DeployedModel deployedModel_;
  /**
   *
   *
   * <pre>
   * Required. The DeployedModel to be created within the Endpoint. Note that
   * [Endpoint.traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] must be updated for the DeployedModel to start
   * receiving traffic, either as part of this call, or via
   * [EndpointService.UpdateEndpoint][google.cloud.aiplatform.v1.EndpointService.UpdateEndpoint].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeployedModel deployed_model = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the deployedModel field is set.
   */
  @java.lang.Override
  public boolean hasDeployedModel() {
    return deployedModel_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The DeployedModel to be created within the Endpoint. Note that
   * [Endpoint.traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] must be updated for the DeployedModel to start
   * receiving traffic, either as part of this call, or via
   * [EndpointService.UpdateEndpoint][google.cloud.aiplatform.v1.EndpointService.UpdateEndpoint].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeployedModel deployed_model = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The deployedModel.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeployedModel getDeployedModel() {
    return deployedModel_ == null
        ? com.google.cloud.aiplatform.v1.DeployedModel.getDefaultInstance()
        : deployedModel_;
  }
  /**
   *
   *
   * <pre>
   * Required. The DeployedModel to be created within the Endpoint. Note that
   * [Endpoint.traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] must be updated for the DeployedModel to start
   * receiving traffic, either as part of this call, or via
   * [EndpointService.UpdateEndpoint][google.cloud.aiplatform.v1.EndpointService.UpdateEndpoint].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeployedModel deployed_model = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeployedModelOrBuilder getDeployedModelOrBuilder() {
    return getDeployedModel();
  }

  public static final int TRAFFIC_SPLIT_FIELD_NUMBER = 3;

  private static final class TrafficSplitDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.Integer>newDefaultInstance(
            com.google.cloud.aiplatform.v1.EndpointServiceProto
                .internal_static_google_cloud_aiplatform_v1_DeployModelRequest_TrafficSplitEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.INT32,
            0);
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer> trafficSplit_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
      internalGetTrafficSplit() {
    if (trafficSplit_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          TrafficSplitDefaultEntryHolder.defaultEntry);
    }
    return trafficSplit_;
  }

  public int getTrafficSplitCount() {
    return internalGetTrafficSplit().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A map from a DeployedModel's ID to the percentage of this Endpoint's
   * traffic that should be forwarded to that DeployedModel.
   * If this field is non-empty, then the Endpoint's
   * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be overwritten with it.
   * To refer to the ID of the just being deployed Model, a "0" should be used,
   * and the actual ID of the new DeployedModel will be filled in its place by
   * this method. The traffic percentage values must add up to 100.
   * If this field is empty, then the Endpoint's
   * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] is not updated.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
   */
  @java.lang.Override
  public boolean containsTrafficSplit(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetTrafficSplit().getMap().containsKey(key);
  }
  /** Use {@link #getTrafficSplitMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Integer> getTrafficSplit() {
    return getTrafficSplitMap();
  }
  /**
   *
   *
   * <pre>
   * A map from a DeployedModel's ID to the percentage of this Endpoint's
   * traffic that should be forwarded to that DeployedModel.
   * If this field is non-empty, then the Endpoint's
   * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be overwritten with it.
   * To refer to the ID of the just being deployed Model, a "0" should be used,
   * and the actual ID of the new DeployedModel will be filled in its place by
   * this method. The traffic percentage values must add up to 100.
   * If this field is empty, then the Endpoint's
   * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] is not updated.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.Integer> getTrafficSplitMap() {
    return internalGetTrafficSplit().getMap();
  }
  /**
   *
   *
   * <pre>
   * A map from a DeployedModel's ID to the percentage of this Endpoint's
   * traffic that should be forwarded to that DeployedModel.
   * If this field is non-empty, then the Endpoint's
   * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be overwritten with it.
   * To refer to the ID of the just being deployed Model, a "0" should be used,
   * and the actual ID of the new DeployedModel will be filled in its place by
   * this method. The traffic percentage values must add up to 100.
   * If this field is empty, then the Endpoint's
   * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] is not updated.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
   */
  @java.lang.Override
  public int getTrafficSplitOrDefault(java.lang.String key, int defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetTrafficSplit().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A map from a DeployedModel's ID to the percentage of this Endpoint's
   * traffic that should be forwarded to that DeployedModel.
   * If this field is non-empty, then the Endpoint's
   * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be overwritten with it.
   * To refer to the ID of the just being deployed Model, a "0" should be used,
   * and the actual ID of the new DeployedModel will be filled in its place by
   * this method. The traffic percentage values must add up to 100.
   * If this field is empty, then the Endpoint's
   * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] is not updated.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
   */
  @java.lang.Override
  public int getTrafficSplitOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetTrafficSplit().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, endpoint_);
    }
    if (deployedModel_ != null) {
      output.writeMessage(2, getDeployedModel());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetTrafficSplit(), TrafficSplitDefaultEntryHolder.defaultEntry, 3);
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, endpoint_);
    }
    if (deployedModel_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDeployedModel());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.Integer> entry :
        internalGetTrafficSplit().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> trafficSplit__ =
          TrafficSplitDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, trafficSplit__);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.DeployModelRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.DeployModelRequest other =
        (com.google.cloud.aiplatform.v1.DeployModelRequest) obj;

    if (!getEndpoint().equals(other.getEndpoint())) return false;
    if (hasDeployedModel() != other.hasDeployedModel()) return false;
    if (hasDeployedModel()) {
      if (!getDeployedModel().equals(other.getDeployedModel())) return false;
    }
    if (!internalGetTrafficSplit().equals(other.internalGetTrafficSplit())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENDPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getEndpoint().hashCode();
    if (hasDeployedModel()) {
      hash = (37 * hash) + DEPLOYED_MODEL_FIELD_NUMBER;
      hash = (53 * hash) + getDeployedModel().hashCode();
    }
    if (!internalGetTrafficSplit().getMap().isEmpty()) {
      hash = (37 * hash) + TRAFFIC_SPLIT_FIELD_NUMBER;
      hash = (53 * hash) + internalGetTrafficSplit().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.DeployModelRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DeployModelRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployModelRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DeployModelRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployModelRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DeployModelRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployModelRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DeployModelRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployModelRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DeployModelRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployModelRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DeployModelRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.DeployModelRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.DeployModelRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.DeployModelRequest)
      com.google.cloud.aiplatform.v1.DeployModelRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.EndpointServiceProto
          .internal_static_google_cloud_aiplatform_v1_DeployModelRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetTrafficSplit();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableTrafficSplit();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.EndpointServiceProto
          .internal_static_google_cloud_aiplatform_v1_DeployModelRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.DeployModelRequest.class,
              com.google.cloud.aiplatform.v1.DeployModelRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.DeployModelRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      endpoint_ = "";

      if (deployedModelBuilder_ == null) {
        deployedModel_ = null;
      } else {
        deployedModel_ = null;
        deployedModelBuilder_ = null;
      }
      internalGetMutableTrafficSplit().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.EndpointServiceProto
          .internal_static_google_cloud_aiplatform_v1_DeployModelRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeployModelRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.DeployModelRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeployModelRequest build() {
      com.google.cloud.aiplatform.v1.DeployModelRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeployModelRequest buildPartial() {
      com.google.cloud.aiplatform.v1.DeployModelRequest result =
          new com.google.cloud.aiplatform.v1.DeployModelRequest(this);
      int from_bitField0_ = bitField0_;
      result.endpoint_ = endpoint_;
      if (deployedModelBuilder_ == null) {
        result.deployedModel_ = deployedModel_;
      } else {
        result.deployedModel_ = deployedModelBuilder_.build();
      }
      result.trafficSplit_ = internalGetTrafficSplit();
      result.trafficSplit_.makeImmutable();
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.DeployModelRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1.DeployModelRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.DeployModelRequest other) {
      if (other == com.google.cloud.aiplatform.v1.DeployModelRequest.getDefaultInstance())
        return this;
      if (!other.getEndpoint().isEmpty()) {
        endpoint_ = other.endpoint_;
        onChanged();
      }
      if (other.hasDeployedModel()) {
        mergeDeployedModel(other.getDeployedModel());
      }
      internalGetMutableTrafficSplit().mergeFrom(other.internalGetTrafficSplit());
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1.DeployModelRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1.DeployModelRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object endpoint_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint resource into which to deploy a Model.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The endpoint.
     */
    public java.lang.String getEndpoint() {
      java.lang.Object ref = endpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint resource into which to deploy a Model.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for endpoint.
     */
    public com.google.protobuf.ByteString getEndpointBytes() {
      java.lang.Object ref = endpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint resource into which to deploy a Model.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The endpoint to set.
     * @return This builder for chaining.
     */
    public Builder setEndpoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      endpoint_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint resource into which to deploy a Model.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndpoint() {

      endpoint_ = getDefaultInstance().getEndpoint();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint resource into which to deploy a Model.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for endpoint to set.
     * @return This builder for chaining.
     */
    public Builder setEndpointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      endpoint_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.DeployedModel deployedModel_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeployedModel,
            com.google.cloud.aiplatform.v1.DeployedModel.Builder,
            com.google.cloud.aiplatform.v1.DeployedModelOrBuilder>
        deployedModelBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The DeployedModel to be created within the Endpoint. Note that
     * [Endpoint.traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] must be updated for the DeployedModel to start
     * receiving traffic, either as part of this call, or via
     * [EndpointService.UpdateEndpoint][google.cloud.aiplatform.v1.EndpointService.UpdateEndpoint].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeployedModel deployed_model = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the deployedModel field is set.
     */
    public boolean hasDeployedModel() {
      return deployedModelBuilder_ != null || deployedModel_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The DeployedModel to be created within the Endpoint. Note that
     * [Endpoint.traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] must be updated for the DeployedModel to start
     * receiving traffic, either as part of this call, or via
     * [EndpointService.UpdateEndpoint][google.cloud.aiplatform.v1.EndpointService.UpdateEndpoint].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeployedModel deployed_model = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The deployedModel.
     */
    public com.google.cloud.aiplatform.v1.DeployedModel getDeployedModel() {
      if (deployedModelBuilder_ == null) {
        return deployedModel_ == null
            ? com.google.cloud.aiplatform.v1.DeployedModel.getDefaultInstance()
            : deployedModel_;
      } else {
        return deployedModelBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The DeployedModel to be created within the Endpoint. Note that
     * [Endpoint.traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] must be updated for the DeployedModel to start
     * receiving traffic, either as part of this call, or via
     * [EndpointService.UpdateEndpoint][google.cloud.aiplatform.v1.EndpointService.UpdateEndpoint].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeployedModel deployed_model = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDeployedModel(com.google.cloud.aiplatform.v1.DeployedModel value) {
      if (deployedModelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deployedModel_ = value;
        onChanged();
      } else {
        deployedModelBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The DeployedModel to be created within the Endpoint. Note that
     * [Endpoint.traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] must be updated for the DeployedModel to start
     * receiving traffic, either as part of this call, or via
     * [EndpointService.UpdateEndpoint][google.cloud.aiplatform.v1.EndpointService.UpdateEndpoint].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeployedModel deployed_model = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDeployedModel(
        com.google.cloud.aiplatform.v1.DeployedModel.Builder builderForValue) {
      if (deployedModelBuilder_ == null) {
        deployedModel_ = builderForValue.build();
        onChanged();
      } else {
        deployedModelBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The DeployedModel to be created within the Endpoint. Note that
     * [Endpoint.traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] must be updated for the DeployedModel to start
     * receiving traffic, either as part of this call, or via
     * [EndpointService.UpdateEndpoint][google.cloud.aiplatform.v1.EndpointService.UpdateEndpoint].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeployedModel deployed_model = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeDeployedModel(com.google.cloud.aiplatform.v1.DeployedModel value) {
      if (deployedModelBuilder_ == null) {
        if (deployedModel_ != null) {
          deployedModel_ =
              com.google.cloud.aiplatform.v1.DeployedModel.newBuilder(deployedModel_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          deployedModel_ = value;
        }
        onChanged();
      } else {
        deployedModelBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The DeployedModel to be created within the Endpoint. Note that
     * [Endpoint.traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] must be updated for the DeployedModel to start
     * receiving traffic, either as part of this call, or via
     * [EndpointService.UpdateEndpoint][google.cloud.aiplatform.v1.EndpointService.UpdateEndpoint].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeployedModel deployed_model = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDeployedModel() {
      if (deployedModelBuilder_ == null) {
        deployedModel_ = null;
        onChanged();
      } else {
        deployedModel_ = null;
        deployedModelBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The DeployedModel to be created within the Endpoint. Note that
     * [Endpoint.traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] must be updated for the DeployedModel to start
     * receiving traffic, either as part of this call, or via
     * [EndpointService.UpdateEndpoint][google.cloud.aiplatform.v1.EndpointService.UpdateEndpoint].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeployedModel deployed_model = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedModel.Builder getDeployedModelBuilder() {

      onChanged();
      return getDeployedModelFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The DeployedModel to be created within the Endpoint. Note that
     * [Endpoint.traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] must be updated for the DeployedModel to start
     * receiving traffic, either as part of this call, or via
     * [EndpointService.UpdateEndpoint][google.cloud.aiplatform.v1.EndpointService.UpdateEndpoint].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeployedModel deployed_model = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedModelOrBuilder getDeployedModelOrBuilder() {
      if (deployedModelBuilder_ != null) {
        return deployedModelBuilder_.getMessageOrBuilder();
      } else {
        return deployedModel_ == null
            ? com.google.cloud.aiplatform.v1.DeployedModel.getDefaultInstance()
            : deployedModel_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The DeployedModel to be created within the Endpoint. Note that
     * [Endpoint.traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] must be updated for the DeployedModel to start
     * receiving traffic, either as part of this call, or via
     * [EndpointService.UpdateEndpoint][google.cloud.aiplatform.v1.EndpointService.UpdateEndpoint].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeployedModel deployed_model = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeployedModel,
            com.google.cloud.aiplatform.v1.DeployedModel.Builder,
            com.google.cloud.aiplatform.v1.DeployedModelOrBuilder>
        getDeployedModelFieldBuilder() {
      if (deployedModelBuilder_ == null) {
        deployedModelBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.DeployedModel,
                com.google.cloud.aiplatform.v1.DeployedModel.Builder,
                com.google.cloud.aiplatform.v1.DeployedModelOrBuilder>(
                getDeployedModel(), getParentForChildren(), isClean());
        deployedModel_ = null;
      }
      return deployedModelBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer> trafficSplit_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetTrafficSplit() {
      if (trafficSplit_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            TrafficSplitDefaultEntryHolder.defaultEntry);
      }
      return trafficSplit_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetMutableTrafficSplit() {
      onChanged();
      ;
      if (trafficSplit_ == null) {
        trafficSplit_ =
            com.google.protobuf.MapField.newMapField(TrafficSplitDefaultEntryHolder.defaultEntry);
      }
      if (!trafficSplit_.isMutable()) {
        trafficSplit_ = trafficSplit_.copy();
      }
      return trafficSplit_;
    }

    public int getTrafficSplitCount() {
      return internalGetTrafficSplit().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     * If this field is non-empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be overwritten with it.
     * To refer to the ID of the just being deployed Model, a "0" should be used,
     * and the actual ID of the new DeployedModel will be filled in its place by
     * this method. The traffic percentage values must add up to 100.
     * If this field is empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] is not updated.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
     */
    @java.lang.Override
    public boolean containsTrafficSplit(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetTrafficSplit().getMap().containsKey(key);
    }
    /** Use {@link #getTrafficSplitMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getTrafficSplit() {
      return getTrafficSplitMap();
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     * If this field is non-empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be overwritten with it.
     * To refer to the ID of the just being deployed Model, a "0" should be used,
     * and the actual ID of the new DeployedModel will be filled in its place by
     * this method. The traffic percentage values must add up to 100.
     * If this field is empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] is not updated.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Integer> getTrafficSplitMap() {
      return internalGetTrafficSplit().getMap();
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     * If this field is non-empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be overwritten with it.
     * To refer to the ID of the just being deployed Model, a "0" should be used,
     * and the actual ID of the new DeployedModel will be filled in its place by
     * this method. The traffic percentage values must add up to 100.
     * If this field is empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] is not updated.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
     */
    @java.lang.Override
    public int getTrafficSplitOrDefault(java.lang.String key, int defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map = internalGetTrafficSplit().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     * If this field is non-empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be overwritten with it.
     * To refer to the ID of the just being deployed Model, a "0" should be used,
     * and the actual ID of the new DeployedModel will be filled in its place by
     * this method. The traffic percentage values must add up to 100.
     * If this field is empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] is not updated.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
     */
    @java.lang.Override
    public int getTrafficSplitOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map = internalGetTrafficSplit().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearTrafficSplit() {
      internalGetMutableTrafficSplit().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     * If this field is non-empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be overwritten with it.
     * To refer to the ID of the just being deployed Model, a "0" should be used,
     * and the actual ID of the new DeployedModel will be filled in its place by
     * this method. The traffic percentage values must add up to 100.
     * If this field is empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] is not updated.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
     */
    public Builder removeTrafficSplit(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableTrafficSplit().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getMutableTrafficSplit() {
      return internalGetMutableTrafficSplit().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     * If this field is non-empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be overwritten with it.
     * To refer to the ID of the just being deployed Model, a "0" should be used,
     * and the actual ID of the new DeployedModel will be filled in its place by
     * this method. The traffic percentage values must add up to 100.
     * If this field is empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] is not updated.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
     */
    public Builder putTrafficSplit(java.lang.String key, int value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableTrafficSplit().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     * If this field is non-empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be overwritten with it.
     * To refer to the ID of the just being deployed Model, a "0" should be used,
     * and the actual ID of the new DeployedModel will be filled in its place by
     * this method. The traffic percentage values must add up to 100.
     * If this field is empty, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] is not updated.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
     */
    public Builder putAllTrafficSplit(java.util.Map<java.lang.String, java.lang.Integer> values) {
      internalGetMutableTrafficSplit().getMutableMap().putAll(values);
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.DeployModelRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.DeployModelRequest)
  private static final com.google.cloud.aiplatform.v1.DeployModelRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.DeployModelRequest();
  }

  public static com.google.cloud.aiplatform.v1.DeployModelRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeployModelRequest> PARSER =
      new com.google.protobuf.AbstractParser<DeployModelRequest>() {
        @java.lang.Override
        public DeployModelRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new DeployModelRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<DeployModelRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeployModelRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeployModelRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
