/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExecutionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_METADATA_STORE_EXECUTION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/metadataStores/{metadata_store}/executions/{execution}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String metadataStore;
    private final String execution;

    @Deprecated
    protected ExecutionName() {
        this.project = null;
        this.location = null;
        this.metadataStore = null;
        this.execution = null;
    }

    private ExecutionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.metadataStore = (String)Preconditions.checkNotNull((Object)builder.getMetadataStore());
        this.execution = (String)Preconditions.checkNotNull((Object)builder.getExecution());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMetadataStore() {
        return this.metadataStore;
    }

    public String getExecution() {
        return this.execution;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ExecutionName of(String project, String location, String metadataStore, String execution) {
        return ExecutionName.newBuilder().setProject(project).setLocation(location).setMetadataStore(metadataStore).setExecution(execution).build();
    }

    public static String format(String project, String location, String metadataStore, String execution) {
        return ExecutionName.newBuilder().setProject(project).setLocation(location).setMetadataStore(metadataStore).setExecution(execution).build().toString();
    }

    public static ExecutionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_METADATA_STORE_EXECUTION.validatedMatch(formattedString, "ExecutionName.parse: formattedString not in valid format");
        return ExecutionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("metadata_store"), (String)matchMap.get("execution"));
    }

    public static List<ExecutionName> parseList(List<String> formattedStrings) {
        ArrayList<ExecutionName> list = new ArrayList<ExecutionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ExecutionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ExecutionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExecutionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_METADATA_STORE_EXECUTION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ExecutionName executionName = this;
            synchronized (executionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.metadataStore != null) {
                        fieldMapBuilder.put((Object)"metadata_store", (Object)this.metadataStore);
                    }
                    if (this.execution != null) {
                        fieldMapBuilder.put((Object)"execution", (Object)this.execution);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_METADATA_STORE_EXECUTION.instantiate(new String[]{"project", this.project, "location", this.location, "metadata_store", this.metadataStore, "execution", this.execution});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ExecutionName that = (ExecutionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.metadataStore, that.metadataStore) && Objects.equals(this.execution, that.execution);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.metadataStore);
        h *= 1000003;
        return h ^= Objects.hashCode(this.execution);
    }

    public static class Builder {
        private String project;
        private String location;
        private String metadataStore;
        private String execution;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMetadataStore() {
            return this.metadataStore;
        }

        public String getExecution() {
            return this.execution;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setMetadataStore(String metadataStore) {
            this.metadataStore = metadataStore;
            return this;
        }

        public Builder setExecution(String execution) {
            this.execution = execution;
            return this;
        }

        private Builder(ExecutionName executionName) {
            this.project = executionName.project;
            this.location = executionName.location;
            this.metadataStore = executionName.metadataStore;
            this.execution = executionName.execution;
        }

        public ExecutionName build() {
            return new ExecutionName(this);
        }
    }
}

