/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.advisorynotifications.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NotificationName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_NOTIFICATION = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/notifications/{notification}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String notification;

    @Deprecated
    protected NotificationName() {
        this.organization = null;
        this.location = null;
        this.notification = null;
    }

    private NotificationName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.notification = (String)Preconditions.checkNotNull((Object)builder.getNotification());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNotification() {
        return this.notification;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NotificationName of(String organization, String location, String notification) {
        return NotificationName.newBuilder().setOrganization(organization).setLocation(location).setNotification(notification).build();
    }

    public static String format(String organization, String location, String notification) {
        return NotificationName.newBuilder().setOrganization(organization).setLocation(location).setNotification(notification).build().toString();
    }

    public static NotificationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION_NOTIFICATION.validatedMatch(formattedString, "NotificationName.parse: formattedString not in valid format");
        return NotificationName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("notification"));
    }

    public static List<NotificationName> parseList(List<String> formattedStrings) {
        ArrayList<NotificationName> list = new ArrayList<NotificationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NotificationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NotificationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NotificationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_NOTIFICATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NotificationName notificationName = this;
            synchronized (notificationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.notification != null) {
                        fieldMapBuilder.put((Object)"notification", (Object)this.notification);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION_NOTIFICATION.instantiate(new String[]{"organization", this.organization, "location", this.location, "notification", this.notification});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            NotificationName that = (NotificationName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.notification, that.notification);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.notification);
    }

    public static class Builder {
        private String organization;
        private String location;
        private String notification;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNotification() {
            return this.notification;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setNotification(String notification) {
            this.notification = notification;
            return this;
        }

        private Builder(NotificationName notificationName) {
            this.organization = notificationName.organization;
            this.location = notificationName.location;
            this.notification = notificationName.notification;
        }

        public NotificationName build() {
            return new NotificationName(this);
        }
    }
}

