/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.accessapproval.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ApprovalRequestName
implements ResourceName {
    private static final PathTemplate PROJECT_APPROVAL_REQUEST = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/approvalRequests/{approval_request}");
    private static final PathTemplate FOLDER_APPROVAL_REQUEST = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/approvalRequests/{approval_request}");
    private static final PathTemplate ORGANIZATION_APPROVAL_REQUEST = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/approvalRequests/{approval_request}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String approvalRequest;
    private final String folder;
    private final String organization;

    @Deprecated
    protected ApprovalRequestName() {
        this.project = null;
        this.approvalRequest = null;
        this.folder = null;
        this.organization = null;
    }

    private ApprovalRequestName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.approvalRequest = (String)Preconditions.checkNotNull((Object)builder.getApprovalRequest());
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT_APPROVAL_REQUEST;
    }

    private ApprovalRequestName(FolderApprovalRequestBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.approvalRequest = (String)Preconditions.checkNotNull((Object)builder.getApprovalRequest());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_APPROVAL_REQUEST;
    }

    private ApprovalRequestName(OrganizationApprovalRequestBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.approvalRequest = (String)Preconditions.checkNotNull((Object)builder.getApprovalRequest());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_APPROVAL_REQUEST;
    }

    public String getProject() {
        return this.project;
    }

    public String getApprovalRequest() {
        return this.approvalRequest;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectApprovalRequestBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderApprovalRequestBuilder newFolderApprovalRequestBuilder() {
        return new FolderApprovalRequestBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationApprovalRequestBuilder newOrganizationApprovalRequestBuilder() {
        return new OrganizationApprovalRequestBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ApprovalRequestName of(String project, String approvalRequest) {
        return ApprovalRequestName.newBuilder().setProject(project).setApprovalRequest(approvalRequest).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ApprovalRequestName ofProjectApprovalRequestName(String project, String approvalRequest) {
        return ApprovalRequestName.newBuilder().setProject(project).setApprovalRequest(approvalRequest).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ApprovalRequestName ofFolderApprovalRequestName(String folder, String approvalRequest) {
        return ApprovalRequestName.newFolderApprovalRequestBuilder().setFolder(folder).setApprovalRequest(approvalRequest).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ApprovalRequestName ofOrganizationApprovalRequestName(String organization, String approvalRequest) {
        return ApprovalRequestName.newOrganizationApprovalRequestBuilder().setOrganization(organization).setApprovalRequest(approvalRequest).build();
    }

    public static String format(String project, String approvalRequest) {
        return ApprovalRequestName.newBuilder().setProject(project).setApprovalRequest(approvalRequest).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectApprovalRequestName(String project, String approvalRequest) {
        return ApprovalRequestName.newBuilder().setProject(project).setApprovalRequest(approvalRequest).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderApprovalRequestName(String folder, String approvalRequest) {
        return ApprovalRequestName.newFolderApprovalRequestBuilder().setFolder(folder).setApprovalRequest(approvalRequest).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationApprovalRequestName(String organization, String approvalRequest) {
        return ApprovalRequestName.newOrganizationApprovalRequestBuilder().setOrganization(organization).setApprovalRequest(approvalRequest).build().toString();
    }

    public static ApprovalRequestName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_APPROVAL_REQUEST.matches(formattedString)) {
            Map matchMap = PROJECT_APPROVAL_REQUEST.match(formattedString);
            return ApprovalRequestName.ofProjectApprovalRequestName((String)matchMap.get("project"), (String)matchMap.get("approval_request"));
        }
        if (FOLDER_APPROVAL_REQUEST.matches(formattedString)) {
            Map matchMap = FOLDER_APPROVAL_REQUEST.match(formattedString);
            return ApprovalRequestName.ofFolderApprovalRequestName((String)matchMap.get("folder"), (String)matchMap.get("approval_request"));
        }
        if (ORGANIZATION_APPROVAL_REQUEST.matches(formattedString)) {
            Map matchMap = ORGANIZATION_APPROVAL_REQUEST.match(formattedString);
            return ApprovalRequestName.ofOrganizationApprovalRequestName((String)matchMap.get("organization"), (String)matchMap.get("approval_request"));
        }
        throw new ValidationException("ApprovalRequestName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ApprovalRequestName> parseList(List<String> formattedStrings) {
        ArrayList<ApprovalRequestName> list = new ArrayList<ApprovalRequestName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ApprovalRequestName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ApprovalRequestName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ApprovalRequestName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_APPROVAL_REQUEST.matches(formattedString) || FOLDER_APPROVAL_REQUEST.matches(formattedString) || ORGANIZATION_APPROVAL_REQUEST.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ApprovalRequestName approvalRequestName = this;
            synchronized (approvalRequestName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.approvalRequest != null) {
                        fieldMapBuilder.put((Object)"approval_request", (Object)this.approvalRequest);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ApprovalRequestName that = (ApprovalRequestName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.approvalRequest, that.approvalRequest) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.approvalRequest);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationApprovalRequestBuilder {
        private String organization;
        private String approvalRequest;

        protected OrganizationApprovalRequestBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getApprovalRequest() {
            return this.approvalRequest;
        }

        public OrganizationApprovalRequestBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationApprovalRequestBuilder setApprovalRequest(String approvalRequest) {
            this.approvalRequest = approvalRequest;
            return this;
        }

        public ApprovalRequestName build() {
            return new ApprovalRequestName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderApprovalRequestBuilder {
        private String folder;
        private String approvalRequest;

        protected FolderApprovalRequestBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getApprovalRequest() {
            return this.approvalRequest;
        }

        public FolderApprovalRequestBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderApprovalRequestBuilder setApprovalRequest(String approvalRequest) {
            this.approvalRequest = approvalRequest;
            return this;
        }

        public ApprovalRequestName build() {
            return new ApprovalRequestName(this);
        }
    }

    public static class Builder {
        private String project;
        private String approvalRequest;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getApprovalRequest() {
            return this.approvalRequest;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setApprovalRequest(String approvalRequest) {
            this.approvalRequest = approvalRequest;
            return this;
        }

        private Builder(ApprovalRequestName approvalRequestName) {
            Preconditions.checkArgument((boolean)Objects.equals(approvalRequestName.pathTemplate, PROJECT_APPROVAL_REQUEST), (Object)"toBuilder is only supported when ApprovalRequestName has the pattern of projects/{project}/approvalRequests/{approval_request}");
            this.project = approvalRequestName.project;
            this.approvalRequest = approvalRequestName.approvalRequest;
        }

        public ApprovalRequestName build() {
            return new ApprovalRequestName(this);
        }
    }
}

