/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1beta/analytics_data_api.proto

package com.google.analytics.data.v1beta;

/**
 *
 *
 * <pre>
 * The request for compatibility information for a report's dimensions and
 * metrics. Check compatibility provides a preview of the compatibility of a
 * report; fields shared with the `runReport` request should be the same values
 * as in your `runReport` request.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1beta.CheckCompatibilityRequest}
 */
public final class CheckCompatibilityRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1beta.CheckCompatibilityRequest)
    CheckCompatibilityRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CheckCompatibilityRequest.newBuilder() to construct.
  private CheckCompatibilityRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CheckCompatibilityRequest() {
    property_ = "";
    dimensions_ = java.util.Collections.emptyList();
    metrics_ = java.util.Collections.emptyList();
    compatibilityFilter_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CheckCompatibilityRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private CheckCompatibilityRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              property_ = s;
              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                dimensions_ = new java.util.ArrayList<com.google.analytics.data.v1beta.Dimension>();
                mutable_bitField0_ |= 0x00000001;
              }
              dimensions_.add(
                  input.readMessage(
                      com.google.analytics.data.v1beta.Dimension.parser(), extensionRegistry));
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                metrics_ = new java.util.ArrayList<com.google.analytics.data.v1beta.Metric>();
                mutable_bitField0_ |= 0x00000002;
              }
              metrics_.add(
                  input.readMessage(
                      com.google.analytics.data.v1beta.Metric.parser(), extensionRegistry));
              break;
            }
          case 34:
            {
              com.google.analytics.data.v1beta.FilterExpression.Builder subBuilder = null;
              if (dimensionFilter_ != null) {
                subBuilder = dimensionFilter_.toBuilder();
              }
              dimensionFilter_ =
                  input.readMessage(
                      com.google.analytics.data.v1beta.FilterExpression.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(dimensionFilter_);
                dimensionFilter_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.analytics.data.v1beta.FilterExpression.Builder subBuilder = null;
              if (metricFilter_ != null) {
                subBuilder = metricFilter_.toBuilder();
              }
              metricFilter_ =
                  input.readMessage(
                      com.google.analytics.data.v1beta.FilterExpression.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(metricFilter_);
                metricFilter_ = subBuilder.buildPartial();
              }

              break;
            }
          case 48:
            {
              int rawValue = input.readEnum();

              compatibilityFilter_ = rawValue;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        dimensions_ = java.util.Collections.unmodifiableList(dimensions_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        metrics_ = java.util.Collections.unmodifiableList(metrics_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1beta.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1beta_CheckCompatibilityRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1beta.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1beta_CheckCompatibilityRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1beta.CheckCompatibilityRequest.class,
            com.google.analytics.data.v1beta.CheckCompatibilityRequest.Builder.class);
  }

  public static final int PROPERTY_FIELD_NUMBER = 1;
  private volatile java.lang.Object property_;
  /**
   *
   *
   * <pre>
   * A Google Analytics GA4 property identifier whose events are tracked. To
   * learn more, see [where to find your Property
   * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
   * `property` should be the same value as in your `runReport` request.
   * Example: properties/1234
   * Set the Property ID to 0 for compatibility checking on dimensions and
   * metrics common to all properties. In this special mode, this method will
   * not return custom dimensions and metrics.
   * </pre>
   *
   * <code>string property = 1;</code>
   *
   * @return The property.
   */
  @java.lang.Override
  public java.lang.String getProperty() {
    java.lang.Object ref = property_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      property_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A Google Analytics GA4 property identifier whose events are tracked. To
   * learn more, see [where to find your Property
   * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
   * `property` should be the same value as in your `runReport` request.
   * Example: properties/1234
   * Set the Property ID to 0 for compatibility checking on dimensions and
   * metrics common to all properties. In this special mode, this method will
   * not return custom dimensions and metrics.
   * </pre>
   *
   * <code>string property = 1;</code>
   *
   * @return The bytes for property.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPropertyBytes() {
    java.lang.Object ref = property_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      property_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIMENSIONS_FIELD_NUMBER = 2;
  private java.util.List<com.google.analytics.data.v1beta.Dimension> dimensions_;
  /**
   *
   *
   * <pre>
   * The dimensions in this report. `dimensions` should be the same value as in
   * your `runReport` request.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1beta.Dimension> getDimensionsList() {
    return dimensions_;
  }
  /**
   *
   *
   * <pre>
   * The dimensions in this report. `dimensions` should be the same value as in
   * your `runReport` request.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1beta.DimensionOrBuilder>
      getDimensionsOrBuilderList() {
    return dimensions_;
  }
  /**
   *
   *
   * <pre>
   * The dimensions in this report. `dimensions` should be the same value as in
   * your `runReport` request.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
   */
  @java.lang.Override
  public int getDimensionsCount() {
    return dimensions_.size();
  }
  /**
   *
   *
   * <pre>
   * The dimensions in this report. `dimensions` should be the same value as in
   * your `runReport` request.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.Dimension getDimensions(int index) {
    return dimensions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The dimensions in this report. `dimensions` should be the same value as in
   * your `runReport` request.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.DimensionOrBuilder getDimensionsOrBuilder(int index) {
    return dimensions_.get(index);
  }

  public static final int METRICS_FIELD_NUMBER = 3;
  private java.util.List<com.google.analytics.data.v1beta.Metric> metrics_;
  /**
   *
   *
   * <pre>
   * The metrics in this report. `metrics` should be the same value as in your
   * `runReport` request.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1beta.Metric> getMetricsList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * The metrics in this report. `metrics` should be the same value as in your
   * `runReport` request.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1beta.MetricOrBuilder>
      getMetricsOrBuilderList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * The metrics in this report. `metrics` should be the same value as in your
   * `runReport` request.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
   */
  @java.lang.Override
  public int getMetricsCount() {
    return metrics_.size();
  }
  /**
   *
   *
   * <pre>
   * The metrics in this report. `metrics` should be the same value as in your
   * `runReport` request.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.Metric getMetrics(int index) {
    return metrics_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The metrics in this report. `metrics` should be the same value as in your
   * `runReport` request.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.MetricOrBuilder getMetricsOrBuilder(int index) {
    return metrics_.get(index);
  }

  public static final int DIMENSION_FILTER_FIELD_NUMBER = 4;
  private com.google.analytics.data.v1beta.FilterExpression dimensionFilter_;
  /**
   *
   *
   * <pre>
   * The filter clause of dimensions. `dimensionFilter` should be the same value
   * as in your `runReport` request.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
   *
   * @return Whether the dimensionFilter field is set.
   */
  @java.lang.Override
  public boolean hasDimensionFilter() {
    return dimensionFilter_ != null;
  }
  /**
   *
   *
   * <pre>
   * The filter clause of dimensions. `dimensionFilter` should be the same value
   * as in your `runReport` request.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
   *
   * @return The dimensionFilter.
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.FilterExpression getDimensionFilter() {
    return dimensionFilter_ == null
        ? com.google.analytics.data.v1beta.FilterExpression.getDefaultInstance()
        : dimensionFilter_;
  }
  /**
   *
   *
   * <pre>
   * The filter clause of dimensions. `dimensionFilter` should be the same value
   * as in your `runReport` request.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.FilterExpressionOrBuilder getDimensionFilterOrBuilder() {
    return getDimensionFilter();
  }

  public static final int METRIC_FILTER_FIELD_NUMBER = 5;
  private com.google.analytics.data.v1beta.FilterExpression metricFilter_;
  /**
   *
   *
   * <pre>
   * The filter clause of metrics. `metricFilter` should be the same value as in
   * your `runReport` request
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
   *
   * @return Whether the metricFilter field is set.
   */
  @java.lang.Override
  public boolean hasMetricFilter() {
    return metricFilter_ != null;
  }
  /**
   *
   *
   * <pre>
   * The filter clause of metrics. `metricFilter` should be the same value as in
   * your `runReport` request
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
   *
   * @return The metricFilter.
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.FilterExpression getMetricFilter() {
    return metricFilter_ == null
        ? com.google.analytics.data.v1beta.FilterExpression.getDefaultInstance()
        : metricFilter_;
  }
  /**
   *
   *
   * <pre>
   * The filter clause of metrics. `metricFilter` should be the same value as in
   * your `runReport` request
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.FilterExpressionOrBuilder getMetricFilterOrBuilder() {
    return getMetricFilter();
  }

  public static final int COMPATIBILITY_FILTER_FIELD_NUMBER = 6;
  private int compatibilityFilter_;
  /**
   *
   *
   * <pre>
   * Filters the dimensions and metrics in the response to just this
   * compatibility. Commonly used as `”compatibilityFilter”: “COMPATIBLE”`
   * to only return compatible dimensions &amp; metrics.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.Compatibility compatibility_filter = 6;</code>
   *
   * @return The enum numeric value on the wire for compatibilityFilter.
   */
  @java.lang.Override
  public int getCompatibilityFilterValue() {
    return compatibilityFilter_;
  }
  /**
   *
   *
   * <pre>
   * Filters the dimensions and metrics in the response to just this
   * compatibility. Commonly used as `”compatibilityFilter”: “COMPATIBLE”`
   * to only return compatible dimensions &amp; metrics.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.Compatibility compatibility_filter = 6;</code>
   *
   * @return The compatibilityFilter.
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.Compatibility getCompatibilityFilter() {
    @SuppressWarnings("deprecation")
    com.google.analytics.data.v1beta.Compatibility result =
        com.google.analytics.data.v1beta.Compatibility.valueOf(compatibilityFilter_);
    return result == null ? com.google.analytics.data.v1beta.Compatibility.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(property_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, property_);
    }
    for (int i = 0; i < dimensions_.size(); i++) {
      output.writeMessage(2, dimensions_.get(i));
    }
    for (int i = 0; i < metrics_.size(); i++) {
      output.writeMessage(3, metrics_.get(i));
    }
    if (dimensionFilter_ != null) {
      output.writeMessage(4, getDimensionFilter());
    }
    if (metricFilter_ != null) {
      output.writeMessage(5, getMetricFilter());
    }
    if (compatibilityFilter_
        != com.google.analytics.data.v1beta.Compatibility.COMPATIBILITY_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, compatibilityFilter_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(property_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, property_);
    }
    for (int i = 0; i < dimensions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, dimensions_.get(i));
    }
    for (int i = 0; i < metrics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, metrics_.get(i));
    }
    if (dimensionFilter_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDimensionFilter());
    }
    if (metricFilter_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getMetricFilter());
    }
    if (compatibilityFilter_
        != com.google.analytics.data.v1beta.Compatibility.COMPATIBILITY_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, compatibilityFilter_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1beta.CheckCompatibilityRequest)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1beta.CheckCompatibilityRequest other =
        (com.google.analytics.data.v1beta.CheckCompatibilityRequest) obj;

    if (!getProperty().equals(other.getProperty())) return false;
    if (!getDimensionsList().equals(other.getDimensionsList())) return false;
    if (!getMetricsList().equals(other.getMetricsList())) return false;
    if (hasDimensionFilter() != other.hasDimensionFilter()) return false;
    if (hasDimensionFilter()) {
      if (!getDimensionFilter().equals(other.getDimensionFilter())) return false;
    }
    if (hasMetricFilter() != other.hasMetricFilter()) return false;
    if (hasMetricFilter()) {
      if (!getMetricFilter().equals(other.getMetricFilter())) return false;
    }
    if (compatibilityFilter_ != other.compatibilityFilter_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROPERTY_FIELD_NUMBER;
    hash = (53 * hash) + getProperty().hashCode();
    if (getDimensionsCount() > 0) {
      hash = (37 * hash) + DIMENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getDimensionsList().hashCode();
    }
    if (getMetricsCount() > 0) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetricsList().hashCode();
    }
    if (hasDimensionFilter()) {
      hash = (37 * hash) + DIMENSION_FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getDimensionFilter().hashCode();
    }
    if (hasMetricFilter()) {
      hash = (37 * hash) + METRIC_FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getMetricFilter().hashCode();
    }
    hash = (37 * hash) + COMPATIBILITY_FILTER_FIELD_NUMBER;
    hash = (53 * hash) + compatibilityFilter_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1beta.CheckCompatibilityRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.CheckCompatibilityRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.CheckCompatibilityRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.CheckCompatibilityRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.CheckCompatibilityRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.CheckCompatibilityRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.CheckCompatibilityRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.CheckCompatibilityRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.CheckCompatibilityRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.CheckCompatibilityRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.CheckCompatibilityRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.CheckCompatibilityRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.analytics.data.v1beta.CheckCompatibilityRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for compatibility information for a report's dimensions and
   * metrics. Check compatibility provides a preview of the compatibility of a
   * report; fields shared with the `runReport` request should be the same values
   * as in your `runReport` request.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1beta.CheckCompatibilityRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1beta.CheckCompatibilityRequest)
      com.google.analytics.data.v1beta.CheckCompatibilityRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1beta.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1beta_CheckCompatibilityRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1beta.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1beta_CheckCompatibilityRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1beta.CheckCompatibilityRequest.class,
              com.google.analytics.data.v1beta.CheckCompatibilityRequest.Builder.class);
    }

    // Construct using com.google.analytics.data.v1beta.CheckCompatibilityRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDimensionsFieldBuilder();
        getMetricsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      property_ = "";

      if (dimensionsBuilder_ == null) {
        dimensions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        dimensionsBuilder_.clear();
      }
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        metricsBuilder_.clear();
      }
      if (dimensionFilterBuilder_ == null) {
        dimensionFilter_ = null;
      } else {
        dimensionFilter_ = null;
        dimensionFilterBuilder_ = null;
      }
      if (metricFilterBuilder_ == null) {
        metricFilter_ = null;
      } else {
        metricFilter_ = null;
        metricFilterBuilder_ = null;
      }
      compatibilityFilter_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1beta.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1beta_CheckCompatibilityRequest_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.CheckCompatibilityRequest getDefaultInstanceForType() {
      return com.google.analytics.data.v1beta.CheckCompatibilityRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.CheckCompatibilityRequest build() {
      com.google.analytics.data.v1beta.CheckCompatibilityRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.CheckCompatibilityRequest buildPartial() {
      com.google.analytics.data.v1beta.CheckCompatibilityRequest result =
          new com.google.analytics.data.v1beta.CheckCompatibilityRequest(this);
      int from_bitField0_ = bitField0_;
      result.property_ = property_;
      if (dimensionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          dimensions_ = java.util.Collections.unmodifiableList(dimensions_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.dimensions_ = dimensions_;
      } else {
        result.dimensions_ = dimensionsBuilder_.build();
      }
      if (metricsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          metrics_ = java.util.Collections.unmodifiableList(metrics_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.metrics_ = metrics_;
      } else {
        result.metrics_ = metricsBuilder_.build();
      }
      if (dimensionFilterBuilder_ == null) {
        result.dimensionFilter_ = dimensionFilter_;
      } else {
        result.dimensionFilter_ = dimensionFilterBuilder_.build();
      }
      if (metricFilterBuilder_ == null) {
        result.metricFilter_ = metricFilter_;
      } else {
        result.metricFilter_ = metricFilterBuilder_.build();
      }
      result.compatibilityFilter_ = compatibilityFilter_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1beta.CheckCompatibilityRequest) {
        return mergeFrom((com.google.analytics.data.v1beta.CheckCompatibilityRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1beta.CheckCompatibilityRequest other) {
      if (other == com.google.analytics.data.v1beta.CheckCompatibilityRequest.getDefaultInstance())
        return this;
      if (!other.getProperty().isEmpty()) {
        property_ = other.property_;
        onChanged();
      }
      if (dimensionsBuilder_ == null) {
        if (!other.dimensions_.isEmpty()) {
          if (dimensions_.isEmpty()) {
            dimensions_ = other.dimensions_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureDimensionsIsMutable();
            dimensions_.addAll(other.dimensions_);
          }
          onChanged();
        }
      } else {
        if (!other.dimensions_.isEmpty()) {
          if (dimensionsBuilder_.isEmpty()) {
            dimensionsBuilder_.dispose();
            dimensionsBuilder_ = null;
            dimensions_ = other.dimensions_;
            bitField0_ = (bitField0_ & ~0x00000001);
            dimensionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDimensionsFieldBuilder()
                    : null;
          } else {
            dimensionsBuilder_.addAllMessages(other.dimensions_);
          }
        }
      }
      if (metricsBuilder_ == null) {
        if (!other.metrics_.isEmpty()) {
          if (metrics_.isEmpty()) {
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureMetricsIsMutable();
            metrics_.addAll(other.metrics_);
          }
          onChanged();
        }
      } else {
        if (!other.metrics_.isEmpty()) {
          if (metricsBuilder_.isEmpty()) {
            metricsBuilder_.dispose();
            metricsBuilder_ = null;
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000002);
            metricsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMetricsFieldBuilder()
                    : null;
          } else {
            metricsBuilder_.addAllMessages(other.metrics_);
          }
        }
      }
      if (other.hasDimensionFilter()) {
        mergeDimensionFilter(other.getDimensionFilter());
      }
      if (other.hasMetricFilter()) {
        mergeMetricFilter(other.getMetricFilter());
      }
      if (other.compatibilityFilter_ != 0) {
        setCompatibilityFilterValue(other.getCompatibilityFilterValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.analytics.data.v1beta.CheckCompatibilityRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.analytics.data.v1beta.CheckCompatibilityRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object property_ = "";
    /**
     *
     *
     * <pre>
     * A Google Analytics GA4 property identifier whose events are tracked. To
     * learn more, see [where to find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     * `property` should be the same value as in your `runReport` request.
     * Example: properties/1234
     * Set the Property ID to 0 for compatibility checking on dimensions and
     * metrics common to all properties. In this special mode, this method will
     * not return custom dimensions and metrics.
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @return The property.
     */
    public java.lang.String getProperty() {
      java.lang.Object ref = property_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        property_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A Google Analytics GA4 property identifier whose events are tracked. To
     * learn more, see [where to find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     * `property` should be the same value as in your `runReport` request.
     * Example: properties/1234
     * Set the Property ID to 0 for compatibility checking on dimensions and
     * metrics common to all properties. In this special mode, this method will
     * not return custom dimensions and metrics.
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @return The bytes for property.
     */
    public com.google.protobuf.ByteString getPropertyBytes() {
      java.lang.Object ref = property_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        property_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A Google Analytics GA4 property identifier whose events are tracked. To
     * learn more, see [where to find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     * `property` should be the same value as in your `runReport` request.
     * Example: properties/1234
     * Set the Property ID to 0 for compatibility checking on dimensions and
     * metrics common to all properties. In this special mode, this method will
     * not return custom dimensions and metrics.
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @param value The property to set.
     * @return This builder for chaining.
     */
    public Builder setProperty(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      property_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Google Analytics GA4 property identifier whose events are tracked. To
     * learn more, see [where to find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     * `property` should be the same value as in your `runReport` request.
     * Example: properties/1234
     * Set the Property ID to 0 for compatibility checking on dimensions and
     * metrics common to all properties. In this special mode, this method will
     * not return custom dimensions and metrics.
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProperty() {

      property_ = getDefaultInstance().getProperty();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Google Analytics GA4 property identifier whose events are tracked. To
     * learn more, see [where to find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     * `property` should be the same value as in your `runReport` request.
     * Example: properties/1234
     * Set the Property ID to 0 for compatibility checking on dimensions and
     * metrics common to all properties. In this special mode, this method will
     * not return custom dimensions and metrics.
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @param value The bytes for property to set.
     * @return This builder for chaining.
     */
    public Builder setPropertyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      property_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.analytics.data.v1beta.Dimension> dimensions_ =
        java.util.Collections.emptyList();

    private void ensureDimensionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        dimensions_ =
            new java.util.ArrayList<com.google.analytics.data.v1beta.Dimension>(dimensions_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.Dimension,
            com.google.analytics.data.v1beta.Dimension.Builder,
            com.google.analytics.data.v1beta.DimensionOrBuilder>
        dimensionsBuilder_;

    /**
     *
     *
     * <pre>
     * The dimensions in this report. `dimensions` should be the same value as in
     * your `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.Dimension> getDimensionsList() {
      if (dimensionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dimensions_);
      } else {
        return dimensionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The dimensions in this report. `dimensions` should be the same value as in
     * your `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public int getDimensionsCount() {
      if (dimensionsBuilder_ == null) {
        return dimensions_.size();
      } else {
        return dimensionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The dimensions in this report. `dimensions` should be the same value as in
     * your `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public com.google.analytics.data.v1beta.Dimension getDimensions(int index) {
      if (dimensionsBuilder_ == null) {
        return dimensions_.get(index);
      } else {
        return dimensionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The dimensions in this report. `dimensions` should be the same value as in
     * your `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public Builder setDimensions(int index, com.google.analytics.data.v1beta.Dimension value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.set(index, value);
        onChanged();
      } else {
        dimensionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions in this report. `dimensions` should be the same value as in
     * your `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public Builder setDimensions(
        int index, com.google.analytics.data.v1beta.Dimension.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.set(index, builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions in this report. `dimensions` should be the same value as in
     * your `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public Builder addDimensions(com.google.analytics.data.v1beta.Dimension value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.add(value);
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions in this report. `dimensions` should be the same value as in
     * your `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public Builder addDimensions(int index, com.google.analytics.data.v1beta.Dimension value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.add(index, value);
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions in this report. `dimensions` should be the same value as in
     * your `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public Builder addDimensions(
        com.google.analytics.data.v1beta.Dimension.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.add(builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions in this report. `dimensions` should be the same value as in
     * your `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public Builder addDimensions(
        int index, com.google.analytics.data.v1beta.Dimension.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.add(index, builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions in this report. `dimensions` should be the same value as in
     * your `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public Builder addAllDimensions(
        java.lang.Iterable<? extends com.google.analytics.data.v1beta.Dimension> values) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dimensions_);
        onChanged();
      } else {
        dimensionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions in this report. `dimensions` should be the same value as in
     * your `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public Builder clearDimensions() {
      if (dimensionsBuilder_ == null) {
        dimensions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        dimensionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions in this report. `dimensions` should be the same value as in
     * your `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public Builder removeDimensions(int index) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.remove(index);
        onChanged();
      } else {
        dimensionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions in this report. `dimensions` should be the same value as in
     * your `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public com.google.analytics.data.v1beta.Dimension.Builder getDimensionsBuilder(int index) {
      return getDimensionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The dimensions in this report. `dimensions` should be the same value as in
     * your `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public com.google.analytics.data.v1beta.DimensionOrBuilder getDimensionsOrBuilder(int index) {
      if (dimensionsBuilder_ == null) {
        return dimensions_.get(index);
      } else {
        return dimensionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The dimensions in this report. `dimensions` should be the same value as in
     * your `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public java.util.List<? extends com.google.analytics.data.v1beta.DimensionOrBuilder>
        getDimensionsOrBuilderList() {
      if (dimensionsBuilder_ != null) {
        return dimensionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dimensions_);
      }
    }
    /**
     *
     *
     * <pre>
     * The dimensions in this report. `dimensions` should be the same value as in
     * your `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public com.google.analytics.data.v1beta.Dimension.Builder addDimensionsBuilder() {
      return getDimensionsFieldBuilder()
          .addBuilder(com.google.analytics.data.v1beta.Dimension.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The dimensions in this report. `dimensions` should be the same value as in
     * your `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public com.google.analytics.data.v1beta.Dimension.Builder addDimensionsBuilder(int index) {
      return getDimensionsFieldBuilder()
          .addBuilder(index, com.google.analytics.data.v1beta.Dimension.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The dimensions in this report. `dimensions` should be the same value as in
     * your `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.Dimension.Builder>
        getDimensionsBuilderList() {
      return getDimensionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.Dimension,
            com.google.analytics.data.v1beta.Dimension.Builder,
            com.google.analytics.data.v1beta.DimensionOrBuilder>
        getDimensionsFieldBuilder() {
      if (dimensionsBuilder_ == null) {
        dimensionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1beta.Dimension,
                com.google.analytics.data.v1beta.Dimension.Builder,
                com.google.analytics.data.v1beta.DimensionOrBuilder>(
                dimensions_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        dimensions_ = null;
      }
      return dimensionsBuilder_;
    }

    private java.util.List<com.google.analytics.data.v1beta.Metric> metrics_ =
        java.util.Collections.emptyList();

    private void ensureMetricsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        metrics_ = new java.util.ArrayList<com.google.analytics.data.v1beta.Metric>(metrics_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.Metric,
            com.google.analytics.data.v1beta.Metric.Builder,
            com.google.analytics.data.v1beta.MetricOrBuilder>
        metricsBuilder_;

    /**
     *
     *
     * <pre>
     * The metrics in this report. `metrics` should be the same value as in your
     * `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.Metric> getMetricsList() {
      if (metricsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(metrics_);
      } else {
        return metricsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The metrics in this report. `metrics` should be the same value as in your
     * `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public int getMetricsCount() {
      if (metricsBuilder_ == null) {
        return metrics_.size();
      } else {
        return metricsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The metrics in this report. `metrics` should be the same value as in your
     * `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public com.google.analytics.data.v1beta.Metric getMetrics(int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The metrics in this report. `metrics` should be the same value as in your
     * `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public Builder setMetrics(int index, com.google.analytics.data.v1beta.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.set(index, value);
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics in this report. `metrics` should be the same value as in your
     * `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public Builder setMetrics(
        int index, com.google.analytics.data.v1beta.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.set(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics in this report. `metrics` should be the same value as in your
     * `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public Builder addMetrics(com.google.analytics.data.v1beta.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics in this report. `metrics` should be the same value as in your
     * `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public Builder addMetrics(int index, com.google.analytics.data.v1beta.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(index, value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics in this report. `metrics` should be the same value as in your
     * `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public Builder addMetrics(com.google.analytics.data.v1beta.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics in this report. `metrics` should be the same value as in your
     * `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public Builder addMetrics(
        int index, com.google.analytics.data.v1beta.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics in this report. `metrics` should be the same value as in your
     * `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public Builder addAllMetrics(
        java.lang.Iterable<? extends com.google.analytics.data.v1beta.Metric> values) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metrics_);
        onChanged();
      } else {
        metricsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics in this report. `metrics` should be the same value as in your
     * `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public Builder clearMetrics() {
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        metricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics in this report. `metrics` should be the same value as in your
     * `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public Builder removeMetrics(int index) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.remove(index);
        onChanged();
      } else {
        metricsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics in this report. `metrics` should be the same value as in your
     * `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public com.google.analytics.data.v1beta.Metric.Builder getMetricsBuilder(int index) {
      return getMetricsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The metrics in this report. `metrics` should be the same value as in your
     * `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public com.google.analytics.data.v1beta.MetricOrBuilder getMetricsOrBuilder(int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The metrics in this report. `metrics` should be the same value as in your
     * `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public java.util.List<? extends com.google.analytics.data.v1beta.MetricOrBuilder>
        getMetricsOrBuilderList() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(metrics_);
      }
    }
    /**
     *
     *
     * <pre>
     * The metrics in this report. `metrics` should be the same value as in your
     * `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public com.google.analytics.data.v1beta.Metric.Builder addMetricsBuilder() {
      return getMetricsFieldBuilder()
          .addBuilder(com.google.analytics.data.v1beta.Metric.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The metrics in this report. `metrics` should be the same value as in your
     * `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public com.google.analytics.data.v1beta.Metric.Builder addMetricsBuilder(int index) {
      return getMetricsFieldBuilder()
          .addBuilder(index, com.google.analytics.data.v1beta.Metric.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The metrics in this report. `metrics` should be the same value as in your
     * `runReport` request.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.Metric.Builder> getMetricsBuilderList() {
      return getMetricsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.Metric,
            com.google.analytics.data.v1beta.Metric.Builder,
            com.google.analytics.data.v1beta.MetricOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1beta.Metric,
                com.google.analytics.data.v1beta.Metric.Builder,
                com.google.analytics.data.v1beta.MetricOrBuilder>(
                metrics_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    private com.google.analytics.data.v1beta.FilterExpression dimensionFilter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.FilterExpression,
            com.google.analytics.data.v1beta.FilterExpression.Builder,
            com.google.analytics.data.v1beta.FilterExpressionOrBuilder>
        dimensionFilterBuilder_;
    /**
     *
     *
     * <pre>
     * The filter clause of dimensions. `dimensionFilter` should be the same value
     * as in your `runReport` request.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
     *
     * @return Whether the dimensionFilter field is set.
     */
    public boolean hasDimensionFilter() {
      return dimensionFilterBuilder_ != null || dimensionFilter_ != null;
    }
    /**
     *
     *
     * <pre>
     * The filter clause of dimensions. `dimensionFilter` should be the same value
     * as in your `runReport` request.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
     *
     * @return The dimensionFilter.
     */
    public com.google.analytics.data.v1beta.FilterExpression getDimensionFilter() {
      if (dimensionFilterBuilder_ == null) {
        return dimensionFilter_ == null
            ? com.google.analytics.data.v1beta.FilterExpression.getDefaultInstance()
            : dimensionFilter_;
      } else {
        return dimensionFilterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The filter clause of dimensions. `dimensionFilter` should be the same value
     * as in your `runReport` request.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
     */
    public Builder setDimensionFilter(com.google.analytics.data.v1beta.FilterExpression value) {
      if (dimensionFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dimensionFilter_ = value;
        onChanged();
      } else {
        dimensionFilterBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter clause of dimensions. `dimensionFilter` should be the same value
     * as in your `runReport` request.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
     */
    public Builder setDimensionFilter(
        com.google.analytics.data.v1beta.FilterExpression.Builder builderForValue) {
      if (dimensionFilterBuilder_ == null) {
        dimensionFilter_ = builderForValue.build();
        onChanged();
      } else {
        dimensionFilterBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter clause of dimensions. `dimensionFilter` should be the same value
     * as in your `runReport` request.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
     */
    public Builder mergeDimensionFilter(com.google.analytics.data.v1beta.FilterExpression value) {
      if (dimensionFilterBuilder_ == null) {
        if (dimensionFilter_ != null) {
          dimensionFilter_ =
              com.google.analytics.data.v1beta.FilterExpression.newBuilder(dimensionFilter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dimensionFilter_ = value;
        }
        onChanged();
      } else {
        dimensionFilterBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter clause of dimensions. `dimensionFilter` should be the same value
     * as in your `runReport` request.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
     */
    public Builder clearDimensionFilter() {
      if (dimensionFilterBuilder_ == null) {
        dimensionFilter_ = null;
        onChanged();
      } else {
        dimensionFilter_ = null;
        dimensionFilterBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter clause of dimensions. `dimensionFilter` should be the same value
     * as in your `runReport` request.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
     */
    public com.google.analytics.data.v1beta.FilterExpression.Builder getDimensionFilterBuilder() {

      onChanged();
      return getDimensionFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The filter clause of dimensions. `dimensionFilter` should be the same value
     * as in your `runReport` request.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
     */
    public com.google.analytics.data.v1beta.FilterExpressionOrBuilder
        getDimensionFilterOrBuilder() {
      if (dimensionFilterBuilder_ != null) {
        return dimensionFilterBuilder_.getMessageOrBuilder();
      } else {
        return dimensionFilter_ == null
            ? com.google.analytics.data.v1beta.FilterExpression.getDefaultInstance()
            : dimensionFilter_;
      }
    }
    /**
     *
     *
     * <pre>
     * The filter clause of dimensions. `dimensionFilter` should be the same value
     * as in your `runReport` request.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.FilterExpression,
            com.google.analytics.data.v1beta.FilterExpression.Builder,
            com.google.analytics.data.v1beta.FilterExpressionOrBuilder>
        getDimensionFilterFieldBuilder() {
      if (dimensionFilterBuilder_ == null) {
        dimensionFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1beta.FilterExpression,
                com.google.analytics.data.v1beta.FilterExpression.Builder,
                com.google.analytics.data.v1beta.FilterExpressionOrBuilder>(
                getDimensionFilter(), getParentForChildren(), isClean());
        dimensionFilter_ = null;
      }
      return dimensionFilterBuilder_;
    }

    private com.google.analytics.data.v1beta.FilterExpression metricFilter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.FilterExpression,
            com.google.analytics.data.v1beta.FilterExpression.Builder,
            com.google.analytics.data.v1beta.FilterExpressionOrBuilder>
        metricFilterBuilder_;
    /**
     *
     *
     * <pre>
     * The filter clause of metrics. `metricFilter` should be the same value as in
     * your `runReport` request
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
     *
     * @return Whether the metricFilter field is set.
     */
    public boolean hasMetricFilter() {
      return metricFilterBuilder_ != null || metricFilter_ != null;
    }
    /**
     *
     *
     * <pre>
     * The filter clause of metrics. `metricFilter` should be the same value as in
     * your `runReport` request
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
     *
     * @return The metricFilter.
     */
    public com.google.analytics.data.v1beta.FilterExpression getMetricFilter() {
      if (metricFilterBuilder_ == null) {
        return metricFilter_ == null
            ? com.google.analytics.data.v1beta.FilterExpression.getDefaultInstance()
            : metricFilter_;
      } else {
        return metricFilterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The filter clause of metrics. `metricFilter` should be the same value as in
     * your `runReport` request
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
     */
    public Builder setMetricFilter(com.google.analytics.data.v1beta.FilterExpression value) {
      if (metricFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricFilter_ = value;
        onChanged();
      } else {
        metricFilterBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter clause of metrics. `metricFilter` should be the same value as in
     * your `runReport` request
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
     */
    public Builder setMetricFilter(
        com.google.analytics.data.v1beta.FilterExpression.Builder builderForValue) {
      if (metricFilterBuilder_ == null) {
        metricFilter_ = builderForValue.build();
        onChanged();
      } else {
        metricFilterBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter clause of metrics. `metricFilter` should be the same value as in
     * your `runReport` request
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
     */
    public Builder mergeMetricFilter(com.google.analytics.data.v1beta.FilterExpression value) {
      if (metricFilterBuilder_ == null) {
        if (metricFilter_ != null) {
          metricFilter_ =
              com.google.analytics.data.v1beta.FilterExpression.newBuilder(metricFilter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricFilter_ = value;
        }
        onChanged();
      } else {
        metricFilterBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter clause of metrics. `metricFilter` should be the same value as in
     * your `runReport` request
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
     */
    public Builder clearMetricFilter() {
      if (metricFilterBuilder_ == null) {
        metricFilter_ = null;
        onChanged();
      } else {
        metricFilter_ = null;
        metricFilterBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter clause of metrics. `metricFilter` should be the same value as in
     * your `runReport` request
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
     */
    public com.google.analytics.data.v1beta.FilterExpression.Builder getMetricFilterBuilder() {

      onChanged();
      return getMetricFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The filter clause of metrics. `metricFilter` should be the same value as in
     * your `runReport` request
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
     */
    public com.google.analytics.data.v1beta.FilterExpressionOrBuilder getMetricFilterOrBuilder() {
      if (metricFilterBuilder_ != null) {
        return metricFilterBuilder_.getMessageOrBuilder();
      } else {
        return metricFilter_ == null
            ? com.google.analytics.data.v1beta.FilterExpression.getDefaultInstance()
            : metricFilter_;
      }
    }
    /**
     *
     *
     * <pre>
     * The filter clause of metrics. `metricFilter` should be the same value as in
     * your `runReport` request
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.FilterExpression,
            com.google.analytics.data.v1beta.FilterExpression.Builder,
            com.google.analytics.data.v1beta.FilterExpressionOrBuilder>
        getMetricFilterFieldBuilder() {
      if (metricFilterBuilder_ == null) {
        metricFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1beta.FilterExpression,
                com.google.analytics.data.v1beta.FilterExpression.Builder,
                com.google.analytics.data.v1beta.FilterExpressionOrBuilder>(
                getMetricFilter(), getParentForChildren(), isClean());
        metricFilter_ = null;
      }
      return metricFilterBuilder_;
    }

    private int compatibilityFilter_ = 0;
    /**
     *
     *
     * <pre>
     * Filters the dimensions and metrics in the response to just this
     * compatibility. Commonly used as `”compatibilityFilter”: “COMPATIBLE”`
     * to only return compatible dimensions &amp; metrics.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.Compatibility compatibility_filter = 6;</code>
     *
     * @return The enum numeric value on the wire for compatibilityFilter.
     */
    @java.lang.Override
    public int getCompatibilityFilterValue() {
      return compatibilityFilter_;
    }
    /**
     *
     *
     * <pre>
     * Filters the dimensions and metrics in the response to just this
     * compatibility. Commonly used as `”compatibilityFilter”: “COMPATIBLE”`
     * to only return compatible dimensions &amp; metrics.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.Compatibility compatibility_filter = 6;</code>
     *
     * @param value The enum numeric value on the wire for compatibilityFilter to set.
     * @return This builder for chaining.
     */
    public Builder setCompatibilityFilterValue(int value) {

      compatibilityFilter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filters the dimensions and metrics in the response to just this
     * compatibility. Commonly used as `”compatibilityFilter”: “COMPATIBLE”`
     * to only return compatible dimensions &amp; metrics.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.Compatibility compatibility_filter = 6;</code>
     *
     * @return The compatibilityFilter.
     */
    @java.lang.Override
    public com.google.analytics.data.v1beta.Compatibility getCompatibilityFilter() {
      @SuppressWarnings("deprecation")
      com.google.analytics.data.v1beta.Compatibility result =
          com.google.analytics.data.v1beta.Compatibility.valueOf(compatibilityFilter_);
      return result == null ? com.google.analytics.data.v1beta.Compatibility.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Filters the dimensions and metrics in the response to just this
     * compatibility. Commonly used as `”compatibilityFilter”: “COMPATIBLE”`
     * to only return compatible dimensions &amp; metrics.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.Compatibility compatibility_filter = 6;</code>
     *
     * @param value The compatibilityFilter to set.
     * @return This builder for chaining.
     */
    public Builder setCompatibilityFilter(com.google.analytics.data.v1beta.Compatibility value) {
      if (value == null) {
        throw new NullPointerException();
      }

      compatibilityFilter_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filters the dimensions and metrics in the response to just this
     * compatibility. Commonly used as `”compatibilityFilter”: “COMPATIBLE”`
     * to only return compatible dimensions &amp; metrics.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.Compatibility compatibility_filter = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCompatibilityFilter() {

      compatibilityFilter_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1beta.CheckCompatibilityRequest)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1beta.CheckCompatibilityRequest)
  private static final com.google.analytics.data.v1beta.CheckCompatibilityRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1beta.CheckCompatibilityRequest();
  }

  public static com.google.analytics.data.v1beta.CheckCompatibilityRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CheckCompatibilityRequest> PARSER =
      new com.google.protobuf.AbstractParser<CheckCompatibilityRequest>() {
        @java.lang.Override
        public CheckCompatibilityRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new CheckCompatibilityRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<CheckCompatibilityRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CheckCompatibilityRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1beta.CheckCompatibilityRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
