/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/analytics_data_api.proto

package com.google.analytics.data.v1alpha;

public interface AudienceListOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.analytics.data.v1alpha.AudienceList)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. The audience list resource name assigned during creation. This
   * resource name identifies this `AudienceList`.
   *
   * Format: `properties/{propertyId}/audienceLists/{audienceListId}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Output only. The audience list resource name assigned during creation. This
   * resource name identifies this `AudienceList`.
   *
   * Format: `properties/{propertyId}/audienceLists/{audienceListId}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The audience resource name. This resource name identifies the
   * audience being listed and is shared between the Analytics Data &amp; Admin
   * APIs.
   *
   * Format: `properties/{propertyId}/audiences/{audienceId}`
   * </pre>
   *
   * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The audience.
   */
  java.lang.String getAudience();
  /**
   *
   *
   * <pre>
   * Required. The audience resource name. This resource name identifies the
   * audience being listed and is shared between the Analytics Data &amp; Admin
   * APIs.
   *
   * Format: `properties/{propertyId}/audiences/{audienceId}`
   * </pre>
   *
   * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for audience.
   */
  com.google.protobuf.ByteString getAudienceBytes();

  /**
   *
   *
   * <pre>
   * Output only. The descriptive display name for this audience. For example,
   * "Purchasers".
   * </pre>
   *
   * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The audienceDisplayName.
   */
  java.lang.String getAudienceDisplayName();
  /**
   *
   *
   * <pre>
   * Output only. The descriptive display name for this audience. For example,
   * "Purchasers".
   * </pre>
   *
   * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for audienceDisplayName.
   */
  com.google.protobuf.ByteString getAudienceDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the report response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<com.google.analytics.data.v1alpha.AudienceDimension> getDimensionsList();
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the report response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.analytics.data.v1alpha.AudienceDimension getDimensions(int index);
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the report response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  int getDimensionsCount();
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the report response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<? extends com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder>
      getDimensionsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the report response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder getDimensionsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Output only. The current state for this AudienceList.
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.AudienceList.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the state field is set.
   */
  boolean hasState();
  /**
   *
   *
   * <pre>
   * Output only. The current state for this AudienceList.
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.AudienceList.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * Output only. The current state for this AudienceList.
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.AudienceList.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.analytics.data.v1alpha.AudienceList.State getState();

  /**
   *
   *
   * <pre>
   * Output only. The time when CreateAudienceList was called and the
   * AudienceList began the `CREATING` state.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the beginCreatingTime field is set.
   */
  boolean hasBeginCreatingTime();
  /**
   *
   *
   * <pre>
   * Output only. The time when CreateAudienceList was called and the
   * AudienceList began the `CREATING` state.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The beginCreatingTime.
   */
  com.google.protobuf.Timestamp getBeginCreatingTime();
  /**
   *
   *
   * <pre>
   * Output only. The time when CreateAudienceList was called and the
   * AudienceList began the `CREATING` state.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getBeginCreatingTimeOrBuilder();
}
