/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/data.proto

package com.google.analytics.data.v1alpha;

/**
 *
 *
 * <pre>
 * Define conditions that must occur in a specific order for the user to be
 * a member of the segment.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1alpha.UserSegmentSequenceGroup}
 */
public final class UserSegmentSequenceGroup extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1alpha.UserSegmentSequenceGroup)
    UserSegmentSequenceGroupOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UserSegmentSequenceGroup.newBuilder() to construct.
  private UserSegmentSequenceGroup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UserSegmentSequenceGroup() {
    sequenceScoping_ = 0;
    userSequenceSteps_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UserSegmentSequenceGroup();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private UserSegmentSequenceGroup(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8:
            {
              int rawValue = input.readEnum();

              sequenceScoping_ = rawValue;
              break;
            }
          case 18:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (sequenceMaximumDuration_ != null) {
                subBuilder = sequenceMaximumDuration_.toBuilder();
              }
              sequenceMaximumDuration_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(sequenceMaximumDuration_);
                sequenceMaximumDuration_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                userSequenceSteps_ =
                    new java.util.ArrayList<com.google.analytics.data.v1alpha.UserSequenceStep>();
                mutable_bitField0_ |= 0x00000001;
              }
              userSequenceSteps_.add(
                  input.readMessage(
                      com.google.analytics.data.v1alpha.UserSequenceStep.parser(),
                      extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        userSequenceSteps_ = java.util.Collections.unmodifiableList(userSequenceSteps_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1alpha.ReportingApiProto
        .internal_static_google_analytics_data_v1alpha_UserSegmentSequenceGroup_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1alpha.ReportingApiProto
        .internal_static_google_analytics_data_v1alpha_UserSegmentSequenceGroup_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1alpha.UserSegmentSequenceGroup.class,
            com.google.analytics.data.v1alpha.UserSegmentSequenceGroup.Builder.class);
  }

  public static final int SEQUENCE_SCOPING_FIELD_NUMBER = 1;
  private int sequenceScoping_;
  /**
   *
   *
   * <pre>
   * All sequence steps must be satisfied in the scoping for the user to
   * match the sequence. For example if `sequenceScoping =
   * USER_CRITERIA_WITHIN_SAME_SESSION`, all sequence steps must complete within
   * one session for the user to match the sequence. `sequenceScoping =
   * USER_CRITERIA_WITHIN_SAME_EVENT` is not supported.
   * Optional. If unspecified, `conditionScoping = ACROSS_ALL_SESSIONS` is
   * used.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.UserCriteriaScoping sequence_scoping = 1;</code>
   *
   * @return The enum numeric value on the wire for sequenceScoping.
   */
  @java.lang.Override
  public int getSequenceScopingValue() {
    return sequenceScoping_;
  }
  /**
   *
   *
   * <pre>
   * All sequence steps must be satisfied in the scoping for the user to
   * match the sequence. For example if `sequenceScoping =
   * USER_CRITERIA_WITHIN_SAME_SESSION`, all sequence steps must complete within
   * one session for the user to match the sequence. `sequenceScoping =
   * USER_CRITERIA_WITHIN_SAME_EVENT` is not supported.
   * Optional. If unspecified, `conditionScoping = ACROSS_ALL_SESSIONS` is
   * used.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.UserCriteriaScoping sequence_scoping = 1;</code>
   *
   * @return The sequenceScoping.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.UserCriteriaScoping getSequenceScoping() {
    @SuppressWarnings("deprecation")
    com.google.analytics.data.v1alpha.UserCriteriaScoping result =
        com.google.analytics.data.v1alpha.UserCriteriaScoping.valueOf(sequenceScoping_);
    return result == null
        ? com.google.analytics.data.v1alpha.UserCriteriaScoping.UNRECOGNIZED
        : result;
  }

  public static final int SEQUENCE_MAXIMUM_DURATION_FIELD_NUMBER = 2;
  private com.google.protobuf.Duration sequenceMaximumDuration_;
  /**
   *
   *
   * <pre>
   * Defines the time period in which the whole sequence must occur; for
   * example, 30 Minutes. `sequenceMaximumDuration` is inclusive
   * of the endpoint at the microsecond granularity. For example a sequence
   * with a maximum duration of 5 seconds can be completed at 4.9 or 5.0
   * seconds, but not 5 seconds and 1 microsecond.
   * `sequenceMaximumDuration` is optional, and if unspecified, sequences can
   * be completed in any time duration.
   * </pre>
   *
   * <code>.google.protobuf.Duration sequence_maximum_duration = 2;</code>
   *
   * @return Whether the sequenceMaximumDuration field is set.
   */
  @java.lang.Override
  public boolean hasSequenceMaximumDuration() {
    return sequenceMaximumDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Defines the time period in which the whole sequence must occur; for
   * example, 30 Minutes. `sequenceMaximumDuration` is inclusive
   * of the endpoint at the microsecond granularity. For example a sequence
   * with a maximum duration of 5 seconds can be completed at 4.9 or 5.0
   * seconds, but not 5 seconds and 1 microsecond.
   * `sequenceMaximumDuration` is optional, and if unspecified, sequences can
   * be completed in any time duration.
   * </pre>
   *
   * <code>.google.protobuf.Duration sequence_maximum_duration = 2;</code>
   *
   * @return The sequenceMaximumDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getSequenceMaximumDuration() {
    return sequenceMaximumDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : sequenceMaximumDuration_;
  }
  /**
   *
   *
   * <pre>
   * Defines the time period in which the whole sequence must occur; for
   * example, 30 Minutes. `sequenceMaximumDuration` is inclusive
   * of the endpoint at the microsecond granularity. For example a sequence
   * with a maximum duration of 5 seconds can be completed at 4.9 or 5.0
   * seconds, but not 5 seconds and 1 microsecond.
   * `sequenceMaximumDuration` is optional, and if unspecified, sequences can
   * be completed in any time duration.
   * </pre>
   *
   * <code>.google.protobuf.Duration sequence_maximum_duration = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getSequenceMaximumDurationOrBuilder() {
    return getSequenceMaximumDuration();
  }

  public static final int USER_SEQUENCE_STEPS_FIELD_NUMBER = 3;
  private java.util.List<com.google.analytics.data.v1alpha.UserSequenceStep> userSequenceSteps_;
  /**
   *
   *
   * <pre>
   * An ordered sequence of condition steps. A user's events must complete
   * each step in order for the user to match the
   * `UserSegmentSequenceGroup`.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1alpha.UserSequenceStep>
      getUserSequenceStepsList() {
    return userSequenceSteps_;
  }
  /**
   *
   *
   * <pre>
   * An ordered sequence of condition steps. A user's events must complete
   * each step in order for the user to match the
   * `UserSegmentSequenceGroup`.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1alpha.UserSequenceStepOrBuilder>
      getUserSequenceStepsOrBuilderList() {
    return userSequenceSteps_;
  }
  /**
   *
   *
   * <pre>
   * An ordered sequence of condition steps. A user's events must complete
   * each step in order for the user to match the
   * `UserSegmentSequenceGroup`.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;</code>
   */
  @java.lang.Override
  public int getUserSequenceStepsCount() {
    return userSequenceSteps_.size();
  }
  /**
   *
   *
   * <pre>
   * An ordered sequence of condition steps. A user's events must complete
   * each step in order for the user to match the
   * `UserSegmentSequenceGroup`.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.UserSequenceStep getUserSequenceSteps(int index) {
    return userSequenceSteps_.get(index);
  }
  /**
   *
   *
   * <pre>
   * An ordered sequence of condition steps. A user's events must complete
   * each step in order for the user to match the
   * `UserSegmentSequenceGroup`.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.UserSequenceStepOrBuilder getUserSequenceStepsOrBuilder(
      int index) {
    return userSequenceSteps_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (sequenceScoping_
        != com.google.analytics.data.v1alpha.UserCriteriaScoping.USER_CRITERIA_SCOPING_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, sequenceScoping_);
    }
    if (sequenceMaximumDuration_ != null) {
      output.writeMessage(2, getSequenceMaximumDuration());
    }
    for (int i = 0; i < userSequenceSteps_.size(); i++) {
      output.writeMessage(3, userSequenceSteps_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (sequenceScoping_
        != com.google.analytics.data.v1alpha.UserCriteriaScoping.USER_CRITERIA_SCOPING_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, sequenceScoping_);
    }
    if (sequenceMaximumDuration_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSequenceMaximumDuration());
    }
    for (int i = 0; i < userSequenceSteps_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, userSequenceSteps_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1alpha.UserSegmentSequenceGroup)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1alpha.UserSegmentSequenceGroup other =
        (com.google.analytics.data.v1alpha.UserSegmentSequenceGroup) obj;

    if (sequenceScoping_ != other.sequenceScoping_) return false;
    if (hasSequenceMaximumDuration() != other.hasSequenceMaximumDuration()) return false;
    if (hasSequenceMaximumDuration()) {
      if (!getSequenceMaximumDuration().equals(other.getSequenceMaximumDuration())) return false;
    }
    if (!getUserSequenceStepsList().equals(other.getUserSequenceStepsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SEQUENCE_SCOPING_FIELD_NUMBER;
    hash = (53 * hash) + sequenceScoping_;
    if (hasSequenceMaximumDuration()) {
      hash = (37 * hash) + SEQUENCE_MAXIMUM_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getSequenceMaximumDuration().hashCode();
    }
    if (getUserSequenceStepsCount() > 0) {
      hash = (37 * hash) + USER_SEQUENCE_STEPS_FIELD_NUMBER;
      hash = (53 * hash) + getUserSequenceStepsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1alpha.UserSegmentSequenceGroup parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.UserSegmentSequenceGroup parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.UserSegmentSequenceGroup parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.UserSegmentSequenceGroup parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.UserSegmentSequenceGroup parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.UserSegmentSequenceGroup parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.UserSegmentSequenceGroup parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.UserSegmentSequenceGroup parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.UserSegmentSequenceGroup parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.UserSegmentSequenceGroup parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.UserSegmentSequenceGroup parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.UserSegmentSequenceGroup parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.analytics.data.v1alpha.UserSegmentSequenceGroup prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Define conditions that must occur in a specific order for the user to be
   * a member of the segment.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1alpha.UserSegmentSequenceGroup}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1alpha.UserSegmentSequenceGroup)
      com.google.analytics.data.v1alpha.UserSegmentSequenceGroupOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_UserSegmentSequenceGroup_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_UserSegmentSequenceGroup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1alpha.UserSegmentSequenceGroup.class,
              com.google.analytics.data.v1alpha.UserSegmentSequenceGroup.Builder.class);
    }

    // Construct using com.google.analytics.data.v1alpha.UserSegmentSequenceGroup.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUserSequenceStepsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      sequenceScoping_ = 0;

      if (sequenceMaximumDurationBuilder_ == null) {
        sequenceMaximumDuration_ = null;
      } else {
        sequenceMaximumDuration_ = null;
        sequenceMaximumDurationBuilder_ = null;
      }
      if (userSequenceStepsBuilder_ == null) {
        userSequenceSteps_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        userSequenceStepsBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_UserSegmentSequenceGroup_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.UserSegmentSequenceGroup getDefaultInstanceForType() {
      return com.google.analytics.data.v1alpha.UserSegmentSequenceGroup.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.UserSegmentSequenceGroup build() {
      com.google.analytics.data.v1alpha.UserSegmentSequenceGroup result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.UserSegmentSequenceGroup buildPartial() {
      com.google.analytics.data.v1alpha.UserSegmentSequenceGroup result =
          new com.google.analytics.data.v1alpha.UserSegmentSequenceGroup(this);
      int from_bitField0_ = bitField0_;
      result.sequenceScoping_ = sequenceScoping_;
      if (sequenceMaximumDurationBuilder_ == null) {
        result.sequenceMaximumDuration_ = sequenceMaximumDuration_;
      } else {
        result.sequenceMaximumDuration_ = sequenceMaximumDurationBuilder_.build();
      }
      if (userSequenceStepsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          userSequenceSteps_ = java.util.Collections.unmodifiableList(userSequenceSteps_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.userSequenceSteps_ = userSequenceSteps_;
      } else {
        result.userSequenceSteps_ = userSequenceStepsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1alpha.UserSegmentSequenceGroup) {
        return mergeFrom((com.google.analytics.data.v1alpha.UserSegmentSequenceGroup) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1alpha.UserSegmentSequenceGroup other) {
      if (other == com.google.analytics.data.v1alpha.UserSegmentSequenceGroup.getDefaultInstance())
        return this;
      if (other.sequenceScoping_ != 0) {
        setSequenceScopingValue(other.getSequenceScopingValue());
      }
      if (other.hasSequenceMaximumDuration()) {
        mergeSequenceMaximumDuration(other.getSequenceMaximumDuration());
      }
      if (userSequenceStepsBuilder_ == null) {
        if (!other.userSequenceSteps_.isEmpty()) {
          if (userSequenceSteps_.isEmpty()) {
            userSequenceSteps_ = other.userSequenceSteps_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureUserSequenceStepsIsMutable();
            userSequenceSteps_.addAll(other.userSequenceSteps_);
          }
          onChanged();
        }
      } else {
        if (!other.userSequenceSteps_.isEmpty()) {
          if (userSequenceStepsBuilder_.isEmpty()) {
            userSequenceStepsBuilder_.dispose();
            userSequenceStepsBuilder_ = null;
            userSequenceSteps_ = other.userSequenceSteps_;
            bitField0_ = (bitField0_ & ~0x00000001);
            userSequenceStepsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getUserSequenceStepsFieldBuilder()
                    : null;
          } else {
            userSequenceStepsBuilder_.addAllMessages(other.userSequenceSteps_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.analytics.data.v1alpha.UserSegmentSequenceGroup parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.analytics.data.v1alpha.UserSegmentSequenceGroup) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private int sequenceScoping_ = 0;
    /**
     *
     *
     * <pre>
     * All sequence steps must be satisfied in the scoping for the user to
     * match the sequence. For example if `sequenceScoping =
     * USER_CRITERIA_WITHIN_SAME_SESSION`, all sequence steps must complete within
     * one session for the user to match the sequence. `sequenceScoping =
     * USER_CRITERIA_WITHIN_SAME_EVENT` is not supported.
     * Optional. If unspecified, `conditionScoping = ACROSS_ALL_SESSIONS` is
     * used.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.UserCriteriaScoping sequence_scoping = 1;</code>
     *
     * @return The enum numeric value on the wire for sequenceScoping.
     */
    @java.lang.Override
    public int getSequenceScopingValue() {
      return sequenceScoping_;
    }
    /**
     *
     *
     * <pre>
     * All sequence steps must be satisfied in the scoping for the user to
     * match the sequence. For example if `sequenceScoping =
     * USER_CRITERIA_WITHIN_SAME_SESSION`, all sequence steps must complete within
     * one session for the user to match the sequence. `sequenceScoping =
     * USER_CRITERIA_WITHIN_SAME_EVENT` is not supported.
     * Optional. If unspecified, `conditionScoping = ACROSS_ALL_SESSIONS` is
     * used.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.UserCriteriaScoping sequence_scoping = 1;</code>
     *
     * @param value The enum numeric value on the wire for sequenceScoping to set.
     * @return This builder for chaining.
     */
    public Builder setSequenceScopingValue(int value) {

      sequenceScoping_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All sequence steps must be satisfied in the scoping for the user to
     * match the sequence. For example if `sequenceScoping =
     * USER_CRITERIA_WITHIN_SAME_SESSION`, all sequence steps must complete within
     * one session for the user to match the sequence. `sequenceScoping =
     * USER_CRITERIA_WITHIN_SAME_EVENT` is not supported.
     * Optional. If unspecified, `conditionScoping = ACROSS_ALL_SESSIONS` is
     * used.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.UserCriteriaScoping sequence_scoping = 1;</code>
     *
     * @return The sequenceScoping.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.UserCriteriaScoping getSequenceScoping() {
      @SuppressWarnings("deprecation")
      com.google.analytics.data.v1alpha.UserCriteriaScoping result =
          com.google.analytics.data.v1alpha.UserCriteriaScoping.valueOf(sequenceScoping_);
      return result == null
          ? com.google.analytics.data.v1alpha.UserCriteriaScoping.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * All sequence steps must be satisfied in the scoping for the user to
     * match the sequence. For example if `sequenceScoping =
     * USER_CRITERIA_WITHIN_SAME_SESSION`, all sequence steps must complete within
     * one session for the user to match the sequence. `sequenceScoping =
     * USER_CRITERIA_WITHIN_SAME_EVENT` is not supported.
     * Optional. If unspecified, `conditionScoping = ACROSS_ALL_SESSIONS` is
     * used.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.UserCriteriaScoping sequence_scoping = 1;</code>
     *
     * @param value The sequenceScoping to set.
     * @return This builder for chaining.
     */
    public Builder setSequenceScoping(com.google.analytics.data.v1alpha.UserCriteriaScoping value) {
      if (value == null) {
        throw new NullPointerException();
      }

      sequenceScoping_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All sequence steps must be satisfied in the scoping for the user to
     * match the sequence. For example if `sequenceScoping =
     * USER_CRITERIA_WITHIN_SAME_SESSION`, all sequence steps must complete within
     * one session for the user to match the sequence. `sequenceScoping =
     * USER_CRITERIA_WITHIN_SAME_EVENT` is not supported.
     * Optional. If unspecified, `conditionScoping = ACROSS_ALL_SESSIONS` is
     * used.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.UserCriteriaScoping sequence_scoping = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSequenceScoping() {

      sequenceScoping_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration sequenceMaximumDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        sequenceMaximumDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Defines the time period in which the whole sequence must occur; for
     * example, 30 Minutes. `sequenceMaximumDuration` is inclusive
     * of the endpoint at the microsecond granularity. For example a sequence
     * with a maximum duration of 5 seconds can be completed at 4.9 or 5.0
     * seconds, but not 5 seconds and 1 microsecond.
     * `sequenceMaximumDuration` is optional, and if unspecified, sequences can
     * be completed in any time duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration sequence_maximum_duration = 2;</code>
     *
     * @return Whether the sequenceMaximumDuration field is set.
     */
    public boolean hasSequenceMaximumDuration() {
      return sequenceMaximumDurationBuilder_ != null || sequenceMaximumDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Defines the time period in which the whole sequence must occur; for
     * example, 30 Minutes. `sequenceMaximumDuration` is inclusive
     * of the endpoint at the microsecond granularity. For example a sequence
     * with a maximum duration of 5 seconds can be completed at 4.9 or 5.0
     * seconds, but not 5 seconds and 1 microsecond.
     * `sequenceMaximumDuration` is optional, and if unspecified, sequences can
     * be completed in any time duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration sequence_maximum_duration = 2;</code>
     *
     * @return The sequenceMaximumDuration.
     */
    public com.google.protobuf.Duration getSequenceMaximumDuration() {
      if (sequenceMaximumDurationBuilder_ == null) {
        return sequenceMaximumDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : sequenceMaximumDuration_;
      } else {
        return sequenceMaximumDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the time period in which the whole sequence must occur; for
     * example, 30 Minutes. `sequenceMaximumDuration` is inclusive
     * of the endpoint at the microsecond granularity. For example a sequence
     * with a maximum duration of 5 seconds can be completed at 4.9 or 5.0
     * seconds, but not 5 seconds and 1 microsecond.
     * `sequenceMaximumDuration` is optional, and if unspecified, sequences can
     * be completed in any time duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration sequence_maximum_duration = 2;</code>
     */
    public Builder setSequenceMaximumDuration(com.google.protobuf.Duration value) {
      if (sequenceMaximumDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sequenceMaximumDuration_ = value;
        onChanged();
      } else {
        sequenceMaximumDurationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the time period in which the whole sequence must occur; for
     * example, 30 Minutes. `sequenceMaximumDuration` is inclusive
     * of the endpoint at the microsecond granularity. For example a sequence
     * with a maximum duration of 5 seconds can be completed at 4.9 or 5.0
     * seconds, but not 5 seconds and 1 microsecond.
     * `sequenceMaximumDuration` is optional, and if unspecified, sequences can
     * be completed in any time duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration sequence_maximum_duration = 2;</code>
     */
    public Builder setSequenceMaximumDuration(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (sequenceMaximumDurationBuilder_ == null) {
        sequenceMaximumDuration_ = builderForValue.build();
        onChanged();
      } else {
        sequenceMaximumDurationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the time period in which the whole sequence must occur; for
     * example, 30 Minutes. `sequenceMaximumDuration` is inclusive
     * of the endpoint at the microsecond granularity. For example a sequence
     * with a maximum duration of 5 seconds can be completed at 4.9 or 5.0
     * seconds, but not 5 seconds and 1 microsecond.
     * `sequenceMaximumDuration` is optional, and if unspecified, sequences can
     * be completed in any time duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration sequence_maximum_duration = 2;</code>
     */
    public Builder mergeSequenceMaximumDuration(com.google.protobuf.Duration value) {
      if (sequenceMaximumDurationBuilder_ == null) {
        if (sequenceMaximumDuration_ != null) {
          sequenceMaximumDuration_ =
              com.google.protobuf.Duration.newBuilder(sequenceMaximumDuration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sequenceMaximumDuration_ = value;
        }
        onChanged();
      } else {
        sequenceMaximumDurationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the time period in which the whole sequence must occur; for
     * example, 30 Minutes. `sequenceMaximumDuration` is inclusive
     * of the endpoint at the microsecond granularity. For example a sequence
     * with a maximum duration of 5 seconds can be completed at 4.9 or 5.0
     * seconds, but not 5 seconds and 1 microsecond.
     * `sequenceMaximumDuration` is optional, and if unspecified, sequences can
     * be completed in any time duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration sequence_maximum_duration = 2;</code>
     */
    public Builder clearSequenceMaximumDuration() {
      if (sequenceMaximumDurationBuilder_ == null) {
        sequenceMaximumDuration_ = null;
        onChanged();
      } else {
        sequenceMaximumDuration_ = null;
        sequenceMaximumDurationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the time period in which the whole sequence must occur; for
     * example, 30 Minutes. `sequenceMaximumDuration` is inclusive
     * of the endpoint at the microsecond granularity. For example a sequence
     * with a maximum duration of 5 seconds can be completed at 4.9 or 5.0
     * seconds, but not 5 seconds and 1 microsecond.
     * `sequenceMaximumDuration` is optional, and if unspecified, sequences can
     * be completed in any time duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration sequence_maximum_duration = 2;</code>
     */
    public com.google.protobuf.Duration.Builder getSequenceMaximumDurationBuilder() {

      onChanged();
      return getSequenceMaximumDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Defines the time period in which the whole sequence must occur; for
     * example, 30 Minutes. `sequenceMaximumDuration` is inclusive
     * of the endpoint at the microsecond granularity. For example a sequence
     * with a maximum duration of 5 seconds can be completed at 4.9 or 5.0
     * seconds, but not 5 seconds and 1 microsecond.
     * `sequenceMaximumDuration` is optional, and if unspecified, sequences can
     * be completed in any time duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration sequence_maximum_duration = 2;</code>
     */
    public com.google.protobuf.DurationOrBuilder getSequenceMaximumDurationOrBuilder() {
      if (sequenceMaximumDurationBuilder_ != null) {
        return sequenceMaximumDurationBuilder_.getMessageOrBuilder();
      } else {
        return sequenceMaximumDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : sequenceMaximumDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the time period in which the whole sequence must occur; for
     * example, 30 Minutes. `sequenceMaximumDuration` is inclusive
     * of the endpoint at the microsecond granularity. For example a sequence
     * with a maximum duration of 5 seconds can be completed at 4.9 or 5.0
     * seconds, but not 5 seconds and 1 microsecond.
     * `sequenceMaximumDuration` is optional, and if unspecified, sequences can
     * be completed in any time duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration sequence_maximum_duration = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getSequenceMaximumDurationFieldBuilder() {
      if (sequenceMaximumDurationBuilder_ == null) {
        sequenceMaximumDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getSequenceMaximumDuration(), getParentForChildren(), isClean());
        sequenceMaximumDuration_ = null;
      }
      return sequenceMaximumDurationBuilder_;
    }

    private java.util.List<com.google.analytics.data.v1alpha.UserSequenceStep> userSequenceSteps_ =
        java.util.Collections.emptyList();

    private void ensureUserSequenceStepsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        userSequenceSteps_ =
            new java.util.ArrayList<com.google.analytics.data.v1alpha.UserSequenceStep>(
                userSequenceSteps_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1alpha.UserSequenceStep,
            com.google.analytics.data.v1alpha.UserSequenceStep.Builder,
            com.google.analytics.data.v1alpha.UserSequenceStepOrBuilder>
        userSequenceStepsBuilder_;

    /**
     *
     *
     * <pre>
     * An ordered sequence of condition steps. A user's events must complete
     * each step in order for the user to match the
     * `UserSegmentSequenceGroup`.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;
     * </code>
     */
    public java.util.List<com.google.analytics.data.v1alpha.UserSequenceStep>
        getUserSequenceStepsList() {
      if (userSequenceStepsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(userSequenceSteps_);
      } else {
        return userSequenceStepsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * An ordered sequence of condition steps. A user's events must complete
     * each step in order for the user to match the
     * `UserSegmentSequenceGroup`.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;
     * </code>
     */
    public int getUserSequenceStepsCount() {
      if (userSequenceStepsBuilder_ == null) {
        return userSequenceSteps_.size();
      } else {
        return userSequenceStepsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * An ordered sequence of condition steps. A user's events must complete
     * each step in order for the user to match the
     * `UserSegmentSequenceGroup`.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;
     * </code>
     */
    public com.google.analytics.data.v1alpha.UserSequenceStep getUserSequenceSteps(int index) {
      if (userSequenceStepsBuilder_ == null) {
        return userSequenceSteps_.get(index);
      } else {
        return userSequenceStepsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * An ordered sequence of condition steps. A user's events must complete
     * each step in order for the user to match the
     * `UserSegmentSequenceGroup`.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;
     * </code>
     */
    public Builder setUserSequenceSteps(
        int index, com.google.analytics.data.v1alpha.UserSequenceStep value) {
      if (userSequenceStepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUserSequenceStepsIsMutable();
        userSequenceSteps_.set(index, value);
        onChanged();
      } else {
        userSequenceStepsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An ordered sequence of condition steps. A user's events must complete
     * each step in order for the user to match the
     * `UserSegmentSequenceGroup`.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;
     * </code>
     */
    public Builder setUserSequenceSteps(
        int index, com.google.analytics.data.v1alpha.UserSequenceStep.Builder builderForValue) {
      if (userSequenceStepsBuilder_ == null) {
        ensureUserSequenceStepsIsMutable();
        userSequenceSteps_.set(index, builderForValue.build());
        onChanged();
      } else {
        userSequenceStepsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An ordered sequence of condition steps. A user's events must complete
     * each step in order for the user to match the
     * `UserSegmentSequenceGroup`.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;
     * </code>
     */
    public Builder addUserSequenceSteps(com.google.analytics.data.v1alpha.UserSequenceStep value) {
      if (userSequenceStepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUserSequenceStepsIsMutable();
        userSequenceSteps_.add(value);
        onChanged();
      } else {
        userSequenceStepsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An ordered sequence of condition steps. A user's events must complete
     * each step in order for the user to match the
     * `UserSegmentSequenceGroup`.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;
     * </code>
     */
    public Builder addUserSequenceSteps(
        int index, com.google.analytics.data.v1alpha.UserSequenceStep value) {
      if (userSequenceStepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUserSequenceStepsIsMutable();
        userSequenceSteps_.add(index, value);
        onChanged();
      } else {
        userSequenceStepsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An ordered sequence of condition steps. A user's events must complete
     * each step in order for the user to match the
     * `UserSegmentSequenceGroup`.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;
     * </code>
     */
    public Builder addUserSequenceSteps(
        com.google.analytics.data.v1alpha.UserSequenceStep.Builder builderForValue) {
      if (userSequenceStepsBuilder_ == null) {
        ensureUserSequenceStepsIsMutable();
        userSequenceSteps_.add(builderForValue.build());
        onChanged();
      } else {
        userSequenceStepsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An ordered sequence of condition steps. A user's events must complete
     * each step in order for the user to match the
     * `UserSegmentSequenceGroup`.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;
     * </code>
     */
    public Builder addUserSequenceSteps(
        int index, com.google.analytics.data.v1alpha.UserSequenceStep.Builder builderForValue) {
      if (userSequenceStepsBuilder_ == null) {
        ensureUserSequenceStepsIsMutable();
        userSequenceSteps_.add(index, builderForValue.build());
        onChanged();
      } else {
        userSequenceStepsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An ordered sequence of condition steps. A user's events must complete
     * each step in order for the user to match the
     * `UserSegmentSequenceGroup`.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;
     * </code>
     */
    public Builder addAllUserSequenceSteps(
        java.lang.Iterable<? extends com.google.analytics.data.v1alpha.UserSequenceStep> values) {
      if (userSequenceStepsBuilder_ == null) {
        ensureUserSequenceStepsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, userSequenceSteps_);
        onChanged();
      } else {
        userSequenceStepsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An ordered sequence of condition steps. A user's events must complete
     * each step in order for the user to match the
     * `UserSegmentSequenceGroup`.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;
     * </code>
     */
    public Builder clearUserSequenceSteps() {
      if (userSequenceStepsBuilder_ == null) {
        userSequenceSteps_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        userSequenceStepsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An ordered sequence of condition steps. A user's events must complete
     * each step in order for the user to match the
     * `UserSegmentSequenceGroup`.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;
     * </code>
     */
    public Builder removeUserSequenceSteps(int index) {
      if (userSequenceStepsBuilder_ == null) {
        ensureUserSequenceStepsIsMutable();
        userSequenceSteps_.remove(index);
        onChanged();
      } else {
        userSequenceStepsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An ordered sequence of condition steps. A user's events must complete
     * each step in order for the user to match the
     * `UserSegmentSequenceGroup`.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;
     * </code>
     */
    public com.google.analytics.data.v1alpha.UserSequenceStep.Builder getUserSequenceStepsBuilder(
        int index) {
      return getUserSequenceStepsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * An ordered sequence of condition steps. A user's events must complete
     * each step in order for the user to match the
     * `UserSegmentSequenceGroup`.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;
     * </code>
     */
    public com.google.analytics.data.v1alpha.UserSequenceStepOrBuilder
        getUserSequenceStepsOrBuilder(int index) {
      if (userSequenceStepsBuilder_ == null) {
        return userSequenceSteps_.get(index);
      } else {
        return userSequenceStepsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * An ordered sequence of condition steps. A user's events must complete
     * each step in order for the user to match the
     * `UserSegmentSequenceGroup`.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;
     * </code>
     */
    public java.util.List<? extends com.google.analytics.data.v1alpha.UserSequenceStepOrBuilder>
        getUserSequenceStepsOrBuilderList() {
      if (userSequenceStepsBuilder_ != null) {
        return userSequenceStepsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(userSequenceSteps_);
      }
    }
    /**
     *
     *
     * <pre>
     * An ordered sequence of condition steps. A user's events must complete
     * each step in order for the user to match the
     * `UserSegmentSequenceGroup`.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;
     * </code>
     */
    public com.google.analytics.data.v1alpha.UserSequenceStep.Builder
        addUserSequenceStepsBuilder() {
      return getUserSequenceStepsFieldBuilder()
          .addBuilder(com.google.analytics.data.v1alpha.UserSequenceStep.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * An ordered sequence of condition steps. A user's events must complete
     * each step in order for the user to match the
     * `UserSegmentSequenceGroup`.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;
     * </code>
     */
    public com.google.analytics.data.v1alpha.UserSequenceStep.Builder addUserSequenceStepsBuilder(
        int index) {
      return getUserSequenceStepsFieldBuilder()
          .addBuilder(
              index, com.google.analytics.data.v1alpha.UserSequenceStep.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * An ordered sequence of condition steps. A user's events must complete
     * each step in order for the user to match the
     * `UserSegmentSequenceGroup`.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.UserSequenceStep user_sequence_steps = 3;
     * </code>
     */
    public java.util.List<com.google.analytics.data.v1alpha.UserSequenceStep.Builder>
        getUserSequenceStepsBuilderList() {
      return getUserSequenceStepsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1alpha.UserSequenceStep,
            com.google.analytics.data.v1alpha.UserSequenceStep.Builder,
            com.google.analytics.data.v1alpha.UserSequenceStepOrBuilder>
        getUserSequenceStepsFieldBuilder() {
      if (userSequenceStepsBuilder_ == null) {
        userSequenceStepsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1alpha.UserSequenceStep,
                com.google.analytics.data.v1alpha.UserSequenceStep.Builder,
                com.google.analytics.data.v1alpha.UserSequenceStepOrBuilder>(
                userSequenceSteps_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        userSequenceSteps_ = null;
      }
      return userSequenceStepsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1alpha.UserSegmentSequenceGroup)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1alpha.UserSegmentSequenceGroup)
  private static final com.google.analytics.data.v1alpha.UserSegmentSequenceGroup DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1alpha.UserSegmentSequenceGroup();
  }

  public static com.google.analytics.data.v1alpha.UserSegmentSequenceGroup getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UserSegmentSequenceGroup> PARSER =
      new com.google.protobuf.AbstractParser<UserSegmentSequenceGroup>() {
        @java.lang.Override
        public UserSegmentSequenceGroup parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new UserSegmentSequenceGroup(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<UserSegmentSequenceGroup> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UserSegmentSequenceGroup> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1alpha.UserSegmentSequenceGroup getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
