/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/data.proto

package com.google.analytics.data.v1alpha;

/**
 *
 *
 * <pre>
 * An expression to filter dimension or metric values.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1alpha.SegmentFilter}
 */
public final class SegmentFilter extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1alpha.SegmentFilter)
    SegmentFilterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SegmentFilter.newBuilder() to construct.
  private SegmentFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SegmentFilter() {
    fieldName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SegmentFilter();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private SegmentFilter(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              fieldName_ = s;
              break;
            }
          case 34:
            {
              com.google.analytics.data.v1alpha.StringFilter.Builder subBuilder = null;
              if (oneFilterCase_ == 4) {
                subBuilder =
                    ((com.google.analytics.data.v1alpha.StringFilter) oneFilter_).toBuilder();
              }
              oneFilter_ =
                  input.readMessage(
                      com.google.analytics.data.v1alpha.StringFilter.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.analytics.data.v1alpha.StringFilter) oneFilter_);
                oneFilter_ = subBuilder.buildPartial();
              }
              oneFilterCase_ = 4;
              break;
            }
          case 42:
            {
              com.google.analytics.data.v1alpha.InListFilter.Builder subBuilder = null;
              if (oneFilterCase_ == 5) {
                subBuilder =
                    ((com.google.analytics.data.v1alpha.InListFilter) oneFilter_).toBuilder();
              }
              oneFilter_ =
                  input.readMessage(
                      com.google.analytics.data.v1alpha.InListFilter.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.analytics.data.v1alpha.InListFilter) oneFilter_);
                oneFilter_ = subBuilder.buildPartial();
              }
              oneFilterCase_ = 5;
              break;
            }
          case 50:
            {
              com.google.analytics.data.v1alpha.NumericFilter.Builder subBuilder = null;
              if (oneFilterCase_ == 6) {
                subBuilder =
                    ((com.google.analytics.data.v1alpha.NumericFilter) oneFilter_).toBuilder();
              }
              oneFilter_ =
                  input.readMessage(
                      com.google.analytics.data.v1alpha.NumericFilter.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.analytics.data.v1alpha.NumericFilter) oneFilter_);
                oneFilter_ = subBuilder.buildPartial();
              }
              oneFilterCase_ = 6;
              break;
            }
          case 58:
            {
              com.google.analytics.data.v1alpha.BetweenFilter.Builder subBuilder = null;
              if (oneFilterCase_ == 7) {
                subBuilder =
                    ((com.google.analytics.data.v1alpha.BetweenFilter) oneFilter_).toBuilder();
              }
              oneFilter_ =
                  input.readMessage(
                      com.google.analytics.data.v1alpha.BetweenFilter.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.analytics.data.v1alpha.BetweenFilter) oneFilter_);
                oneFilter_ = subBuilder.buildPartial();
              }
              oneFilterCase_ = 7;
              break;
            }
          case 66:
            {
              com.google.analytics.data.v1alpha.SegmentFilterScoping.Builder subBuilder = null;
              if (filterScoping_ != null) {
                subBuilder = filterScoping_.toBuilder();
              }
              filterScoping_ =
                  input.readMessage(
                      com.google.analytics.data.v1alpha.SegmentFilterScoping.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(filterScoping_);
                filterScoping_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1alpha.ReportingApiProto
        .internal_static_google_analytics_data_v1alpha_SegmentFilter_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1alpha.ReportingApiProto
        .internal_static_google_analytics_data_v1alpha_SegmentFilter_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1alpha.SegmentFilter.class,
            com.google.analytics.data.v1alpha.SegmentFilter.Builder.class);
  }

  private int oneFilterCase_ = 0;
  private java.lang.Object oneFilter_;

  public enum OneFilterCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STRING_FILTER(4),
    IN_LIST_FILTER(5),
    NUMERIC_FILTER(6),
    BETWEEN_FILTER(7),
    ONEFILTER_NOT_SET(0);
    private final int value;

    private OneFilterCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OneFilterCase valueOf(int value) {
      return forNumber(value);
    }

    public static OneFilterCase forNumber(int value) {
      switch (value) {
        case 4:
          return STRING_FILTER;
        case 5:
          return IN_LIST_FILTER;
        case 6:
          return NUMERIC_FILTER;
        case 7:
          return BETWEEN_FILTER;
        case 0:
          return ONEFILTER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public OneFilterCase getOneFilterCase() {
    return OneFilterCase.forNumber(oneFilterCase_);
  }

  public static final int FIELD_NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object fieldName_;
  /**
   *
   *
   * <pre>
   * The dimension name or metric name.
   * </pre>
   *
   * <code>string field_name = 1;</code>
   *
   * @return The fieldName.
   */
  @java.lang.Override
  public java.lang.String getFieldName() {
    java.lang.Object ref = fieldName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fieldName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The dimension name or metric name.
   * </pre>
   *
   * <code>string field_name = 1;</code>
   *
   * @return The bytes for fieldName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFieldNameBytes() {
    java.lang.Object ref = fieldName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fieldName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STRING_FILTER_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Strings related filter.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 4;</code>
   *
   * @return Whether the stringFilter field is set.
   */
  @java.lang.Override
  public boolean hasStringFilter() {
    return oneFilterCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Strings related filter.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 4;</code>
   *
   * @return The stringFilter.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.StringFilter getStringFilter() {
    if (oneFilterCase_ == 4) {
      return (com.google.analytics.data.v1alpha.StringFilter) oneFilter_;
    }
    return com.google.analytics.data.v1alpha.StringFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Strings related filter.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 4;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.StringFilterOrBuilder getStringFilterOrBuilder() {
    if (oneFilterCase_ == 4) {
      return (com.google.analytics.data.v1alpha.StringFilter) oneFilter_;
    }
    return com.google.analytics.data.v1alpha.StringFilter.getDefaultInstance();
  }

  public static final int IN_LIST_FILTER_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * A filter for in list values.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 5;</code>
   *
   * @return Whether the inListFilter field is set.
   */
  @java.lang.Override
  public boolean hasInListFilter() {
    return oneFilterCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * A filter for in list values.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 5;</code>
   *
   * @return The inListFilter.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.InListFilter getInListFilter() {
    if (oneFilterCase_ == 5) {
      return (com.google.analytics.data.v1alpha.InListFilter) oneFilter_;
    }
    return com.google.analytics.data.v1alpha.InListFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A filter for in list values.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 5;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.InListFilterOrBuilder getInListFilterOrBuilder() {
    if (oneFilterCase_ == 5) {
      return (com.google.analytics.data.v1alpha.InListFilter) oneFilter_;
    }
    return com.google.analytics.data.v1alpha.InListFilter.getDefaultInstance();
  }

  public static final int NUMERIC_FILTER_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * A filter for numeric or date values.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 6;</code>
   *
   * @return Whether the numericFilter field is set.
   */
  @java.lang.Override
  public boolean hasNumericFilter() {
    return oneFilterCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * A filter for numeric or date values.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 6;</code>
   *
   * @return The numericFilter.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.NumericFilter getNumericFilter() {
    if (oneFilterCase_ == 6) {
      return (com.google.analytics.data.v1alpha.NumericFilter) oneFilter_;
    }
    return com.google.analytics.data.v1alpha.NumericFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A filter for numeric or date values.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 6;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.NumericFilterOrBuilder getNumericFilterOrBuilder() {
    if (oneFilterCase_ == 6) {
      return (com.google.analytics.data.v1alpha.NumericFilter) oneFilter_;
    }
    return com.google.analytics.data.v1alpha.NumericFilter.getDefaultInstance();
  }

  public static final int BETWEEN_FILTER_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * A filter for between two values.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 7;</code>
   *
   * @return Whether the betweenFilter field is set.
   */
  @java.lang.Override
  public boolean hasBetweenFilter() {
    return oneFilterCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * A filter for between two values.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 7;</code>
   *
   * @return The betweenFilter.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.BetweenFilter getBetweenFilter() {
    if (oneFilterCase_ == 7) {
      return (com.google.analytics.data.v1alpha.BetweenFilter) oneFilter_;
    }
    return com.google.analytics.data.v1alpha.BetweenFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A filter for between two values.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 7;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.BetweenFilterOrBuilder getBetweenFilterOrBuilder() {
    if (oneFilterCase_ == 7) {
      return (com.google.analytics.data.v1alpha.BetweenFilter) oneFilter_;
    }
    return com.google.analytics.data.v1alpha.BetweenFilter.getDefaultInstance();
  }

  public static final int FILTER_SCOPING_FIELD_NUMBER = 8;
  private com.google.analytics.data.v1alpha.SegmentFilterScoping filterScoping_;
  /**
   *
   *
   * <pre>
   * Specifies the scope for the filter.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.SegmentFilterScoping filter_scoping = 8;</code>
   *
   * @return Whether the filterScoping field is set.
   */
  @java.lang.Override
  public boolean hasFilterScoping() {
    return filterScoping_ != null;
  }
  /**
   *
   *
   * <pre>
   * Specifies the scope for the filter.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.SegmentFilterScoping filter_scoping = 8;</code>
   *
   * @return The filterScoping.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.SegmentFilterScoping getFilterScoping() {
    return filterScoping_ == null
        ? com.google.analytics.data.v1alpha.SegmentFilterScoping.getDefaultInstance()
        : filterScoping_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the scope for the filter.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.SegmentFilterScoping filter_scoping = 8;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.SegmentFilterScopingOrBuilder
      getFilterScopingOrBuilder() {
    return getFilterScoping();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, fieldName_);
    }
    if (oneFilterCase_ == 4) {
      output.writeMessage(4, (com.google.analytics.data.v1alpha.StringFilter) oneFilter_);
    }
    if (oneFilterCase_ == 5) {
      output.writeMessage(5, (com.google.analytics.data.v1alpha.InListFilter) oneFilter_);
    }
    if (oneFilterCase_ == 6) {
      output.writeMessage(6, (com.google.analytics.data.v1alpha.NumericFilter) oneFilter_);
    }
    if (oneFilterCase_ == 7) {
      output.writeMessage(7, (com.google.analytics.data.v1alpha.BetweenFilter) oneFilter_);
    }
    if (filterScoping_ != null) {
      output.writeMessage(8, getFilterScoping());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, fieldName_);
    }
    if (oneFilterCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.analytics.data.v1alpha.StringFilter) oneFilter_);
    }
    if (oneFilterCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.analytics.data.v1alpha.InListFilter) oneFilter_);
    }
    if (oneFilterCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.analytics.data.v1alpha.NumericFilter) oneFilter_);
    }
    if (oneFilterCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.analytics.data.v1alpha.BetweenFilter) oneFilter_);
    }
    if (filterScoping_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getFilterScoping());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1alpha.SegmentFilter)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1alpha.SegmentFilter other =
        (com.google.analytics.data.v1alpha.SegmentFilter) obj;

    if (!getFieldName().equals(other.getFieldName())) return false;
    if (hasFilterScoping() != other.hasFilterScoping()) return false;
    if (hasFilterScoping()) {
      if (!getFilterScoping().equals(other.getFilterScoping())) return false;
    }
    if (!getOneFilterCase().equals(other.getOneFilterCase())) return false;
    switch (oneFilterCase_) {
      case 4:
        if (!getStringFilter().equals(other.getStringFilter())) return false;
        break;
      case 5:
        if (!getInListFilter().equals(other.getInListFilter())) return false;
        break;
      case 6:
        if (!getNumericFilter().equals(other.getNumericFilter())) return false;
        break;
      case 7:
        if (!getBetweenFilter().equals(other.getBetweenFilter())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FIELD_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getFieldName().hashCode();
    if (hasFilterScoping()) {
      hash = (37 * hash) + FILTER_SCOPING_FIELD_NUMBER;
      hash = (53 * hash) + getFilterScoping().hashCode();
    }
    switch (oneFilterCase_) {
      case 4:
        hash = (37 * hash) + STRING_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getStringFilter().hashCode();
        break;
      case 5:
        hash = (37 * hash) + IN_LIST_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getInListFilter().hashCode();
        break;
      case 6:
        hash = (37 * hash) + NUMERIC_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getNumericFilter().hashCode();
        break;
      case 7:
        hash = (37 * hash) + BETWEEN_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getBetweenFilter().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1alpha.SegmentFilter parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.SegmentFilter parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.SegmentFilter parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.SegmentFilter parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.SegmentFilter parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.SegmentFilter parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.SegmentFilter parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.SegmentFilter parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.SegmentFilter parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.SegmentFilter parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.SegmentFilter parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.SegmentFilter parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.analytics.data.v1alpha.SegmentFilter prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An expression to filter dimension or metric values.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1alpha.SegmentFilter}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1alpha.SegmentFilter)
      com.google.analytics.data.v1alpha.SegmentFilterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_SegmentFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_SegmentFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1alpha.SegmentFilter.class,
              com.google.analytics.data.v1alpha.SegmentFilter.Builder.class);
    }

    // Construct using com.google.analytics.data.v1alpha.SegmentFilter.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      fieldName_ = "";

      if (filterScopingBuilder_ == null) {
        filterScoping_ = null;
      } else {
        filterScoping_ = null;
        filterScopingBuilder_ = null;
      }
      oneFilterCase_ = 0;
      oneFilter_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_SegmentFilter_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.SegmentFilter getDefaultInstanceForType() {
      return com.google.analytics.data.v1alpha.SegmentFilter.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.SegmentFilter build() {
      com.google.analytics.data.v1alpha.SegmentFilter result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.SegmentFilter buildPartial() {
      com.google.analytics.data.v1alpha.SegmentFilter result =
          new com.google.analytics.data.v1alpha.SegmentFilter(this);
      result.fieldName_ = fieldName_;
      if (oneFilterCase_ == 4) {
        if (stringFilterBuilder_ == null) {
          result.oneFilter_ = oneFilter_;
        } else {
          result.oneFilter_ = stringFilterBuilder_.build();
        }
      }
      if (oneFilterCase_ == 5) {
        if (inListFilterBuilder_ == null) {
          result.oneFilter_ = oneFilter_;
        } else {
          result.oneFilter_ = inListFilterBuilder_.build();
        }
      }
      if (oneFilterCase_ == 6) {
        if (numericFilterBuilder_ == null) {
          result.oneFilter_ = oneFilter_;
        } else {
          result.oneFilter_ = numericFilterBuilder_.build();
        }
      }
      if (oneFilterCase_ == 7) {
        if (betweenFilterBuilder_ == null) {
          result.oneFilter_ = oneFilter_;
        } else {
          result.oneFilter_ = betweenFilterBuilder_.build();
        }
      }
      if (filterScopingBuilder_ == null) {
        result.filterScoping_ = filterScoping_;
      } else {
        result.filterScoping_ = filterScopingBuilder_.build();
      }
      result.oneFilterCase_ = oneFilterCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1alpha.SegmentFilter) {
        return mergeFrom((com.google.analytics.data.v1alpha.SegmentFilter) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1alpha.SegmentFilter other) {
      if (other == com.google.analytics.data.v1alpha.SegmentFilter.getDefaultInstance())
        return this;
      if (!other.getFieldName().isEmpty()) {
        fieldName_ = other.fieldName_;
        onChanged();
      }
      if (other.hasFilterScoping()) {
        mergeFilterScoping(other.getFilterScoping());
      }
      switch (other.getOneFilterCase()) {
        case STRING_FILTER:
          {
            mergeStringFilter(other.getStringFilter());
            break;
          }
        case IN_LIST_FILTER:
          {
            mergeInListFilter(other.getInListFilter());
            break;
          }
        case NUMERIC_FILTER:
          {
            mergeNumericFilter(other.getNumericFilter());
            break;
          }
        case BETWEEN_FILTER:
          {
            mergeBetweenFilter(other.getBetweenFilter());
            break;
          }
        case ONEFILTER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.analytics.data.v1alpha.SegmentFilter parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.analytics.data.v1alpha.SegmentFilter) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int oneFilterCase_ = 0;
    private java.lang.Object oneFilter_;

    public OneFilterCase getOneFilterCase() {
      return OneFilterCase.forNumber(oneFilterCase_);
    }

    public Builder clearOneFilter() {
      oneFilterCase_ = 0;
      oneFilter_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object fieldName_ = "";
    /**
     *
     *
     * <pre>
     * The dimension name or metric name.
     * </pre>
     *
     * <code>string field_name = 1;</code>
     *
     * @return The fieldName.
     */
    public java.lang.String getFieldName() {
      java.lang.Object ref = fieldName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fieldName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The dimension name or metric name.
     * </pre>
     *
     * <code>string field_name = 1;</code>
     *
     * @return The bytes for fieldName.
     */
    public com.google.protobuf.ByteString getFieldNameBytes() {
      java.lang.Object ref = fieldName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fieldName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The dimension name or metric name.
     * </pre>
     *
     * <code>string field_name = 1;</code>
     *
     * @param value The fieldName to set.
     * @return This builder for chaining.
     */
    public Builder setFieldName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      fieldName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimension name or metric name.
     * </pre>
     *
     * <code>string field_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFieldName() {

      fieldName_ = getDefaultInstance().getFieldName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimension name or metric name.
     * </pre>
     *
     * <code>string field_name = 1;</code>
     *
     * @param value The bytes for fieldName to set.
     * @return This builder for chaining.
     */
    public Builder setFieldNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      fieldName_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.StringFilter,
            com.google.analytics.data.v1alpha.StringFilter.Builder,
            com.google.analytics.data.v1alpha.StringFilterOrBuilder>
        stringFilterBuilder_;
    /**
     *
     *
     * <pre>
     * Strings related filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 4;</code>
     *
     * @return Whether the stringFilter field is set.
     */
    @java.lang.Override
    public boolean hasStringFilter() {
      return oneFilterCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Strings related filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 4;</code>
     *
     * @return The stringFilter.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.StringFilter getStringFilter() {
      if (stringFilterBuilder_ == null) {
        if (oneFilterCase_ == 4) {
          return (com.google.analytics.data.v1alpha.StringFilter) oneFilter_;
        }
        return com.google.analytics.data.v1alpha.StringFilter.getDefaultInstance();
      } else {
        if (oneFilterCase_ == 4) {
          return stringFilterBuilder_.getMessage();
        }
        return com.google.analytics.data.v1alpha.StringFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Strings related filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 4;</code>
     */
    public Builder setStringFilter(com.google.analytics.data.v1alpha.StringFilter value) {
      if (stringFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        oneFilter_ = value;
        onChanged();
      } else {
        stringFilterBuilder_.setMessage(value);
      }
      oneFilterCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strings related filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 4;</code>
     */
    public Builder setStringFilter(
        com.google.analytics.data.v1alpha.StringFilter.Builder builderForValue) {
      if (stringFilterBuilder_ == null) {
        oneFilter_ = builderForValue.build();
        onChanged();
      } else {
        stringFilterBuilder_.setMessage(builderForValue.build());
      }
      oneFilterCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strings related filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 4;</code>
     */
    public Builder mergeStringFilter(com.google.analytics.data.v1alpha.StringFilter value) {
      if (stringFilterBuilder_ == null) {
        if (oneFilterCase_ == 4
            && oneFilter_ != com.google.analytics.data.v1alpha.StringFilter.getDefaultInstance()) {
          oneFilter_ =
              com.google.analytics.data.v1alpha.StringFilter.newBuilder(
                      (com.google.analytics.data.v1alpha.StringFilter) oneFilter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          oneFilter_ = value;
        }
        onChanged();
      } else {
        if (oneFilterCase_ == 4) {
          stringFilterBuilder_.mergeFrom(value);
        } else {
          stringFilterBuilder_.setMessage(value);
        }
      }
      oneFilterCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strings related filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 4;</code>
     */
    public Builder clearStringFilter() {
      if (stringFilterBuilder_ == null) {
        if (oneFilterCase_ == 4) {
          oneFilterCase_ = 0;
          oneFilter_ = null;
          onChanged();
        }
      } else {
        if (oneFilterCase_ == 4) {
          oneFilterCase_ = 0;
          oneFilter_ = null;
        }
        stringFilterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strings related filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 4;</code>
     */
    public com.google.analytics.data.v1alpha.StringFilter.Builder getStringFilterBuilder() {
      return getStringFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Strings related filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 4;</code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.StringFilterOrBuilder getStringFilterOrBuilder() {
      if ((oneFilterCase_ == 4) && (stringFilterBuilder_ != null)) {
        return stringFilterBuilder_.getMessageOrBuilder();
      } else {
        if (oneFilterCase_ == 4) {
          return (com.google.analytics.data.v1alpha.StringFilter) oneFilter_;
        }
        return com.google.analytics.data.v1alpha.StringFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Strings related filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.StringFilter,
            com.google.analytics.data.v1alpha.StringFilter.Builder,
            com.google.analytics.data.v1alpha.StringFilterOrBuilder>
        getStringFilterFieldBuilder() {
      if (stringFilterBuilder_ == null) {
        if (!(oneFilterCase_ == 4)) {
          oneFilter_ = com.google.analytics.data.v1alpha.StringFilter.getDefaultInstance();
        }
        stringFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.StringFilter,
                com.google.analytics.data.v1alpha.StringFilter.Builder,
                com.google.analytics.data.v1alpha.StringFilterOrBuilder>(
                (com.google.analytics.data.v1alpha.StringFilter) oneFilter_,
                getParentForChildren(),
                isClean());
        oneFilter_ = null;
      }
      oneFilterCase_ = 4;
      onChanged();
      ;
      return stringFilterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.InListFilter,
            com.google.analytics.data.v1alpha.InListFilter.Builder,
            com.google.analytics.data.v1alpha.InListFilterOrBuilder>
        inListFilterBuilder_;
    /**
     *
     *
     * <pre>
     * A filter for in list values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 5;</code>
     *
     * @return Whether the inListFilter field is set.
     */
    @java.lang.Override
    public boolean hasInListFilter() {
      return oneFilterCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * A filter for in list values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 5;</code>
     *
     * @return The inListFilter.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.InListFilter getInListFilter() {
      if (inListFilterBuilder_ == null) {
        if (oneFilterCase_ == 5) {
          return (com.google.analytics.data.v1alpha.InListFilter) oneFilter_;
        }
        return com.google.analytics.data.v1alpha.InListFilter.getDefaultInstance();
      } else {
        if (oneFilterCase_ == 5) {
          return inListFilterBuilder_.getMessage();
        }
        return com.google.analytics.data.v1alpha.InListFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A filter for in list values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 5;</code>
     */
    public Builder setInListFilter(com.google.analytics.data.v1alpha.InListFilter value) {
      if (inListFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        oneFilter_ = value;
        onChanged();
      } else {
        inListFilterBuilder_.setMessage(value);
      }
      oneFilterCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for in list values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 5;</code>
     */
    public Builder setInListFilter(
        com.google.analytics.data.v1alpha.InListFilter.Builder builderForValue) {
      if (inListFilterBuilder_ == null) {
        oneFilter_ = builderForValue.build();
        onChanged();
      } else {
        inListFilterBuilder_.setMessage(builderForValue.build());
      }
      oneFilterCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for in list values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 5;</code>
     */
    public Builder mergeInListFilter(com.google.analytics.data.v1alpha.InListFilter value) {
      if (inListFilterBuilder_ == null) {
        if (oneFilterCase_ == 5
            && oneFilter_ != com.google.analytics.data.v1alpha.InListFilter.getDefaultInstance()) {
          oneFilter_ =
              com.google.analytics.data.v1alpha.InListFilter.newBuilder(
                      (com.google.analytics.data.v1alpha.InListFilter) oneFilter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          oneFilter_ = value;
        }
        onChanged();
      } else {
        if (oneFilterCase_ == 5) {
          inListFilterBuilder_.mergeFrom(value);
        } else {
          inListFilterBuilder_.setMessage(value);
        }
      }
      oneFilterCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for in list values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 5;</code>
     */
    public Builder clearInListFilter() {
      if (inListFilterBuilder_ == null) {
        if (oneFilterCase_ == 5) {
          oneFilterCase_ = 0;
          oneFilter_ = null;
          onChanged();
        }
      } else {
        if (oneFilterCase_ == 5) {
          oneFilterCase_ = 0;
          oneFilter_ = null;
        }
        inListFilterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for in list values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 5;</code>
     */
    public com.google.analytics.data.v1alpha.InListFilter.Builder getInListFilterBuilder() {
      return getInListFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A filter for in list values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 5;</code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.InListFilterOrBuilder getInListFilterOrBuilder() {
      if ((oneFilterCase_ == 5) && (inListFilterBuilder_ != null)) {
        return inListFilterBuilder_.getMessageOrBuilder();
      } else {
        if (oneFilterCase_ == 5) {
          return (com.google.analytics.data.v1alpha.InListFilter) oneFilter_;
        }
        return com.google.analytics.data.v1alpha.InListFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A filter for in list values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.InListFilter,
            com.google.analytics.data.v1alpha.InListFilter.Builder,
            com.google.analytics.data.v1alpha.InListFilterOrBuilder>
        getInListFilterFieldBuilder() {
      if (inListFilterBuilder_ == null) {
        if (!(oneFilterCase_ == 5)) {
          oneFilter_ = com.google.analytics.data.v1alpha.InListFilter.getDefaultInstance();
        }
        inListFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.InListFilter,
                com.google.analytics.data.v1alpha.InListFilter.Builder,
                com.google.analytics.data.v1alpha.InListFilterOrBuilder>(
                (com.google.analytics.data.v1alpha.InListFilter) oneFilter_,
                getParentForChildren(),
                isClean());
        oneFilter_ = null;
      }
      oneFilterCase_ = 5;
      onChanged();
      ;
      return inListFilterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.NumericFilter,
            com.google.analytics.data.v1alpha.NumericFilter.Builder,
            com.google.analytics.data.v1alpha.NumericFilterOrBuilder>
        numericFilterBuilder_;
    /**
     *
     *
     * <pre>
     * A filter for numeric or date values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 6;</code>
     *
     * @return Whether the numericFilter field is set.
     */
    @java.lang.Override
    public boolean hasNumericFilter() {
      return oneFilterCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * A filter for numeric or date values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 6;</code>
     *
     * @return The numericFilter.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.NumericFilter getNumericFilter() {
      if (numericFilterBuilder_ == null) {
        if (oneFilterCase_ == 6) {
          return (com.google.analytics.data.v1alpha.NumericFilter) oneFilter_;
        }
        return com.google.analytics.data.v1alpha.NumericFilter.getDefaultInstance();
      } else {
        if (oneFilterCase_ == 6) {
          return numericFilterBuilder_.getMessage();
        }
        return com.google.analytics.data.v1alpha.NumericFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A filter for numeric or date values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 6;</code>
     */
    public Builder setNumericFilter(com.google.analytics.data.v1alpha.NumericFilter value) {
      if (numericFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        oneFilter_ = value;
        onChanged();
      } else {
        numericFilterBuilder_.setMessage(value);
      }
      oneFilterCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for numeric or date values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 6;</code>
     */
    public Builder setNumericFilter(
        com.google.analytics.data.v1alpha.NumericFilter.Builder builderForValue) {
      if (numericFilterBuilder_ == null) {
        oneFilter_ = builderForValue.build();
        onChanged();
      } else {
        numericFilterBuilder_.setMessage(builderForValue.build());
      }
      oneFilterCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for numeric or date values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 6;</code>
     */
    public Builder mergeNumericFilter(com.google.analytics.data.v1alpha.NumericFilter value) {
      if (numericFilterBuilder_ == null) {
        if (oneFilterCase_ == 6
            && oneFilter_ != com.google.analytics.data.v1alpha.NumericFilter.getDefaultInstance()) {
          oneFilter_ =
              com.google.analytics.data.v1alpha.NumericFilter.newBuilder(
                      (com.google.analytics.data.v1alpha.NumericFilter) oneFilter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          oneFilter_ = value;
        }
        onChanged();
      } else {
        if (oneFilterCase_ == 6) {
          numericFilterBuilder_.mergeFrom(value);
        } else {
          numericFilterBuilder_.setMessage(value);
        }
      }
      oneFilterCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for numeric or date values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 6;</code>
     */
    public Builder clearNumericFilter() {
      if (numericFilterBuilder_ == null) {
        if (oneFilterCase_ == 6) {
          oneFilterCase_ = 0;
          oneFilter_ = null;
          onChanged();
        }
      } else {
        if (oneFilterCase_ == 6) {
          oneFilterCase_ = 0;
          oneFilter_ = null;
        }
        numericFilterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for numeric or date values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 6;</code>
     */
    public com.google.analytics.data.v1alpha.NumericFilter.Builder getNumericFilterBuilder() {
      return getNumericFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A filter for numeric or date values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 6;</code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.NumericFilterOrBuilder getNumericFilterOrBuilder() {
      if ((oneFilterCase_ == 6) && (numericFilterBuilder_ != null)) {
        return numericFilterBuilder_.getMessageOrBuilder();
      } else {
        if (oneFilterCase_ == 6) {
          return (com.google.analytics.data.v1alpha.NumericFilter) oneFilter_;
        }
        return com.google.analytics.data.v1alpha.NumericFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A filter for numeric or date values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.NumericFilter,
            com.google.analytics.data.v1alpha.NumericFilter.Builder,
            com.google.analytics.data.v1alpha.NumericFilterOrBuilder>
        getNumericFilterFieldBuilder() {
      if (numericFilterBuilder_ == null) {
        if (!(oneFilterCase_ == 6)) {
          oneFilter_ = com.google.analytics.data.v1alpha.NumericFilter.getDefaultInstance();
        }
        numericFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.NumericFilter,
                com.google.analytics.data.v1alpha.NumericFilter.Builder,
                com.google.analytics.data.v1alpha.NumericFilterOrBuilder>(
                (com.google.analytics.data.v1alpha.NumericFilter) oneFilter_,
                getParentForChildren(),
                isClean());
        oneFilter_ = null;
      }
      oneFilterCase_ = 6;
      onChanged();
      ;
      return numericFilterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.BetweenFilter,
            com.google.analytics.data.v1alpha.BetweenFilter.Builder,
            com.google.analytics.data.v1alpha.BetweenFilterOrBuilder>
        betweenFilterBuilder_;
    /**
     *
     *
     * <pre>
     * A filter for between two values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 7;</code>
     *
     * @return Whether the betweenFilter field is set.
     */
    @java.lang.Override
    public boolean hasBetweenFilter() {
      return oneFilterCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * A filter for between two values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 7;</code>
     *
     * @return The betweenFilter.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.BetweenFilter getBetweenFilter() {
      if (betweenFilterBuilder_ == null) {
        if (oneFilterCase_ == 7) {
          return (com.google.analytics.data.v1alpha.BetweenFilter) oneFilter_;
        }
        return com.google.analytics.data.v1alpha.BetweenFilter.getDefaultInstance();
      } else {
        if (oneFilterCase_ == 7) {
          return betweenFilterBuilder_.getMessage();
        }
        return com.google.analytics.data.v1alpha.BetweenFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A filter for between two values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 7;</code>
     */
    public Builder setBetweenFilter(com.google.analytics.data.v1alpha.BetweenFilter value) {
      if (betweenFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        oneFilter_ = value;
        onChanged();
      } else {
        betweenFilterBuilder_.setMessage(value);
      }
      oneFilterCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for between two values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 7;</code>
     */
    public Builder setBetweenFilter(
        com.google.analytics.data.v1alpha.BetweenFilter.Builder builderForValue) {
      if (betweenFilterBuilder_ == null) {
        oneFilter_ = builderForValue.build();
        onChanged();
      } else {
        betweenFilterBuilder_.setMessage(builderForValue.build());
      }
      oneFilterCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for between two values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 7;</code>
     */
    public Builder mergeBetweenFilter(com.google.analytics.data.v1alpha.BetweenFilter value) {
      if (betweenFilterBuilder_ == null) {
        if (oneFilterCase_ == 7
            && oneFilter_ != com.google.analytics.data.v1alpha.BetweenFilter.getDefaultInstance()) {
          oneFilter_ =
              com.google.analytics.data.v1alpha.BetweenFilter.newBuilder(
                      (com.google.analytics.data.v1alpha.BetweenFilter) oneFilter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          oneFilter_ = value;
        }
        onChanged();
      } else {
        if (oneFilterCase_ == 7) {
          betweenFilterBuilder_.mergeFrom(value);
        } else {
          betweenFilterBuilder_.setMessage(value);
        }
      }
      oneFilterCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for between two values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 7;</code>
     */
    public Builder clearBetweenFilter() {
      if (betweenFilterBuilder_ == null) {
        if (oneFilterCase_ == 7) {
          oneFilterCase_ = 0;
          oneFilter_ = null;
          onChanged();
        }
      } else {
        if (oneFilterCase_ == 7) {
          oneFilterCase_ = 0;
          oneFilter_ = null;
        }
        betweenFilterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for between two values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 7;</code>
     */
    public com.google.analytics.data.v1alpha.BetweenFilter.Builder getBetweenFilterBuilder() {
      return getBetweenFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A filter for between two values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 7;</code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.BetweenFilterOrBuilder getBetweenFilterOrBuilder() {
      if ((oneFilterCase_ == 7) && (betweenFilterBuilder_ != null)) {
        return betweenFilterBuilder_.getMessageOrBuilder();
      } else {
        if (oneFilterCase_ == 7) {
          return (com.google.analytics.data.v1alpha.BetweenFilter) oneFilter_;
        }
        return com.google.analytics.data.v1alpha.BetweenFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A filter for between two values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.BetweenFilter,
            com.google.analytics.data.v1alpha.BetweenFilter.Builder,
            com.google.analytics.data.v1alpha.BetweenFilterOrBuilder>
        getBetweenFilterFieldBuilder() {
      if (betweenFilterBuilder_ == null) {
        if (!(oneFilterCase_ == 7)) {
          oneFilter_ = com.google.analytics.data.v1alpha.BetweenFilter.getDefaultInstance();
        }
        betweenFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.BetweenFilter,
                com.google.analytics.data.v1alpha.BetweenFilter.Builder,
                com.google.analytics.data.v1alpha.BetweenFilterOrBuilder>(
                (com.google.analytics.data.v1alpha.BetweenFilter) oneFilter_,
                getParentForChildren(),
                isClean());
        oneFilter_ = null;
      }
      oneFilterCase_ = 7;
      onChanged();
      ;
      return betweenFilterBuilder_;
    }

    private com.google.analytics.data.v1alpha.SegmentFilterScoping filterScoping_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.SegmentFilterScoping,
            com.google.analytics.data.v1alpha.SegmentFilterScoping.Builder,
            com.google.analytics.data.v1alpha.SegmentFilterScopingOrBuilder>
        filterScopingBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the scope for the filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SegmentFilterScoping filter_scoping = 8;</code>
     *
     * @return Whether the filterScoping field is set.
     */
    public boolean hasFilterScoping() {
      return filterScopingBuilder_ != null || filterScoping_ != null;
    }
    /**
     *
     *
     * <pre>
     * Specifies the scope for the filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SegmentFilterScoping filter_scoping = 8;</code>
     *
     * @return The filterScoping.
     */
    public com.google.analytics.data.v1alpha.SegmentFilterScoping getFilterScoping() {
      if (filterScopingBuilder_ == null) {
        return filterScoping_ == null
            ? com.google.analytics.data.v1alpha.SegmentFilterScoping.getDefaultInstance()
            : filterScoping_;
      } else {
        return filterScopingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the scope for the filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SegmentFilterScoping filter_scoping = 8;</code>
     */
    public Builder setFilterScoping(com.google.analytics.data.v1alpha.SegmentFilterScoping value) {
      if (filterScopingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filterScoping_ = value;
        onChanged();
      } else {
        filterScopingBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the scope for the filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SegmentFilterScoping filter_scoping = 8;</code>
     */
    public Builder setFilterScoping(
        com.google.analytics.data.v1alpha.SegmentFilterScoping.Builder builderForValue) {
      if (filterScopingBuilder_ == null) {
        filterScoping_ = builderForValue.build();
        onChanged();
      } else {
        filterScopingBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the scope for the filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SegmentFilterScoping filter_scoping = 8;</code>
     */
    public Builder mergeFilterScoping(
        com.google.analytics.data.v1alpha.SegmentFilterScoping value) {
      if (filterScopingBuilder_ == null) {
        if (filterScoping_ != null) {
          filterScoping_ =
              com.google.analytics.data.v1alpha.SegmentFilterScoping.newBuilder(filterScoping_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filterScoping_ = value;
        }
        onChanged();
      } else {
        filterScopingBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the scope for the filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SegmentFilterScoping filter_scoping = 8;</code>
     */
    public Builder clearFilterScoping() {
      if (filterScopingBuilder_ == null) {
        filterScoping_ = null;
        onChanged();
      } else {
        filterScoping_ = null;
        filterScopingBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the scope for the filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SegmentFilterScoping filter_scoping = 8;</code>
     */
    public com.google.analytics.data.v1alpha.SegmentFilterScoping.Builder
        getFilterScopingBuilder() {

      onChanged();
      return getFilterScopingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the scope for the filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SegmentFilterScoping filter_scoping = 8;</code>
     */
    public com.google.analytics.data.v1alpha.SegmentFilterScopingOrBuilder
        getFilterScopingOrBuilder() {
      if (filterScopingBuilder_ != null) {
        return filterScopingBuilder_.getMessageOrBuilder();
      } else {
        return filterScoping_ == null
            ? com.google.analytics.data.v1alpha.SegmentFilterScoping.getDefaultInstance()
            : filterScoping_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the scope for the filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SegmentFilterScoping filter_scoping = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.SegmentFilterScoping,
            com.google.analytics.data.v1alpha.SegmentFilterScoping.Builder,
            com.google.analytics.data.v1alpha.SegmentFilterScopingOrBuilder>
        getFilterScopingFieldBuilder() {
      if (filterScopingBuilder_ == null) {
        filterScopingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.SegmentFilterScoping,
                com.google.analytics.data.v1alpha.SegmentFilterScoping.Builder,
                com.google.analytics.data.v1alpha.SegmentFilterScopingOrBuilder>(
                getFilterScoping(), getParentForChildren(), isClean());
        filterScoping_ = null;
      }
      return filterScopingBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1alpha.SegmentFilter)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1alpha.SegmentFilter)
  private static final com.google.analytics.data.v1alpha.SegmentFilter DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1alpha.SegmentFilter();
  }

  public static com.google.analytics.data.v1alpha.SegmentFilter getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SegmentFilter> PARSER =
      new com.google.protobuf.AbstractParser<SegmentFilter>() {
        @java.lang.Override
        public SegmentFilter parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new SegmentFilter(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<SegmentFilter> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SegmentFilter> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1alpha.SegmentFilter getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
