/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PropertyName
implements ResourceName {
    private static final PathTemplate PROPERTY = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;

    @Deprecated
    protected PropertyName() {
        this.property = null;
    }

    private PropertyName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
    }

    public String getProperty() {
        return this.property;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PropertyName of(String property) {
        return PropertyName.newBuilder().setProperty(property).build();
    }

    public static String format(String property) {
        return PropertyName.newBuilder().setProperty(property).build().toString();
    }

    public static PropertyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY.validatedMatch(formattedString, "PropertyName.parse: formattedString not in valid format");
        return PropertyName.of((String)matchMap.get("property"));
    }

    public static List<PropertyName> parseList(List<String> formattedStrings) {
        ArrayList<PropertyName> list = new ArrayList<PropertyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PropertyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PropertyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PropertyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PropertyName propertyName = this;
            synchronized (propertyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY.instantiate(new String[]{"property", this.property});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PropertyName that = (PropertyName)o;
            return Objects.equals(this.property, that.property);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.property);
    }

    public static class Builder {
        private String property;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        private Builder(PropertyName propertyName) {
            this.property = propertyName.property;
        }

        public PropertyName build() {
            return new PropertyName(this);
        }
    }
}

