/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IosAppDataStreamName
implements ResourceName {
    private static final PathTemplate PROPERTY_IOS_APP_DATA_STREAM = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/iosAppDataStreams/{ios_app_data_stream}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String iosAppDataStream;

    @Deprecated
    protected IosAppDataStreamName() {
        this.property = null;
        this.iosAppDataStream = null;
    }

    private IosAppDataStreamName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.iosAppDataStream = (String)Preconditions.checkNotNull((Object)builder.getIosAppDataStream());
    }

    public String getProperty() {
        return this.property;
    }

    public String getIosAppDataStream() {
        return this.iosAppDataStream;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static IosAppDataStreamName of(String property, String iosAppDataStream) {
        return IosAppDataStreamName.newBuilder().setProperty(property).setIosAppDataStream(iosAppDataStream).build();
    }

    public static String format(String property, String iosAppDataStream) {
        return IosAppDataStreamName.newBuilder().setProperty(property).setIosAppDataStream(iosAppDataStream).build().toString();
    }

    public static IosAppDataStreamName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_IOS_APP_DATA_STREAM.validatedMatch(formattedString, "IosAppDataStreamName.parse: formattedString not in valid format");
        return IosAppDataStreamName.of((String)matchMap.get("property"), (String)matchMap.get("ios_app_data_stream"));
    }

    public static List<IosAppDataStreamName> parseList(List<String> formattedStrings) {
        ArrayList<IosAppDataStreamName> list = new ArrayList<IosAppDataStreamName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(IosAppDataStreamName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<IosAppDataStreamName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (IosAppDataStreamName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_IOS_APP_DATA_STREAM.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            IosAppDataStreamName iosAppDataStreamName = this;
            synchronized (iosAppDataStreamName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.iosAppDataStream != null) {
                        fieldMapBuilder.put((Object)"ios_app_data_stream", (Object)this.iosAppDataStream);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_IOS_APP_DATA_STREAM.instantiate(new String[]{"property", this.property, "ios_app_data_stream", this.iosAppDataStream});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            IosAppDataStreamName that = (IosAppDataStreamName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.iosAppDataStream, that.iosAppDataStream);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.iosAppDataStream);
    }

    public static class Builder {
        private String property;
        private String iosAppDataStream;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getIosAppDataStream() {
            return this.iosAppDataStream;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setIosAppDataStream(String iosAppDataStream) {
            this.iosAppDataStream = iosAppDataStream;
            return this;
        }

        private Builder(IosAppDataStreamName iosAppDataStreamName) {
            this.property = iosAppDataStreamName.property;
            this.iosAppDataStream = iosAppDataStreamName.iosAppDataStream;
        }

        public IosAppDataStreamName build() {
            return new IosAppDataStreamName(this);
        }
    }
}

