/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EventEditRuleName
implements ResourceName {
    private static final PathTemplate PROPERTY_DATA_STREAM_EVENT_EDIT_RULE = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/dataStreams/{data_stream}/eventEditRules/{event_edit_rule}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String dataStream;
    private final String eventEditRule;

    @Deprecated
    protected EventEditRuleName() {
        this.property = null;
        this.dataStream = null;
        this.eventEditRule = null;
    }

    private EventEditRuleName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.dataStream = (String)Preconditions.checkNotNull((Object)builder.getDataStream());
        this.eventEditRule = (String)Preconditions.checkNotNull((Object)builder.getEventEditRule());
    }

    public String getProperty() {
        return this.property;
    }

    public String getDataStream() {
        return this.dataStream;
    }

    public String getEventEditRule() {
        return this.eventEditRule;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EventEditRuleName of(String property, String dataStream, String eventEditRule) {
        return EventEditRuleName.newBuilder().setProperty(property).setDataStream(dataStream).setEventEditRule(eventEditRule).build();
    }

    public static String format(String property, String dataStream, String eventEditRule) {
        return EventEditRuleName.newBuilder().setProperty(property).setDataStream(dataStream).setEventEditRule(eventEditRule).build().toString();
    }

    public static EventEditRuleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_DATA_STREAM_EVENT_EDIT_RULE.validatedMatch(formattedString, "EventEditRuleName.parse: formattedString not in valid format");
        return EventEditRuleName.of((String)matchMap.get("property"), (String)matchMap.get("data_stream"), (String)matchMap.get("event_edit_rule"));
    }

    public static List<EventEditRuleName> parseList(List<String> formattedStrings) {
        ArrayList<EventEditRuleName> list = new ArrayList<EventEditRuleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EventEditRuleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EventEditRuleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EventEditRuleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_DATA_STREAM_EVENT_EDIT_RULE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EventEditRuleName eventEditRuleName = this;
            synchronized (eventEditRuleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.dataStream != null) {
                        fieldMapBuilder.put((Object)"data_stream", (Object)this.dataStream);
                    }
                    if (this.eventEditRule != null) {
                        fieldMapBuilder.put((Object)"event_edit_rule", (Object)this.eventEditRule);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_DATA_STREAM_EVENT_EDIT_RULE.instantiate(new String[]{"property", this.property, "data_stream", this.dataStream, "event_edit_rule", this.eventEditRule});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EventEditRuleName that = (EventEditRuleName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.dataStream, that.dataStream) && Objects.equals(this.eventEditRule, that.eventEditRule);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataStream);
        h *= 1000003;
        return h ^= Objects.hashCode(this.eventEditRule);
    }

    public static class Builder {
        private String property;
        private String dataStream;
        private String eventEditRule;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getDataStream() {
            return this.dataStream;
        }

        public String getEventEditRule() {
            return this.eventEditRule;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setDataStream(String dataStream) {
            this.dataStream = dataStream;
            return this;
        }

        public Builder setEventEditRule(String eventEditRule) {
            this.eventEditRule = eventEditRule;
            return this;
        }

        private Builder(EventEditRuleName eventEditRuleName) {
            this.property = eventEditRuleName.property;
            this.dataStream = eventEditRuleName.dataStream;
            this.eventEditRule = eventEditRuleName.eventEditRule;
        }

        public EventEditRuleName build() {
            return new EventEditRuleName(this);
        }
    }
}

