/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomMetricName
implements ResourceName {
    private static final PathTemplate PROPERTY_CUSTOM_METRIC = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/customMetrics/{custom_metric}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String customMetric;

    @Deprecated
    protected CustomMetricName() {
        this.property = null;
        this.customMetric = null;
    }

    private CustomMetricName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.customMetric = (String)Preconditions.checkNotNull((Object)builder.getCustomMetric());
    }

    public String getProperty() {
        return this.property;
    }

    public String getCustomMetric() {
        return this.customMetric;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomMetricName of(String property, String customMetric) {
        return CustomMetricName.newBuilder().setProperty(property).setCustomMetric(customMetric).build();
    }

    public static String format(String property, String customMetric) {
        return CustomMetricName.newBuilder().setProperty(property).setCustomMetric(customMetric).build().toString();
    }

    public static CustomMetricName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_CUSTOM_METRIC.validatedMatch(formattedString, "CustomMetricName.parse: formattedString not in valid format");
        return CustomMetricName.of((String)matchMap.get("property"), (String)matchMap.get("custom_metric"));
    }

    public static List<CustomMetricName> parseList(List<String> formattedStrings) {
        ArrayList<CustomMetricName> list = new ArrayList<CustomMetricName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomMetricName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomMetricName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomMetricName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_CUSTOM_METRIC.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomMetricName customMetricName = this;
            synchronized (customMetricName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.customMetric != null) {
                        fieldMapBuilder.put((Object)"custom_metric", (Object)this.customMetric);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_CUSTOM_METRIC.instantiate(new String[]{"property", this.property, "custom_metric", this.customMetric});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CustomMetricName that = (CustomMetricName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.customMetric, that.customMetric);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.customMetric);
    }

    public static class Builder {
        private String property;
        private String customMetric;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getCustomMetric() {
            return this.customMetric;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setCustomMetric(String customMetric) {
            this.customMetric = customMetric;
            return this;
        }

        private Builder(CustomMetricName customMetricName) {
            this.property = customMetricName.property;
            this.customMetric = customMetricName.customMetric;
        }

        public CustomMetricName build() {
            return new CustomMetricName(this);
        }
    }
}

