/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EventCreateRuleName
implements ResourceName {
    private static final PathTemplate PROPERTY_DATA_STREAM_EVENT_CREATE_RULE = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/dataStreams/{data_stream}/eventCreateRules/{event_create_rule}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String dataStream;
    private final String eventCreateRule;

    @Deprecated
    protected EventCreateRuleName() {
        this.property = null;
        this.dataStream = null;
        this.eventCreateRule = null;
    }

    private EventCreateRuleName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.dataStream = (String)Preconditions.checkNotNull((Object)builder.getDataStream());
        this.eventCreateRule = (String)Preconditions.checkNotNull((Object)builder.getEventCreateRule());
    }

    public String getProperty() {
        return this.property;
    }

    public String getDataStream() {
        return this.dataStream;
    }

    public String getEventCreateRule() {
        return this.eventCreateRule;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EventCreateRuleName of(String property, String dataStream, String eventCreateRule) {
        return EventCreateRuleName.newBuilder().setProperty(property).setDataStream(dataStream).setEventCreateRule(eventCreateRule).build();
    }

    public static String format(String property, String dataStream, String eventCreateRule) {
        return EventCreateRuleName.newBuilder().setProperty(property).setDataStream(dataStream).setEventCreateRule(eventCreateRule).build().toString();
    }

    public static EventCreateRuleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_DATA_STREAM_EVENT_CREATE_RULE.validatedMatch(formattedString, "EventCreateRuleName.parse: formattedString not in valid format");
        return EventCreateRuleName.of((String)matchMap.get("property"), (String)matchMap.get("data_stream"), (String)matchMap.get("event_create_rule"));
    }

    public static List<EventCreateRuleName> parseList(List<String> formattedStrings) {
        ArrayList<EventCreateRuleName> list = new ArrayList<EventCreateRuleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EventCreateRuleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EventCreateRuleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EventCreateRuleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_DATA_STREAM_EVENT_CREATE_RULE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EventCreateRuleName eventCreateRuleName = this;
            synchronized (eventCreateRuleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.dataStream != null) {
                        fieldMapBuilder.put((Object)"data_stream", (Object)this.dataStream);
                    }
                    if (this.eventCreateRule != null) {
                        fieldMapBuilder.put((Object)"event_create_rule", (Object)this.eventCreateRule);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_DATA_STREAM_EVENT_CREATE_RULE.instantiate(new String[]{"property", this.property, "data_stream", this.dataStream, "event_create_rule", this.eventCreateRule});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            EventCreateRuleName that = (EventCreateRuleName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.dataStream, that.dataStream) && Objects.equals(this.eventCreateRule, that.eventCreateRule);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataStream);
        h *= 1000003;
        return h ^= Objects.hashCode(this.eventCreateRule);
    }

    public static class Builder {
        private String property;
        private String dataStream;
        private String eventCreateRule;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getDataStream() {
            return this.dataStream;
        }

        public String getEventCreateRule() {
            return this.eventCreateRule;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setDataStream(String dataStream) {
            this.dataStream = dataStream;
            return this;
        }

        public Builder setEventCreateRule(String eventCreateRule) {
            this.eventCreateRule = eventCreateRule;
            return this;
        }

        private Builder(EventCreateRuleName eventCreateRuleName) {
            this.property = eventCreateRuleName.property;
            this.dataStream = eventCreateRuleName.dataStream;
            this.eventCreateRule = eventCreateRuleName.eventCreateRule;
        }

        public EventCreateRuleName build() {
            return new EventCreateRuleName(this);
        }
    }
}

