/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomDimensionName
implements ResourceName {
    private static final PathTemplate PROPERTY_CUSTOM_DIMENSION = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/customDimensions/{custom_dimension}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String customDimension;

    @Deprecated
    protected CustomDimensionName() {
        this.property = null;
        this.customDimension = null;
    }

    private CustomDimensionName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.customDimension = (String)Preconditions.checkNotNull((Object)builder.getCustomDimension());
    }

    public String getProperty() {
        return this.property;
    }

    public String getCustomDimension() {
        return this.customDimension;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomDimensionName of(String property, String customDimension) {
        return CustomDimensionName.newBuilder().setProperty(property).setCustomDimension(customDimension).build();
    }

    public static String format(String property, String customDimension) {
        return CustomDimensionName.newBuilder().setProperty(property).setCustomDimension(customDimension).build().toString();
    }

    public static CustomDimensionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_CUSTOM_DIMENSION.validatedMatch(formattedString, "CustomDimensionName.parse: formattedString not in valid format");
        return CustomDimensionName.of((String)matchMap.get("property"), (String)matchMap.get("custom_dimension"));
    }

    public static List<CustomDimensionName> parseList(List<String> formattedStrings) {
        ArrayList<CustomDimensionName> list = new ArrayList<CustomDimensionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomDimensionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomDimensionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomDimensionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_CUSTOM_DIMENSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomDimensionName customDimensionName = this;
            synchronized (customDimensionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.customDimension != null) {
                        fieldMapBuilder.put((Object)"custom_dimension", (Object)this.customDimension);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_CUSTOM_DIMENSION.instantiate(new String[]{"property", this.property, "custom_dimension", this.customDimension});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CustomDimensionName that = (CustomDimensionName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.customDimension, that.customDimension);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.customDimension);
    }

    public static class Builder {
        private String property;
        private String customDimension;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getCustomDimension() {
            return this.customDimension;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setCustomDimension(String customDimension) {
            this.customDimension = customDimension;
            return this;
        }

        private Builder(CustomDimensionName customDimensionName) {
            this.property = customDimensionName.property;
            this.customDimension = customDimensionName.customDimension;
        }

        public CustomDimensionName build() {
            return new CustomDimensionName(this);
        }
    }
}

