/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SearchAds360LinkName
implements ResourceName {
    private static final PathTemplate PROPERTY_SEARCH_ADS360_LINK = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/searchAds360Links/{search_ads_360_link}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String searchAds360Link;

    @Deprecated
    protected SearchAds360LinkName() {
        this.property = null;
        this.searchAds360Link = null;
    }

    private SearchAds360LinkName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.searchAds360Link = (String)Preconditions.checkNotNull((Object)builder.getSearchAds360Link());
    }

    public String getProperty() {
        return this.property;
    }

    public String getSearchAds360Link() {
        return this.searchAds360Link;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SearchAds360LinkName of(String property, String searchAds360Link) {
        return SearchAds360LinkName.newBuilder().setProperty(property).setSearchAds360Link(searchAds360Link).build();
    }

    public static String format(String property, String searchAds360Link) {
        return SearchAds360LinkName.newBuilder().setProperty(property).setSearchAds360Link(searchAds360Link).build().toString();
    }

    public static SearchAds360LinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_SEARCH_ADS360_LINK.validatedMatch(formattedString, "SearchAds360LinkName.parse: formattedString not in valid format");
        return SearchAds360LinkName.of((String)matchMap.get("property"), (String)matchMap.get("search_ads_360_link"));
    }

    public static List<SearchAds360LinkName> parseList(List<String> formattedStrings) {
        ArrayList<SearchAds360LinkName> list = new ArrayList<SearchAds360LinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SearchAds360LinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SearchAds360LinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SearchAds360LinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_SEARCH_ADS360_LINK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SearchAds360LinkName searchAds360LinkName = this;
            synchronized (searchAds360LinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.searchAds360Link != null) {
                        fieldMapBuilder.put((Object)"search_ads_360_link", (Object)this.searchAds360Link);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_SEARCH_ADS360_LINK.instantiate(new String[]{"property", this.property, "search_ads_360_link", this.searchAds360Link});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SearchAds360LinkName that = (SearchAds360LinkName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.searchAds360Link, that.searchAds360Link);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.searchAds360Link);
    }

    public static class Builder {
        private String property;
        private String searchAds360Link;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getSearchAds360Link() {
            return this.searchAds360Link;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setSearchAds360Link(String searchAds360Link) {
            this.searchAds360Link = searchAds360Link;
            return this;
        }

        private Builder(SearchAds360LinkName searchAds360LinkName) {
            this.property = searchAds360LinkName.property;
            this.searchAds360Link = searchAds360LinkName.searchAds360Link;
        }

        public SearchAds360LinkName build() {
            return new SearchAds360LinkName(this);
        }
    }
}

