/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AccountName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"accounts/{account}");
    private volatile Map<String, String> fieldValuesMap;
    private final String account;

    public String getAccount() {
        return this.account;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AccountName(Builder builder) {
        this.account = (String)Preconditions.checkNotNull((Object)builder.getAccount());
    }

    public static AccountName of(String account) {
        return AccountName.newBuilder().setAccount(account).build();
    }

    public static String format(String account) {
        return AccountName.newBuilder().setAccount(account).build().toString();
    }

    public static AccountName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AccountName.parse: formattedString not in valid format");
        return AccountName.of((String)matchMap.get("account"));
    }

    public static List<AccountName> parseList(List<String> formattedStrings) {
        ArrayList<AccountName> list = new ArrayList<AccountName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AccountName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AccountName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AccountName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AccountName accountName = this;
            synchronized (accountName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"account", (Object)this.account);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"account", this.account});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AccountName) {
            AccountName that = (AccountName)o;
            return this.account.equals(that.account);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.account.hashCode();
    }

    public static class Builder {
        private String account;

        public String getAccount() {
            return this.account;
        }

        public Builder setAccount(String account) {
            this.account = account;
            return this;
        }

        private Builder() {
        }

        private Builder(AccountName accountName) {
            this.account = accountName.account;
        }

        public AccountName build() {
            return new AccountName(this);
        }
    }
}

