/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FirebaseLinkName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/firebaseLinks/{firebase_link}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String firebaseLink;

    public String getProperty() {
        return this.property;
    }

    public String getFirebaseLink() {
        return this.firebaseLink;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private FirebaseLinkName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.firebaseLink = (String)Preconditions.checkNotNull((Object)builder.getFirebaseLink());
    }

    public static FirebaseLinkName of(String property, String firebaseLink) {
        return FirebaseLinkName.newBuilder().setProperty(property).setFirebaseLink(firebaseLink).build();
    }

    public static String format(String property, String firebaseLink) {
        return FirebaseLinkName.newBuilder().setProperty(property).setFirebaseLink(firebaseLink).build().toString();
    }

    public static FirebaseLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "FirebaseLinkName.parse: formattedString not in valid format");
        return FirebaseLinkName.of((String)matchMap.get("property"), (String)matchMap.get("firebase_link"));
    }

    public static List<FirebaseLinkName> parseList(List<String> formattedStrings) {
        ArrayList<FirebaseLinkName> list = new ArrayList<FirebaseLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FirebaseLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FirebaseLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FirebaseLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FirebaseLinkName firebaseLinkName = this;
            synchronized (firebaseLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"property", (Object)this.property);
                    fieldMapBuilder.put((Object)"firebaseLink", (Object)this.firebaseLink);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"property", this.property, "firebase_link", this.firebaseLink});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FirebaseLinkName) {
            FirebaseLinkName that = (FirebaseLinkName)o;
            return this.property.equals(that.property) && this.firebaseLink.equals(that.firebaseLink);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.property.hashCode();
        h *= 1000003;
        return h ^= this.firebaseLink.hashCode();
    }

    public static class Builder {
        private String property;
        private String firebaseLink;

        public String getProperty() {
            return this.property;
        }

        public String getFirebaseLink() {
            return this.firebaseLink;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setFirebaseLink(String firebaseLink) {
            this.firebaseLink = firebaseLink;
            return this;
        }

        private Builder() {
        }

        private Builder(FirebaseLinkName firebaseLinkName) {
            this.property = firebaseLinkName.property;
            this.firebaseLink = firebaseLinkName.firebaseLink;
        }

        public FirebaseLinkName build() {
            return new FirebaseLinkName(this);
        }
    }
}

