/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerContext;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.AppCentricTracer;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TraceManager;
import com.google.common.annotations.VisibleForTesting;

@BetaApi
@InternalApi
public class AppCentricTracerFactory
implements ApiTracerFactory {
    private final TraceManager traceManager;
    private final ApiTracerContext apiTracerContext;

    public AppCentricTracerFactory(TraceManager traceManager) {
        this(traceManager, ApiTracerContext.newBuilder().build());
    }

    @VisibleForTesting
    AppCentricTracerFactory(TraceManager traceManager, ApiTracerContext apiTracerContext) {
        this.traceManager = traceManager;
        this.apiTracerContext = apiTracerContext;
    }

    @Override
    public ApiTracer newTracer(ApiTracer parent, SpanName spanName, ApiTracerFactory.OperationType operationType) {
        String attemptSpanName = spanName.getClientName() + "/" + spanName.getMethodName() + "/attempt";
        AppCentricTracer appCentricTracer = new AppCentricTracer(this.traceManager, this.apiTracerContext, attemptSpanName);
        return appCentricTracer;
    }

    @Override
    public ApiTracerFactory withContext(ApiTracerContext context) {
        return new AppCentricTracerFactory(this.traceManager, context);
    }
}

