/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerContext;
import com.google.api.gax.tracing.TraceManager;
import java.util.HashMap;
import java.util.Map;

@BetaApi
@InternalApi
public class AppCentricTracer
implements ApiTracer {
    public static final String LANGUAGE_ATTRIBUTE = "gcp.client.language";
    public static final String DEFAULT_LANGUAGE = "Java";
    private final TraceManager traceManager;
    private final Map<String, String> attemptAttributes;
    private final String attemptSpanName;
    private final ApiTracerContext apiTracerContext;
    private TraceManager.Span attemptHandle;

    public AppCentricTracer(TraceManager traceManager, ApiTracerContext apiTracerContext, String attemptSpanName) {
        this.traceManager = traceManager;
        this.attemptSpanName = attemptSpanName;
        this.apiTracerContext = apiTracerContext;
        this.attemptAttributes = new HashMap<String, String>();
        this.buildAttributes();
    }

    private void buildAttributes() {
        this.attemptAttributes.put(LANGUAGE_ATTRIBUTE, DEFAULT_LANGUAGE);
        this.attemptAttributes.putAll(this.apiTracerContext.getAttemptAttributes());
    }

    @Override
    public void attemptStarted(Object request, int attemptNumber) {
        HashMap<String, String> attemptAttributes = new HashMap<String, String>(this.attemptAttributes);
        this.attemptHandle = this.traceManager.createSpan(this.attemptSpanName, attemptAttributes);
    }

    @Override
    public void attemptSucceeded() {
        this.endAttempt();
    }

    private void endAttempt() {
        if (this.attemptHandle != null) {
            this.attemptHandle.end();
            this.attemptHandle = null;
        }
    }
}

