package com.google.api.gax.core;

import com.google.api.core.BetaApi;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GoogleCredentialsProvider extends GoogleCredentialsProvider {

  private final List<String> scopesToApply;

  private final List<String> jwtEnabledScopes;

  private final boolean useJwtAccessWithScope;

  @Nullable
  private final GoogleCredentials OAuth2Credentials;

  private AutoValue_GoogleCredentialsProvider(
      List<String> scopesToApply,
      List<String> jwtEnabledScopes,
      boolean useJwtAccessWithScope,
      @Nullable GoogleCredentials OAuth2Credentials) {
    this.scopesToApply = scopesToApply;
    this.jwtEnabledScopes = jwtEnabledScopes;
    this.useJwtAccessWithScope = useJwtAccessWithScope;
    this.OAuth2Credentials = OAuth2Credentials;
  }

  @Override
  public List<String> getScopesToApply() {
    return scopesToApply;
  }

  @BetaApi
  @Override
  public List<String> getJwtEnabledScopes() {
    return jwtEnabledScopes;
  }

  @BetaApi
  @Override
  public boolean getUseJwtAccessWithScope() {
    return useJwtAccessWithScope;
  }

  @VisibleForTesting
  @Nullable
  @Override
  GoogleCredentials getOAuth2Credentials() {
    return OAuth2Credentials;
  }

  @Override
  public String toString() {
    return "GoogleCredentialsProvider{"
        + "scopesToApply=" + scopesToApply + ", "
        + "jwtEnabledScopes=" + jwtEnabledScopes + ", "
        + "useJwtAccessWithScope=" + useJwtAccessWithScope + ", "
        + "OAuth2Credentials=" + OAuth2Credentials
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GoogleCredentialsProvider) {
      GoogleCredentialsProvider that = (GoogleCredentialsProvider) o;
      return this.scopesToApply.equals(that.getScopesToApply())
          && this.jwtEnabledScopes.equals(that.getJwtEnabledScopes())
          && this.useJwtAccessWithScope == that.getUseJwtAccessWithScope()
          && (this.OAuth2Credentials == null ? that.getOAuth2Credentials() == null : this.OAuth2Credentials.equals(that.getOAuth2Credentials()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= scopesToApply.hashCode();
    h$ *= 1000003;
    h$ ^= jwtEnabledScopes.hashCode();
    h$ *= 1000003;
    h$ ^= useJwtAccessWithScope ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (OAuth2Credentials == null) ? 0 : OAuth2Credentials.hashCode();
    return h$;
  }

  @Override
  public GoogleCredentialsProvider.Builder toBuilder() {
    return new AutoValue_GoogleCredentialsProvider.Builder(this);
  }

  static final class Builder extends GoogleCredentialsProvider.Builder {
    private List<String> scopesToApply;
    private List<String> jwtEnabledScopes;
    private boolean useJwtAccessWithScope;
    private GoogleCredentials OAuth2Credentials;
    private byte set$0;
    Builder() {
    }
    Builder(GoogleCredentialsProvider source) {
      this.scopesToApply = source.getScopesToApply();
      this.jwtEnabledScopes = source.getJwtEnabledScopes();
      this.useJwtAccessWithScope = source.getUseJwtAccessWithScope();
      this.OAuth2Credentials = source.getOAuth2Credentials();
      set$0 = (byte) 1;
    }
    @Override
    public GoogleCredentialsProvider.Builder setScopesToApply(List<String> scopesToApply) {
      if (scopesToApply == null) {
        throw new NullPointerException("Null scopesToApply");
      }
      this.scopesToApply = scopesToApply;
      return this;
    }
    @Override
    public List<String> getScopesToApply() {
      if (this.scopesToApply == null) {
        throw new IllegalStateException("Property \"scopesToApply\" has not been set");
      }
      return scopesToApply;
    }
    @Override
    public GoogleCredentialsProvider.Builder setJwtEnabledScopes(List<String> jwtEnabledScopes) {
      if (jwtEnabledScopes == null) {
        throw new NullPointerException("Null jwtEnabledScopes");
      }
      this.jwtEnabledScopes = jwtEnabledScopes;
      return this;
    }
    @Override
    public List<String> getJwtEnabledScopes() {
      if (this.jwtEnabledScopes == null) {
        throw new IllegalStateException("Property \"jwtEnabledScopes\" has not been set");
      }
      return jwtEnabledScopes;
    }
    @Override
    public GoogleCredentialsProvider.Builder setUseJwtAccessWithScope(boolean useJwtAccessWithScope) {
      this.useJwtAccessWithScope = useJwtAccessWithScope;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public boolean getUseJwtAccessWithScope() {
      if ((set$0 & 1) == 0) {
        throw new IllegalStateException("Property \"useJwtAccessWithScope\" has not been set");
      }
      return useJwtAccessWithScope;
    }
    @Override
    GoogleCredentialsProvider.Builder setOAuth2Credentials(GoogleCredentials OAuth2Credentials) {
      this.OAuth2Credentials = OAuth2Credentials;
      return this;
    }
    @Override
    GoogleCredentialsProvider autoBuild() {
      if (set$0 != 1
          || this.scopesToApply == null
          || this.jwtEnabledScopes == null) {
        StringBuilder missing = new StringBuilder();
        if (this.scopesToApply == null) {
          missing.append(" scopesToApply");
        }
        if (this.jwtEnabledScopes == null) {
          missing.append(" jwtEnabledScopes");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" useJwtAccessWithScope");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GoogleCredentialsProvider(
          this.scopesToApply,
          this.jwtEnabledScopes,
          this.useJwtAccessWithScope,
          this.OAuth2Credentials);
    }
  }

}
