/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiCallContextEnhancer;
import com.google.api.gax.rpc.ApiCallContextEnhancers;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.OperationFuture;
import java.util.Collections;
import java.util.List;

@InternalApi(value="For use by transport-specific implementations")
public class EntryPointOperationCallable<RequestT, ResponseT, MetadataT, OperationT>
extends OperationCallable<RequestT, ResponseT, MetadataT, OperationT> {
    private final OperationCallable<RequestT, ResponseT, MetadataT, OperationT> callable;
    private final ApiCallContext defaultCallContext;
    private final List<ApiCallContextEnhancer> callContextEnhancers;

    public EntryPointOperationCallable(OperationCallable<RequestT, ResponseT, MetadataT, OperationT> callable, ApiCallContext defaultCallContext) {
        this(callable, defaultCallContext, Collections.emptyList());
    }

    public EntryPointOperationCallable(OperationCallable<RequestT, ResponseT, MetadataT, OperationT> callable, ApiCallContext defaultCallContext, List<ApiCallContextEnhancer> callContextEnhancers) {
        this.callable = (OperationCallable)Preconditions.checkNotNull(callable);
        this.defaultCallContext = (ApiCallContext)Preconditions.checkNotNull((Object)defaultCallContext);
        this.callContextEnhancers = (List)Preconditions.checkNotNull(callContextEnhancers);
    }

    @Override
    public OperationFuture<ResponseT, MetadataT, OperationT> futureCall(RequestT request, ApiCallContext thisCallContext) {
        ApiCallContext newCallContext = ApiCallContextEnhancers.applyEnhancers(this.defaultCallContext, thisCallContext, this.callContextEnhancers);
        return this.callable.futureCall(request, newCallContext);
    }

    @Override
    public OperationFuture<ResponseT, MetadataT, OperationT> resumeFutureCall(String operationName, ApiCallContext thisCallContext) {
        ApiCallContext newCallContext = ApiCallContextEnhancers.applyEnhancers(this.defaultCallContext, thisCallContext, this.callContextEnhancers);
        return this.callable.resumeFutureCall(operationName, newCallContext);
    }

    @Override
    public ApiFuture<Void> cancel(String operationName, ApiCallContext thisCallContext) {
        ApiCallContext newCallContext = ApiCallContextEnhancers.applyEnhancers(this.defaultCallContext, thisCallContext, this.callContextEnhancers);
        return this.callable.cancel(operationName, newCallContext);
    }
}

