/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiClock;
import com.google.api.core.BetaApi;
import com.google.api.core.NanoClock;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.ExecutorAsBackgroundResource;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.rpc.AutoValue_ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.NullTransport;
import com.google.api.gax.rpc.Transport;
import com.google.api.gax.rpc.TransportProvider;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

@BetaApi
public abstract class ClientContext {
    public abstract List<BackgroundResource> getBackgroundResources();

    public abstract ScheduledExecutorService getExecutor();

    @Nullable
    public abstract Credentials getCredentials();

    public abstract Transport getTransportContext();

    public abstract ApiClock getClock();

    public static Builder newBuilder() {
        return new AutoValue_ClientContext.Builder().setBackgroundResources(Collections.emptyList()).setExecutor(Executors.newScheduledThreadPool(0)).setTransportContext(NullTransport.create()).setClock(NanoClock.getDefaultClock());
    }

    public static ClientContext create(ClientSettings settings) throws IOException {
        TransportProvider transportProvider;
        ImmutableList.Builder backgroundResources = ImmutableList.builder();
        ExecutorProvider executorProvider = settings.getExecutorProvider();
        ScheduledExecutorService executor = executorProvider.getExecutor();
        if (executorProvider.shouldAutoClose()) {
            backgroundResources.add((Object)new ExecutorAsBackgroundResource(executor));
        }
        Transport transport = (transportProvider = settings.getTransportProvider()).needsExecutor() ? transportProvider.getTransport(executor) : transportProvider.getTransport();
        backgroundResources.addAll(transport.getBackgroundResources());
        return ClientContext.newBuilder().setBackgroundResources((List<BackgroundResource>)backgroundResources.build()).setExecutor(executor).setCredentials(settings.getCredentialsProvider().getCredentials()).setTransportContext(transport).setClock(settings.getClock()).build();
    }

    public static abstract class Builder {
        public abstract Builder setBackgroundResources(List<BackgroundResource> var1);

        public abstract Builder setExecutor(ScheduledExecutorService var1);

        public abstract Builder setCredentials(Credentials var1);

        public abstract Builder setTransportContext(Transport var1);

        public abstract Builder setClock(ApiClock var1);

        public abstract ClientContext build();
    }
}

