/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public abstract class UnaryCallSettings {
    private final ImmutableSet<StatusCode> retryableCodes;
    private final RetrySettings retrySettings;

    public final Set<StatusCode> getRetryableCodes() {
        return this.retryableCodes;
    }

    public final RetrySettings getRetrySettings() {
        return this.retrySettings;
    }

    public static Builder newUnaryCallSettingsBuilder() {
        return new Builder();
    }

    public abstract Builder toBuilder();

    protected UnaryCallSettings(Set<StatusCode> retryableCodes, RetrySettings retrySettings) {
        this.retryableCodes = ImmutableSet.copyOf(retryableCodes);
        this.retrySettings = retrySettings;
    }

    public static class Builder {
        private Set<StatusCode> retryableCodes;
        private RetrySettings retrySettings;

        protected Builder() {
            this.retryableCodes = Sets.newHashSet();
            this.retrySettings = RetrySettings.newBuilder().build();
        }

        protected Builder(UnaryCallSettings unaryCallSettings) {
            this.setRetryableCodes((Set<StatusCode>)unaryCallSettings.retryableCodes);
            this.setRetrySettings(unaryCallSettings.getRetrySettings());
        }

        public Builder setRetryableCodes(Set<StatusCode> retryableCodes) {
            this.retryableCodes = Sets.newHashSet(retryableCodes);
            return this;
        }

        public Builder setRetryableCodes(StatusCode ... codes) {
            this.setRetryableCodes(Sets.newHashSet((Object[])codes));
            return this;
        }

        public Builder setRetrySettings(RetrySettings retrySettings) {
            this.retrySettings = (RetrySettings)Preconditions.checkNotNull((Object)retrySettings);
            return this;
        }

        public Builder setSimpleTimeoutNoRetries(Duration timeout) {
            this.setRetryableCodes(new StatusCode[0]);
            this.setRetrySettings(RetrySettings.newBuilder().setTotalTimeout(timeout).setInitialRetryDelay(Duration.ZERO).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ZERO).setInitialRpcTimeout(timeout).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(timeout).setMaxAttempts(1).build());
            return this;
        }

        public Set<StatusCode> getRetryableCodes() {
            return this.retryableCodes;
        }

        public RetrySettings getRetrySettings() {
            return this.retrySettings;
        }

        public UnaryCallSettings build() {
            throw new UnsupportedOperationException("Cannot build an instance of abstract class UnaryCallSettings.");
        }
    }
}

