/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallSettingsTyped;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

@BetaApi
public final class PagedCallSettings<RequestT, ResponseT, PagedListResponseT>
extends UnaryCallSettingsTyped<RequestT, ResponseT> {
    private final PagedListResponseFactory<RequestT, ResponseT, PagedListResponseT> pagedListResponseFactory;

    public PagedListResponseFactory<RequestT, ResponseT, PagedListResponseT> getPagedListResponseFactory() {
        return this.pagedListResponseFactory;
    }

    public static <RequestT, ResponseT, PagedListResponseT> Builder<RequestT, ResponseT, PagedListResponseT> newBuilder(PagedListResponseFactory<RequestT, ResponseT, PagedListResponseT> pagedListResponseFactory) {
        return new Builder<RequestT, ResponseT, PagedListResponseT>(pagedListResponseFactory);
    }

    @Override
    public final Builder<RequestT, ResponseT, PagedListResponseT> toBuilder() {
        return new Builder(this);
    }

    private PagedCallSettings(ImmutableSet<StatusCode> retryableCodes, RetrySettings retrySettings, PagedListResponseFactory<RequestT, ResponseT, PagedListResponseT> pagedListResponseFactory) {
        super(retryableCodes, retrySettings);
        this.pagedListResponseFactory = pagedListResponseFactory;
    }

    public static class Builder<RequestT, ResponseT, PagedListResponseT>
    extends UnaryCallSettingsTyped.Builder<RequestT, ResponseT> {
        private PagedListResponseFactory<RequestT, ResponseT, PagedListResponseT> pagedListResponseFactory;

        public Builder(PagedListResponseFactory<RequestT, ResponseT, PagedListResponseT> pagedListResponseFactory) {
            this.pagedListResponseFactory = pagedListResponseFactory;
        }

        public Builder(PagedCallSettings<RequestT, ResponseT, PagedListResponseT> settings) {
            super(settings);
            this.pagedListResponseFactory = ((PagedCallSettings)settings).pagedListResponseFactory;
        }

        @Override
        public Builder<RequestT, ResponseT, PagedListResponseT> setRetryableCodes(Set<StatusCode> retryableCodes) {
            super.setRetryableCodes(retryableCodes);
            return this;
        }

        @Override
        public Builder<RequestT, ResponseT, PagedListResponseT> setRetryableCodes(StatusCode ... codes) {
            super.setRetryableCodes(codes);
            return this;
        }

        @Override
        public Builder<RequestT, ResponseT, PagedListResponseT> setRetrySettings(RetrySettings retrySettings) {
            super.setRetrySettings(retrySettings);
            return this;
        }

        public PagedListResponseFactory<RequestT, ResponseT, PagedListResponseT> getPagedListResponseFactory() {
            return this.pagedListResponseFactory;
        }

        @Override
        public PagedCallSettings<RequestT, ResponseT, PagedListResponseT> build() {
            return new PagedCallSettings(ImmutableSet.copyOf(this.getRetryableCodes()), this.getRetrySettings(), this.pagedListResponseFactory);
        }
    }
}

