/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.v2.Batcher;
import com.google.api.gax.batching.v2.BatchingDescriptor;
import com.google.api.gax.batching.v2.BatchingSettings;
import com.google.api.gax.batching.v2.RequestBuilder;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

@BetaApi(value="The surface for batching is not stable yet and may change in the future.")
@InternalApi(value="For google-cloud-java client use only")
public class BatcherImpl<ElementT, ElementResultT, RequestT, ResponseT>
implements Batcher<ElementT, ElementResultT> {
    private final BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> batchingDescriptor;
    private final UnaryCallable<RequestT, ResponseT> unaryCallable;
    private final RequestT prototype;
    private final BatchingSettings batchingSettings;
    private Batch<ElementT, ElementResultT, RequestT, ResponseT> currentOpenBatch;
    private final AtomicInteger numOfOutstandingBatches = new AtomicInteger(0);
    private final Object flushLock = new Object();
    private volatile boolean isClosed = false;

    public BatcherImpl(BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> batchingDescriptor, UnaryCallable<RequestT, ResponseT> unaryCallable, RequestT prototype, BatchingSettings batchingSettings) {
        this.batchingDescriptor = (BatchingDescriptor)Preconditions.checkNotNull(batchingDescriptor, (Object)"batching descriptor cannot be null");
        this.unaryCallable = (UnaryCallable)Preconditions.checkNotNull(unaryCallable, (Object)"callable cannot be null");
        this.prototype = Preconditions.checkNotNull(prototype, (Object)"request prototype cannot be null");
        this.batchingSettings = (BatchingSettings)Preconditions.checkNotNull((Object)batchingSettings, (Object)"batching setting cannot be null");
    }

    @Override
    public ApiFuture<ElementResultT> add(ElementT element) {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"Cannot add elements on a closed batcher");
        if (this.currentOpenBatch == null) {
            this.currentOpenBatch = new Batch(this.prototype, this.batchingDescriptor, this.batchingSettings);
        }
        SettableApiFuture result = SettableApiFuture.create();
        this.currentOpenBatch.add(element, result);
        if (this.currentOpenBatch.hasAnyThresholdReached()) {
            this.sendBatch();
        }
        return result;
    }

    @Override
    public void flush() throws InterruptedException {
        this.sendBatch();
        this.awaitAllOutstandingBatches();
    }

    private void sendBatch() {
        if (this.currentOpenBatch == null) {
            return;
        }
        final Batch<ElementT, ElementResultT, RequestT, ResponseT> accumulatedBatch = this.currentOpenBatch;
        this.currentOpenBatch = null;
        ApiFuture<ResponseT> batchResponse = this.unaryCallable.futureCall(((Batch)accumulatedBatch).builder.build());
        this.numOfOutstandingBatches.incrementAndGet();
        ApiFutures.addCallback(batchResponse, (ApiFutureCallback)new ApiFutureCallback<ResponseT>(){

            public void onSuccess(ResponseT response) {
                try {
                    accumulatedBatch.onBatchSuccess(response);
                }
                finally {
                    BatcherImpl.this.onBatchCompletion();
                }
            }

            public void onFailure(Throwable throwable) {
                try {
                    accumulatedBatch.onBatchFailure(throwable);
                }
                finally {
                    BatcherImpl.this.onBatchCompletion();
                }
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBatchCompletion() {
        if (this.numOfOutstandingBatches.decrementAndGet() == 0) {
            Object object = this.flushLock;
            synchronized (object) {
                this.flushLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitAllOutstandingBatches() throws InterruptedException {
        while (this.numOfOutstandingBatches.get() > 0) {
            Object object = this.flushLock;
            synchronized (object) {
                this.flushLock.wait();
            }
        }
    }

    @Override
    public void close() throws InterruptedException {
        this.isClosed = true;
        this.flush();
    }

    private static class Batch<ElementT, ElementResultT, RequestT, ResponseT> {
        private final RequestBuilder<ElementT, RequestT> builder;
        private final List<SettableApiFuture<ElementResultT>> results;
        private final BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> descriptor;
        private final long elementThreshold;
        private final long bytesThreshold;
        private long elementCounter = 0L;
        private long byteCounter = 0L;

        private Batch(RequestT prototype, BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> descriptor, BatchingSettings batchingSettings) {
            this.descriptor = descriptor;
            this.builder = descriptor.newRequestBuilder(prototype);
            this.elementThreshold = batchingSettings.getElementCountThreshold();
            this.bytesThreshold = batchingSettings.getRequestByteThreshold();
            this.results = new ArrayList<SettableApiFuture<ElementResultT>>();
        }

        void add(ElementT element, SettableApiFuture<ElementResultT> result) {
            this.builder.add(element);
            this.results.add(result);
            ++this.elementCounter;
            this.byteCounter += this.descriptor.countBytes(element);
        }

        void onBatchSuccess(ResponseT response) {
            try {
                this.descriptor.splitResponse(response, this.results);
            }
            catch (Exception ex) {
                this.onBatchFailure(ex);
            }
        }

        void onBatchFailure(Throwable throwable) {
            try {
                this.descriptor.splitException(throwable, this.results);
            }
            catch (Exception ex) {
                for (SettableApiFuture<ElementResultT> result : this.results) {
                    result.setException((Throwable)ex);
                }
            }
        }

        boolean hasAnyThresholdReached() {
            return this.elementCounter >= this.elementThreshold || this.byteCounter >= this.bytesThreshold;
        }
    }
}

