/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import com.google.api.core.BetaApi;
import com.google.api.gax.batching.AutoValue_FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

@BetaApi
public abstract class FlowControlSettings {
    public static FlowControlSettings getDefaultInstance() {
        return FlowControlSettings.newBuilder().build();
    }

    @Nullable
    public abstract Long getMaxOutstandingElementCount();

    @Nullable
    public abstract Long getMaxOutstandingRequestBytes();

    public abstract FlowController.LimitExceededBehavior getLimitExceededBehavior();

    public Builder toBuilder() {
        return new AutoValue_FlowControlSettings.Builder(this);
    }

    public static Builder newBuilder() {
        return new AutoValue_FlowControlSettings.Builder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block);
    }

    @BetaApi
    public static abstract class Builder {
        public abstract Builder setMaxOutstandingElementCount(Long var1);

        @Deprecated
        public Builder setMaxOutstandingElementCount(Integer value) {
            return this.setMaxOutstandingElementCount(value == null ? null : Long.valueOf(value.longValue()));
        }

        public abstract Builder setMaxOutstandingRequestBytes(Long var1);

        @Deprecated
        public Builder setMaxOutstandingRequestBytes(Integer value) {
            return this.setMaxOutstandingRequestBytes(value == null ? null : Long.valueOf(value.longValue()));
        }

        public abstract Builder setLimitExceededBehavior(FlowController.LimitExceededBehavior var1);

        abstract FlowControlSettings autoBuild();

        public FlowControlSettings build() {
            FlowControlSettings settings = this.autoBuild();
            Preconditions.checkArgument((settings.getMaxOutstandingElementCount() == null || settings.getMaxOutstandingElementCount() > 0L ? 1 : 0) != 0, (Object)"maxOutstandingElementCount limit is disabled by default, but if set it must be set to a value greater than 0.");
            Preconditions.checkArgument((settings.getMaxOutstandingRequestBytes() == null || settings.getMaxOutstandingRequestBytes() > 0L ? 1 : 0) != 0, (Object)"maxOutstandingRequestBytes limit is disabled by default, but if set it must be set to a value greater than 0.");
            return settings;
        }
    }
}

