/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import java.util.Iterator;

@BetaApi(value="The surface for streaming is not stable yet and may change in the future.")
public abstract class ServerStreamingCallable<RequestT, ResponseT> {
    protected ServerStreamingCallable() {
    }

    public abstract void call(RequestT var1, ResponseObserver<ResponseT> var2, ApiCallContext var3);

    public void call(RequestT request, ResponseObserver<ResponseT> responseObserver) {
        this.call(request, responseObserver, null);
    }

    @Deprecated
    public void serverStreamingCall(RequestT request, ApiStreamObserver<ResponseT> responseObserver, ApiCallContext context) {
        this.call(request, new ApiStreamObserverAdapter<ResponseT>(responseObserver), context);
    }

    @Deprecated
    public void serverStreamingCall(RequestT request, ApiStreamObserver<ResponseT> responseObserver) {
        this.serverStreamingCall(request, responseObserver, null);
    }

    public abstract Iterator<ResponseT> blockingServerStreamingCall(RequestT var1, ApiCallContext var2);

    public Iterator<ResponseT> blockingServerStreamingCall(RequestT request) {
        return this.blockingServerStreamingCall(request, null);
    }

    public ServerStreamingCallable<RequestT, ResponseT> withDefaultCallContext(final ApiCallContext defaultCallContext) {
        return new ServerStreamingCallable<RequestT, ResponseT>(){

            @Override
            public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext thisCallContext) {
                ServerStreamingCallable.this.call(request, responseObserver, defaultCallContext.merge(thisCallContext));
            }

            @Override
            public Iterator<ResponseT> blockingServerStreamingCall(RequestT request, ApiCallContext thisCallContext) {
                return ServerStreamingCallable.this.blockingServerStreamingCall(request, defaultCallContext.merge(thisCallContext));
            }
        };
    }

    @Deprecated
    private static class ApiStreamObserverAdapter<T>
    implements ResponseObserver<T> {
        private final ApiStreamObserver<T> delegate;

        ApiStreamObserverAdapter(ApiStreamObserver<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onStart(StreamController controller) {
        }

        @Override
        public void onResponse(T response) {
            this.delegate.onNext(response);
        }

        @Override
        public void onError(Throwable t) {
            this.delegate.onError(t);
        }

        @Override
        public void onComplete() {
            this.delegate.onCompleted();
        }
    }
}

