/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.retrying;

import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ListenableFutureToApiFuture;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetryingExecutor;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.RetryingFutureImpl;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.InterruptedIOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.Callable;
import org.threeten.bp.Duration;

@BetaApi
public class DirectRetryingExecutor<ResponseT>
implements RetryingExecutor<ResponseT> {
    private final RetryAlgorithm retryAlgorithm;

    public DirectRetryingExecutor(RetryAlgorithm retryAlgorithm) {
        this.retryAlgorithm = (RetryAlgorithm)Preconditions.checkNotNull((Object)retryAlgorithm);
    }

    @Override
    public RetryingFuture<ResponseT> createFuture(Callable<ResponseT> callable) {
        return new RetryingFutureImpl<ResponseT>(callable, this.retryAlgorithm, this);
    }

    @Override
    public void submit(RetryingFuture<ResponseT> retryingFuture) {
        ListenableFuture attemptFuture;
        try {
            Duration delay = retryingFuture.getAttemptSettings().getRandomizedRetryDelay();
            if (Duration.ZERO.compareTo(delay) < 0) {
                Thread.sleep(delay.toMillis());
            }
            attemptFuture = Futures.immediateFuture(retryingFuture.getCallable().call());
        }
        catch (InterruptedIOException | InterruptedException | ClosedByInterruptException e) {
            Thread.currentThread().interrupt();
            attemptFuture = Futures.immediateFailedFuture((Throwable)e);
        }
        catch (Throwable e) {
            attemptFuture = Futures.immediateFailedFuture((Throwable)e);
        }
        retryingFuture.setAttemptFuture((ApiFuture<ResponseT>)new ListenableFutureToApiFuture(attemptFuture));
    }
}

