/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import com.google.api.gax.core.AutoValue_GoogleCredentialsProvider;
import com.google.api.gax.core.CredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.IOException;
import java.util.List;

public abstract class GoogleCredentialsProvider
implements CredentialsProvider {
    public abstract List<String> getScopesToApply();

    @Override
    public Credentials getCredentials() throws IOException {
        GoogleCredentials credentials = GoogleCredentials.getApplicationDefault();
        if (credentials.createScopedRequired()) {
            credentials = credentials.createScoped(this.getScopesToApply());
        }
        return credentials;
    }

    public static Builder newBuilder() {
        return new AutoValue_GoogleCredentialsProvider.Builder();
    }

    public Builder toBuilder() {
        return new AutoValue_GoogleCredentialsProvider.Builder(this);
    }

    public static abstract class Builder {
        public abstract Builder setScopesToApply(List<String> var1);

        public abstract List<String> getScopesToApply();

        public abstract GoogleCredentialsProvider build();
    }
}

