/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.bundling.ThresholdBundleReceiver;
import com.google.api.gax.core.ApiFuture;
import com.google.api.gax.core.ApiFutureCallback;
import com.google.api.gax.core.ApiFutures;
import com.google.api.gax.grpc.Bundle;
import com.google.api.gax.grpc.BundledRequestIssuer;
import com.google.api.gax.grpc.BundlingDescriptor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.common.base.Preconditions;
import java.util.List;

class BundleExecutor<RequestT, ResponseT>
implements ThresholdBundleReceiver<Bundle<RequestT, ResponseT>> {
    private final BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor;
    private final String partitionKey;

    public BundleExecutor(BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor, String partitionKey) {
        this.bundlingDescriptor = (BundlingDescriptor)Preconditions.checkNotNull(bundlingDescriptor);
        this.partitionKey = (String)Preconditions.checkNotNull((Object)partitionKey);
    }

    @Override
    public void validateBundle(Bundle<RequestT, ResponseT> item) {
        String itemPartitionKey = this.bundlingDescriptor.getBundlePartitionKey(item.getRequest());
        if (!itemPartitionKey.equals(this.partitionKey)) {
            String requestClassName = item.getRequest().getClass().getSimpleName();
            throw new IllegalArgumentException(String.format("For type %s, invalid partition key: %s, should be: %s", requestClassName, itemPartitionKey, this.partitionKey));
        }
    }

    @Override
    public ApiFuture<ResponseT> processBundle(Bundle<RequestT, ResponseT> bundle) {
        UnaryCallable<RequestT, ResponseT> callable = bundle.getCallable();
        RequestT request = bundle.getRequest();
        final List<BundledRequestIssuer<ResponseT>> requestIssuerList = bundle.getRequestIssuerList();
        ApiFuture<ResponseT> future = callable.futureCall(request);
        ApiFutures.addCallback(future, new ApiFutureCallback<ResponseT>(){

            @Override
            public void onSuccess(ResponseT result) {
                BundleExecutor.this.bundlingDescriptor.splitResponse(result, requestIssuerList);
                for (BundledRequestIssuer requestIssuer : requestIssuerList) {
                    requestIssuer.sendResult();
                }
            }

            @Override
            public void onFailure(Throwable t) {
                BundleExecutor.this.bundlingDescriptor.splitException(t, requestIssuerList);
                for (BundledRequestIssuer requestIssuer : requestIssuerList) {
                    requestIssuer.sendResult();
                }
            }
        });
        return future;
    }
}

